/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.UnknownSdkCollector;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFix;
import com.intellij.openapi.projectRoots.impl.UnknownSdkFixAction;
import com.intellij.openapi.projectRoots.impl.UnknownSdkTracker;
import com.intellij.openapi.util.registry.Registry;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkInspectionCommandLineConfigurator;", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator;", "()V", "configureEnvironment", "", "context", "Lcom/intellij/ide/CommandLineInspectionProjectConfigurator$ConfiguratorContext;", "configureProject", "project", "Lcom/intellij/openapi/project/Project;", "getDescription", "", "getName", "isApplicable", "", "Companion", "intellij.platform.lang.impl"})
public final class UnknownSdkInspectionCommandLineConfigurator
implements CommandLineInspectionProjectConfigurator {
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public String getName() {
        return "sdk";
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = ProjectBundle.message((String)"config.unknown.sdk.commandline.configure", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ProjectBundle.message(\"c\u2026k.commandline.configure\")");
        return string;
    }

    @Override
    public boolean isApplicable(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        return !application.isUnitTestMode();
    }

    @Override
    public void configureEnvironment(@NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Registry.get((String)"unknown.sdk.auto").setValue(false);
    }

    @Override
    public void configureProject(@NotNull Project project, @NotNull CommandLineInspectionProjectConfigurator.ConfiguratorContext context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProgressIndicator progressIndicator = context.getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"context.progressIndicator");
        Companion.configureUnknownSdks(project, progressIndicator);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UnknownSdkInspectionCommandLineConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/projectRoots/impl/UnknownSdkInspectionCommandLineConfigurator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "configureUnknownSdks", "", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.lang.impl"})
    public static final class Companion {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public final void configureUnknownSdks(@NotNull Project project, @NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            boolean bl = !application.isWriteThread();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "The code below uses the same GUI thread to complete operations. Running from EDT would deadlock";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            ProgressIndicator $this$withPushPop$iv = indicator;
            boolean $i$f$withPushPop = false;
            boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
            $this$withPushPop$iv.pushState();
            try {
                boolean bl5 = false;
                indicator.setText(ProjectBundle.message((String)"config.unknown.progress.scanning", (Object[])new Object[0]));
                List<UnknownSdkFix> list2 = UnknownSdkTracker.getInstance(project).collectUnknownSdks(new UnknownSdkCollector(project), indicator);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"UnknownSdkTracker\n      \u2026ctor(project), indicator)");
                List<UnknownSdkFix> problems = list2;
                if (!problems.isEmpty()) {
                    indicator.setIndeterminate(false);
                    boolean bl6 = false;
                    Iterator iterator2 = ((Iterable)problems).iterator();
                    while (iterator2.hasNext()) {
                        void i2;
                        UnknownSdkFix problem;
                        UnknownSdkFix unknownSdkFix = problem = (UnknownSdkFix)iterator2.next();
                        Intrinsics.checkNotNullExpressionValue((Object)unknownSdkFix, (String)"problem");
                        UnknownSdkFixAction fix = unknownSdkFix.getSuggestedFixAction();
                        if (fix == null) {
                            LOG.warn("Failed to resolve " + problem.getSdkTypeAndNameText() + ": " + problem.getNotificationText());
                        } else {
                            LOG.info("Resolving " + problem.getSdkTypeAndNameText());
                            ProgressIndicator $this$withPushPop$iv2 = indicator;
                            boolean $i$f$withPushPop2 = false;
                            boolean wasIndeterminate$iv2 = $this$withPushPop$iv2.isIndeterminate();
                            $this$withPushPop$iv2.pushState();
                            try {
                                boolean bl7 = false;
                                indicator.setFraction((double)i2 / (double)problems.size());
                                indicator.setText(ProjectBundle.message((String)"config.unknown.progress.configuring", (Object[])new Object[]{problem.getSdkTypeAndNameText()}));
                                Sdk sdk2 = fix.applySuggestionBlocking(indicator);
                            }
                            finally {
                                $this$withPushPop$iv2.setIndeterminate(wasIndeterminate$iv2);
                                $this$withPushPop$iv2.popState();
                            }
                        }
                        ++i2;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
                $this$withPushPop$iv.popState();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

