/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.UnknownSdkType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="ProjectJdkTable", storages={@Storage(value="jdk.table.xml", roamingType=RoamingType.DISABLED, useSaveThreshold=ThreeState.NO)})
public class ProjectJdkTableImpl
extends ProjectJdkTable
implements ExportableComponent,
PersistentStateComponent<Element> {
    private final List<Sdk> mySdks = new ArrayList<Sdk>();
    @NonNls
    private static final String ELEMENT_JDK = "jdk";
    private final Map<String, ProjectJdkImpl> myCachedProjectJdks = new HashMap<String, ProjectJdkImpl>();

    public ProjectJdkTableImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){
            private final FileTypeManager myFileTypeManager = FileTypeManager.getInstance();

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!events.isEmpty()) {
                    SmartHashSet affected = new SmartHashSet();
                    for (VFileEvent vFileEvent : events) {
                        this.addAffectedJavaSdk(vFileEvent, (Set<? super Sdk>)affected);
                    }
                    if (!affected.isEmpty()) {
                        for (Sdk sdk2 : affected) {
                            ((SdkType)sdk2.getSdkType()).setupSdkPaths(sdk2);
                        }
                    }
                }
            }

            private void addAffectedJavaSdk(VFileEvent event, Set<? super Sdk> affected) {
                CharSequence fileName = null;
                if (event instanceof VFileCreateEvent) {
                    if (((VFileCreateEvent)event).isDirectory()) {
                        return;
                    }
                    fileName = ((VFileCreateEvent)event).getChildName();
                } else {
                    VirtualFile file2 = event.getFile();
                    if (file2 != null && file2.isValid()) {
                        if (file2.isDirectory()) {
                            return;
                        }
                        fileName = file2.getNameSequence();
                    }
                }
                if (fileName == null) {
                    String eventPath = event.getPath();
                    fileName = VfsUtil.extractFileName((String)eventPath);
                }
                if (fileName != null && !ArchiveFileType.INSTANCE.equals(this.myFileTypeManager.getFileTypeByFileName(fileName))) {
                    return;
                }
                for (Sdk sdk2 : ProjectJdkTableImpl.this.mySdks) {
                    if (!(sdk2.getSdkType() instanceof JavaSdkType) || affected.contains(sdk2)) continue;
                    String homePath = sdk2.getHomePath();
                    String eventPath = event.getPath();
                    if (StringUtil.isEmpty((String)homePath) || !FileUtil.isAncestor((String)homePath, (String)eventPath, (boolean)true)) continue;
                    affected.add((Sdk)sdk2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl$1", "after"));
            }
        });
        SdkType.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<SdkType>(){

            public void extensionAdded(@NotNull SdkType extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                ProjectJdkTableImpl.this.loadSdkType(extension2);
            }

            public void extensionRemoved(@NotNull SdkType extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                ProjectJdkTableImpl.this.forgetSdkType(extension2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private void loadSdkType(@NotNull SdkType newSdkType) {
        if (newSdkType == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(0);
        }
        for (Sdk sdk2 : this.mySdks) {
            SdkTypeId sdkType = sdk2.getSdkType();
            if (!(sdkType instanceof UnknownSdkType) || !sdkType.getName().equals(newSdkType.getName()) || !(sdk2 instanceof ProjectJdkImpl)) continue;
            WriteAction.run(() -> {
                Element additionalData = ProjectJdkTableImpl.saveSdkAdditionalData(sdk2);
                ((ProjectJdkImpl)sdk2).changeType((SdkTypeId)newSdkType, additionalData);
            });
        }
    }

    private void forgetSdkType(@NotNull SdkType extension2) {
        if (extension2 == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(1);
        }
        HashSet<Sdk> toRemove2 = new HashSet<Sdk>();
        for (Sdk sdk2 : this.mySdks) {
            SdkTypeId sdkType = sdk2.getSdkType();
            if (sdkType != extension2) continue;
            if (sdk2 instanceof ProjectJdkImpl) {
                Element additionalDataElement = ProjectJdkTableImpl.saveSdkAdditionalData(sdk2);
                ((ProjectJdkImpl)sdk2).changeType((SdkTypeId)UnknownSdkType.getInstance((String)sdkType.getName()), additionalDataElement);
                continue;
            }
            toRemove2.add(sdk2);
        }
        for (Sdk sdk2 : toRemove2) {
            this.removeJdk(sdk2);
        }
    }

    @Nullable
    private static Element saveSdkAdditionalData(Sdk sdk2) {
        Element additionalDataElement;
        SdkAdditionalData additionalData = sdk2.getSdkAdditionalData();
        if (additionalData != null) {
            additionalDataElement = new Element("additional");
            sdk2.getSdkType().saveAdditionalData(additionalData, additionalDataElement);
        } else {
            additionalDataElement = null;
        }
        return additionalDataElement;
    }

    public File @NotNull [] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"jdk.table")};
        if (fileArray == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(2);
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = ProjectBundle.message((String)"sdk.table.settings", (Object[])new Object[0]);
        if (string == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public Sdk findJdk(@NotNull String name) {
        if (name == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(4);
        }
        int len = this.mySdks.size();
        for (int i2 = 0; i2 < len; ++i2) {
            Sdk jdk = this.mySdks.get(i2);
            if (!Comparing.strEqual((String)name, (String)jdk.getName())) continue;
            return jdk;
        }
        return null;
    }

    @Nullable
    public Sdk findJdk(@NotNull String name, @NotNull String type) {
        Sdk projectJdk;
        if (name == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(6);
        }
        if ((projectJdk = this.findJdk(name)) != null) {
            return projectJdk;
        }
        String uniqueName = type + "." + name;
        projectJdk = this.myCachedProjectJdks.get(uniqueName);
        if (projectJdk != null) {
            return projectJdk;
        }
        @NonNls String jdkPrefix = "jdk.";
        String jdkPath = System.getProperty("jdk." + name);
        if (jdkPath == null) {
            return null;
        }
        SdkType sdkType = SdkType.findByName((String)type);
        if (sdkType != null && sdkType.isValidSdkHome(jdkPath)) {
            ProjectJdkImpl projectJdkImpl = new ProjectJdkImpl(name, (SdkTypeId)sdkType);
            projectJdkImpl.setHomePath(jdkPath);
            sdkType.setupSdkPaths((Sdk)projectJdkImpl);
            this.myCachedProjectJdks.put(uniqueName, projectJdkImpl);
            return projectJdkImpl;
        }
        return null;
    }

    public Sdk @NotNull [] getAllJdks() {
        Sdk[] sdkArray = this.mySdks.toArray(new Sdk[0]);
        if (sdkArray == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(7);
        }
        return sdkArray;
    }

    @NotNull
    public List<Sdk> getSdksOfType(@NotNull SdkTypeId type) {
        Sdk[] sdks;
        if (type == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(8);
        }
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        for (Sdk sdk2 : sdks = this.getAllJdks()) {
            if (sdk2.getSdkType() != type) continue;
            result2.add(sdk2);
        }
        ArrayList<Sdk> arrayList = result2;
        if (arrayList == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @TestOnly
    public void addTestJdk(@NotNull Sdk jdk, @NotNull Disposable parentDisposable) {
        if (jdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(11);
        }
        WriteAction.runAndWait(() -> this.mySdks.add(jdk));
        Disposer.register((Disposable)parentDisposable, () -> this.removeTestJdk(jdk));
    }

    @TestOnly
    public void removeTestJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(12);
        }
        WriteAction.runAndWait(() -> this.mySdks.remove(jdk));
    }

    public void addJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.mySdks.add(jdk);
        ((ProjectJdkTable.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JDK_TABLE_TOPIC)).jdkAdded(jdk);
    }

    public void removeJdk(@NotNull Sdk jdk) {
        if (jdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        ((ProjectJdkTable.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JDK_TABLE_TOPIC)).jdkRemoved(jdk);
        this.mySdks.remove(jdk);
        if (jdk instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)jdk));
        }
    }

    public void updateJdk(@NotNull Sdk originalJdk, @NotNull Sdk modifiedJdk) {
        if (originalJdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(15);
        }
        if (modifiedJdk == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(16);
        }
        String previousName = originalJdk.getName();
        String newName2 = modifiedJdk.getName();
        ((ProjectJdkImpl)modifiedJdk).copyTo((ProjectJdkImpl)originalJdk);
        if (!previousName.equals(newName2)) {
            ((ProjectJdkTable.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(JDK_TABLE_TOPIC)).jdkNameChanged(originalJdk, previousName);
        }
    }

    @NotNull
    public SdkTypeId getDefaultSdkType() {
        UnknownSdkType unknownSdkType = UnknownSdkType.getInstance((String)"");
        if (unknownSdkType == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(17);
        }
        return unknownSdkType;
    }

    @NotNull
    public SdkTypeId getSdkTypeByName(@NotNull String sdkTypeName) {
        if (sdkTypeName == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(18);
        }
        return ProjectJdkTableImpl.findSdkTypeByName(sdkTypeName);
    }

    @NotNull
    private static SdkTypeId findSdkTypeByName(@NotNull String sdkTypeName) {
        SdkType[] allSdkTypes;
        if (sdkTypeName == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(19);
        }
        for (SdkType type : allSdkTypes = SdkType.getAllTypes()) {
            if (!type.getName().equals(sdkTypeName)) continue;
            SdkType sdkType = type;
            if (sdkType == null) {
                ProjectJdkTableImpl.$$$reportNull$$$0(20);
            }
            return sdkType;
        }
        UnknownSdkType unknownSdkType = UnknownSdkType.getInstance((String)sdkTypeName);
        if (unknownSdkType == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(21);
        }
        return unknownSdkType;
    }

    @NotNull
    public Sdk createSdk(@NotNull String name, @NotNull SdkTypeId sdkType) {
        if (name == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(22);
        }
        if (sdkType == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(23);
        }
        return new ProjectJdkImpl(name, sdkType);
    }

    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            ProjectJdkTableImpl.$$$reportNull$$$0(24);
        }
        this.mySdks.clear();
        for (Element child2 : element2.getChildren(ELEMENT_JDK)) {
            ProjectJdkImpl jdk = new ProjectJdkImpl(null, null);
            jdk.readExternal(child2, this);
            this.mySdks.add(jdk);
        }
    }

    public Element getState() {
        Element element2 = new Element("state");
        for (Sdk jdk : this.mySdks) {
            if (!(jdk instanceof ProjectJdkImpl)) continue;
            Element e = new Element(ELEMENT_JDK);
            ((ProjectJdkImpl)jdk).writeExternal(e);
            element2.addContent(e);
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 17: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 17: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 17: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl";
                break;
            }
            case 4: 
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_JDK;
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalJdk";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiedJdk";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkTableImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJdks";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdksOfType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSdkType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findSdkTypeByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadSdkType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forgetSdkType";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 17: 
            case 20: 
            case 21: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findJdk";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSdksOfType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addTestJdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeTestJdk";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addJdk";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeJdk";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "updateJdk";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSdkTypeByName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSdkTypeByName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createSdk";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 17: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

