/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWindows$WhenMappings;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWindows$sam$java_util_function_Supplier$0;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWsl;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/projectRoots/impl/JavaHomeFinderWindows;", "Lcom/intellij/openapi/projectRoots/impl/JavaHomeFinderBasic;", "forceEmbeddedJava", "", "(Z)V", "guessPossibleLocations", "", "", "readRegisteredLocations", "b", "Lcom/intellij/openapi/util/Bitness;", "readRegisteredLocationsOS32J32", "readRegisteredLocationsOS64J32", "readRegisteredLocationsOS64J64", "Companion", "intellij.platform.lang.impl"})
public final class JavaHomeFinderWindows
extends JavaHomeFinderBasic {
    @NotNull
    public static final String defaultJavaLocation = "C:\\Program Files";
    private static final String regCommand = "reg query HKLM\\SOFTWARE\\JavaSoft\\JDK /s /v JavaHome";
    private static final Regex javaHomePattern;
    private static final boolean os64bit;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    private final Set<String> readRegisteredLocationsOS64J64() {
        return this.readRegisteredLocations(Bitness.x64);
    }

    private final Set<String> readRegisteredLocationsOS64J32() {
        return this.readRegisteredLocations(Bitness.x32);
    }

    private final Set<String> readRegisteredLocationsOS32J32() {
        return this.readRegisteredLocations(null);
    }

    private final Set<String> readRegisteredLocations(Bitness b) {
        String string;
        Bitness bitness = b;
        if (bitness == null) {
            string = regCommand;
        } else {
            switch (JavaHomeFinderWindows$WhenMappings.$EnumSwitchMapping$0[bitness.ordinal()]) {
                case 1: {
                    string = "reg query HKLM\\SOFTWARE\\JavaSoft\\JDK /s /v JavaHome /reg:32";
                    break;
                }
                case 2: {
                    string = "reg query HKLM\\SOFTWARE\\JavaSoft\\JDK /s /v JavaHome /reg:64";
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        String cmd = string;
        try {
            String string2 = WindowsRegistryUtil.readRegistry((String)cmd);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"WindowsRegistryUtil.readRegistry(cmd)");
            CharSequence registryLines = string2;
            Set<String> registeredPaths = Companion.gatherHomePaths(registryLines);
            Set folders = new TreeSet();
            for (String rp : registeredPaths) {
                Path r;
                Path path = r = Paths.get(rp, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"r");
                Path parent = path.getParent();
                if (parent != null && PathKt.exists((Path)parent)) {
                    folders.add(parent);
                    continue;
                }
                if (!PathKt.exists((Path)r)) continue;
                folders.add(r);
            }
            Set<String> set2 = this.scanAll(folders, true);
            Intrinsics.checkNotNullExpressionValue(set2, (String)"scanAll(folders, true)");
            return set2;
        }
        catch (InterruptedException ie) {
            return SetsKt.emptySet();
        }
        catch (Exception e) {
            logger.warn("Unable to detect registered JDK using the following command: " + cmd, (Throwable)e);
            return SetsKt.emptySet();
        }
    }

    private final Set<String> guessPossibleLocations() {
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"FileSystems.getDefault()");
        Iterable<Path> iterable = fileSystem.getRootDirectories();
        if (iterable == null) {
            return SetsKt.emptySet();
        }
        Iterable<Path> fsRoots = iterable;
        Set roots = new HashSet();
        Iterator<Path> iterator2 = fsRoots.iterator();
        while (iterator2.hasNext()) {
            Path root;
            Path path = root = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"root");
            if (!PathKt.exists((Path)path)) continue;
            Path path2 = root.resolve("Program Files/Java");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"root.resolve(\"Program Files/Java\")");
            roots.add(path2);
            Path path3 = root.resolve("Program Files (x86)/Java");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"root.resolve(\"Program Files (x86)/Java\")");
            roots.add(path3);
            Path path4 = root.resolve("Java");
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"root.resolve(\"Java\")");
            roots.add(path4);
        }
        Path path = Path.of(SystemProperties.getUserHome(), ".jdks");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Path.of(SystemProperties.getUserHome(), \".jdks\")");
        roots.add(path);
        Set<String> set2 = this.scanAll(roots, true);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"scanAll(roots, true)");
        return set2;
    }

    public JavaHomeFinderWindows(boolean forceEmbeddedJava) {
        super(forceEmbeddedJava, new String[0]);
        Function0 function0;
        if (os64bit && SystemInfoRt.isWindows) {
            function0 = (Function0)new Function0<Set<? extends String>>(this){

                @NotNull
                public final Set<String> invoke() {
                    return ((JavaHomeFinderWindows)this.receiver).readRegisteredLocationsOS64J64();
                }
            };
            this.registerFinder(new JavaHomeFinderWindows$sam$java_util_function_Supplier$0(function0));
            function0 = (Function0)new Function0<Set<? extends String>>(this){

                @NotNull
                public final Set<String> invoke() {
                    return ((JavaHomeFinderWindows)this.receiver).readRegisteredLocationsOS64J32();
                }
            };
            this.registerFinder(new JavaHomeFinderWindows$sam$java_util_function_Supplier$0(function0));
        } else {
            function0 = (Function0)new Function0<Set<? extends String>>(this){

                @NotNull
                public final Set<String> invoke() {
                    return ((JavaHomeFinderWindows)this.receiver).readRegisteredLocationsOS32J32();
                }
            };
            this.registerFinder(new JavaHomeFinderWindows$sam$java_util_function_Supplier$0(function0));
        }
        function0 = (Function0)new Function0<Set<? extends String>>(this){

            @NotNull
            public final Set<String> invoke() {
                return ((JavaHomeFinderWindows)this.receiver).guessPossibleLocations();
            }
        };
        this.registerFinder(new JavaHomeFinderWindows$sam$java_util_function_Supplier$0(function0));
        WslDistributionManager wslDistributionManager = WslDistributionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)wslDistributionManager, (String)"WslDistributionManager.getInstance()");
        for (WSLDistribution distro : wslDistributionManager.getInstalledDistributions()) {
            final JavaHomeFinderWsl wslFinder = new JavaHomeFinderWsl(distro);
            this.registerFinder(new Supplier<Set<String>>(){

                @Override
                public final Set<String> get() {
                    return wslFinder.findExistingJdks();
                }
            });
        }
    }

    static {
        Companion = new Companion(null);
        javaHomePattern = new Regex("^\\s+JavaHome\\s+REG_SZ\\s+(\\S.+\\S)\\s*$", SetsKt.setOf((Object[])new RegexOption[]{RegexOption.MULTILINE, RegexOption.IGNORE_CASE}));
        CharSequence charSequence = System.getenv("ProgramFiles(x86)");
        boolean bl = false;
        boolean bl2 = false;
        os64bit = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        Logger logger = Logger.getInstance(JavaHomeFinderWindows.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(JavaH\u2026inderWindows::class.java)");
        JavaHomeFinderWindows.logger = logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/projectRoots/impl/JavaHomeFinderWindows$Companion;", "", "()V", "defaultJavaLocation", "", "javaHomePattern", "Lkotlin/text/Regex;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "os64bit", "", "regCommand", "getRegCommand$annotations", "gatherHomePaths", "", "text", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        private static /* synthetic */ void getRegCommand$annotations() {
        }

        @NotNull
        public final Set<String> gatherHomePaths(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            TreeSet paths = new TreeSet();
            for (MatchResult m = Regex.find$default((Regex)javaHomePattern, (CharSequence)text2, (int)0, (int)2, null); m != null; m = m.next()) {
                MatchGroup matchGroup;
                if (m.getGroups().get(1) == null) continue;
                boolean bl = false;
                boolean bl2 = false;
                MatchGroup $this$run = matchGroup;
                boolean bl3 = false;
                Collection collection = paths;
                String string = $this$run.getValue();
                boolean bl4 = false;
                collection.add(string);
            }
            return paths;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

