/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.projectRoots.impl.JavaHomeFinderBasic;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderMac;
import com.intellij.openapi.projectRoots.impl.JavaHomeFinderWindows;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.lang.JavaVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaHomeFinder {
    public static final String[] DEFAULT_JAVA_LINUX_PATHS = new String[]{"/usr/java", "/opt/java", "/usr/lib/jvm"};

    @NotNull
    public static List<String> suggestHomePaths() {
        return JavaHomeFinder.suggestHomePaths(false);
    }

    @NotNull
    public static List<String> suggestHomePaths(boolean forceEmbeddedJava) {
        JavaHomeFinderBasic javaFinder = JavaHomeFinder.getFinder(forceEmbeddedJava);
        if (javaFinder == null) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                JavaHomeFinder.$$$reportNull$$$0(0);
            }
            return list2;
        }
        ArrayList<String> paths = new ArrayList<String>(javaFinder.findExistingJdks());
        paths.sort((o1, o2) -> Comparing.compare((Comparable)JavaVersion.tryParse((String)o2), (Comparable)JavaVersion.tryParse((String)o1)));
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            JavaHomeFinder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    private static boolean isDetectorEnabled(boolean forceEmbeddedJava) {
        return forceEmbeddedJava || Registry.is((String)"java.detector.enabled", (boolean)true);
    }

    private static JavaHomeFinderBasic getFinder(boolean forceEmbeddedJava) {
        if (!JavaHomeFinder.isDetectorEnabled(forceEmbeddedJava)) {
            return null;
        }
        if (SystemInfo.isWindows) {
            return new JavaHomeFinderWindows(forceEmbeddedJava);
        }
        if (SystemInfo.isMac) {
            return new JavaHomeFinderMac(forceEmbeddedJava);
        }
        if (SystemInfo.isLinux) {
            return new JavaHomeFinderBasic(forceEmbeddedJava, DEFAULT_JAVA_LINUX_PATHS);
        }
        if (SystemInfo.isSolaris) {
            return new JavaHomeFinderBasic(forceEmbeddedJava, "/usr/jdk");
        }
        return new JavaHomeFinderBasic(forceEmbeddedJava, new String[0]);
    }

    @Nullable
    public static String defaultJavaLocation() {
        if (SystemInfo.isWindows) {
            return "C:\\Program Files";
        }
        if (SystemInfo.isMac) {
            return JavaHomeFinderMac.defaultJavaLocation;
        }
        if (SystemInfo.isLinux) {
            return "/opt/java";
        }
        if (SystemInfo.isSolaris) {
            return "/usr/jdk";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/JavaHomeFinder", "suggestHomePaths"));
    }
}

