/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerExImpl;
import com.intellij.openapi.project.impl.ProjectManagerExImplKt;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.serviceContainer.ContainerUtilKt;
import com.intellij.util.io.PathKt;
import java.awt.AWTEvent;
import java.awt.event.InvocationEvent;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.PicoContainer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003\u001a\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u00a8\u0006\u001b"}, d2={"checkExistingProjectOnOpen", "", "projectToClose", "Lcom/intellij/openapi/project/Project;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "projectDir", "Ljava/nio/file/Path;", "projectManager", "Lcom/intellij/openapi/project/impl/ProjectManagerExImpl;", "message", "", "e", "", "openProject", "", "project", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "runStartUpActivities", "removeProjectConfigurationAndCaches", "projectFile", "toCanonicalName", "filePath", "waitAndProcessInvocationEventsInIdeEventQueue", "startupManager", "Lcom/intellij/ide/startup/impl/StartupManagerImpl;", "intellij.platform.ide.impl"})
public final class ProjectManagerExImplKt {
    @NlsSafe
    private static final String message(Throwable e) {
        String message2;
        String string = e.getMessage();
        if (string == null) {
            string = message2 = e.getLocalizedMessage();
        }
        if (message2 != null) {
            return message2;
        }
        message2 = e.toString();
        Throwable throwable = e.getCause();
        if (throwable == null) {
            return message2;
        }
        String causeMessage = ProjectManagerExImplKt.message(throwable);
        return message2 + " (cause: " + causeMessage + ')';
    }

    private static final boolean checkExistingProjectOnOpen(Project projectToClose, ProjectOpenedCallback callback2, Path projectDir, ProjectManagerExImpl projectManager) {
        CompletableFuture result2 = new CompletableFuture();
        GeneralSettings settings = GeneralSettings.getInstance();
        boolean isValidProject = projectDir != null && com.intellij.ide.impl.ProjectUtil.isValidProjectPath(projectDir);
        ApplicationManager.getApplication().invokeAndWait(new Runnable(projectDir, isValidProject, settings, result2, projectManager, projectToClose, callback2){
            final /* synthetic */ Path $projectDir;
            final /* synthetic */ boolean $isValidProject;
            final /* synthetic */ GeneralSettings $settings;
            final /* synthetic */ CompletableFuture $result;
            final /* synthetic */ ProjectManagerExImpl $projectManager;
            final /* synthetic */ Project $projectToClose;
            final /* synthetic */ ProjectOpenedCallback $callback;

            /*
             * Unable to fully structure code
             */
            public final void run() {
                try {
                    if (this.$projectDir == null || !ProjectAttachProcessor.canAttachToProject()) ** GOTO lbl-1000
                    if (!this.$isValidProject) ** GOTO lbl-1000
                    v0 = this.$settings;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"settings");
                    if (v0.getConfirmOpenNewProject() == -1) lbl-1000:
                    // 2 sources

                    {
                        if ((exitCode = com.intellij.ide.impl.ProjectUtil.confirmOpenOrAttachProject()) == -1) {
                            this.$result.complete(true);
                            return;
                        }
                        if (exitCode == 1) {
                            if (!this.$projectManager.closeAndDispose(this.$projectToClose)) {
                                this.$result.complete(true);
                                return;
                            }
                        } else if (exitCode == 2 && PlatformProjectOpenProcessor.Companion.attachToProject(this.$projectToClose, this.$projectDir, this.$callback)) {
                            this.$result.complete(true);
                            return;
                        }
                        IdeEventQueue.getInstance().flushQueue();
                    } else if ((exitCode = com.intellij.ide.impl.ProjectUtil.confirmOpenNewProject(false)) == 1) {
                        if (!this.$projectManager.closeAndDispose(this.$projectToClose)) {
                            this.$result.complete(true);
                            return;
                        }
                    } else if (exitCode != 0) {
                        this.$result.complete(true);
                        return;
                    }
                    this.$result.complete(false);
                }
                catch (Throwable err) {
                    this.$result.completeExceptionally(err);
                }
            }
            {
                this.$projectDir = path;
                this.$isValidProject = bl;
                this.$settings = generalSettings;
                this.$result = completableFuture;
                this.$projectManager = projectManagerExImpl;
                this.$projectToClose = project;
                this.$callback = projectOpenedCallback;
            }
        });
        Object t = result2.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"result.get()");
        return (Boolean)t;
    }

    private static final void openProject(Project project, ProgressIndicator indicator, boolean runStartUpActivities) {
        Activity activity = StartUpMeasurer.startMainActivity((String)"placing calling projectOpened on event queue");
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startMai\u2026ctOpened on event queue\")");
        Activity waitEdtActivity = activity;
        if (indicator != null) {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            indicator.setText(application.isInternal() ? "Waiting on event queue..." : ProjectBundle.message((String)"project.preparing.workspace", (Object[])new Object[0]));
            indicator.setIndeterminate(true);
        }
        ApplicationManager.getApplication().invokeAndWait(new Runnable(waitEdtActivity, indicator, project){
            final /* synthetic */ Activity $waitEdtActivity;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Project $project;

            public final void run() {
                this.$waitEdtActivity.end();
                if (this.$indicator != null) {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (application.isInternal()) {
                        this.$indicator.setText("Running project opened tasks...");
                    }
                }
                ProjectManagerImpl.LOG.debug("projectOpened");
                LifecycleUsageTriggerCollector.onProjectOpened(this.$project);
                Activity activity = StartUpMeasurer.startMainActivity((String)"project opened callbacks");
                Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"StartUpMeasurer.startMai\u2026roject opened callbacks\")");
                Activity activity2 = activity;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                ((ProjectManagerListener)application.getMessageBus().syncPublisher(ProjectManager.TOPIC)).projectOpened(this.$project);
                PicoContainer picoContainer = this.$project.getPicoContainer();
                Intrinsics.checkNotNullExpressionValue((Object)picoContainer, (String)"project.picoContainer");
                ContainerUtilKt.processProjectComponents(picoContainer, (Function2<? super ProjectComponent, ? super PluginDescriptor, Unit>)((Function2)openProject.1.INSTANCE));
                activity2.end();
                ProjectImpl.ourClassesAreLoaded = true;
            }
            {
                this.$waitEdtActivity = activity;
                this.$indicator = progressIndicator;
                this.$project = project;
            }
        });
        if (runStartUpActivities) {
            StartupManager startupManager = StartupManager.getInstance((Project)project);
            if (startupManager == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.ide.startup.impl.StartupManagerImpl");
            }
            ((StartupManagerImpl)startupManager).projectOpened(indicator);
        }
    }

    public static final void waitAndProcessInvocationEventsInIdeEventQueue(@NotNull StartupManagerImpl startupManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)startupManager), (String)"startupManager");
        IdeEventQueue eventQueue = IdeEventQueue.getInstance();
        while (true) {
            AWTEvent event;
            if (eventQueue.peekEvent() == null) {
                if (!startupManager.postStartupActivityPassed()) continue;
                break;
            }
            IdeEventQueue ideEventQueue = eventQueue;
            Intrinsics.checkNotNullExpressionValue((Object)ideEventQueue, (String)"eventQueue");
            Intrinsics.checkNotNullExpressionValue((Object)ideEventQueue.getNextEvent(), (String)"eventQueue.nextEvent");
            if (!(event instanceof InvocationEvent)) continue;
            eventQueue.dispatchEvent(event);
        }
    }

    private static final Path toCanonicalName(String filePath) {
        Path file2 = Paths.get(filePath, new String[0]);
        try {
            if (SystemInfoRt.isWindows && FileUtil.containsWindowsShortName((String)filePath)) {
                Path path = file2.toRealPath(LinkOption.NOFOLLOW_LINKS);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.toRealPath(LinkOption.NOFOLLOW_LINKS)");
                return path;
            }
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path path = file2;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void removeProjectConfigurationAndCaches(Path projectFile) {
        block11: {
            try {
                if (Files.isRegularFile(projectFile, new LinkOption[0])) {
                    Files.deleteIfExists(projectFile);
                    break block11;
                }
                Closeable closeable = Files.newDirectoryStream(projectFile.resolve(".idea"));
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    DirectoryStream directoryStream = (DirectoryStream)closeable;
                    boolean bl3 = false;
                    Iterator iterator2 = directoryStream.iterator();
                    while (iterator2.hasNext()) {
                        Path file2;
                        Path path = file2 = (Path)iterator2.next();
                        Intrinsics.checkNotNull((Object)path);
                        PathKt.delete$default((Path)path, (boolean)false, (int)1, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            PathKt.delete$default((Path)ProjectUtil.getProjectDataPathRoot((Path)projectFile), (boolean)false, (int)1, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final /* synthetic */ Path access$toCanonicalName(String filePath) {
        return ProjectManagerExImplKt.toCanonicalName(filePath);
    }

    public static final /* synthetic */ boolean access$checkExistingProjectOnOpen(Project projectToClose, ProjectOpenedCallback callback2, Path projectDir, ProjectManagerExImpl projectManager) {
        return ProjectManagerExImplKt.checkExistingProjectOnOpen(projectToClose, callback2, projectDir, projectManager);
    }

    public static final /* synthetic */ void access$openProject(Project project, ProgressIndicator indicator, boolean runStartUpActivities) {
        ProjectManagerExImplKt.openProject(project, indicator, runStartUpActivities);
    }

    public static final /* synthetic */ void access$removeProjectConfigurationAndCaches(Path projectFile) {
        ProjectManagerExImplKt.removeProjectConfigurationAndCaches(projectFile);
    }

    public static final /* synthetic */ String access$message(Throwable e) {
        return ProjectManagerExImplKt.message(e);
    }
}

