/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ExcludeRootsCache {
    private volatile CachedUrls myCache;

    ExcludeRootsCache(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            ExcludeRootsCache.$$$reportNull$$$0(0);
        }
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExcludeRootsCache.this.myCache = null;
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExcludeRootsCache.this.myCache = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/openapi/project/impl/ExcludeRootsCache$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    final List<String> getExcludedUrls() {
        List list2 = (List)ReadAction.compute(() -> {
            Object[] urls;
            CachedUrls cache2 = this.myCache;
            long actualModCount = Arrays.stream(ProjectManager.getInstance().getOpenProjects()).map(ProjectRootManager::getInstance).mapToLong(SimpleModificationTracker::getModificationCount).sum();
            if (cache2 != null && actualModCount == cache2.myModificationCount) {
                urls = cache2.myUrls;
            } else {
                HashSet excludedUrls = new HashSet();
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        Collections.addAll(excludedUrls, ModuleRootManager.getInstance((Module)module).getExcludeRootUrls());
                    }
                }
                urls = ArrayUtilRt.toStringArray(excludedUrls);
                Arrays.sort(urls);
                this.myCache = new CachedUrls(actualModCount, (String[])urls);
            }
            return Arrays.asList(urls);
        });
        if (list2 == null) {
            ExcludeRootsCache.$$$reportNull$$$0(1);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/impl/ExcludeRootsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/impl/ExcludeRootsCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CachedUrls {
        private final long myModificationCount;
        private final String @NotNull [] myUrls;

        /*
         * WARNING - void declaration
         */
        private CachedUrls(long count, String @NotNull [] stringArray) {
            void urls;
            if (stringArray == null) {
                CachedUrls.$$$reportNull$$$0(0);
            }
            this.myModificationCount = count;
            this.myUrls = urls;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/openapi/project/impl/ExcludeRootsCache$CachedUrls", "<init>"));
        }
    }
}

