/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressDialog;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.SunToolkit;

public final class PotemkinProgress
extends ProgressWindow
implements PingProgress {
    private final Application myApp;
    private long myLastUiUpdate;
    private final LinkedBlockingQueue<InputEvent> myInputEvents;
    private final LinkedBlockingQueue<InvocationEvent> myInvocationEvents;
    private long myLastInteraction;

    public PotemkinProgress(@NotNull @NlsContexts.ProgressTitle String title, @Nullable Project project, @Nullable JComponent parentComponent, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String cancelText) {
        if (title == null) {
            PotemkinProgress.$$$reportNull$$$0(0);
        }
        super(cancelText != null, false, project, parentComponent, cancelText);
        this.myApp = ApplicationManager.getApplication();
        this.myLastUiUpdate = System.currentTimeMillis();
        this.myInputEvents = new LinkedBlockingQueue();
        this.myInvocationEvents = new LinkedBlockingQueue();
        this.setTitle(title);
        this.myApp.assertIsDispatchThread();
        this.startStealingInputEvents();
    }

    private void startStealingInputEvents() {
        IdeEventQueue.getInstance().addPostEventListener(event -> {
            if (event instanceof MouseEvent || event instanceof KeyEvent && ((KeyEvent)event).getKeyCode() == 27) {
                this.myInputEvents.offer((InputEvent)event);
                return true;
            }
            if (event instanceof InvocationEvent && PotemkinProgress.isUrgentInvocationEvent(event)) {
                this.myInvocationEvents.offer((InvocationEvent)event);
                return true;
            }
            return false;
        }, this);
    }

    private static boolean isUrgentInvocationEvent(AWTEvent event) {
        return event.toString().contains(",runnable=sun.lwawt.macosx.LWCToolkit") || event instanceof MyInvocationEvent;
    }

    @Override
    @NotNull
    protected ProgressDialog getDialog() {
        ProgressDialog progressDialog = Objects.requireNonNull(super.getDialog());
        if (progressDialog == null) {
            PotemkinProgress.$$$reportNull$$$0(1);
        }
        return progressDialog;
    }

    @Override
    public void interact() {
        if (!this.myApp.isDispatchThread()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now == this.myLastInteraction) {
            return;
        }
        this.myLastInteraction = now;
        if (this.getDialog().getPanel().isShowing()) {
            this.dispatchAwtEventsWithoutModelAccess(0);
        }
        this.updateUI(now);
    }

    private void dispatchAwtEventsWithoutModelAccess(int timeoutMs) {
        SunToolkit.flushPendingEvents();
        try {
            while (true) {
                this.dispatchInvocationEvents();
                InputEvent event = this.myInputEvents.poll(timeoutMs, TimeUnit.MILLISECONDS);
                if (event == null) {
                    return;
                }
                this.dispatchInputEvent(event);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void dispatchInputEvent(@NotNull InputEvent e) {
        if (e == null) {
            PotemkinProgress.$$$reportNull$$$0(2);
        }
        if (this.isCancellationEvent(e)) {
            this.cancel();
            return;
        }
        Object source = e.getSource();
        if (source instanceof Component && this.isInDialogWindow((Component)source)) {
            ((Component)source).dispatchEvent(e);
        }
    }

    private boolean isInDialogWindow(Component source) {
        Window dialogWindow = SwingUtilities.windowForComponent(this.getDialog().getPanel());
        return dialogWindow instanceof JDialog && SwingUtilities.isDescendingFrom(source, dialogWindow);
    }

    private void updateUI(long now) {
        if (this.myApp.isUnitTestMode()) {
            return;
        }
        JRootPane rootPane = this.getDialog().getPanel().getRootPane();
        if (rootPane == null) {
            rootPane = this.considerShowingDialog(now);
        }
        if (rootPane != null && this.timeToPaint(now)) {
            this.paintProgress();
        }
    }

    @Nullable
    private JRootPane considerShowingDialog(long now) {
        if (now - this.myLastUiUpdate > (long)this.myDelayInMillis && this.myApp.isActive() && this.myApp.getServiceIfCreated(DialogWrapperPeerFactory.class) != null) {
            this.getDialog().myRepaintRunnable.run();
            this.showDialog();
            return this.getDialog().getPanel().getRootPane();
        }
        return null;
    }

    private boolean timeToPaint(long now) {
        if (now - this.myLastUiUpdate <= 50L) {
            return false;
        }
        this.myLastUiUpdate = now;
        return true;
    }

    private void progressFinished() {
        this.getDialog().hideImmediately();
        this.dispatchInvocationEvents();
    }

    private void dispatchInvocationEvents() {
        InvocationEvent event;
        while ((event = this.myInvocationEvents.poll()) != null) {
            event.dispatch();
        }
        return;
    }

    private void paintProgress() {
        this.getDialog().myRepaintRunnable.run();
        JPanel dialogPanel = this.getDialog().getPanel();
        dialogPanel.validate();
        dialogPanel.paintImmediately(dialogPanel.getBounds());
    }

    public void runInSwingThread(@NotNull Runnable action2) {
        if (action2 == null) {
            PotemkinProgress.$$$reportNull$$$0(3);
        }
        this.myApp.assertIsDispatchThread();
        try {
            ProgressManager.getInstance().runProcess(action2, (ProgressIndicator)this);
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            this.progressFinished();
        }
    }

    public void runInBackground(@NotNull Runnable action2) {
        if (action2 == null) {
            PotemkinProgress.$$$reportNull$$$0(4);
        }
        this.myApp.assertIsDispatchThread();
        this.enterModality();
        try {
            this.ensureBackgroundThreadStarted(action2);
            while (this.isRunning()) {
                this.dispatchAwtEventsWithoutModelAccess(10);
                this.updateUI(System.currentTimeMillis());
            }
        }
        finally {
            this.exitModality();
            this.progressFinished();
        }
    }

    private void ensureBackgroundThreadStarted(@NotNull Runnable action2) {
        if (action2 == null) {
            PotemkinProgress.$$$reportNull$$$0(5);
        }
        Semaphore started = new Semaphore();
        started.down();
        AppExecutorUtil.getAppExecutorService().execute(() -> ProgressManager.getInstance().runProcess(() -> {
            started.up();
            action2.run();
        }, (ProgressIndicator)this));
        started.waitFor();
    }

    public static void invokeLaterNotBlocking(Object source, Runnable runnable2) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new MyInvocationEvent(source, runnable2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/PotemkinProgress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/PotemkinProgress";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dispatchInputEvent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runInSwingThread";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runInBackground";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureBackgroundThreadStarted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyInvocationEvent
    extends InvocationEvent {
        MyInvocationEvent(Object source, Runnable runnable2) {
            super(source, runnable2);
        }
    }
}

