/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.icons.AllIcons;
import com.intellij.model.Pointer;
import com.intellij.model.Symbol;
import com.intellij.model.presentation.PresentableSymbol;
import com.intellij.model.presentation.SymbolPresentation;
import com.intellij.navigation.NavigatableSymbol;
import com.intellij.navigation.NavigationTarget;
import com.intellij.navigation.TargetPopupPresentation;
import com.intellij.openapi.paths.UrlNavigatable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.pom.Navigatable;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0001H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u0000H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/paths/UrlSymbol;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/model/presentation/PresentableSymbol;", "Lcom/intellij/navigation/NavigatableSymbol;", "Lcom/intellij/navigation/NavigationTarget;", "url", "", "(Ljava/lang/String;)V", "createPointer", "Lcom/intellij/model/Symbol;", "dereference", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "getNavigationTargets", "", "project", "Lcom/intellij/openapi/project/Project;", "getSymbolPresentation", "Lcom/intellij/model/presentation/SymbolPresentation;", "getTargetPresentation", "Lcom/intellij/navigation/TargetPopupPresentation;", "isValid", "", "intellij.platform.lang.impl"})
final class UrlSymbol
implements Pointer<UrlSymbol>,
PresentableSymbol,
NavigatableSymbol,
NavigationTarget {
    private final String url;

    @NotNull
    public Pointer<? extends Symbol> createPointer() {
        return this;
    }

    @Nullable
    public UrlSymbol dereference() {
        return this;
    }

    @NotNull
    public SymbolPresentation getSymbolPresentation() {
        SymbolPresentation symbolPresentation = SymbolPresentation.create((Icon)AllIcons.General.Web, (String)this.url, (String)this.url);
        Intrinsics.checkNotNullExpressionValue((Object)symbolPresentation, (String)"SymbolPresentation.creat\u2026ns.General.Web, url, url)");
        return symbolPresentation;
    }

    @NotNull
    public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.listOf((Object)this);
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    public Navigatable getNavigatable() {
        return new UrlNavigatable(this.url);
    }

    @NotNull
    public TargetPopupPresentation getTargetPresentation() {
        String string = "In all known cases the symbol doesn't appear in the disambiguation popup, because this symbol is usually alone, so no popup required. Implement this method when needed.";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    public UrlSymbol(@NlsSafe @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }
}

