/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.observable.properties;

import com.intellij.openapi.observable.operations.AnonymousParallelOperationTrace;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableClearableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002$%B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004JG\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\r2\u001d\u0010\u0018\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u0016\u0012\u0004\u0012\u00020\u00130\u0019\u00a2\u0006\u0002\b\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dJ&\u0010\u001e\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\rJ4\u0010\u001e\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u001dJ\u0014\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\rH\u0007J\u0014\u0010\"\u001a\u00020\u00132\n\u0010\u0017\u001a\u00060\u0007R\u00020\u0000H\u0002J\u0012\u0010#\u001a\u00020\u00132\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\rR(\u0010\u0005\u001a\u001c\u0012\b\u0012\u00060\u0007R\u00020\u0000\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001d\u0012\u0014\u0012\u0012 \u0010*\b\u0018\u00010\u0007R\u00020\u00000\u0007R\u00020\u00000\u000f\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/openapi/observable/properties/PropertyGraph;", "", "debugName", "", "(Ljava/lang/String;)V", "dependencies", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/intellij/openapi/observable/properties/PropertyGraph$Dependency;", "propagation", "Lcom/intellij/openapi/observable/operations/AnonymousParallelOperationTrace;", "properties", "Lcom/intellij/openapi/observable/properties/ObservableClearableProperty;", "recursionGuard", "Lcom/intellij/openapi/util/RecursionGuard;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addDependency", "", "T", "child", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "parent", "update", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "afterPropagation", "listener", "Lkotlin/Function0;", "dependsOn", "isPropagationBlocked", "", "property", "propagateChange", "register", "Dependency", "PropertyNode", "intellij.platform.ide.impl"})
public final class PropertyGraph {
    private final AnonymousParallelOperationTrace propagation;
    private final ConcurrentHashMap<ObservableClearableProperty<?>, PropertyNode> properties;
    private final ConcurrentHashMap<PropertyNode, CopyOnWriteArrayList<Dependency<?>>> dependencies;
    private final RecursionGuard<PropertyNode> recursionGuard;

    public final <T> void dependsOn(@NotNull AtomicProperty<T> child2, @NotNull ObservableClearableProperty<?> parent) {
        Intrinsics.checkNotNullParameter(child2, (String)"child");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        this.addDependency(child2, parent, dependsOn.1.INSTANCE);
    }

    public final <T> void dependsOn(@NotNull AtomicProperty<T> child2, @NotNull ObservableClearableProperty<?> parent, @NotNull Function0<? extends T> update2) {
        Intrinsics.checkNotNullParameter(child2, (String)"child");
        Intrinsics.checkNotNullParameter(parent, (String)"parent");
        Intrinsics.checkNotNullParameter(update2, (String)"update");
        this.addDependency(child2, parent, (Function1)new Function1<AtomicProperty<T>, Unit>(update2){
            final /* synthetic */ Function0 $update;

            public final void invoke(@NotNull AtomicProperty<T> $this$addDependency) {
                Intrinsics.checkNotNullParameter($this$addDependency, (String)"$receiver");
                $this$addDependency.updateAndGet((Function1)new Function1<T, T>(this){
                    final /* synthetic */ dependsOn.2 this$0;

                    public final T invoke(T it) {
                        return (T)this.this$0.$update.invoke();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.$update = function0;
                super(1);
            }
        });
    }

    private final <T> void addDependency(AtomicProperty<T> child2, ObservableClearableProperty<?> parent, Function1<? super AtomicProperty<T>, Unit> update2) {
        PropertyNode propertyNode = this.properties.get(child2);
        if (propertyNode == null) {
            throw (Throwable)new IllegalArgumentException("Unregistered child property");
        }
        Intrinsics.checkNotNullExpressionValue((Object)propertyNode, (String)"properties[child] ?: thr\u2026gistered child property\")");
        PropertyNode childNode = propertyNode;
        PropertyNode propertyNode2 = this.properties.get(parent);
        if (propertyNode2 == null) {
            throw (Throwable)new IllegalArgumentException("Unregistered parent property");
        }
        Intrinsics.checkNotNullExpressionValue((Object)propertyNode2, (String)"properties[parent] ?: th\u2026istered parent property\")");
        PropertyNode parentNode = propertyNode2;
        this.dependencies.putIfAbsent(parentNode, new CopyOnWriteArrayList());
        CopyOnWriteArrayList children2 = (CopyOnWriteArrayList)MapsKt.getValue((Map)this.dependencies, (Object)parentNode);
        children2.add(new Dependency<T>(childNode, child2, update2));
    }

    public final void afterPropagation(@NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.propagation.afterOperation(listener2);
    }

    public final void register(@NotNull ObservableClearableProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        PropertyNode node = new PropertyNode();
        ((Map)this.properties).put(property, node);
        property.afterChange((Function1)new Function1<Object, Unit>(this, node){
            final /* synthetic */ PropertyGraph this$0;
            final /* synthetic */ PropertyNode $node;

            public final void invoke(@Nullable Object it) {
                PropertyGraph.access$getRecursionGuard$p(this.this$0).doPreventingRecursion((Object)this.$node, false, (Computable)new Computable<Unit>(this){
                    final /* synthetic */ register.1 this$0;

                    public final void compute() {
                        AnonymousParallelOperationTrace.Companion.task(PropertyGraph.access$getPropagation$p(this.this$0.this$0), (Function0)new Function0<Unit>(this){
                            final /* synthetic */ register.1 this$0;

                            public final void invoke() {
                                this.this$0.this$0.$node.setPropagationBlocked(true);
                                PropertyGraph.access$propagateChange(this.this$0.this$0.this$0, this.this$0.this$0.$node);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = propertyGraph;
                this.$node = propertyNode;
                super(1);
            }
        });
        property.afterReset((Function0<Unit>)((Function0)new Function0<Unit>(node){
            final /* synthetic */ PropertyNode $node;

            public final void invoke() {
                this.$node.setPropagationBlocked(false);
            }
            {
                this.$node = propertyNode;
                super(0);
            }
        }));
    }

    private final void propagateChange(PropertyNode parent) {
        CopyOnWriteArrayList<Dependency<?>> copyOnWriteArrayList = this.dependencies.get(parent);
        if (copyOnWriteArrayList == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue(copyOnWriteArrayList, (String)"dependencies[parent] ?: return");
        CopyOnWriteArrayList<Dependency<?>> dependencies = copyOnWriteArrayList;
        for (Dependency<?> dependency : dependencies) {
            PropertyNode child2 = dependency.getNode();
            if (child2.isPropagationBlocked()) continue;
            this.recursionGuard.doPreventingRecursion((Object)child2, false, (Computable)new Computable<Unit>(this, dependency, child2){
                final /* synthetic */ PropertyGraph this$0;
                final /* synthetic */ Dependency $dependency;
                final /* synthetic */ PropertyNode $child;

                public final void compute() {
                    this.$dependency.applyUpdate();
                    PropertyGraph.access$propagateChange(this.this$0, this.$child);
                }
                {
                    this.this$0 = propertyGraph;
                    this.$dependency = dependency;
                    this.$child = propertyNode;
                }
            });
        }
    }

    @TestOnly
    public final boolean isPropagationBlocked(@NotNull ObservableClearableProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return ((PropertyNode)MapsKt.getValue((Map)this.properties, property)).isPropagationBlocked();
    }

    public PropertyGraph(@Nullable String debugName) {
        this.propagation = new AnonymousParallelOperationTrace((debugName == null ? "" : " of " + debugName) + ": Graph propagation");
        this.properties = new ConcurrentHashMap();
        this.dependencies = new ConcurrentHashMap();
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)PropertyGraph.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)recursionGuard, (String)"RecursionManager.createG\u2026tyGraph::class.java.name)");
        this.recursionGuard = recursionGuard;
    }

    public /* synthetic */ PropertyGraph(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public PropertyGraph() {
        this(null, 1, null);
    }

    public static final /* synthetic */ RecursionGuard access$getRecursionGuard$p(PropertyGraph $this) {
        return $this.recursionGuard;
    }

    public static final /* synthetic */ AnonymousParallelOperationTrace access$getPropagation$p(PropertyGraph $this) {
        return $this.propagation;
    }

    public static final /* synthetic */ void access$propagateChange(PropertyGraph $this, PropertyNode parent) {
        $this.propagateChange(parent);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;", "", "(Lcom/intellij/openapi/observable/properties/PropertyGraph;)V", "isPropagationBlocked", "", "()Z", "setPropagationBlocked", "(Z)V", "intellij.platform.ide.impl"})
    private final class PropertyNode {
        private volatile boolean isPropagationBlocked;

        public final boolean isPropagationBlocked() {
            return this.isPropagationBlocked;
        }

        public final void setPropagationBlocked(boolean bl) {
            this.isPropagationBlocked = bl;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B>\u0012\n\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u001d\u0010\b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0013\u001a\u00020\nJ\r\u0010\u0014\u001a\u00060\u0004R\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u00c6\u0003J \u0010\u0016\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000bH\u00c6\u0003JN\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\b\u0002\u0010\u0003\u001a\u00060\u0004R\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u001f\b\u0002\u0010\b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R(\u0010\b\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/observable/properties/PropertyGraph$Dependency;", "T", "", "node", "Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "property", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "update", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;Lcom/intellij/openapi/observable/properties/AtomicProperty;Lkotlin/jvm/functions/Function1;)V", "getNode", "()Lcom/intellij/openapi/observable/properties/PropertyGraph$PropertyNode;", "getProperty", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getUpdate", "()Lkotlin/jvm/functions/Function1;", "applyUpdate", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    private static final class Dependency<T> {
        @NotNull
        private final PropertyNode node;
        @NotNull
        private final AtomicProperty<T> property;
        @NotNull
        private final Function1<AtomicProperty<T>, Unit> update;

        public final void applyUpdate() {
            this.update.invoke(this.property);
        }

        @NotNull
        public final PropertyNode getNode() {
            return this.node;
        }

        @NotNull
        public final AtomicProperty<T> getProperty() {
            return this.property;
        }

        @NotNull
        public final Function1<AtomicProperty<T>, Unit> getUpdate() {
            return this.update;
        }

        public Dependency(@NotNull PropertyNode node, @NotNull AtomicProperty<T> property, @NotNull Function1<? super AtomicProperty<T>, Unit> update2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNullParameter(update2, (String)"update");
            this.node = node;
            this.property = property;
            this.update = update2;
        }

        @NotNull
        public final PropertyNode component1() {
            return this.node;
        }

        @NotNull
        public final AtomicProperty<T> component2() {
            return this.property;
        }

        @NotNull
        public final Function1<AtomicProperty<T>, Unit> component3() {
            return this.update;
        }

        @NotNull
        public final Dependency<T> copy(@NotNull PropertyNode node, @NotNull AtomicProperty<T> property, @NotNull Function1<? super AtomicProperty<T>, Unit> update2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNullParameter(update2, (String)"update");
            return new Dependency<T>(node, property, update2);
        }

        public static /* synthetic */ Dependency copy$default(Dependency dependency, PropertyNode propertyNode, AtomicProperty atomicProperty, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                propertyNode = dependency.node;
            }
            if ((n & 2) != 0) {
                atomicProperty = dependency.property;
            }
            if ((n & 4) != 0) {
                function1 = dependency.update;
            }
            return dependency.copy(propertyNode, atomicProperty, function1);
        }

        @NotNull
        public String toString() {
            return "Dependency(node=" + this.node + ", property=" + this.property + ", update=" + this.update + ")";
        }

        public int hashCode() {
            PropertyNode propertyNode = this.node;
            AtomicProperty<T> atomicProperty = this.property;
            Function1<AtomicProperty<T>, Unit> function1 = this.update;
            return ((propertyNode != null ? propertyNode.hashCode() : 0) * 31 + (atomicProperty != null ? atomicProperty.hashCode() : 0)) * 31 + (function1 != null ? function1.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Dependency)) break block3;
                    Dependency dependency = (Dependency)object;
                    if (!Intrinsics.areEqual((Object)this.node, (Object)dependency.node) || !Intrinsics.areEqual(this.property, dependency.property) || !Intrinsics.areEqual(this.update, dependency.update)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

