/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.ModuleStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleDescription;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.module.impl.ExternalModuleListStorage;
import com.intellij.openapi.module.impl.ExternalModuleListStorageKt;
import com.intellij.openapi.module.impl.LoadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleGroupersKt;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathSaveItem;
import com.intellij.openapi.module.impl.SaveItem;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListStorage;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@ApiStatus.Internal
public abstract class ModuleManagerImpl
extends ModuleManagerEx
implements Disposable,
PersistentStateComponent<Element>,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance(ModuleManagerImpl.class);
    private static final Key<String> DISPOSED_MODULE_NAME = Key.create((String)"DisposedNeverAddedModuleName");
    protected final Project myProject;
    private final ProjectRootManagerEx myProjectRootManager;
    protected volatile ModuleModelImpl myModuleModel;
    private Set<ModulePath> myModulePathsToLoad;
    private final Set<ModulePath> myFailedModulePaths;
    private final Map<String, UnloadedModuleDescriptionImpl> myUnloadedModules;
    private boolean myModulesLoaded;
    private volatile Module[] myCachedSortedModules;
    private volatile Graph<Module> myCachedModuleProductionGraph;
    private volatile Graph<Module> myCachedModuleTestGraph;
    private volatile Comparator<Module> myCachedModuleComparator;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance((Project)project);
    }

    public ModuleManagerImpl(@NotNull Project project) {
        if (project == null) {
            ModuleManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModuleModel = new ModuleModelImpl(this);
        this.myFailedModulePaths = new HashSet<ModulePath>();
        this.myUnloadedModules = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>();
        this.myProject = project;
        this.myProjectRootManager = ProjectRootManagerEx.getInstanceEx((Project)project);
    }

    public void projectOpened() {
        this.fireModulesAdded();
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectOpened();
        }
    }

    public void projectClosed() {
        for (Module module : this.myModuleModel.getModules()) {
            ((ModuleEx)module).projectClosed();
        }
    }

    protected void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
        this.myCachedModuleProductionGraph = null;
        this.myCachedModuleTestGraph = null;
    }

    public void dispose() {
        this.myModuleModel.disposeModel();
        this.myProjectRootManager.assertListenersAreDisposed();
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e, ExternalModuleListStorageKt.getFilteredModuleList(this.myProject, this.getModules(), false));
        return e;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ModuleManagerImpl.$$$reportNull$$$0(1);
        }
        Set<ModulePath> files2 = ModuleManagerImpl.getPathsToModuleFiles(state);
        Set<ModulePath> externalModules = ((ExternalModuleListStorage)this.myProject.getComponent(ExternalModuleListStorage.class)).getExternalModules();
        if (externalModules != null) {
            files2.addAll(externalModules);
        }
        this.loadState(files2);
    }

    public void noStateLoaded() {
        Set<ModulePath> externalModules = ((ExternalModuleListStorage)this.myProject.getComponent(ExternalModuleListStorage.class)).getExternalModules();
        if (externalModules != null) {
            this.loadState(new LinkedHashSet<ModulePath>(externalModules));
        }
    }

    private void loadState(@NotNull Set<ModulePath> modulePaths) {
        if (modulePaths == null) {
            ModuleManagerImpl.$$$reportNull$$$0(2);
        }
        boolean isFirstLoadState = this.myModulePathsToLoad == null;
        this.myModulePathsToLoad = modulePaths;
        HashSet<String> unloadedModuleNames = new HashSet<String>(UnloadedModulesListStorage.getInstance(this.myProject).getUnloadedModuleNames());
        Iterator<ModulePath> iterator2 = this.myModulePathsToLoad.iterator();
        ArrayList<ModulePath> unloadedModulePaths = new ArrayList<ModulePath>();
        while (iterator2.hasNext()) {
            ModulePath modulePath = iterator2.next();
            if (!unloadedModuleNames.contains(modulePath.getModuleName())) continue;
            unloadedModulePaths.add(modulePath);
            iterator2.remove();
        }
        ArrayList<UnloadedModuleDescriptionImpl> unloaded = new ArrayList<UnloadedModuleDescriptionImpl>(UnloadedModuleDescriptionImpl.createFromPaths(unloadedModulePaths, this));
        if (!unloaded.isEmpty()) {
            this.unloadNewlyAddedModulesIfPossible(this.myModulePathsToLoad, unloaded);
        }
        this.myUnloadedModules.clear();
        for (UnloadedModuleDescriptionImpl description : unloaded) {
            this.myUnloadedModules.put(description.getName(), description);
        }
        if (isFirstLoadState) {
            return;
        }
        ModifiableModuleModel model2 = this.getModifiableModel();
        Module[] existingModules = model2.getModules();
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        HashMap<String, ModulePath> modulePathMap = new HashMap<String, ModulePath>(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            modulePathMap.put(modulePath.getPath(), modulePath);
        }
        for (Module existingModule : existingModules) {
            Object[] group2;
            ModulePath correspondingPath = (ModulePath)modulePathMap.remove(existingModule.getModuleFilePath());
            if (correspondingPath == null) {
                model2.disposeModule(existingModule);
                continue;
            }
            this.myModulePathsToLoad.remove(correspondingPath);
            String groupStr = correspondingPath.getGroup();
            Object[] objectArray = group2 = groupStr == null ? null : groupStr.split("/");
            if (Arrays.equals(group2, model2.getModuleGroupPath(existingModule))) continue;
            groupInterner.setModuleGroupPath(model2, existingModule, (String[])group2);
        }
        this.loadModules((ModuleModelImpl)model2);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableModuleModel)model2).commit());
        this.myModulePathsToLoad.clear();
    }

    @Override
    public void unloadNewlyAddedModulesIfPossible(@NotNull Set<ModulePath> modulesToLoad, @NotNull List<UnloadedModuleDescriptionImpl> modulesToUnload2) {
        if (modulesToLoad == null) {
            ModuleManagerImpl.$$$reportNull$$$0(3);
        }
        if (modulesToUnload2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    public static Set<ModulePath> getPathsToModuleFiles(@NotNull Element element2) {
        if (element2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(5);
        }
        LinkedHashSet<ModulePath> paths = new LinkedHashSet<ModulePath>();
        Element modules2 = element2.getChild("modules");
        if (modules2 != null) {
            for (Element moduleElement : modules2.getChildren("module")) {
                String fileUrlValue = moduleElement.getAttributeValue("fileurl");
                String filepath = fileUrlValue == null ? moduleElement.getAttributeValue("filepath") : VirtualFileManager.extractPath((String)fileUrlValue);
                paths.add(new ModulePath(FileUtilRt.toSystemIndependentName((String)Objects.requireNonNull(filepath)), moduleElement.getAttributeValue("group")));
            }
        }
        LinkedHashSet<ModulePath> linkedHashSet = paths;
        if (linkedHashSet == null) {
            ModuleManagerImpl.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    protected void loadModules(@NotNull ModuleModelImpl moduleModel) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(7);
        }
        this.myFailedModulePaths.clear();
        if (this.myModulePathsToLoad == null || this.myModulePathsToLoad.isEmpty()) {
            this.myModulesLoaded = true;
            return;
        }
        this.myFailedModulePaths.addAll(this.myModulePathsToLoad);
        ProgressIndicator globalIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        EmptyProgressIndicator progressIndicator = this.myProject.isDefault() || globalIndicator == null ? new EmptyProgressIndicator() : globalIndicator;
        progressIndicator.setText(ProjectModelBundle.message((String)"progress.text.loading.modules", (Object[])new Object[0]));
        progressIndicator.setText2("");
        List<ModuleLoadingErrorDescription> errors = Collections.synchronizedList(new ArrayList());
        double progressStep = (1.0 - progressIndicator.getFraction()) / (double)this.myModulePathsToLoad.size();
        boolean isParallel = Registry.is((String)"parallel.modules.loading") && !ApplicationManager.getApplication().isDispatchThread();
        ExecutorService service = isParallel ? AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"ModuleManager Loader", (int)Math.min(2, Runtime.getRuntime().availableProcessors())) : ConcurrencyUtil.newSameThreadExecutorService();
        ArrayList<Pair> tasks = new ArrayList<Pair>();
        HashSet<Object> paths = new HashSet<Object>(this.myModulePathsToLoad.size());
        for (ModulePath modulePath : this.myModulePathsToLoad) {
            if (progressIndicator.isCanceled()) break;
            String path = modulePath.getPath();
            if (!paths.add(path)) continue;
            tasks.add(new Pair(service.submit(() -> this.lambda$loadModules$1((ProgressIndicator)progressIndicator, progressStep, path, errors, modulePath)), (Object)modulePath));
        }
        ModuleGroupInterner groupInterner = new ModuleGroupInterner();
        SmartList modulesWithUnknownTypes = new SmartList();
        for (Pair task2 : tasks) {
            if (progressIndicator.isCanceled()) break;
            try {
                ModulePath modulePath;
                String groupPathString;
                Module module = (Module)((Future)task2.first).get();
                if (module == null) continue;
                moduleModel.addModule(module);
                if (this.isUnknownModuleType(module)) {
                    modulesWithUnknownTypes.add(module);
                }
                if ((groupPathString = (modulePath = (ModulePath)task2.second).getGroup()) != null) {
                    groupInterner.setModuleGroupPath(moduleModel, module, groupPathString.split("/"));
                }
                this.myFailedModulePaths.remove(modulePath);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        service.shutdown();
        progressIndicator.checkCanceled();
        this.myModulesLoaded = true;
        Application app = ApplicationManager.getApplication();
        if (app.isInternal() || app.isEAP() || ApplicationInfo.getInstance().getBuild().isSnapshot()) {
            Module[] modules2 = moduleModel.getModules();
            HashMap<String, Module> track = new HashMap<String, Module>(modules2.length);
            for (Module module : modules2) {
                for (String url : ModuleRootManager.getInstance((Module)module).getContentRootUrls()) {
                    Module oldModule = track.put(url, module);
                    if (oldModule == null) continue;
                    LOG.warn("Module '" + module.getName() + "' and module '" + oldModule.getName() + "' have the same content root: " + url);
                }
            }
        }
        this.onModuleLoadErrors(moduleModel, errors);
        this.showUnknownModuleTypeNotification((List<? extends Module>)modulesWithUnknownTypes);
    }

    @NotNull
    private static Module loadModuleInternal(@NotNull Path file2, @NotNull ModuleManagerImpl manager2) throws IOException {
        if (file2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(8);
        }
        if (manager2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(9);
        }
        String systemIndependentPath = file2.toString().replace(File.separatorChar, '/');
        VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(systemIndependentPath);
        if (virtualFile != null) {
            virtualFile.setCharset(StandardCharsets.UTF_8, null, false);
        }
        Module module = (Module)ReadAction.compute(() -> {
            ModuleEx module = manager2.createAndLoadModule(systemIndependentPath);
            ModuleManagerImpl.initModule(module, () -> ((ModuleStore)module.getService(IComponentStore.class)).setPath(file2, virtualFile, false));
            return module;
        });
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(10);
        }
        return module;
    }

    private static void initModule(@NotNull ModuleEx module, @NotNull Runnable beforeComponentCreation) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(11);
        }
        if (beforeComponentCreation == null) {
            ModuleManagerImpl.$$$reportNull$$$0(12);
        }
        try {
            module.init(beforeComponentCreation);
        }
        catch (Throwable e) {
            ModuleManagerImpl.disposeModuleLater((ComponentManager)module);
            throw e;
        }
    }

    private void reportError(@NotNull List<ModuleLoadingErrorDescription> errors, @NotNull ModulePath modulePath, @NotNull Exception e) {
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(13);
        }
        if (modulePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(14);
        }
        if (e == null) {
            ModuleManagerImpl.$$$reportNull$$$0(15);
        }
        errors.add(new ModuleLoadingErrorDescription(ProjectModelBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, this));
    }

    public int getModulePathsCount() {
        return this.myModulePathsToLoad == null ? 0 : this.myModulePathsToLoad.size();
    }

    @Override
    public boolean areModulesLoaded() {
        return this.myModulesLoaded;
    }

    protected boolean isUnknownModuleType(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(16);
        }
        return false;
    }

    protected void showUnknownModuleTypeNotification(@NotNull List<? extends Module> types) {
        if (types == null) {
            ModuleManagerImpl.$$$reportNull$$$0(17);
        }
    }

    protected void fireModuleRemoved(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(18);
        }
        ((ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES)).moduleRemoved(this.myProject, module);
    }

    protected void fireBeforeModuleRemoved(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(19);
        }
        ((ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES)).beforeModuleRemoved(this.myProject, module);
    }

    protected void fireModulesRenamed(@NotNull List<Module> modules2, @NotNull Map<Module, String> oldNames) {
        if (modules2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(20);
        }
        if (oldNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(21);
        }
        if (modules2.isEmpty()) {
            return;
        }
        try {
            for (Module module : this.getModules()) {
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                if (!(moduleRootManager instanceof ModuleRootManagerImpl)) continue;
                ((ModuleRootManagerImpl)moduleRootManager).stateChanged();
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        ((ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES)).modulesRenamed(this.myProject, modules2, oldNames::get);
    }

    private void onModuleLoadErrors(@NotNull ModuleModelImpl moduleModel, @NotNull List<ModuleLoadingErrorDescription> errors) {
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(22);
        }
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(23);
        }
        if (errors.isEmpty()) {
            return;
        }
        moduleModel.myModulesCache = null;
        for (ModuleLoadingErrorDescription error : errors) {
            ModuleEx module = moduleModel.getModuleByFilePath(error.getModulePath().getPath());
            if (module == null) continue;
            moduleModel.myModules.remove(module.getName());
            ModuleManagerImpl.disposeModuleLater((ComponentManager)module);
        }
        this.fireModuleLoadErrors(errors);
    }

    private static void disposeModuleLater(@NotNull ComponentManager module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(24);
        }
        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)module), module.getDisposed());
    }

    protected void fireModuleLoadErrors(@NotNull List<ModuleLoadingErrorDescription> errors) {
        if (errors == null) {
            ModuleManagerImpl.$$$reportNull$$$0(25);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(26);
        }
        this.myFailedModulePaths.remove(modulePath);
        this.incModificationCount();
    }

    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return new ModuleModelImpl(this.myModuleModel);
    }

    public void writeExternal(@NotNull Element element2, @NotNull List<? extends Module> collection) {
        if (element2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(27);
        }
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(28);
        }
        ModuleManagerImpl.writeExternal(element2, collection, this);
    }

    @ApiStatus.Internal
    public static void writeExternal(@NotNull Element element2, @NotNull List<? extends Module> collection, ModuleManagerEx moduleManager) {
        if (element2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(29);
        }
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(30);
        }
        Collection<ModulePath> failedModulePaths = moduleManager.getFailedModulePaths();
        Collection unloadedModuleDescriptions = moduleManager.getUnloadedModuleDescriptions();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.size() + failedModulePaths.size() + unloadedModuleDescriptions.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module, moduleManager));
        }
        for (ModulePath modulePath : failedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        for (UnloadedModuleDescription unloadedModuleDescription : unloadedModuleDescriptions) {
            sorted.add(new ModulePathSaveItem(((UnloadedModuleDescriptionImpl)unloadedModuleDescription).getModulePath()));
        }
        if (!sorted.isEmpty()) {
            sorted.sort(Comparator.comparing(SaveItem::getModuleName));
            Element modules2 = new Element("modules");
            for (SaveItem saveItem : sorted) {
                saveItem.writeExternal(modules2);
            }
            element2.addContent(modules2);
        }
    }

    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(31);
        }
        if (moduleTypeId == null) {
            ModuleManagerImpl.$$$reportNull$$$0(32);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(33);
        }
        return module2;
    }

    @NotNull
    public Module newModule(@NotNull Path filePath, @NotNull String moduleTypeId) {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(34);
        }
        if (moduleTypeId == null) {
            ModuleManagerImpl.$$$reportNull$$$0(35);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleTypeId);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(36);
        }
        return module2;
    }

    @NotNull
    public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String id2) {
        if (moduleName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(37);
        }
        if (id2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(38);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newNonPersistentModule(moduleName, id2);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(39);
        }
        return module2;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) throws IOException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            ModuleManagerImpl.$$$reportNull$$$0(40);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(41);
        }
        return module2;
    }

    @NotNull
    public Module loadModule(@NotNull Path file2) throws IOException, ModuleWithNameAlreadyExists {
        if (file2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(42);
        }
        this.incModificationCount();
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(file2);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(43);
        }
        return module2;
    }

    public void disposeModule(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(44);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            ModifiableModuleModel modifiableModel = this.getModifiableModel();
            modifiableModel.disposeModule(module);
            modifiableModel.commit();
        });
    }

    public Module @NotNull [] getModules() {
        ModuleModelImpl model2 = this.myModuleModel;
        if (model2.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = model2.getModules();
        if (moduleArray == null) {
            ModuleManagerImpl.$$$reportNull$$$0(45);
        }
        return moduleArray;
    }

    public Module @NotNull [] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        Module[] sortedModules = this.myCachedSortedModules;
        if (sortedModules == null) {
            this.myCachedSortedModules = sortedModules = this.myModuleModel.getSortedModules();
        }
        if (sortedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(46);
        }
        return sortedModules;
    }

    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            ModuleManagerImpl.$$$reportNull$$$0(47);
        }
        return this.myModuleModel.findModuleByName(name);
    }

    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.deliverPendingEvents();
        Comparator<Module> cachedModuleComparator = this.myCachedModuleComparator;
        if (cachedModuleComparator == null) {
            this.myCachedModuleComparator = cachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator2 = cachedModuleComparator;
        if (comparator2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(48);
        }
        return comparator2;
    }

    protected void deliverPendingEvents() {
    }

    @NotNull
    public Graph<Module> moduleGraph() {
        Graph<Module> graph2 = this.moduleGraph(true);
        if (graph2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(49);
        }
        return graph2;
    }

    @NotNull
    public Graph<Module> moduleGraph(boolean includeTests) {
        Graph<Module> graph2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph<Module> graph3 = graph2 = includeTests ? this.myCachedModuleTestGraph : this.myCachedModuleProductionGraph;
        if (graph2 != null) {
            Graph<Module> graph4 = graph2;
            if (graph4 == null) {
                ModuleManagerImpl.$$$reportNull$$$0(50);
            }
            return graph4;
        }
        graph2 = this.myModuleModel.moduleGraph(includeTests);
        if (includeTests) {
            this.myCachedModuleTestGraph = graph2;
        } else {
            this.myCachedModuleProductionGraph = graph2;
        }
        Graph<Module> graph5 = graph2;
        if (graph5 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(51);
        }
        return graph5;
    }

    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(52);
        }
        SmartList result2 = new SmartList();
        for (Module aModule : this.getModules()) {
            if (!ModuleManagerImpl.isModuleDependsOn(aModule, module)) continue;
            result2.add(aModule);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            ModuleManagerImpl.$$$reportNull$$$0(53);
        }
        return smartList;
    }

    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(54);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(55);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return ModuleManagerImpl.isModuleDependsOn(module, onModule);
    }

    private static boolean isModuleDependsOn(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(56);
        }
        if (onModule == null) {
            ModuleManagerImpl.$$$reportNull$$$0(57);
        }
        return ModuleRootManager.getInstance((Module)module).isDependsOn(onModule);
    }

    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module);
        }
    }

    protected void fireModuleAddedInWriteAction(@NotNull ModuleEx module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(58);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!module.isLoaded()) {
                module.moduleAdded();
                ((ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES)).moduleAdded(this.myProject, (Module)module);
            }
        });
    }

    public static void commitModelWithRunnable(@NotNull ModifiableModuleModel model2, @NotNull Runnable runnable2) {
        if (model2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(59);
        }
        if (runnable2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(60);
        }
        ((ModuleModelImpl)model2).commitWithRunnable(runnable2);
    }

    @NotNull
    protected abstract ModuleEx createModule(@NotNull String var1);

    protected ModuleEx createNonPersistentModule(@NotNull String name) {
        if (name == null) {
            ModuleManagerImpl.$$$reportNull$$$0(61);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected abstract ModuleEx createAndLoadModule(@NotNull String var1) throws IOException;

    private void commitModel(@NotNull ModuleModelImpl moduleModel, @NotNull Runnable runnable2) {
        Collection<Object> removedModules;
        Collection<Module> addedModules;
        if (moduleModel == null) {
            ModuleManagerImpl.$$$reportNull$$$0(62);
        }
        if (runnable2 == null) {
            ModuleManagerImpl.$$$reportNull$$$0(63);
        }
        this.myModuleModel.myModulesCache = null;
        this.incModificationCount();
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<Module> oldModules = Arrays.asList(this.myModuleModel.getModules());
        List<Module> newModules = Arrays.asList(moduleModel.getModules());
        if (oldModules.isEmpty()) {
            addedModules = newModules;
            removedModules = Collections.emptyList();
        } else {
            addedModules = new HashSet<Module>(newModules);
            addedModules.removeAll(oldModules);
            removedModules = new HashSet<Module>(oldModules);
            removedModules.removeAll(newModules);
        }
        this.myProjectRootManager.makeRootsChange(() -> {
            for (Object removedModule : removedModules) {
                this.fireBeforeModuleRemoved((Module)removedModule);
                this.cleanCachedStuff();
            }
            if (!moduleModel.myModulesToDispose.isEmpty()) {
                ArrayList<Module> neverAddedModules = new ArrayList<Module>(moduleModel.myModulesToDispose);
                neverAddedModules.removeAll(oldModules);
                for (Module neverAddedModule : neverAddedModules) {
                    neverAddedModule.putUserData(DISPOSED_MODULE_NAME, (Object)neverAddedModule.getName());
                    Disposer.dispose((Disposable)neverAddedModule);
                }
            }
            runnable2.run();
            Map<Module, String> modulesToNewNamesMap = moduleModel.myModuleToNewName;
            Set<Module> modulesToBeRenamed = modulesToNewNamesMap.keySet();
            modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
            ArrayList<Module> modules2 = new ArrayList<Module>();
            HashMap<Module, String> oldNames = new HashMap<Module, String>();
            for (Module module : modulesToBeRenamed) {
                oldNames.put(module, module.getName());
                moduleModel.myModules.remove(module.getName());
                modules2.add(module);
                ((ModuleEx)module).rename(modulesToNewNamesMap.get(module), true);
                moduleModel.myModules.put(module.getName(), module);
                this.myUnloadedModules.remove(module.getName());
            }
            moduleModel.myIsWritable = false;
            this.myModuleModel = moduleModel;
            for (Module module : removedModules) {
                this.fireModuleRemoved(module);
                this.cleanCachedStuff();
                Disposer.dispose((Disposable)module);
                this.cleanCachedStuff();
            }
            ModuleListener publisher = (ModuleListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.MODULES);
            for (Module addedModule : addedModules) {
                this.myUnloadedModules.remove(addedModule.getName());
                ((ModuleEx)addedModule).moduleAdded();
                this.cleanCachedStuff();
                publisher.moduleAdded(this.myProject, addedModule);
                this.cleanCachedStuff();
            }
            this.cleanCachedStuff();
            this.fireModulesRenamed(modules2, oldNames);
            this.cleanCachedStuff();
            UnloadedModulesListStorage unloadedModulesListStorage = UnloadedModulesListStorage.getInstance(this.myProject);
            this.setUnloadedModuleNames(ContainerUtil.filter(unloadedModulesListStorage.getUnloadedModuleNames(), this.myUnloadedModules::containsKey));
        }, false, true);
    }

    public void fireModuleRenamedByVfsEvent(@NotNull Module module, @NotNull String oldName) {
        Module moduleInMap;
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(64);
        }
        if (oldName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(65);
        }
        LOG.assertTrue((moduleInMap = this.myModuleModel.myModules.remove(oldName)) == null || moduleInMap == module);
        this.myModuleModel.myModules.put(module.getName(), module);
        this.incModificationCount();
        this.myProjectRootManager.makeRootsChange(() -> this.fireModulesRenamed(Collections.singletonList(module), Collections.singletonMap(module, oldName)), false, true);
    }

    public String[] getModuleGroupPath(@NotNull Module module) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(66);
        }
        return this.myModuleModel.getModuleGroupPath(module);
    }

    public boolean hasModuleGroups() {
        return this.myModuleModel.hasModuleGroups();
    }

    @NotNull
    public Collection<ModuleDescription> getAllModuleDescriptions() {
        Module[] modules2 = this.getModules();
        ArrayList<ModuleDescription> descriptions = new ArrayList<ModuleDescription>(modules2.length + this.myUnloadedModules.size());
        for (Module module : modules2) {
            descriptions.add((ModuleDescription)new LoadedModuleDescriptionImpl(module));
        }
        descriptions.addAll(this.myUnloadedModules.values());
        ArrayList<ModuleDescription> arrayList = descriptions;
        if (arrayList == null) {
            ModuleManagerImpl.$$$reportNull$$$0(67);
        }
        return arrayList;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModuleDescriptions() {
        Collection<UnloadedModuleDescription> collection = Collections.unmodifiableCollection(this.myUnloadedModules.values());
        if (collection == null) {
            ModuleManagerImpl.$$$reportNull$$$0(68);
        }
        return collection;
    }

    @Override
    public Collection<ModulePath> getFailedModulePaths() {
        return Collections.unmodifiableSet(this.myFailedModulePaths);
    }

    @Nullable
    public UnloadedModuleDescription getUnloadedModuleDescription(@NotNull String moduleName) {
        if (moduleName == null) {
            ModuleManagerImpl.$$$reportNull$$$0(69);
        }
        return this.myUnloadedModules.get(moduleName);
    }

    @NotNull
    public ModuleGrouper getModuleGrouper(@Nullable ModifiableModuleModel model2) {
        ModuleGrouper moduleGrouper = ModuleGroupersKt.createGrouper(this.myProject, model2);
        if (moduleGrouper == null) {
            ModuleManagerImpl.$$$reportNull$$$0(70);
        }
        return moduleGrouper;
    }

    public void setUnloadedModules(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(71);
        }
        if (this.myUnloadedModules.keySet().equals(new HashSet<String>(unloadedModuleNames))) {
            return;
        }
        this.setUnloadedModuleNames(unloadedModuleNames);
        ModifiableModuleModel model2 = this.getModifiableModel();
        LinkedHashMap<String, UnloadedModuleDescriptionImpl> toLoad = new LinkedHashMap<String, UnloadedModuleDescriptionImpl>(this.myUnloadedModules);
        this.myUnloadedModules.clear();
        for (String name : unloadedModuleNames) {
            if (toLoad.containsKey(name)) {
                this.myUnloadedModules.put(name, (UnloadedModuleDescriptionImpl)toLoad.remove(name));
                continue;
            }
            Module module = this.findModuleByName(name);
            if (module == null) continue;
            LoadedModuleDescriptionImpl description = new LoadedModuleDescriptionImpl(module);
            ModuleSaveItem saveItem = new ModuleSaveItem(module, this);
            ModulePath modulePath = new ModulePath(saveItem.getModuleFilePath(), saveItem.getGroupPathString());
            VirtualFilePointerManager pointerManager = VirtualFilePointerManager.getInstance();
            List contentRoots = ContainerUtil.map((Object[])ModuleRootManager.getInstance((Module)module).getContentRootUrls(), url -> pointerManager.create(url, (Disposable)this, null));
            UnloadedModuleDescriptionImpl unloadedModuleDescription = new UnloadedModuleDescriptionImpl(modulePath, description.getDependencyModuleNames(), contentRoots);
            StateStorageManagerKt.saveComponentManager((ComponentManager)module);
            model2.disposeModule(module);
            this.myUnloadedModules.put(name, unloadedModuleDescription);
        }
        ArrayList<ModulePath> oldFailedPaths = new ArrayList<ModulePath>(this.myFailedModulePaths);
        this.myModulePathsToLoad = toLoad.values().stream().map(UnloadedModuleDescriptionImpl::getModulePath).collect(Collectors.toCollection(LinkedHashSet::new));
        this.loadModules((ModuleModelImpl)model2);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableModuleModel)model2).commit());
        this.myFailedModulePaths.addAll(oldFailedPaths);
        this.myModulePathsToLoad.clear();
    }

    public void removeUnloadedModules(@NotNull Collection<? extends UnloadedModuleDescription> unloadedModules) {
        if (unloadedModules == null) {
            ModuleManagerImpl.$$$reportNull$$$0(72);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (UnloadedModuleDescription unloadedModuleDescription : unloadedModules) {
            this.myUnloadedModules.remove(unloadedModuleDescription.getName());
        }
        this.setUnloadedModuleNames(new ArrayList<String>(this.myUnloadedModules.keySet()));
    }

    protected void setUnloadedModuleNames(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerImpl.$$$reportNull$$$0(73);
        }
        UnloadedModulesListStorage.getInstance(this.myProject).setUnloadedModuleNames(unloadedModuleNames);
    }

    public void setModuleGroupPath(@NotNull Module module, String @Nullable [] groupPath) {
        if (module == null) {
            ModuleManagerImpl.$$$reportNull$$$0(74);
        }
        this.myModuleModel.setModuleGroupPath(module, groupPath);
    }

    private /* synthetic */ Module lambda$loadModules$1(ProgressIndicator progressIndicator, double progressStep, String path, List errors, ModulePath modulePath) throws Exception {
        progressIndicator.setFraction(progressIndicator.getFraction() + progressStep);
        return (Module)ProgressManager.getInstance().runProcess(() -> {
            try {
                return this.myProject.isDisposed() ? null : ModuleManagerImpl.loadModuleInternal(Paths.get(path, new String[0]), this);
            }
            catch (IOException e) {
                this.reportError(errors, modulePath, e);
            }
            catch (ProcessCanceledException e) {
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return null;
        }, (ProgressIndicator)ProgressWrapper.wrap(progressIndicator));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 67: 
            case 68: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 67: 
            case 68: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToLoad";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToUnload";
                break;
            }
            case 5: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 67: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 7: 
            case 22: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 8: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 11: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 44: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 64: 
            case 66: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeComponentCreation";
                break;
            }
            case 13: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 14: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldNames";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 31: 
            case 34: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypeId";
                break;
            }
            case 37: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 47: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onModule";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModuleNames";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToModuleFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModuleInternal";
                break;
            }
            case 33: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "newModule";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "newNonPersistentModule";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "loadModule";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedModules";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleDependencyComparator";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleGraph";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependentModules";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModuleDescriptions";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModuleDescriptions";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleGrouper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unloadNewlyAddedModulesIfPossible";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPathsToModuleFiles";
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 67: 
            case 68: 
            case 70: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadModules";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadModuleInternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "initModule";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownModuleType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showUnknownModuleTypeNotification";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRemoved";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeModuleRemoved";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fireModulesRenamed";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "onModuleLoadErrors";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "disposeModuleLater";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleLoadErrors";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeFailedModulePath";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 31: 
            case 32: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "newModule";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "newNonPersistentModule";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadModule";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "disposeModule";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findModuleByName";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDependentModules";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependent";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependsOn";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleAddedInWriteAction";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "commitModelWithRunnable";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createNonPersistentModule";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "commitModel";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "fireModuleRenamedByVfsEvent";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getModuleGroupPath";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getUnloadedModuleDescription";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModules";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "removeUnloadedModules";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModuleNames";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "setModuleGroupPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 33: 
            case 36: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 67: 
            case 68: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class ModuleModelImpl
    implements ModifiableModuleModel {
        final Map<String, Module> myModules;
        private volatile Module[] myModulesCache;
        private final List<Module> myModulesToDispose;
        private final Map<Module, String> myModuleToNewName;
        private final Map<String, Module> myNewNameToModule;
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;
        private final ModuleManagerImpl myManager;

        private ModuleModelImpl(@NotNull ModuleManagerImpl manager2) {
            if (manager2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(0);
            }
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new HashMap<Module, String>();
            this.myNewNameToModule = new HashMap<String, Module>();
            this.myManager = manager2;
            this.myIsWritable = false;
            this.myModules = Collections.synchronizedMap(new LinkedHashMap());
        }

        private ModuleModelImpl(@NotNull ModuleModelImpl that) {
            if (that == null) {
                ModuleModelImpl.$$$reportNull$$$0(1);
            }
            this.myModulesToDispose = new ArrayList<Module>();
            this.myModuleToNewName = new HashMap<Module, String>();
            this.myNewNameToModule = new HashMap<String, Module>();
            this.myManager = that.myManager;
            this.myModules = Collections.synchronizedMap(new LinkedHashMap<String, Module>(that.myModules));
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new HashMap<Module, String[]>(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, (Object)"Attempt to modify committed ModifiableModuleModel");
        }

        public Module @NotNull [] getModules() {
            Module[] cache2 = this.myModulesCache;
            if (cache2 == null) {
                Collection<Module> modules2 = this.myModules.values();
                this.myModulesCache = cache2 = modules2.toArray(Module.EMPTY_ARRAY);
            }
            if (cache2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(2);
            }
            return cache2;
        }

        private Module @NotNull [] getSortedModules() {
            Module[] allModules = (Module[])this.getModules().clone();
            if (allModules.length > 1) {
                Arrays.sort(allModules, this.moduleDependencyComparator());
            }
            if (allModules == null) {
                ModuleModelImpl.$$$reportNull$$$0(3);
            }
            return allModules;
        }

        public void renameModule(@NotNull Module module, @NotNull String newName2) throws ModuleWithNameAlreadyExists {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(4);
            }
            if (newName2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(5);
            }
            Module oldModule = this.getModuleByNewName(newName2);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName2)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName2);
            } else {
                this.myModuleToNewName.put(module, newName2);
                this.myNewNameToModule.put(newName2, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectModelBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName2}), newName2);
            }
        }

        public Module getModuleToBeRenamed(@NotNull String newName2) {
            if (newName2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(6);
            }
            return this.myNewNameToModule.get(newName2);
        }

        private Module getModuleByNewName(@NotNull String newName2) {
            Module moduleToBeRenamed;
            if (newName2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(7);
            }
            if ((moduleToBeRenamed = this.getModuleToBeRenamed(newName2)) != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName2);
            return this.myModuleToNewName.get(moduleWithOldName) == null ? moduleWithOldName : null;
        }

        public String getNewName(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(8);
            }
            return this.myModuleToNewName.get(module);
        }

        @NotNull
        public String getActualName(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(9);
            }
            String string = (String)ObjectUtils.notNull((Object)this.getNewName(module), (Object)module.getName());
            if (string == null) {
                ModuleModelImpl.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        public final Module newModule(@NotNull String filePath, @NotNull String moduleTypeId) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(11);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(12);
            }
            Module module = this.newModule(filePath, null, moduleTypeId, null);
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(13);
            }
            return module;
        }

        public Module newModule(@NotNull Path file2, @NotNull String moduleTypeId) {
            if (file2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(14);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(15);
            }
            return this.newModule(null, file2, moduleTypeId, null);
        }

        @NotNull
        public Module newNonPersistentModule(@NotNull String moduleName, @NotNull String moduleTypeId) {
            if (moduleName == null) {
                ModuleModelImpl.$$$reportNull$$$0(16);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(17);
            }
            this.assertWritable();
            ModuleEx module = this.myManager.createNonPersistentModule(moduleName);
            ModuleManagerImpl.initModule(module, () -> module.setModuleType(moduleTypeId));
            this.addModule(module);
            ModuleEx moduleEx = module;
            if (moduleEx == null) {
                ModuleModelImpl.$$$reportNull$$$0(18);
            }
            return moduleEx;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull String moduleTypeId, @Nullable Map<String, String> options2) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(19);
            }
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(20);
            }
            Module module = this.newModule(filePath, null, moduleTypeId, options2);
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(21);
            }
            return module;
        }

        private Module newModule(@Nullable String filePath, @Nullable Path file2, @NotNull String moduleTypeId, @Nullable Map<String, String> options2) {
            if (moduleTypeId == null) {
                ModuleModelImpl.$$$reportNull$$$0(22);
            }
            this.assertWritable();
            filePath = filePath == null ? Objects.requireNonNull(file2).toAbsolutePath().normalize().toString().replace(File.separatorChar, '/') : FileUtil.toSystemIndependentName((String)ModuleModelImpl.resolveShortWindowsName(filePath));
            ModuleEx module = this.getModuleByFilePath(filePath);
            if (module != null) {
                return module;
            }
            ModuleEx newModule = module = this.myManager.createModule(filePath);
            Path finalFile = file2 == null ? Paths.get(filePath, new String[0]) : file2;
            ModuleManagerImpl.initModule(module, () -> {
                ((ModuleStore)newModule.getService(IComponentStore.class)).setPath(finalFile, null, true);
                newModule.setModuleType(moduleTypeId);
                if (options2 != null) {
                    for (Map.Entry option2 : options2.entrySet()) {
                        newModule.setOption((String)option2.getKey(), (String)option2.getValue());
                    }
                }
            });
            this.addModule(module);
            return module;
        }

        @NotNull
        private static String resolveShortWindowsName(@NotNull String filePath) {
            String string;
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(23);
            }
            try {
                string = FileUtil.resolveShortWindowsName((String)filePath);
            }
            catch (IOException ignored) {
                String string2 = filePath;
                if (string2 == null) {
                    ModuleModelImpl.$$$reportNull$$$0(25);
                }
                return string2;
            }
            if (string == null) {
                ModuleModelImpl.$$$reportNull$$$0(24);
            }
            return string;
        }

        @Nullable
        private ModuleEx getModuleByFilePath(@NotNull @SystemIndependent String filePath) {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(26);
            }
            for (Module module : this.getModules()) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? module.getModuleFilePath().equals(filePath) : module.getModuleFilePath().equalsIgnoreCase(filePath))) continue;
                return (ModuleEx)module;
            }
            return null;
        }

        public Module loadModule(@NotNull Path file2) throws IOException {
            if (file2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(27);
            }
            this.assertWritable();
            Path normalizedPath = file2.toAbsolutePath().normalize();
            try {
                ModuleEx module = this.getModuleByFilePath(FileUtilRt.toSystemIndependentName((String)normalizedPath.toString()));
                if (module == null) {
                    module = ModuleManagerImpl.loadModuleInternal(normalizedPath, this.myManager);
                    this.addModule(module);
                }
                return module;
            }
            catch (NoSuchFileException e) {
                throw e;
            }
            catch (IOException e) {
                throw new IOException(ProjectModelBundle.message((String)"module.corrupted.file.error", (Object[])new Object[]{normalizedPath.toString(), e.getMessage()}), e);
            }
        }

        @NotNull
        public Module loadModule(@NotNull @SystemIndependent String filePath) throws IOException {
            if (filePath == null) {
                ModuleModelImpl.$$$reportNull$$$0(28);
            }
            Module module = this.loadModule(Paths.get(ModuleModelImpl.resolveShortWindowsName(filePath), new String[0]));
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(29);
            }
            return module;
        }

        private void addModule(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(30);
            }
            this.myModulesCache = null;
            this.myModules.put(module.getName(), module);
        }

        public void disposeModule(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(31);
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myModules.remove(module.getName()) != null) {
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        public Module findModuleByName(@NotNull String name) {
            Module module;
            if (name == null) {
                ModuleModelImpl.$$$reportNull$$$0(32);
            }
            if ((module = this.myModules.get(name)) != null && !module.isDisposed()) {
                return module;
            }
            return null;
        }

        @NotNull
        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder builder2 = new DFSTBuilder(this.moduleGraph(true));
            Comparator comparator2 = builder2.comparator();
            if (comparator2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(33);
            }
            return comparator2;
        }

        @NotNull
        private Graph<Module> moduleGraph(final boolean includeTests) {
            Graph graph2 = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Module>(){

                @NotNull
                public Collection<Module> getNodes() {
                    Collection<Module> collection = myModules.values();
                    if (collection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return collection;
                }

                @NotNull
                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance((Module)m).getDependencies(includeTests);
                    Iterator<Module> iterator2 = Arrays.asList(dependentModules).iterator();
                    if (iterator2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return iterator2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getNodes";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIn";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            }));
            if (graph2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(34);
            }
            return graph2;
        }

        public void commit() {
            ModifiableModelCommitter.multiCommit(Collections.emptyList(), (ModifiableModuleModel)this);
        }

        private void commitWithRunnable(@NotNull Runnable runnable2) {
            if (runnable2 == null) {
                ModuleModelImpl.$$$reportNull$$$0(35);
            }
            this.myManager.commitModel(this, runnable2);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Set existingModules = ContainerUtil.set((Object[])this.myManager.myModuleModel.getModules());
            for (Module thisModule : this.getModules()) {
                if (existingModules.contains(thisModule)) continue;
                Disposer.dispose((Disposable)thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (existingModules.contains(moduleToDispose)) continue;
                Disposer.dispose((Disposable)moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        public boolean isChanged() {
            if (!this.myIsWritable) {
                return false;
            }
            ModuleModelImpl model2 = this.myManager.myModuleModel;
            return !this.myModules.equals(model2.myModules) || !Comparing.equal(model2.myModuleGroupPath, this.myModuleGroupPath) || !this.myModuleToNewName.isEmpty();
        }

        private void disposeModel() {
            Module[] modules2 = this.getModules();
            this.myModulesCache = null;
            this.myModules.clear();
            for (Module module : modules2) {
                Disposer.dispose((Disposable)module);
            }
            this.myModuleGroupPath = null;
        }

        public String[] getModuleGroupPath(@NotNull Module module) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(36);
            }
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        public void setModuleGroupPath(@NotNull Module module, String @Nullable(value="null means remove") [] groupPath) {
            if (module == null) {
                ModuleModelImpl.$$$reportNull$$$0(37);
            }
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new HashMap<Module, String[]>();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath);
            }
        }

        @NotNull
        public Project getProject() {
            Project project = this.myManager.myProject;
            if (project == null) {
                ModuleModelImpl.$$$reportNull$$$0(38);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 18: 
                case 21: 
                case 24: 
                case 25: 
                case 29: 
                case 33: 
                case 34: 
                case 38: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 18: 
                case 21: 
                case 24: 
                case 25: 
                case 29: 
                case 33: 
                case 34: 
                case 38: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "that";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 18: 
                case 21: 
                case 24: 
                case 25: 
                case 29: 
                case 33: 
                case 34: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 30: 
                case 31: 
                case 36: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 11: 
                case 19: 
                case 23: 
                case 26: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 12: 
                case 15: 
                case 17: 
                case 20: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleTypeId";
                    break;
                }
                case 14: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleName";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModules";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedModules";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActualName";
                    break;
                }
                case 13: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newModule";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "newNonPersistentModule";
                    break;
                }
                case 24: 
                case 25: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveShortWindowsName";
                    break;
                }
                case 29: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loadModule";
                    break;
                }
                case 33: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moduleDependencyComparator";
                    break;
                }
                case 34: {
                    objectArray = objectArray2;
                    objectArray2[1] = "moduleGraph";
                    break;
                }
                case 38: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 18: 
                case 21: 
                case 24: 
                case 25: 
                case 29: 
                case 33: 
                case 34: 
                case 38: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "renameModule";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleToBeRenamed";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByNewName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getNewName";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getActualName";
                    break;
                }
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 19: 
                case 20: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "newModule";
                    break;
                }
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "newNonPersistentModule";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "resolveShortWindowsName";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleByFilePath";
                    break;
                }
                case 27: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "loadModule";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "addModule";
                    break;
                }
                case 31: {
                    objectArray = objectArray;
                    objectArray[2] = "disposeModule";
                    break;
                }
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "findModuleByName";
                    break;
                }
                case 35: {
                    objectArray = objectArray;
                    objectArray[2] = "commitWithRunnable";
                    break;
                }
                case 36: {
                    objectArray = objectArray;
                    objectArray[2] = "getModuleGroupPath";
                    break;
                }
                case 37: {
                    objectArray = objectArray;
                    objectArray[2] = "setModuleGroupPath";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 10: 
                case 13: 
                case 18: 
                case 21: 
                case 24: 
                case 25: 
                case 29: 
                case 33: 
                case 34: 
                case 38: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;
        private final ModuleManager myModuleManager;

        ModuleSaveItem(@NotNull Module module, @NotNull ModuleManager moduleManager) {
            if (module == null) {
                ModuleSaveItem.$$$reportNull$$$0(0);
            }
            if (moduleManager == null) {
                ModuleSaveItem.$$$reportNull$$$0(1);
            }
            this.myModule = module;
            this.myModuleManager = moduleManager;
        }

        @Override
        @NotNull
        protected String getModuleName() {
            String string = this.myModule.getName();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = this.myModuleManager.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join((String[])groupPath, (String)"/") : null;
        }

        @Override
        @NotNull
        protected String getModuleFilePath() {
            String string = this.myModule.getModuleFilePath();
            if (string == null) {
                ModuleSaveItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleManager";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleSaveItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleFilePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ModuleGroupInterner {
        private final Interner<String> groups = Interner.createStringInterner();
        private final Map<String[], String[]> paths = new Object2ObjectOpenCustomHashMap(ObjectArrays.HASH_STRATEGY);

        private ModuleGroupInterner() {
        }

        private void setModuleGroupPath(@NotNull ModifiableModuleModel model2, @NotNull Module module, String @Nullable [] group2) {
            String[] cached;
            if (model2 == null) {
                ModuleGroupInterner.$$$reportNull$$$0(0);
            }
            if (module == null) {
                ModuleGroupInterner.$$$reportNull$$$0(1);
            }
            String[] stringArray = cached = group2 == null ? null : this.paths.get(group2);
            if (cached == null && group2 != null) {
                cached = new String[group2.length];
                for (int i2 = 0; i2 < group2.length; ++i2) {
                    String g = group2[i2];
                    cached[i2] = (String)this.groups.intern((Object)g);
                }
                this.paths.put(cached, cached);
            }
            model2.setModuleGroupPath(module, cached);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleGroupInterner";
            objectArray[2] = "setModuleGroupPath";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

