/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.openapi.module.impl.AutomaticModuleUnloader;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleFileListener;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.module.impl.ModulePathKt;
import com.intellij.openapi.module.impl.UnloadedModuleDescriptionImpl;
import com.intellij.openapi.module.impl.UnloadedModulesListChange;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectServiceContainerInitializedListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@State(name="ProjectModuleManager", storages={@Storage(value="modules.xml")}, useLoadedStateAsExisting=false)
@ApiStatus.Internal
public class ModuleManagerComponent
extends ModuleManagerImpl {
    private final MessageBusConnection myMessageBusConnection;

    public ModuleManagerComponent(@NotNull Project project) {
        if (project == null) {
            ModuleManagerComponent.$$$reportNull$$$0(0);
        }
        super(project);
        this.myMessageBusConnection = project.getMessageBus().connect((Disposable)this);
        this.myMessageBusConnection.setDefaultHandler(() -> this.cleanCachedStuff());
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        if (project.isDefault()) {
            return;
        }
        this.myMessageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new ModuleFileListener(this));
    }

    @Override
    public void unloadNewlyAddedModulesIfPossible(@NotNull Set<ModulePath> modulesToLoad, @NotNull List<UnloadedModuleDescriptionImpl> modulesToUnload2) {
        if (modulesToLoad == null) {
            ModuleManagerComponent.$$$reportNull$$$0(1);
        }
        if (modulesToUnload2 == null) {
            ModuleManagerComponent.$$$reportNull$$$0(2);
        }
        UnloadedModulesListChange change = AutomaticModuleUnloader.getInstance(this.myProject).processNewModules(modulesToLoad, modulesToUnload2);
        modulesToLoad.removeAll(change.getToUnload());
        modulesToUnload2.addAll(change.getToUnloadDescriptions());
    }

    @Override
    protected void showUnknownModuleTypeNotification(@NotNull List<? extends Module> modulesWithUnknownTypes) {
        if (modulesWithUnknownTypes == null) {
            ModuleManagerComponent.$$$reportNull$$$0(3);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesWithUnknownTypes.isEmpty()) {
            String message2;
            if (modulesWithUnknownTypes.size() == 1) {
                String message22 = ProjectBundle.message((String)"module.unknown.type.single.error", (Object[])new Object[]{modulesWithUnknownTypes.get(0).getName(), ModuleType.get((Module)modulesWithUnknownTypes.get(0)).getId()});
            } else {
                StringBuilder modulesBuilder = new StringBuilder();
                for (Module module : modulesWithUnknownTypes) {
                    modulesBuilder.append("<br>\"");
                    modulesBuilder.append(module.getName()).append("\" (type '").append(ModuleType.get((Module)module).getId()).append("')");
                }
                modulesBuilder.append("<br>");
                message2 = ProjectBundle.message((String)"module.unknown.type.multiple.error", (Object[])new Object[]{modulesBuilder.toString()});
            }
            Notifications.Bus.notify((Notification)new Notification(NotificationGroup.createIdWithTitle((String)"Module Manager", (String)ProjectBundle.message((String)"notification.group.module.manager", (Object[])new Object[0])), ProjectBundle.message((String)"module.unknown.type.title", (Object[])new Object[0]), message2, NotificationType.WARNING), (Project)this.myProject);
        }
    }

    @Override
    @NotNull
    protected ModuleEx createModule(@NotNull String filePath) {
        if (filePath == null) {
            ModuleManagerComponent.$$$reportNull$$$0(4);
        }
        return new ModuleImpl(ModulePathKt.getModuleNameByFilePath(filePath), this.myProject, filePath);
    }

    @Override
    @NotNull
    protected ModuleEx createNonPersistentModule(@NotNull String name) {
        if (name == null) {
            ModuleManagerComponent.$$$reportNull$$$0(5);
        }
        return new ModuleImpl(name, this.myProject, null);
    }

    @Override
    @NotNull
    protected ModuleEx createAndLoadModule(@NotNull String filePath) {
        if (filePath == null) {
            ModuleManagerComponent.$$$reportNull$$$0(6);
        }
        ModuleEx moduleEx = this.createModule(filePath);
        if (moduleEx == null) {
            ModuleManagerComponent.$$$reportNull$$$0(7);
        }
        return moduleEx;
    }

    @Override
    protected void setUnloadedModuleNames(@NotNull List<String> unloadedModuleNames) {
        if (unloadedModuleNames == null) {
            ModuleManagerComponent.$$$reportNull$$$0(8);
        }
        super.setUnloadedModuleNames(unloadedModuleNames);
        if (!unloadedModuleNames.isEmpty()) {
            ArrayList<String> loadedModules = new ArrayList<String>(this.myModuleModel.myModules.keySet());
            loadedModules.removeAll(new HashSet<String>(unloadedModuleNames));
            AutomaticModuleUnloader.getInstance(this.myProject).setLoadedModules(loadedModules);
        }
    }

    @Override
    protected boolean isUnknownModuleType(@NotNull Module module) {
        if (module == null) {
            ModuleManagerComponent.$$$reportNull$$$0(9);
        }
        return ModuleType.get((Module)module) instanceof UnknownModuleType;
    }

    @Override
    protected void fireModulesAdded() {
        for (Module module : this.myModuleModel.getModules()) {
            this.fireModuleAddedInWriteAction((ModuleEx)module);
        }
    }

    @Override
    protected void deliverPendingEvents() {
        this.myMessageBusConnection.deliverImmediately();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToLoad";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesToUnload";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesWithUnknownTypes";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/impl/ModuleManagerComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unloadedModuleNames";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/impl/ModuleManagerComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndLoadModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unloadNewlyAddedModulesIfPossible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showUnknownModuleTypeNotification";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNonPersistentModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createAndLoadModule";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setUnloadedModuleNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isUnknownModuleType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyProjectServiceContainerInitializedListener
    implements ProjectServiceContainerInitializedListener {
        MyProjectServiceContainerInitializedListener() {
        }

        @Override
        public void serviceCreated(@NotNull Project project) {
            if (project == null) {
                MyProjectServiceContainerInitializedListener.$$$reportNull$$$0(0);
            }
            Activity activity = StartUpMeasurer.startMainActivity((String)"module loading");
            ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
            if (!(moduleManager instanceof ModuleManagerImpl)) {
                return;
            }
            ModuleManagerImpl manager2 = (ModuleManagerImpl)moduleManager;
            manager2.loadModules(manager2.myModuleModel);
            activity.end();
            activity.setDescription("module count: " + manager2.myModuleModel.getModules().length);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/module/impl/ModuleManagerComponent$MyProjectServiceContainerInitializedListener", "serviceCreated"));
        }
    }
}

