/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ExternalModuleListStorage;
import com.intellij.openapi.module.impl.ExternalModuleListStorageKt;
import com.intellij.openapi.module.impl.ModuleManagerEx;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.module.impl.ModulePath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalProjectModuleManager", storages={@Storage(value="modules.xml")}, externalStorageOnly=true)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R.\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/module/impl/ExternalModuleListStorageImpl;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/roots/ProjectModelElement;", "Lcom/intellij/openapi/module/impl/ExternalModuleListStorage;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "", "Lcom/intellij/openapi/module/impl/ModulePath;", "loadedState", "getLoadedState", "()Ljava/util/Set;", "getExternalModules", "getExternalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "getState", "loadState", "", "state", "intellij.platform.projectModel.impl"})
public final class ExternalModuleListStorageImpl
implements PersistentStateComponent<Element>,
ProjectModelElement,
ExternalModuleListStorage {
    @Nullable
    private Set<ModulePath> loadedState;
    private final Project project;

    @Nullable
    public final Set<ModulePath> getLoadedState() {
        return this.loadedState;
    }

    @Override
    @Nullable
    public Set<ModulePath> getExternalModules() {
        return this.loadedState;
    }

    @NotNull
    public Element getState() {
        ModuleManagerEx moduleManager;
        Element e = new Element("state");
        if (!ProjectUtilCore.isExternalStorageEnabled((Project)this.project)) {
            return e;
        }
        ModuleManagerEx moduleManagerEx = moduleManager = ModuleManagerEx.getInstanceEx(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)moduleManagerEx), (String)"moduleManager");
        Module[] moduleArray = moduleManagerEx.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"moduleManager.modules");
        List<Module> filteredModuleList = ExternalModuleListStorageKt.getFilteredModuleList(this.project, moduleArray, true);
        ModuleManagerImpl.writeExternal(e, filteredModuleList, moduleManager);
        return e;
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.loadedState = ModuleManagerImpl.getPathsToModuleFiles(state);
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        ExternalProjectSystemRegistry externalProjectSystemRegistry = ExternalProjectSystemRegistry.getInstance();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module module : moduleManager.getModules()) {
            ProjectModelExternalSource projectModelExternalSource = externalProjectSystemRegistry.getExternalSource(module);
            if (projectModelExternalSource == null) continue;
            ProjectModelExternalSource projectModelExternalSource2 = projectModelExternalSource;
            boolean bl = false;
            boolean bl2 = false;
            ProjectModelExternalSource it = projectModelExternalSource2;
            boolean bl3 = false;
            return it;
        }
        return null;
    }

    public ExternalModuleListStorageImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }
}

