/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.diagnostic.VMOptions;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.NationalKeyboardSupport;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ShortcutRestrictions;
import com.intellij.openapi.keymap.impl.SystemShortcuts;
import com.intellij.openapi.keymap.impl.ui.ActionsTree;
import com.intellij.openapi.keymap.impl.ui.KeyboardShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.KeymapSchemeManager;
import com.intellij.openapi.keymap.impl.ui.KeymapSelector;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutDialog;
import com.intellij.openapi.keymap.impl.ui.ShortcutFilteringPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ToggleActionButton;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.util.Alarm;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeymapPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll,
KeymapListener,
Disposable {
    private JCheckBox nationalKeyboardsSupport;
    private final KeymapSelector myKeymapSelector = new KeymapSelector(this::currentKeymapChanged);
    private final KeymapSchemeManager myManager = this.myKeymapSelector.getManager();
    private final ActionsTree myActionsTree = new ActionsTree();
    private FilterComponent myFilterComponent;
    private TreeExpansionMonitor myTreeExpansionMonitor;
    private final ShortcutFilteringPanel myFilteringPanel = new ShortcutFilteringPanel();
    private boolean myQuickListsModified = false;
    private QuickList[] myQuickLists = QuickListsManager.getInstance().getAllQuickLists();
    private ShowFNKeysSettingWrapper myShowFN;
    private boolean myShowOnlyConflicts;
    private JPanel mySystemShortcutConflictsPanel;
    private ToggleActionButton myShowOnlyConflictsButton;

    public KeymapPanel() {
        this(false);
    }

    public KeymapPanel(boolean showOnlyConflicts) {
        this.myShowOnlyConflicts = showOnlyConflicts;
        this.setLayout(new BorderLayout());
        JPanel keymapPanel = new JPanel(new BorderLayout());
        keymapPanel.add(this.myManager.getSchemesPanel(), "North");
        keymapPanel.add((Component)this.createKeymapSettingsPanel(), "Center");
        IdeFrame ideFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        if (ideFrame != null && NationalKeyboardSupport.isSupportedKeyboardLayout((Component)ideFrame.getComponent())) {
            this.nationalKeyboardsSupport = new JCheckBox(new AbstractAction(KeyMapBundle.message((String)NationalKeyboardSupport.getKeymapBundleKey(), (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NationalKeyboardSupport.getInstance().setEnabled(KeymapPanel.this.nationalKeyboardsSupport.isSelected());
                    VMOptions.writeOption(NationalKeyboardSupport.getVMOption(), "=", Boolean.toString(NationalKeyboardSupport.getInstance().getEnabled()));
                    ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().restart(), ModalityState.NON_MODAL);
                }
            });
            this.nationalKeyboardsSupport.setSelected(NationalKeyboardSupport.getInstance().getEnabled());
            this.nationalKeyboardsSupport.setBorder((Border)JBUI.Borders.empty());
            keymapPanel.add((Component)this.nationalKeyboardsSupport, "South");
        }
        this.add((Component)keymapPanel, "Center");
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (evt.getPropertyName().equals("ancestor") && evt.getNewValue() != null && evt.getOldValue() == null && KeymapPanel.this.myQuickListsModified) {
                    KeymapPanel.this.currentKeymapChanged();
                    KeymapPanel.this.myQuickListsModified = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$2", "propertyChange"));
            }
        });
        this.myFilteringPanel.addPropertyChangeListener("shortcut", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                KeymapPanel.this.filterTreeByShortcut(KeymapPanel.this.myFilteringPanel.getShortcut());
            }
        });
        this.mySystemShortcutConflictsPanel = new JPanel(new FlowLayout(0, 0, 5));
        this.add((Component)this.mySystemShortcutConflictsPanel, "South");
    }

    private void fillConflictsPanel(@NotNull Keymap keymap2) {
        String shortcutsMessage;
        if (keymap2 == null) {
            KeymapPanel.$$$reportNull$$$0(0);
        }
        this.mySystemShortcutConflictsPanel.removeAll();
        SystemShortcuts systemShortcuts = SystemShortcuts.getInstance();
        @NotNull Collection<SystemShortcuts.ConflictItem> allConflicts = systemShortcuts.getUnmutedKeymapConflicts();
        if (allConflicts.isEmpty()) {
            return;
        }
        HtmlBuilder links = new HtmlBuilder();
        final HashMap<String, Runnable> href2linkAction = new HashMap<String, Runnable>();
        int count = 0;
        boolean empty = true;
        for (SystemShortcuts.ConflictItem conf : allConflicts) {
            String actText;
            String actId = conf.getActionIds()[0];
            href2linkAction.put(actId, () -> {
                KeyboardShortcut confShortcut = KeymapPanel.findKeyboardShortcut(keymap2, conf.getSysKeyStroke(), actId);
                KeymapPanel.addKeyboardShortcut(actId, ActionShortcutRestrictions.getInstance().getForActionId(actId), keymap2, (Component)this, confShortcut, systemShortcuts, this.myQuickLists);
            });
            AnAction act = ActionManager.getInstance().getAction(actId);
            String string = actText = act == null ? actId : act.getTemplateText();
            if (!empty) {
                links.append(", ");
            }
            links.appendLink(actId, actText);
            empty = false;
            if (++count <= 2) continue;
            break;
        }
        if (count > 2 && allConflicts.size() > count) {
            String actionId = "show.more";
            HtmlChunk.Element moreLink = HtmlChunk.link((String)actionId, (String)IdeBundle.message((String)"more.shortcuts.link.text.with.count", (Object[])new Object[]{allConflicts.size() - count}));
            href2linkAction.put(actionId, () -> {
                this.myShowOnlyConflicts = true;
                this.myActionsTree.setBaseFilter(systemShortcuts.createKeymapConflictsActionFilter());
                this.myActionsTree.filter(null, this.myQuickLists);
                TreeUtil.expandAll((JTree)this.myActionsTree.getTree());
            });
            shortcutsMessage = IdeBundle.message((String)"macos.shortcut.conflict.many", (Object[])new Object[]{links, moreLink});
        } else {
            shortcutsMessage = IdeBundle.message((String)"macos.shortcut.conflict.few", (Object[])new Object[]{links});
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.appendRaw(shortcutsMessage).br().append(IdeBundle.message((String)"assign.custom.shortcuts.or.change.the.macos.system.settings", (Object[])new Object[0]));
        JBLabel jbLabel = new JBLabel(KeymapPanel.createWarningHtmlText(builder2.toString())){

            @NotNull
            protected HyperlinkListener createHyperlinkListener() {
                return new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        String href;
                        Runnable act;
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (act = (Runnable)href2linkAction.get(href = e.getDescription())) != null) {
                            act.run();
                        }
                    }
                };
            }
        };
        jbLabel.setCopyable(true);
        jbLabel.setAllowAutoWrapping(true);
        jbLabel.setIconWithAlignment(AllIcons.General.Warning, 2, 1);
        this.mySystemShortcutConflictsPanel.add((Component)jbLabel);
        this.validate();
        this.repaint();
    }

    @Nls
    private static String createWarningHtmlText(@Nullable @Nls String htmlBody) {
        if (htmlBody == null) {
            return null;
        }
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.head().child((HtmlChunk)HtmlChunk.styleTag((String)("a, a:link {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED) + ";}\na:visited {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.VISITED) + ";}\na:hover {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.HOVERED) + ";}\na:active {color:#" + ColorUtil.toHex((Color)JBUI.CurrentTheme.Link.Foreground.PRESSED) + ";}\n")))).append((HtmlChunk)HtmlChunk.body().child((HtmlChunk)HtmlChunk.div().addRaw(htmlBody))).wrapWith("html").toString();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myFilteringPanel != null) {
            SwingUtilities.updateComponentTreeUI(this.myFilteringPanel);
        }
    }

    @Override
    public void quickListRenamed(@NotNull QuickList oldQuickList, @NotNull QuickList newQuickList) {
        if (oldQuickList == null) {
            KeymapPanel.$$$reportNull$$$0(1);
        }
        if (newQuickList == null) {
            KeymapPanel.$$$reportNull$$$0(2);
        }
        this.myManager.visitMutableKeymaps(keymap2 -> {
            String actionId = oldQuickList.getActionId();
            Shortcut[] shortcuts = keymap2.getShortcuts(actionId);
            if (shortcuts.length != 0) {
                String newActionId = newQuickList.getActionId();
                for (Shortcut shortcut : shortcuts) {
                    keymap2.removeShortcut(actionId, shortcut);
                    keymap2.addShortcut(newActionId, shortcut);
                }
            }
        });
        this.myQuickListsModified = true;
    }

    public Runnable enableSearch(String option2) {
        return () -> this.showOption(option2);
    }

    @Override
    public void processCurrentKeymapChanged() {
        this.currentKeymapChanged();
    }

    @Override
    public void processCurrentKeymapChanged(QuickList @NotNull [] ids) {
        if (ids == null) {
            KeymapPanel.$$$reportNull$$$0(3);
        }
        this.myQuickLists = ids;
        this.currentKeymapChanged();
    }

    private void currentKeymapChanged() {
        this.currentKeymapChanged(this.myManager.getSelectedKeymap());
    }

    private void currentKeymapChanged(Keymap selectedKeymap) {
        if (selectedKeymap == null) {
            selectedKeymap = new KeymapImpl();
        }
        SystemShortcuts systemShortcuts = SystemShortcuts.getInstance();
        systemShortcuts.updateKeymapConflicts(selectedKeymap);
        this.myShowOnlyConflictsButton.setVisible(!systemShortcuts.getUnmutedKeymapConflicts().isEmpty());
        this.myActionsTree.setBaseFilter(this.myShowOnlyConflicts ? systemShortcuts.createKeymapConflictsActionFilter() : null);
        this.myActionsTree.reset(selectedKeymap, this.myQuickLists);
        this.fillConflictsPanel(selectedKeymap);
    }

    private JPanel createKeymapSettingsPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.createToolbarPanel(), "North");
        panel2.add((Component)this.myActionsTree.getComponent(), "Center");
        this.myTreeExpansionMonitor = TreeExpansionMonitor.install(this.myActionsTree.getTree());
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                KeymapPanel.this.editSelection(e, true);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$5", "onDoubleClick"));
            }
        }.installOn((Component)this.myActionsTree.getTree());
        this.myActionsTree.getTree().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (e.isPopupTrigger()) {
                    KeymapPanel.this.editSelection(e, false);
                    e.consume();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mousePressed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "mouseReleased";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (TouchBarsManager.isTouchBarAvailable()) {
            this.myShowFN = new ShowFNKeysSettingWrapper();
            if (this.myShowFN.getCheckbox() != null) {
                panel2.add((Component)this.myShowFN.getCheckbox(), "South");
            }
        }
        return panel2;
    }

    private JPanel createToolbarPanel() {
        DefaultActionGroup group2 = new DefaultActionGroup();
        JComponent toolbar = ActionManager.getInstance().createActionToolbar("KeymapEdit", (ActionGroup)group2, true).getComponent();
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        TreeExpander treeExpander = KeymapPanel.createTreeExpander(this.myActionsTree);
        group2.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group2.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myActionsTree.getTree()));
        group2.add((AnAction)new EditShortcutAction());
        this.myShowOnlyConflictsButton = new ToggleActionButton(KeyMapBundle.messagePointer((String)"keymap.show.system.conflicts", (Object[])new Object[0]), AllIcons.General.ShowWarning){

            public boolean isSelected(AnActionEvent e) {
                return KeymapPanel.this.myShowOnlyConflicts;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                KeymapPanel.this.myShowOnlyConflicts = state;
                KeymapPanel.this.myActionsTree.setBaseFilter(KeymapPanel.this.myShowOnlyConflicts ? SystemShortcuts.getInstance().createKeymapConflictsActionFilter() : null);
                KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
                JTree tree = KeymapPanel.this.myActionsTree.getTree();
                if (KeymapPanel.this.myShowOnlyConflicts) {
                    TreeUtil.expandAll((JTree)tree);
                } else {
                    TreeUtil.collapseAll((JTree)tree, (int)0);
                }
            }
        };
        group2.add((AnAction)this.myShowOnlyConflictsButton);
        group2 = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("Keymap", (ActionGroup)group2, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent searchToolbar = actionToolbar.getComponent();
        final Alarm alarm2 = new Alarm();
        this.myFilterComponent = new FilterComponent("KEYMAP", 5){

            public void filter() {
                alarm2.cancelAllRequests();
                alarm2.addRequest(() -> {
                    if (!KeymapPanel.this.myFilterComponent.isShowing()) {
                        return;
                    }
                    KeymapPanel.this.myTreeExpansionMonitor.freeze();
                    KeymapPanel.this.myFilteringPanel.setShortcut(null);
                    String filter = this.getFilter();
                    KeymapPanel.this.myActionsTree.filter(filter, KeymapPanel.this.myQuickLists);
                    JTree tree = KeymapPanel.this.myActionsTree.getTree();
                    TreeUtil.expandAll((JTree)tree);
                    if (filter == null || filter.length() == 0) {
                        TreeUtil.collapseAll((JTree)tree, (int)0);
                        KeymapPanel.this.myTreeExpansionMonitor.restore();
                    } else {
                        KeymapPanel.this.myTreeExpansionMonitor.unfreeze();
                    }
                }, 300);
            }
        };
        this.myFilterComponent.reset();
        group2.add((AnAction)new FindByShortcutAction(searchToolbar));
        group2.add((AnAction)new ClearFilteringAction());
        JPanel panel2 = new JPanel(new GridLayout(1, 2));
        panel2.add(toolbar);
        panel2.add((Component)new BorderLayoutPanel().addToCenter((Component)this.myFilterComponent).addToRight((Component)searchToolbar));
        return panel2;
    }

    @NotNull
    public static TreeExpander createTreeExpander(@NotNull ActionsTree actionsTree) {
        if (actionsTree == null) {
            KeymapPanel.$$$reportNull$$$0(4);
        }
        return new DefaultTreeExpander(actionsTree::getTree);
    }

    private void filterTreeByShortcut(Shortcut shortcut) {
        boolean wasFreezed = this.myTreeExpansionMonitor.isFreeze();
        if (!wasFreezed) {
            this.myTreeExpansionMonitor.freeze();
        }
        this.myActionsTree.filterTree(shortcut, this.myQuickLists);
        JTree tree = this.myActionsTree.getTree();
        TreeUtil.expandAll((JTree)tree);
        if (!wasFreezed) {
            this.myTreeExpansionMonitor.restore();
        }
    }

    public void showOption(String option2) {
        this.currentKeymapChanged();
        this.myFilterComponent.setFilter(option2);
        this.myFilteringPanel.setShortcut(null);
        this.myActionsTree.filter(option2, this.myQuickLists);
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(5);
        }
        if (restrictions == null) {
            KeymapPanel.$$$reportNull$$$0(6);
        }
        if (keymapSelected == null) {
            KeymapPanel.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            KeymapPanel.$$$reportNull$$$0(8);
        }
        if (quickLists == null) {
            KeymapPanel.$$$reportNull$$$0(9);
        }
        KeymapPanel.addKeyboardShortcut(actionId, restrictions, keymapSelected, parent, null, null, quickLists);
    }

    public static void addKeyboardShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, @Nullable KeyboardShortcut selectedShortcut, @Nullable SystemShortcuts systemShortcuts, QuickList ... quickLists) {
        Keymap keymap2;
        Map<KeyboardShortcut, String> kscs;
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(10);
        }
        if (restrictions == null) {
            KeymapPanel.$$$reportNull$$$0(11);
        }
        if (keymapSelected == null) {
            KeymapPanel.$$$reportNull$$$0(12);
        }
        if (parent == null) {
            KeymapPanel.$$$reportNull$$$0(13);
        }
        if (quickLists == null) {
            KeymapPanel.$$$reportNull$$$0(14);
        }
        if (!restrictions.allowKeyboardShortcut) {
            return;
        }
        KeyboardShortcutDialog dialog2 = new KeyboardShortcutDialog(parent, restrictions.allowKeyboardSecondStroke, systemShortcuts == null ? null : systemShortcuts.createKeystroke2SysShortcutMap());
        KeyboardShortcut keyboardShortcut = dialog2.showAndGet(actionId, keymapSelected, selectedShortcut, quickLists);
        if (keyboardShortcut == null) {
            return;
        }
        SafeKeymapAccessor accessor = new SafeKeymapAccessor(parent, keymapSelected);
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                Keymap keymap3 = accessor.keymap();
                Map conflicts = keymap3.getConflicts(actionId, keyboardShortcut);
                for (String id2 : conflicts.keySet()) {
                    for (KeyboardShortcut s : (List)conflicts.get(id2)) {
                        keymap3.removeShortcut(id2, (Shortcut)s);
                    }
                }
            } else if (result2 != 1) {
                return;
            }
        }
        if (systemShortcuts != null && (kscs = systemShortcuts.calculateConflicts(keymap2 = accessor.keymap(), actionId)) != null && !kscs.isEmpty()) {
            for (KeyboardShortcut ksc : kscs.keySet()) {
                int result3;
                Object keyDesc = StringUtil.notNullize((String)KeymapUtil.getKeystrokeText((KeyStroke)ksc.getFirstKeyStroke()));
                if (ksc.getSecondKeyStroke() != null) {
                    keyDesc = (String)keyDesc + ", " + KeymapUtil.getKeystrokeText((KeyStroke)ksc.getSecondKeyStroke());
                }
                if ((result3 = Messages.showYesNoCancelDialog((Component)parent, (String)IdeBundle.message((String)"message.action.shortcut.0.is.already.assigned.to.system.action.1.do.you.want.to.remove.this.shortcut", (Object[])new Object[]{keyDesc, kscs.get(ksc)}), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon())) != 0) continue;
                keymap2.removeShortcut(actionId, (Shortcut)ksc);
            }
        }
        accessor.add(actionId, (Shortcut)keyboardShortcut);
        if (systemShortcuts != null) {
            systemShortcuts.updateKeymapConflicts(accessor.keymap());
        }
    }

    private static void addMouseShortcut(@NotNull String actionId, @NotNull ShortcutRestrictions restrictions, @NotNull Keymap keymapSelected, @NotNull Component parent, QuickList ... quickLists) {
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(15);
        }
        if (restrictions == null) {
            KeymapPanel.$$$reportNull$$$0(16);
        }
        if (keymapSelected == null) {
            KeymapPanel.$$$reportNull$$$0(17);
        }
        if (parent == null) {
            KeymapPanel.$$$reportNull$$$0(18);
        }
        if (quickLists == null) {
            KeymapPanel.$$$reportNull$$$0(19);
        }
        if (!restrictions.allowMouseShortcut) {
            return;
        }
        MouseShortcutDialog dialog2 = new MouseShortcutDialog(parent, restrictions.allowMouseDoubleClick);
        MouseShortcut mouseShortcut = (MouseShortcut)dialog2.showAndGet(actionId, keymapSelected, quickLists);
        if (mouseShortcut == null) {
            return;
        }
        SafeKeymapAccessor accessor = new SafeKeymapAccessor(parent, keymapSelected);
        if (dialog2.hasConflicts()) {
            int result2 = KeymapPanel.showConfirmationDialog(parent);
            if (result2 == 0) {
                Keymap keymap2 = accessor.keymap();
                for (String id2 : keymap2.getActionIds(mouseShortcut)) {
                    keymap2.removeShortcut(id2, (Shortcut)mouseShortcut);
                }
            } else if (result2 != 1) {
                return;
            }
        }
        accessor.add(actionId, (Shortcut)mouseShortcut);
    }

    private void repaintLists() {
        this.myActionsTree.getComponent().repaint();
    }

    @NotNull
    public String getId() {
        return "preferences.keymap";
    }

    public void reset() {
        if (this.nationalKeyboardsSupport != null) {
            this.nationalKeyboardsSupport.setSelected(NationalKeyboardSupport.getInstance().getEnabled());
        }
        this.myManager.reset();
    }

    public void apply() throws ConfigurationException {
        String error = this.myManager.apply();
        if (error != null) {
            throw new ConfigurationException(error);
        }
        ActionToolbarImpl.updateAllToolbarsImmediately();
        if (this.myShowFN != null) {
            this.myShowFN.applyChanges();
        }
    }

    public boolean isModified() {
        return this.myManager.isModified() || this.myShowFN != null && this.myShowFN.isModified();
    }

    public void selectAction(String actionId) {
        this.myActionsTree.selectAction(actionId);
    }

    @Nls
    public String getDisplayName() {
        return KeyMapBundle.message((String)"keymap.display.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "preferences.keymap";
    }

    public JComponent createComponent() {
        if (this.myShowFN != null) {
            Disposer.register((Disposable)this, (Disposable)this.myShowFN);
        }
        KeymapExtension.EXTENSION_POINT_NAME.addChangeListener(this::currentKeymapChanged, (Disposable)this);
        this.myKeymapSelector.attachKeymapListener(this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(CHANGE_TOPIC, (Object)this);
        return this;
    }

    public void disposeUIResources() {
        this.myFilteringPanel.hidePopup();
        if (this.myFilterComponent != null) {
            this.myFilterComponent.dispose();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    public Shortcut @Nullable [] getCurrentShortcuts(@NotNull String actionId) {
        Keymap keymap2;
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(20);
        }
        return (keymap2 = this.myManager.getSelectedKeymap()) == null ? null : keymap2.getShortcuts(actionId);
    }

    private void editSelection(InputEvent e, boolean isDoubleClick) {
        String actionId = this.myActionsTree.getSelectedActionId();
        if (actionId == null) {
            return;
        }
        Keymap selectedKeymap = this.myManager.getSelectedKeymap();
        if (selectedKeymap == null) {
            return;
        }
        DefaultActionGroup group2 = this.createEditActionGroup(actionId, selectedKeymap);
        if (e instanceof MouseEvent && ((MouseEvent)e).isPopupTrigger()) {
            ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group2).getComponent().show(e.getComponent(), ((MouseEvent)e).getX(), ((MouseEvent)e).getY());
        } else if (!isDoubleClick || !ActionManager.getInstance().isGroup(actionId)) {
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)this);
            ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(IdeBundle.message((String)"popup.title.edit.shortcuts", (Object[])new Object[0]), (ActionGroup)group2, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
            if (e instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)e));
            } else {
                popup2.showInBestPositionFor(dataContext);
            }
        }
    }

    @NotNull
    private DefaultActionGroup createEditActionGroup(@NotNull String actionId, Keymap selectedKeymap) {
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(21);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        ShortcutRestrictions restrictions = ActionShortcutRestrictions.getInstance().getForActionId(actionId);
        if (restrictions.allowKeyboardShortcut) {
            group2.add((AnAction)new AddKeyboardShortcutAction(actionId, restrictions, selectedKeymap));
        }
        if (restrictions.allowMouseShortcut) {
            group2.add((AnAction)new AddMouseShortcutAction(actionId, restrictions, selectedKeymap));
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && restrictions.allowAbbreviation) {
            group2.add((AnAction)new AddAbbreviationAction(actionId));
        }
        group2.addSeparator();
        for (Shortcut shortcut : selectedKeymap.getShortcuts(actionId)) {
            group2.add((AnAction)new RemoveShortcutAction(shortcut, selectedKeymap, actionId));
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations")) {
            for (String abbreviation : AbbreviationManager.getInstance().getAbbreviations(actionId)) {
                group2.addAction((AnAction)new RemoveAbbreviationAction(abbreviation, actionId));
            }
        }
        if (this.myManager.canResetActionInKeymap(selectedKeymap, actionId)) {
            group2.add((AnAction)new Separator());
            group2.add((AnAction)new ResetShortcutsAction(selectedKeymap, actionId));
        }
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            KeymapPanel.$$$reportNull$$$0(22);
        }
        return defaultActionGroup;
    }

    private static int showConfirmationDialog(Component parent) {
        return Messages.showYesNoCancelDialog((Component)parent, (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.title", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.remove.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.leave.button", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"conflict.shortcut.dialog.cancel.button", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
    }

    @Nullable
    private static KeyboardShortcut findKeyboardShortcut(@NotNull Keymap keymap2, @NotNull KeyStroke ks, @NotNull String actionId) {
        Shortcut[] actionShortcuts;
        if (keymap2 == null) {
            KeymapPanel.$$$reportNull$$$0(23);
        }
        if (ks == null) {
            KeymapPanel.$$$reportNull$$$0(24);
        }
        if (actionId == null) {
            KeymapPanel.$$$reportNull$$$0(25);
        }
        if ((actionShortcuts = keymap2.getShortcuts(actionId)).length == 0) {
            return null;
        }
        for (Shortcut sc : actionShortcuts) {
            KeyboardShortcut ksc;
            if (!(sc instanceof KeyboardShortcut) || !ks.equals((ksc = (KeyboardShortcut)sc).getFirstKeyStroke()) && !ks.equals(ksc.getSecondKeyStroke())) continue;
            return ksc;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldQuickList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQuickList";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionsTree";
                break;
            }
            case 5: 
            case 10: 
            case 15: 
            case 20: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictions";
                break;
            }
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapSelected";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickLists";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillConflictsPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "quickListRenamed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processCurrentKeymapChanged";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTreeExpander";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addKeyboardShortcut";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addMouseShortcut";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentShortcuts";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createEditActionGroup";
                break;
            }
            case 22: {
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findKeyboardShortcut";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ResetShortcutsAction
    extends DumbAwareAction {
        private final Keymap mySelectedKeymap;
        @NotNull
        private final String myActionId;

        private ResetShortcutsAction(@NotNull Keymap selectedKeymap, String actionId) {
            if (actionId == null) {
                ResetShortcutsAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.messagePointer((String)"action.Anonymous.text.reset.shortcuts", (Object[])new Object[0]));
            this.mySelectedKeymap = selectedKeymap;
            this.myActionId = actionId;
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                ResetShortcutsAction.$$$reportNull$$$0(1);
            }
            KeymapPanel.this.myManager.resetActionInKeymap(this.mySelectedKeymap, this.myActionId);
            KeymapPanel.this.repaintLists();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$ResetShortcutsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RemoveAbbreviationAction
    extends DumbAwareAction {
        private final String myAbbreviation;
        @NotNull
        private final String myActionId;

        private RemoveAbbreviationAction(@NotNull String abbreviation, String actionId) {
            if (actionId == null) {
                RemoveAbbreviationAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"action.text.remove.abbreviation.0", (Object[])new Object[]{abbreviation}));
            this.myAbbreviation = abbreviation;
            this.myActionId = actionId;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAbbreviationAction.$$$reportNull$$$0(1);
            }
            AbbreviationManager.getInstance().remove(this.myAbbreviation, this.myActionId);
            KeymapPanel.this.repaintLists();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$RemoveAbbreviationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RemoveShortcutAction
    extends DumbAwareAction {
        private final Shortcut myShortcut;
        private final Keymap mySelectedKeymap;
        @NotNull
        private final String myActionId;

        private RemoveShortcutAction(Shortcut shortcut, @NotNull Keymap selectedKeymap, String actionId) {
            if (actionId == null) {
                RemoveShortcutAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.message((String)"action.text.remove.0", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut)}));
            this.myShortcut = shortcut;
            this.mySelectedKeymap = selectedKeymap;
            this.myActionId = actionId;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveShortcutAction.$$$reportNull$$$0(1);
            }
            Keymap keymap2 = KeymapPanel.this.myManager.getMutableKeymap(this.mySelectedKeymap);
            keymap2.removeShortcut(this.myActionId, this.myShortcut);
            if (StringUtil.startsWithChar((CharSequence)this.myActionId, (char)'$')) {
                keymap2.removeShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{this.myActionId.substring(1)}), this.myShortcut);
            }
            KeymapPanel.this.currentKeymapChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$RemoveShortcutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddAbbreviationAction
    extends DumbAwareAction {
        @NotNull
        private final String myActionId;

        private AddAbbreviationAction(String actionId) {
            if (actionId == null) {
                AddAbbreviationAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.messagePointer((String)"action.Anonymous.text.add.abbreviation", (Object[])new Object[0]));
            this.myActionId = actionId;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String abbr;
            if (e == null) {
                AddAbbreviationAction.$$$reportNull$$$0(1);
            }
            if ((abbr = Messages.showInputDialog((String)IdeBundle.message((String)"label.enter.new.abbreviation", (Object[])new Object[0]), (String)IdeBundle.message((String)"dialog.title.abbreviation", (Object[])new Object[0]), null)) != null) {
                AbbreviationManager.getInstance().register(abbr, this.myActionId);
                KeymapPanel.this.repaintLists();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$AddAbbreviationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddMouseShortcutAction
    extends DumbAwareAction {
        @NotNull
        private final String myActionId;
        private final ShortcutRestrictions myRestrictions;
        private final Keymap mySelectedKeymap;

        private AddMouseShortcutAction(String actionId, ShortcutRestrictions restrictions, Keymap selectedKeymap) {
            if (actionId == null) {
                AddMouseShortcutAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.messagePointer((String)"action.Anonymous.text.add.mouse.shortcut", (Object[])new Object[0]));
            this.myActionId = actionId;
            this.myRestrictions = restrictions;
            this.mySelectedKeymap = selectedKeymap;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddMouseShortcutAction.$$$reportNull$$$0(1);
            }
            KeymapPanel.addMouseShortcut(this.myActionId, this.myRestrictions, this.mySelectedKeymap, KeymapPanel.this, KeymapPanel.this.myQuickLists);
            KeymapPanel.this.currentKeymapChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$AddMouseShortcutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddKeyboardShortcutAction
    extends DumbAwareAction {
        @NotNull
        private final String myActionId;
        private final ShortcutRestrictions myRestrictions;
        private final Keymap mySelectedKeymap;

        private AddKeyboardShortcutAction(String actionId, ShortcutRestrictions restrictions, Keymap selectedKeymap) {
            if (actionId == null) {
                AddKeyboardShortcutAction.$$$reportNull$$$0(0);
            }
            super(IdeBundle.messagePointer((String)"action.Anonymous.text.add.keyboard.shortcut", (Object[])new Object[0]));
            this.myActionId = actionId;
            this.myRestrictions = restrictions;
            this.mySelectedKeymap = selectedKeymap;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddKeyboardShortcutAction.$$$reportNull$$$0(1);
            }
            KeymapPanel.addKeyboardShortcut(this.myActionId, this.myRestrictions, this.mySelectedKeymap, (Component)KeymapPanel.this, null, SystemShortcuts.getInstance(), KeymapPanel.this.myQuickLists);
            KeymapPanel.this.currentKeymapChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$AddKeyboardShortcutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClearFilteringAction
    extends DumbAwareAction {
        private ClearFilteringAction() {
            super(KeyMapBundle.message((String)"filter.clear.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.clear.action.description", (Object[])new Object[0]), AllIcons.Actions.GC);
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                ClearFilteringAction.$$$reportNull$$$0(0);
            }
            boolean enabled = null != KeymapPanel.this.myFilteringPanel.getShortcut();
            Presentation presentation2 = event.getPresentation();
            presentation2.setEnabled(enabled);
            presentation2.setIcon(enabled ? AllIcons.Actions.Cancel : EmptyIcon.ICON_16);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ClearFilteringAction.$$$reportNull$$$0(1);
            }
            KeymapPanel.this.myTreeExpansionMonitor.freeze();
            KeymapPanel.this.myFilteringPanel.setShortcut(null);
            KeymapPanel.this.myActionsTree.filter(null, KeymapPanel.this.myQuickLists);
            TreeUtil.collapseAll((JTree)KeymapPanel.this.myActionsTree.getTree(), (int)0);
            KeymapPanel.this.myTreeExpansionMonitor.restore();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$ClearFilteringAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FindByShortcutAction
    extends DumbAwareAction {
        private final JComponent mySearchToolbar;

        private FindByShortcutAction(JComponent searchToolbar) {
            super(KeyMapBundle.message((String)"filter.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"filter.shortcut.action.description", (Object[])new Object[0]), AllIcons.Actions.ShortcutFilter);
            this.mySearchToolbar = searchToolbar;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                FindByShortcutAction.$$$reportNull$$$0(0);
            }
            KeymapPanel.this.myFilterComponent.reset();
            KeymapPanel.this.currentKeymapChanged();
            KeymapPanel.this.myFilteringPanel.showPopup(this.mySearchToolbar, e.getInputEvent().getComponent());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/KeymapPanel$FindByShortcutAction", "actionPerformed"));
        }
    }

    private class EditShortcutAction
    extends AnAction {
        private EditShortcutAction() {
            super(KeyMapBundle.message((String)"edit.shortcut.action.text", (Object[])new Object[0]), KeyMapBundle.message((String)"edit.shortcut.action.description", (Object[])new Object[0]), (Icon)new LayeredIcon(AllIcons.Actions.Edit, AllIcons.General.Dropdown));
            this.registerCustomShortcutSet(CommonShortcuts.ENTER, KeymapPanel.this.myActionsTree.getTree());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EditShortcutAction.$$$reportNull$$$0(0);
            }
            String actionId = KeymapPanel.this.myActionsTree.getSelectedActionId();
            e.getPresentation().setEnabled(actionId != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditShortcutAction.$$$reportNull$$$0(1);
            }
            KeymapPanel.this.editSelection(e.getInputEvent(), false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$EditShortcutAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SafeKeymapAccessor {
        private final Component parent;
        private final Keymap selected;
        private KeymapSchemeManager manager;
        private Keymap mutable;

        SafeKeymapAccessor(@NotNull Component parent, @NotNull Keymap selected2) {
            if (parent == null) {
                SafeKeymapAccessor.$$$reportNull$$$0(0);
            }
            if (selected2 == null) {
                SafeKeymapAccessor.$$$reportNull$$$0(1);
            }
            this.parent = parent;
            this.selected = selected2;
        }

        Keymap keymap() {
            if (this.mutable == null) {
                if (this.parent instanceof KeymapPanel) {
                    KeymapPanel panel2 = (KeymapPanel)this.parent;
                    this.mutable = panel2.myManager.getMutableKeymap(this.selected);
                } else {
                    if (this.manager == null) {
                        this.manager = new KeymapSelector(selectedKeymap -> {}).getManager();
                        this.manager.reset();
                    }
                    this.mutable = this.manager.getMutableKeymap(this.selected);
                }
            }
            return this.mutable;
        }

        void add(@NotNull String actionId, @NotNull Shortcut newShortcut) {
            Shortcut[] shortcuts;
            if (actionId == null) {
                SafeKeymapAccessor.$$$reportNull$$$0(2);
            }
            if (newShortcut == null) {
                SafeKeymapAccessor.$$$reportNull$$$0(3);
            }
            Keymap keymap2 = this.keymap();
            for (Shortcut shortcut : shortcuts = keymap2.getShortcuts(actionId)) {
                if (!shortcut.equals(newShortcut)) continue;
                if (this.manager != null) {
                    this.manager.apply();
                }
                return;
            }
            keymap2.addShortcut(actionId, newShortcut);
            if (StringUtil.startsWithChar((CharSequence)actionId, (char)'$')) {
                keymap2.addShortcut(KeyMapBundle.message((String)"editor.shortcut", (Object[])new Object[]{actionId.substring(1)}), newShortcut);
            }
            if (this.manager != null) {
                this.manager.apply();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newShortcut";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/KeymapPanel$SafeKeymapAccessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ShowFNKeysSettingWrapper
    implements Disposable {
        private boolean myShowFnInitial = false;
        private JCheckBox myCheckbox = null;
        private volatile boolean myDisposed;

        ShowFNKeysSettingWrapper() {
            if (TouchBarsManager.isTouchBarAvailable()) {
                String appId = Utils.getAppId();
                if (appId != null && !appId.isEmpty()) {
                    this.myShowFnInitial = NSDefaults.isShowFnKeysEnabled((String)appId);
                    this.myCheckbox = new JCheckBox(KeyMapBundle.message((String)"keymap.show.f.on.touch.bar", (Object[])new Object[0]), this.myShowFnInitial);
                } else {
                    Logger.getInstance(KeymapPanel.class).error("can't obtain application id from NSBundle");
                }
            }
        }

        JCheckBox getCheckbox() {
            return this.myCheckbox;
        }

        boolean isModified() {
            return this.myCheckbox != null && this.myShowFnInitial != this.myCheckbox.isSelected();
        }

        void applyChanges() {
            if (!TouchBarsManager.isTouchBarAvailable() || this.myCheckbox == null || !this.isModified()) {
                return;
            }
            String appId = Utils.getAppId();
            if (appId == null || appId.isEmpty()) {
                Logger.getInstance(KeymapPanel.class).error("can't obtain application id from NSBundle");
                return;
            }
            boolean prevVal = this.myShowFnInitial;
            this.myShowFnInitial = this.myCheckbox.isSelected();
            NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial);
            if (this.myShowFnInitial != NSDefaults.isShowFnKeysEnabled((String)appId)) {
                NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial, (boolean)true);
                if (this.myShowFnInitial != NSDefaults.isShowFnKeysEnabled((String)appId)) {
                    return;
                }
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                boolean result2 = Utils.restartTouchBarServer();
                if (!result2) {
                    this.myShowFnInitial = prevVal;
                    NSDefaults.setShowFnKeysEnabled((String)appId, (boolean)this.myShowFnInitial);
                    if (!this.myDisposed) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!this.myDisposed) {
                                this.myCheckbox.setSelected(prevVal);
                            }
                        }, ModalityState.stateForComponent((Component)this.myCheckbox));
                    }
                }
            });
        }

        public void dispose() {
            if (!this.myDisposed) {
                this.myDisposed = true;
                this.myCheckbox = null;
            }
        }
    }
}

