/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsTreeUtil {
    private static final Logger LOG = Logger.getInstance(ActionsTreeUtil.class);
    @NonNls
    private static final String EDITOR_PREFIX = "Editor";

    private ActionsTreeUtil() {
    }

    @NotNull
    public static Map<String, String> createPluginActionsMap() {
        HashSet<PluginId> visited = new HashSet<PluginId>();
        Map result2 = CollectionFactory.createSmallMemoryFootprintMap();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            PluginId id2 = descriptor2.getPluginId();
            visited.add(id2);
            if (PluginManagerCore.CORE_ID == id2) continue;
            for (String actionId : actionManager.getPluginActions(id2)) {
                result2.put(actionId, descriptor2.getName());
            }
        }
        for (PluginId id3 : PluginId.getRegisteredIdList()) {
            if (visited.contains(id3)) continue;
            for (String actionId : actionManager.getPluginActions(id3)) {
                result2.put(actionId, id3.getIdString());
            }
        }
        Map map2 = result2;
        if (map2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @NotNull
    private static Group createPluginsActionsGroup(Condition<? super AnAction> filtered2) {
        AnAction anAction;
        String[] pluginActions;
        Group pluginGroup;
        Group pluginsGroup = new Group(KeyMapBundle.message((String)"plugins.group.title", (Object[])new Object[0]), null, null);
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        ArrayList<IdeaPluginDescriptor> plugins2 = new ArrayList<IdeaPluginDescriptor>(Arrays.asList(PluginManagerCore.getPlugins()));
        plugins2.sort(Comparator.comparing(PluginDescriptor::getName));
        Set collected = CollectionFactory.createSmallMemoryFootprintSet((int)plugins2.size());
        for (IdeaPluginDescriptor plugin2 : plugins2) {
            collected.add(plugin2.getPluginId());
            if (plugin2.getName().equals("IDEA CORE")) continue;
            pluginGroup = new Group(plugin2.getName(), null, null);
            pluginActions = actionManager.getPluginActions(plugin2.getPluginId());
            if (pluginActions.length == 0) continue;
            Arrays.sort(pluginActions, Comparator.comparing(ActionsTreeUtil::getTextToCompare));
            for (String pluginAction : pluginActions) {
                if (keymapManager2.getBoundActions().contains(pluginAction)) continue;
                anAction = actionManager.getActionOrStub(pluginAction);
                if (filtered2 != null && !filtered2.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        for (PluginId pluginId : PluginId.getRegisteredIdList()) {
            if (collected.contains(pluginId)) continue;
            pluginGroup = new Group(pluginId.getIdString(), null, null);
            pluginActions = actionManager.getPluginActions(pluginId);
            if (pluginActions.length == 0) continue;
            for (String pluginAction : pluginActions) {
                if (keymapManager2.getBoundActions().contains(pluginAction)) continue;
                anAction = actionManager.getActionOrStub(pluginAction);
                if (filtered2 != null && !filtered2.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        Group group2 = pluginsGroup;
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(1);
        }
        return group2;
    }

    private static Group createMainMenuGroup(Condition<? super AnAction> filtered2) {
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(ActionsTreeUtil.getMainMenuTitle(), "MainMenu", AllIcons.Nodes.KeymapMainMenu);
        ActionGroup mainMenuGroup = (ActionGroup)actionManager.getActionOrStub("MainMenu");
        ActionsTreeUtil.fillGroupIgnorePopupFlag(mainMenuGroup, group2, filtered2, actionManager);
        return group2;
    }

    @NotNull
    private static Condition<AnAction> wrapFilter(@Nullable Condition<? super AnAction> filter, Keymap keymap2, ActionManager actionManager) {
        ActionShortcutRestrictions shortcutRestrictions = ActionShortcutRestrictions.getInstance();
        Condition condition = action2 -> {
            String id2;
            if (action2 == null) {
                return false;
            }
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id2 != null) {
                if (!Registry.is((String)"keymap.show.alias.actions")) {
                    boolean bound;
                    String binding = ActionsTreeUtil.getActionBinding(keymap2, id2);
                    boolean bl = bound = binding != null && actionManager.getAction(binding) != null && !ActionsTreeUtil.hasAssociatedShortcutsInHierarchy(id2, keymap2);
                    if (bound) {
                        return false;
                    }
                }
                if (!shortcutRestrictions.getForActionId((String)id2).allowChanging) {
                    return false;
                }
            }
            return filter == null || filter.value(action2);
        };
        if (condition == null) {
            ActionsTreeUtil.$$$reportNull$$$0(2);
        }
        return condition;
    }

    private static boolean hasAssociatedShortcutsInHierarchy(String id2, Keymap keymap2) {
        while (keymap2 != null) {
            if (((KeymapImpl)keymap2).hasOwnActionId(id2)) {
                return true;
            }
            keymap2 = keymap2.getParent();
        }
        return false;
    }

    private static void fillGroupIgnorePopupFlag(ActionGroup actionGroup2, Group group2, Condition<? super AnAction> filtered2, ActionManager actionManager) {
        AnAction[] mainMenuTopGroups;
        for (AnAction action2 : mainMenuTopGroups = ActionsTreeUtil.getActions(actionGroup2, actionManager)) {
            Group subGroup;
            if (!(action2 instanceof ActionGroup) || (subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered2)).getSize() <= 0) continue;
            group2.addGroup(subGroup);
        }
    }

    public static Group createGroup(ActionGroup actionGroup2, boolean ignore, Condition<? super AnAction> filtered2) {
        return ActionsTreeUtil.createGroup(actionGroup2, ActionsTreeUtil.getName((AnAction)actionGroup2), actionGroup2.getTemplatePresentation().getIcon(), null, ignore, filtered2);
    }

    @NlsActions.ActionText
    private static String getName(AnAction action2) {
        String id2;
        String name = action2.getTemplatePresentation().getText();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
        if (id2 != null) {
            return id2;
        }
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group2 = (DefaultActionGroup)action2;
            if (group2.getChildrenCount() == 0) {
                return IdeBundle.message((String)"action.empty.group.text", (Object[])new Object[0]);
            }
            for (AnAction child2 : children2 = group2.getChildActionsOrStubs()) {
                if (child2 instanceof Separator) continue;
                return "group." + ActionsTreeUtil.getName(child2);
            }
            return IdeBundle.message((String)"action.empty.unnamed.group.text", (Object[])new Object[0]);
        }
        return action2.getClass().getName();
    }

    public static Group createGroup(ActionGroup actionGroup2, @NlsActions.ActionText String groupName, Icon icon2, Icon openIcon, boolean ignore, Condition<? super AnAction> filtered2) {
        return ActionsTreeUtil.createGroup(actionGroup2, groupName, icon2, openIcon, ignore, filtered2, true);
    }

    public static Group createGroup(ActionGroup actionGroup2, @NlsActions.ActionText String groupName, Icon icon2, Icon openIcon, boolean ignore, Condition<? super AnAction> filtered2, boolean normalizeSeparators) {
        AnAction[] children2;
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(groupName, actionManager.getId((AnAction)actionGroup2), icon2);
        for (AnAction action2 : children2 = ActionsTreeUtil.getActions(actionGroup2, actionManager)) {
            String id2;
            if (action2 == null) {
                LOG.error(groupName + " contains null actions");
                continue;
            }
            if (action2 instanceof ActionGroup) {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, ActionsTreeUtil.getName(action2), null, null, ignore, filtered2, normalizeSeparators);
                if (!ignore && !((ActionGroup)action2).isPopup()) {
                    group2.addAll(subGroup);
                    continue;
                }
                if (subGroup.getSize() <= 0 && filtered2 != null && !filtered2.value((Object)action2)) continue;
                group2.addGroup(subGroup);
                continue;
            }
            if (action2 instanceof Separator) {
                group2.addSeparator();
                continue;
            }
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id2 == null || filtered2 != null && !filtered2.value((Object)action2)) continue;
            group2.addActionId(id2);
        }
        if (normalizeSeparators) {
            group2.normalizeSeparators();
        }
        return group2;
    }

    @NotNull
    public static Group createCorrectedGroup(@NotNull ActionGroup actionGroup2, @NotNull @NlsActions.ActionText String groupName, @NotNull List<? super String> path, @NotNull List<? extends ActionUrl> actionUrls) {
        if (actionGroup2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(3);
        }
        if (groupName == null) {
            ActionsTreeUtil.$$$reportNull$$$0(4);
        }
        if (path == null) {
            ActionsTreeUtil.$$$reportNull$$$0(5);
        }
        if (actionUrls == null) {
            ActionsTreeUtil.$$$reportNull$$$0(6);
        }
        path.add(groupName);
        ActionManager actionManager = ActionManager.getInstance();
        Group group2 = new Group(groupName, actionManager.getId((AnAction)actionGroup2), null);
        ArrayList children2 = ContainerUtil.newArrayList((Object[])ActionsTreeUtil.getActions(actionGroup2, actionManager));
        for (ActionUrl actionUrl : actionUrls) {
            AnAction anAction;
            AnAction componentAction;
            if (!path.equals(actionUrl.getGroupPath()) || (componentAction = actionUrl.getComponentAction()) == null) continue;
            if (actionUrl.getActionType() == 1) {
                if (children2.size() > actionUrl.getAbsolutePosition()) {
                    children2.add(actionUrl.getAbsolutePosition(), componentAction);
                    continue;
                }
                children2.add(componentAction);
                continue;
            }
            if (actionUrl.getActionType() != -1 || children2.size() <= actionUrl.getAbsolutePosition() || ((anAction = (AnAction)children2.get(actionUrl.getAbsolutePosition())).getTemplatePresentation().getText() == null ? componentAction.getTemplatePresentation().getText() != null && componentAction.getTemplatePresentation().getText().length() > 0 : !anAction.getTemplatePresentation().getText().equals(componentAction.getTemplatePresentation().getText()))) continue;
            children2.remove(actionUrl.getAbsolutePosition());
        }
        for (AnAction anAction : children2) {
            if (anAction instanceof ActionGroup) {
                group2.addGroup(ActionsTreeUtil.createCorrectedGroup((ActionGroup)anAction, ActionsTreeUtil.getName(anAction), path, actionUrls));
                continue;
            }
            if (anAction instanceof Separator) {
                group2.addSeparator();
                continue;
            }
            String id2 = anAction instanceof ActionStub ? ((ActionStub)anAction).getId() : actionManager.getId(anAction);
            if (id2 == null) continue;
            group2.addActionId(id2);
        }
        path.remove(path.size() - 1);
        Group group3 = group2;
        if (group3 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(7);
        }
        return group3;
    }

    private static Group createEditorActionsGroup(Condition<? super AnAction> filtered2) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup editorGroup = (DefaultActionGroup)actionManager.getActionOrStub("EditorActions");
        ArrayList ids = new ArrayList();
        ActionsTreeUtil.addEditorActions(filtered2, editorGroup, ids);
        Collections.sort(ids);
        Group group2 = new Group(KeyMapBundle.message((String)"editor.actions.group.title", (Object[])new Object[0]), "EditorActions", AllIcons.Nodes.KeymapEditor);
        for (String id2 : ids) {
            group2.addActionId(id2);
        }
        return group2;
    }

    @Nullable
    private static String getActionBinding(Keymap keymap2, String id2) {
        if (keymap2 == null) {
            return null;
        }
        Keymap parent = keymap2.getParent();
        String result2 = KeymapManagerEx.getInstanceEx().getActionBinding(id2);
        if (result2 == null && parent != null) {
            result2 = KeymapManagerEx.getInstanceEx().getActionBinding(id2);
        }
        return result2;
    }

    private static void addEditorActions(Condition<? super AnAction> filtered2, DefaultActionGroup editorGroup, ArrayList<? super String> ids) {
        AnAction[] editorActions = editorGroup.getChildActionsOrStubs();
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction editorAction : editorActions) {
            String actionId;
            if (editorAction instanceof DefaultActionGroup) {
                ActionsTreeUtil.addEditorActions(filtered2, (DefaultActionGroup)editorAction, ids);
                continue;
            }
            String string = actionId = editorAction instanceof ActionStub ? ((ActionStub)editorAction).getId() : actionManager.getId(editorAction);
            if (actionId == null || filtered2 != null && !filtered2.value((Object)editorAction)) continue;
            ids.add(actionId);
        }
    }

    private static Group createExtensionGroup(Condition<? super AnAction> filtered2, Project project, KeymapExtension provider2) {
        return (Group)provider2.createGroup(filtered2, project);
    }

    private static Group createMacrosGroup(Condition<? super AnAction> filtered2) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        List ids = actionManager.getActionIdList("Macro.");
        ids.sort(null);
        Group group2 = new Group(KeyMapBundle.message((String)"macros.group.title", (Object[])new Object[0]), null, null);
        for (String id2 : ids) {
            if (filtered2 != null && !filtered2.value((Object)actionManager.getActionOrStub(id2))) continue;
            group2.addActionId(id2);
        }
        return group2;
    }

    private static Group createQuickListsGroup(Condition<? super AnAction> filtered2, String filter, boolean forceFiltering, QuickList[] quickLists) {
        Arrays.sort(quickLists, Comparator.comparing(QuickList::getActionId));
        Group group2 = new Group(KeyMapBundle.message((String)"quick.lists.group.title", (Object[])new Object[0]), null, null);
        for (QuickList quickList : quickLists) {
            if ((filtered2 == null || !filtered2.value((Object)ActionManagerEx.getInstanceEx().getAction(quickList.getActionId()))) && !SearchUtil.isComponentHighlighted(quickList.getName(), filter, forceFiltering, null) && (filtered2 != null || !StringUtil.isEmpty((String)filter))) continue;
            group2.addQuickList(quickList);
        }
        return group2;
    }

    @NotNull
    private static Group createOtherGroup(@Nullable Condition<? super AnAction> filtered2, Group addedActions, @Nullable Keymap keymap2) {
        addedActions.initIds();
        Set result2 = CollectionFactory.createSmallMemoryFootprintSet();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        if (keymap2 != null) {
            for (Object id3 : keymap2.getActionIdList()) {
                if (((String)id3).startsWith(EDITOR_PREFIX) && actionManager.getActionOrStub("$" + ((String)id3).substring(6)) != null || ((String)id3).startsWith("QuickList.") || addedActions.containsId((String)id3)) continue;
                result2.add(id3);
            }
        }
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        for (String id4 : actionManager.getActionIdList("")) {
            AnAction actionOrStub = actionManager.getActionOrStub(id4);
            if (actionOrStub instanceof ActionGroup && !((ActionGroup)actionOrStub).canBePerformed(DataManager.getInstance().getDataContext()) || id4.startsWith("QuickList.") || addedActions.containsId(id4) || result2.contains(id4) || keymapManager2.getBoundActions().contains(id4)) continue;
            result2.add(id4);
        }
        ActionsTreeUtil.filterOtherActionsGroup(result2);
        Group group2 = new Group(KeyMapBundle.message((String)"other.group.title", (Object[])new Object[0]), AllIcons.Nodes.KeymapOther);
        AnAction[] groupedActions = ActionsTreeUtil.getActions("Other.KeymapGroup");
        for (AnAction action2 : groupedActions) {
            ActionsTreeUtil.addAction(group2, action2, (ActionManager)actionManager, filtered2, false);
        }
        result2.removeAll(group2.initIds());
        for (String id5 : ContainerUtil.sorted((Collection)result2, (id1, id2) -> ActionsTreeUtil.getTextToCompare(id1).compareToIgnoreCase(ActionsTreeUtil.getTextToCompare(id2)))) {
            if (filtered2 != null && !filtered2.value((Object)actionManager.getActionOrStub(id5))) continue;
            group2.addActionId(id5);
        }
        Group group3 = group2;
        if (group3 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(8);
        }
        return group3;
    }

    private static String getTextToCompare(String id2) {
        AnAction action2 = ActionManager.getInstance().getActionOrStub(id2);
        if (action2 == null) {
            return id2;
        }
        String text2 = action2.getTemplatePresentation().getText();
        return text2 != null ? text2 : id2;
    }

    private static void filterOtherActionsGroup(Set<String> actions) {
        ActionsTreeUtil.filterOutGroup(actions, "GenerateGroup");
        ActionsTreeUtil.filterOutGroup(actions, "NewGroup");
        ActionsTreeUtil.filterOutGroup(actions, "ChangeScheme");
    }

    private static void filterOutGroup(Set<String> actions, String groupId2) {
        if (groupId2 == null) {
            throw new IllegalArgumentException();
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getActionOrStub(groupId2);
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group2 = (DefaultActionGroup)action2;
            for (AnAction child2 : children2 = group2.getChildActionsOrStubs()) {
                String childId;
                String string = childId = child2 instanceof ActionStub ? ((ActionStub)child2).getId() : actionManager.getId(child2);
                if (childId == null) continue;
                if (child2 instanceof DefaultActionGroup) {
                    ActionsTreeUtil.filterOutGroup(actions, childId);
                    continue;
                }
                actions.remove(childId);
            }
        }
    }

    public static DefaultMutableTreeNode createNode(Group group2) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(group2);
        for (Object child2 : group2.getChildren()) {
            if (child2 instanceof Group) {
                DefaultMutableTreeNode childNode = ActionsTreeUtil.createNode((Group)child2);
                node.add(childNode);
                continue;
            }
            LOG.assertTrue(child2 != null);
            node.add(new DefaultMutableTreeNode(child2));
        }
        return node;
    }

    public static Group createMainGroup(Project project, Keymap keymap2, QuickList[] quickLists) {
        return ActionsTreeUtil.createMainGroup(project, keymap2, quickLists, null, false, null);
    }

    public static Group createMainGroup(Project project, Keymap keymap2, QuickList[] quickLists, String filter, boolean forceFiltering, Condition<? super AnAction> filtered2) {
        Condition<AnAction> wrappedFilter = ActionsTreeUtil.wrapFilter(filtered2, keymap2, ActionManager.getInstance());
        Group mainGroup = new Group(KeyMapBundle.message((String)"all.actions.group.title", (Object[])new Object[0]), null, null);
        mainGroup.addGroup(ActionsTreeUtil.createEditorActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createMainMenuGroup(wrappedFilter));
        for (KeymapExtension extension2 : KeymapExtension.EXTENSION_POINT_NAME.getExtensionList()) {
            Group group2 = ActionsTreeUtil.createExtensionGroup(wrappedFilter, project, extension2);
            if (group2 == null) continue;
            mainGroup.addGroup(group2);
        }
        mainGroup.addGroup(ActionsTreeUtil.createMacrosGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createQuickListsGroup(wrappedFilter, filter, forceFiltering, quickLists));
        mainGroup.addGroup(ActionsTreeUtil.createPluginsActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createOtherGroup(wrappedFilter, mainGroup, keymap2));
        if (!StringUtil.isEmpty((String)filter) || filtered2 != null) {
            ArrayList<Object> list2 = mainGroup.getChildren();
            Iterator<Object> i2 = list2.iterator();
            while (i2.hasNext()) {
                Group group3;
                Object o = i2.next();
                if (!(o instanceof Group) || (group3 = (Group)o).getSize() != 0 || SearchUtil.isComponentHighlighted(group3.getName(), filter, forceFiltering, null)) continue;
                i2.remove();
            }
        }
        return mainGroup;
    }

    private static Condition<AnAction> isActionFiltered(String filter, boolean force) {
        return action2 -> {
            String id2;
            if (filter == null) {
                return true;
            }
            if (action2 == null) {
                return false;
            }
            action2 = ActionsTreeUtil.tryUnstubAction(action2);
            String insensitiveFilter = StringUtil.toLowerCase((String)filter);
            ArrayList<String> options2 = new ArrayList<String>();
            options2.add(action2.getTemplatePresentation().getText());
            options2.add(action2.getTemplatePresentation().getDescription());
            for (Supplier synonym : action2.getSynonyms()) {
                options2.add((String)synonym.get());
            }
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
            if (id2 != null) {
                options2.add(id2);
                options2.addAll(AbbreviationManager.getInstance().getAbbreviations(id2));
            }
            for (String text2 : options2) {
                String lowerText;
                if (text2 == null || !SearchUtil.isComponentHighlighted(lowerText = StringUtil.toLowerCase((String)text2), insensitiveFilter, force, null) && !lowerText.contains(insensitiveFilter)) continue;
                return true;
            }
            return false;
        };
    }

    private static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Shortcut shortcut) {
        return ActionsTreeUtil.isActionFiltered(actionManager, keymap2, (Condition<? super Shortcut>)((Condition)sc -> sc != null && sc.startsWith(shortcut)));
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Condition<? super Shortcut> predicat) {
        return action2 -> {
            Shortcut[] actionShortcuts;
            if (action2 == null) {
                return false;
            }
            for (Shortcut actionShortcut : actionShortcuts = keymap2.getShortcuts(action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2))) {
                if (!predicat.value((Object)actionShortcut)) continue;
                return true;
            }
            return false;
        };
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Shortcut shortcut, String filter, boolean force) {
        return filter != null && filter.length() > 0 ? ActionsTreeUtil.isActionFiltered(filter, force) : (shortcut != null ? ActionsTreeUtil.isActionFiltered(actionManager, keymap2, shortcut) : null);
    }

    public static void addAction(KeymapGroup group2, AnAction action2, Condition<? super AnAction> filtered2) {
        ActionsTreeUtil.addAction(group2, action2, filtered2, false);
    }

    public static void addAction(KeymapGroup group2, AnAction action2, Condition<? super AnAction> filtered2, boolean forceNonPopup) {
        ActionsTreeUtil.addAction(group2, action2, ActionManager.getInstance(), filtered2, forceNonPopup);
    }

    private static void addAction(KeymapGroup group2, AnAction action2, ActionManager actionManager, Condition<? super AnAction> filtered2, boolean forceNonPopup) {
        if (action2 instanceof ActionGroup) {
            if (forceNonPopup) {
                AnAction[] actions;
                for (AnAction childAction : actions = ActionsTreeUtil.getActions((ActionGroup)action2, actionManager)) {
                    ActionsTreeUtil.addAction(group2, childAction, actionManager, filtered2, true);
                }
            } else {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered2);
                if (subGroup.getSize() > 0) {
                    group2.addGroup((KeymapGroup)subGroup);
                }
            }
        } else if (action2 instanceof Separator) {
            if (group2 instanceof Group) {
                ((Group)group2).addSeparator();
            }
        } else if (filtered2 == null || filtered2.value((Object)action2)) {
            String id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            group2.addActionId(id2);
        }
    }

    public static AnAction @NotNull [] getActions(@NonNls String actionGroup2) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction group2 = actionManager.getActionOrStub(actionGroup2);
        LOG.assertTrue(group2 instanceof ActionGroup, (Object)(actionGroup2 + " is " + (group2 == null ? "not found" : "not a group")));
        return ActionsTreeUtil.getActions((ActionGroup)group2, actionManager);
    }

    private static AnAction @NotNull [] getActions(@NotNull ActionGroup group2, @NotNull ActionManager actionManager) {
        if (group2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(9);
        }
        if (actionManager == null) {
            ActionsTreeUtil.$$$reportNull$$$0(10);
        }
        ActionGroup adjusted = group2 instanceof ActionGroupStub ? (ActionGroup)actionManager.getAction(((ActionGroupStub)group2).getId()) : group2;
        AnAction[] anActionArray = adjusted instanceof DefaultActionGroup ? ((DefaultActionGroup)adjusted).getChildActionsOrStubs() : adjusted.getChildren(null);
        if (anActionArray == null) {
            ActionsTreeUtil.$$$reportNull$$$0(11);
        }
        return anActionArray;
    }

    @NotNull
    private static AnAction tryUnstubAction(@NotNull AnAction action2) {
        AnAction newAction;
        if (action2 == null) {
            ActionsTreeUtil.$$$reportNull$$$0(12);
        }
        if (action2 instanceof ActionStub && (newAction = ActionManager.getInstance().getActionOrStub(((ActionStub)action2).getId())) != null) {
            AnAction anAction = newAction;
            if (anAction == null) {
                ActionsTreeUtil.$$$reportNull$$$0(13);
            }
            return anAction;
        }
        AnAction anAction = action2;
        if (anAction == null) {
            ActionsTreeUtil.$$$reportNull$$$0(14);
        }
        return anAction;
    }

    @Nls
    public static String getMainMenuTitle() {
        return KeyMapBundle.message((String)"main.menu.action.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getMainToolbar() {
        return KeyMapBundle.message((String)"main.toolbar.title", (Object[])new Object[0]);
    }

    public static String getExperimentalToolbar() {
        return KeyMapBundle.message((String)"experimental.toolbar.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorPopup() {
        return KeyMapBundle.message((String)"editor.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorGutterPopupMenu() {
        return KeyMapBundle.message((String)"editor.gutter.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getScopeViewPopupMenu() {
        return KeyMapBundle.message((String)"scope.view.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getNavigationBarPopupMenu() {
        return KeyMapBundle.message((String)"navigation.bar.popup.menu", (Object[])new Object[0]);
    }

    @Nls
    public static String getNavigationBarToolbar() {
        return KeyMapBundle.message((String)"navigation.bar.toolbar", (Object[])new Object[0]);
    }

    @Nls
    public static String getEditorTabPopup() {
        return KeyMapBundle.message((String)"editor.tab.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getFavoritesPopup() {
        return KeyMapBundle.message((String)"favorites.popup.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getProjectViewPopup() {
        return KeyMapBundle.message((String)"project.view.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getCommanderPopup() {
        return KeyMapBundle.message((String)"commender.view.popup.menu.title", (Object[])new Object[0]);
    }

    @Nls
    public static String getJ2EEPopup() {
        return KeyMapBundle.message((String)"j2ee.view.popup.menu.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionUrls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginActionsMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginsActionsGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapFilter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTreeUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCorrectedGroup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOtherGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "tryUnstubAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCorrectedGroup";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryUnstubAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

