/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.keymap.impl.ui.Hyperlink;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsTree {
    private static final Icon EMPTY_ICON = EmptyIcon.ICON_18;
    private static final Icon CLOSE_ICON = AllIcons.Nodes.Folder;
    private final JTree myTree;
    private DefaultMutableTreeNode myRoot;
    private final JScrollPane myComponent;
    private Keymap myKeymap;
    private Group myMainGroup = new Group("", null, null);
    private final boolean myShowBoundActions = Registry.is((String)"keymap.show.alias.actions");
    @NonNls
    private static final String ROOT = "ROOT";
    private String myFilter = null;
    private Condition<? super AnAction> myBaseFilter;
    private final Map<String, String> myPluginNames = ActionsTreeUtil.createPluginActionsMap();

    public ActionsTree() {
        this.myRoot = new DefaultMutableTreeNode(ROOT);
        this.myTree = new Tree(new MyModel(this.myRoot)){

            public void paint(Graphics g) {
                super.paint(g);
                Rectangle visibleRect = this.getVisibleRect();
                Insets insets = this.getInsets();
                if (insets != null && insets.right > 0) {
                    visibleRect.width -= JBUIScale.scale((int)9);
                }
                Rectangle clip = g.getClipBounds();
                for (int row = 0; row < this.getRowCount(); ++row) {
                    Object data2;
                    Object node;
                    Rectangle rowBounds = this.getRowBounds(row);
                    rowBounds.x = 0;
                    rowBounds.width = Integer.MAX_VALUE;
                    if (!rowBounds.intersects(clip) || !((node = this.getPathForRow(row).getLastPathComponent()) instanceof DefaultMutableTreeNode) || (data2 = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Hyperlink) continue;
                    Rectangle fullRowRect = new Rectangle(visibleRect.x, rowBounds.y, visibleRect.width, rowBounds.height);
                    ActionsTree.this.paintRowData(this, data2, fullRowRect, (Graphics2D)g);
                }
            }

            public String convertValueToText(Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value2 instanceof DefaultMutableTreeNode) {
                    String path = ActionsTree.this.getPath((DefaultMutableTreeNode)value2);
                    return StringUtil.notNullize((String)path);
                }
                return super.convertValueToText(value2, selected2, expanded, leaf, row, hasFocus);
            }
        };
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.putClientProperty("mac.ui.striped", Boolean.TRUE);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new KeymapsRenderer()));
        new TreeLinkMouseListener(new KeymapsRenderer()){

            @Override
            protected boolean doCacheLastNode() {
                return false;
            }

            protected void handleTagClick(@Nullable Object tag2, @NotNull MouseEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (tag2 instanceof Hyperlink) {
                    ((Hyperlink)tag2).onClick(event);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/keymap/impl/ui/ActionsTree$2", "handleTagClick"));
            }
        }.installOn(this.myTree);
        this.myTree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                String description = this.getDescription(e);
                ActionMenu.showDescriptionInStatusBar(description != null, ActionsTree.this.myTree, description);
            }

            @Nullable
            @NlsActions.ActionDescription
            private String getDescription(@NotNull MouseEvent e) {
                Object userObject;
                TreePath path;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DefaultMutableTreeNode node = (path = ActionsTree.this.myTree.getPathForLocation(e.getX(), e.getY())) == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = userObject = node == null ? null : node.getUserObject();
                if (!(userObject instanceof String)) {
                    return null;
                }
                AnAction action2 = ActionManager.getInstance().getActionOrStub((String)userObject);
                return action2 == null ? null : action2.getTemplatePresentation().getDescription();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/keymap/impl/ui/ActionsTree$3", "getDescription"));
            }
        });
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myComponent = ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)22, (int)31);
    }

    void setKeymap(@NotNull Keymap keymap2) {
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(0);
        }
        this.myKeymap = keymap2;
    }

    public void setBaseFilter(@Nullable Condition<? super AnAction> baseFilter) {
        this.myBaseFilter = baseFilter;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public void addTreeSelectionListener(TreeSelectionListener l) {
        this.myTree.getSelectionModel().addTreeSelectionListener(l);
    }

    @Nullable
    private Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        return ((DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject();
    }

    @Nullable
    public String getSelectedActionId() {
        Object userObject = this.getSelectedObject();
        if (userObject instanceof String) {
            return (String)userObject;
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)userObject).getActionId();
        }
        if (userObject instanceof Group) {
            return ((Group)userObject).getId();
        }
        return null;
    }

    public void reset(@NotNull Keymap keymap2, QuickList @NotNull [] allQuickLists) {
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(1);
        }
        if (allQuickLists == null) {
            ActionsTree.$$$reportNull$$$0(2);
        }
        this.reset(keymap2, allQuickLists, this.myFilter, null);
    }

    public Group getMainGroup() {
        return this.myMainGroup;
    }

    public JTree getTree() {
        return this.myTree;
    }

    public void filter(String filter, QuickList[] currentQuickListIds) {
        this.myFilter = filter;
        this.reset(this.myKeymap, currentQuickListIds, filter, null);
    }

    @Nullable
    private Condition<? super AnAction> combineWithBaseFilter(@Nullable Condition<? super AnAction> actionFilter) {
        if (actionFilter != null) {
            return this.myBaseFilter != null ? Conditions.and(this.myBaseFilter, actionFilter) : actionFilter;
        }
        return this.myBaseFilter;
    }

    private void reset(@NotNull Keymap keymap2, QuickList @NotNull [] allQuickLists, String filter, @Nullable Shortcut shortcut) {
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(3);
        }
        if (allQuickLists == null) {
            ActionsTree.$$$reportNull$$$0(4);
        }
        this.myKeymap = keymap2;
        PathsKeeper pathsKeeper = new PathsKeeper();
        pathsKeeper.storePaths();
        this.myRoot.removeAllChildren();
        ActionManager actionManager = ActionManager.getInstance();
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myComponent));
        Condition<? super AnAction> condFilter = this.combineWithBaseFilter(ActionsTreeUtil.isActionFiltered(actionManager, keymap2, shortcut, filter, true));
        Group mainGroup = ActionsTreeUtil.createMainGroup(project, keymap2, allQuickLists, filter, true, condFilter);
        if ((filter != null && filter.length() > 0 || shortcut != null) && mainGroup.initIds().isEmpty()) {
            condFilter = this.combineWithBaseFilter(ActionsTreeUtil.isActionFiltered(actionManager, keymap2, shortcut, filter, false));
            mainGroup = ActionsTreeUtil.createMainGroup(project, keymap2, allQuickLists, filter, false, condFilter);
        }
        this.myRoot = ActionsTreeUtil.createNode(mainGroup);
        this.myMainGroup = mainGroup;
        MyModel model2 = (MyModel)this.myTree.getModel();
        model2.setRoot(this.myRoot);
        model2.nodeStructureChanged(this.myRoot);
        pathsKeeper.restorePaths();
        this.getComponent().repaint();
    }

    public void filterTree(Shortcut shortcut, QuickList[] currentQuickListIds) {
        this.reset(this.myKeymap, currentQuickListIds, this.myFilter, shortcut);
    }

    public static boolean isShortcutCustomized(@NotNull String actionId, @NotNull Keymap keymap2) {
        if (actionId == null) {
            ActionsTree.$$$reportNull$$$0(5);
        }
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(6);
        }
        if (!keymap2.canModify()) {
            return false;
        }
        Keymap parent = keymap2.getParent();
        return parent != null && !Arrays.equals(parent.getShortcuts(actionId), keymap2.getShortcuts(actionId));
    }

    private static boolean areGroupShortcutsCustomized(@NotNull Group group2, @NotNull Keymap keymap2) {
        if (group2 == null) {
            ActionsTree.$$$reportNull$$$0(7);
        }
        if (keymap2 == null) {
            ActionsTree.$$$reportNull$$$0(8);
        }
        if (!keymap2.canModify()) {
            return false;
        }
        ArrayList<Object> children2 = group2.getChildren();
        for (Object child2 : children2) {
            String actionId;
            if (!(child2 instanceof Group ? ActionsTree.areGroupShortcutsCustomized((Group)child2, keymap2) : (child2 instanceof String ? ActionsTree.isShortcutCustomized(actionId = (String)child2, keymap2) : child2 instanceof QuickList && ActionsTree.isShortcutCustomized(actionId = ((QuickList)child2).getActionId(), keymap2)))) continue;
            return true;
        }
        return group2.getId() != null && ActionsTree.isShortcutCustomized(group2.getId(), keymap2);
    }

    public void selectAction(String actionId) {
        String boundId;
        String path = this.myMainGroup.getActionQualifiedPath(actionId);
        String string = boundId = path == null ? KeymapManagerEx.getInstanceEx().getActionBinding(actionId) : null;
        if (path == null && boundId != null && (path = this.myMainGroup.getActionQualifiedPath(boundId)) == null) {
            return;
        }
        DefaultMutableTreeNode node = this.getNodeForPath(path);
        if (node == null) {
            return;
        }
        TreeUtil.selectInTree((DefaultMutableTreeNode)node, (boolean)true, (JTree)this.myTree);
    }

    @Nullable
    private DefaultMutableTreeNode getNodeForPath(String path) {
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!Objects.equals(this.getPath(node), path)) continue;
            return node;
        }
        return null;
    }

    private List<DefaultMutableTreeNode> getNodesByPaths(List<String> paths) {
        SmartList result2 = new SmartList();
        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.myTree.getModel().getRoot()).preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            String path = this.getPath(node);
            if (!paths.contains(path)) continue;
            result2.add(node);
        }
        return result2;
    }

    @Nullable
    private String getPath(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof String) {
            Object object;
            String actionId = (String)userObject;
            TreeNode parent = node.getParent();
            if (parent instanceof DefaultMutableTreeNode && (object = ((DefaultMutableTreeNode)parent).getUserObject()) instanceof Group) {
                return ((Group)object).getActionQualifiedPath(actionId);
            }
            return this.myMainGroup.getActionQualifiedPath(actionId);
        }
        if (userObject instanceof Group) {
            return ((Group)userObject).getQualifiedPath();
        }
        if (userObject instanceof QuickList) {
            return ((QuickList)userObject).getName();
        }
        return null;
    }

    public static Icon getEvenIcon(Icon icon2) {
        LayeredIcon layeredIcon = new LayeredIcon(2);
        layeredIcon.setIcon(EMPTY_ICON, 0);
        if (icon2 != null && icon2.getIconHeight() <= EMPTY_ICON.getIconHeight() && icon2.getIconWidth() <= EMPTY_ICON.getIconWidth()) {
            layeredIcon.setIcon(icon2, 1, (-icon2.getIconWidth() + EMPTY_ICON.getIconWidth()) / 2, (EMPTY_ICON.getIconHeight() - icon2.getIconHeight()) / 2);
        }
        return layeredIcon;
    }

    @NotNull
    private Pair<Shortcut[], Set<String>> extractRowData(Object data2) {
        if (data2 instanceof String) {
            String actionId = (String)data2;
            Pair pair = Pair.create((Object)this.myKeymap.getShortcuts(actionId), (Object)AbbreviationManager.getInstance().getAbbreviations(actionId));
            if (pair == null) {
                ActionsTree.$$$reportNull$$$0(9);
            }
            return pair;
        }
        Shortcut[] shortcuts = null;
        if (data2 instanceof QuickList) {
            shortcuts = this.myKeymap.getShortcuts(((QuickList)data2).getActionId());
        } else if (data2 instanceof Group) {
            shortcuts = this.myKeymap.getShortcuts(((Group)data2).getId());
        }
        Pair pair = Pair.create(shortcuts, null);
        if (pair == null) {
            ActionsTree.$$$reportNull$$$0(10);
        }
        return pair;
    }

    private void paintRowData(Tree tree, Object data2, Rectangle bounds2, Graphics2D g) {
        Color c2;
        Color c1;
        int fontHeight;
        Pair<Shortcut[], Set<String>> rowData = this.extractRowData(data2);
        Shortcut[] shortcuts = (Shortcut[])rowData.first;
        Set abbreviations = (Set)rowData.second;
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
        int totalWidth = 0;
        FontMetrics metrics = tree.getFontMetrics(tree.getFont());
        if (shortcuts != null && shortcuts.length > 0) {
            for (Shortcut shortcut : shortcuts) {
                totalWidth += metrics.stringWidth(KeymapUtil.getShortcutText((Shortcut)shortcut));
                totalWidth += 10;
            }
            int x = bounds2.x + bounds2.width - (totalWidth -= 5);
            fontHeight = (int)metrics.getMaxCharBounds(g).getHeight();
            c1 = new Color(234, 200, 162);
            c2 = new Color(208, 200, 66);
            g.translate(0, bounds2.y - 1);
            for (Shortcut shortcut : shortcuts) {
                int width = metrics.stringWidth(KeymapUtil.getShortcutText((Shortcut)shortcut));
                UIUtil.drawSearchMatch((Graphics2D)g, (float)x, (float)(x + width), (int)bounds2.height, (Color)c1, (Color)c2);
                g.setColor((Color)Gray._50);
                g.drawString(KeymapUtil.getShortcutText((Shortcut)shortcut), x, fontHeight);
                x += width;
                x += 10;
            }
            g.translate(0, -bounds2.y + 1);
        }
        if (Registry.is((String)"actionSystem.enableAbbreviations") && abbreviations != null && abbreviations.size() > 0) {
            for (String abbreviation : abbreviations) {
                totalWidth += metrics.stringWidth(abbreviation);
                totalWidth += 10;
            }
            int x = bounds2.x + bounds2.width - (totalWidth -= 5);
            fontHeight = (int)metrics.getMaxCharBounds(g).getHeight();
            c1 = new Color(206, 234, 176);
            c2 = new Color(126, 208, 82);
            g.translate(0, bounds2.y - 1);
            for (String abbreviation : abbreviations) {
                int width = metrics.stringWidth(abbreviation);
                UIUtil.drawSearchMatch((Graphics2D)g, (float)x, (float)(x + width), (int)bounds2.height, (Color)c1, (Color)c2);
                g.setColor((Color)Gray._50);
                g.drawString(abbreviation, x, fontHeight);
                x += width;
                x += 10;
            }
            g.translate(0, -bounds2.y + 1);
        }
        config2.restore();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymap";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allQuickLists";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ActionsTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTree";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRowData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setKeymap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isShortcutCustomized";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areGroupShortcutsCustomized";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyColoredTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private int myHeight;

        private MyColoredTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyColoredTreeCellRenderer.$$$reportNull$$$0(0);
            }
        }

        protected void doPaint(Graphics2D g) {
            super.doPaint(g);
        }

        public void setHeight(int height) {
            this.myHeight = height;
        }

        public int getHeight() {
            return this.myHeight;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/keymap/impl/ui/ActionsTree$MyColoredTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private class KeymapsRenderer
    extends ColoredTreeCellRenderer {
        private final MyColoredTreeCellRenderer myLink = new MyColoredTreeCellRenderer();
        private boolean myHaveLink;
        private int myLinkOffset;
        private int myLinkWidth;
        private int myRow;

        private KeymapsRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                KeymapsRenderer.$$$reportNull$$$0(0);
            }
            this.myRow = row;
            this.myHaveLink = false;
            this.myLink.getTreeCellRendererComponent(tree, value2, selected2, expanded, leaf, row, hasFocus);
            boolean showIcons = UISettings.getInstance().getShowIconsInMenus();
            Icon icon2 = null;
            String actionId = null;
            boolean bound = false;
            this.setToolTipText(null);
            if (value2 instanceof DefaultMutableTreeNode) {
                Color foreground;
                boolean changed2;
                String text2;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
                Object userObject = node.getUserObject();
                if (userObject instanceof Group) {
                    Group group2 = (Group)userObject;
                    actionId = group2.getId();
                    text2 = group2.getName();
                    changed2 = ActionsTree.this.myKeymap != null && ActionsTree.areGroupShortcutsCustomized(group2, ActionsTree.this.myKeymap);
                    icon2 = group2.getIcon();
                    if (icon2 == null) {
                        icon2 = CLOSE_ICON;
                    }
                } else if (userObject instanceof String) {
                    actionId = (String)userObject;
                    bound = ActionsTree.this.myShowBoundActions && ((KeymapImpl)ActionsTree.this.myKeymap).isActionBound(actionId);
                    AnAction action2 = ActionManager.getInstance().getAction(actionId);
                    if (action2 != null) {
                        Icon actionIcon;
                        text2 = action2.getTemplatePresentation().getText();
                        if (text2 == null || text2.length() == 0) {
                            text2 = actionId;
                        }
                        if ((actionIcon = action2.getTemplatePresentation().getIcon()) != null) {
                            icon2 = actionIcon;
                        }
                        this.setToolTipText(action2.getTemplatePresentation().getDescription());
                    } else {
                        text2 = actionId;
                    }
                    changed2 = ActionsTree.this.myKeymap != null && ActionsTree.isShortcutCustomized(actionId, ActionsTree.this.myKeymap);
                } else if (userObject instanceof QuickList) {
                    QuickList list2 = (QuickList)userObject;
                    icon2 = null;
                    text2 = list2.getName();
                    changed2 = ActionsTree.this.myKeymap != null && ActionsTree.isShortcutCustomized(list2.getActionId(), ActionsTree.this.myKeymap);
                } else if (userObject instanceof Separator) {
                    changed2 = false;
                    text2 = "-------------";
                } else if (userObject instanceof Hyperlink) {
                    this.getIpad().right = 0;
                    this.myLink.getIpad().left = 0;
                    this.myHaveLink = true;
                    Hyperlink link2 = (Hyperlink)userObject;
                    changed2 = false;
                    text2 = "";
                    this.append(link2.getLinkText(), link2.getTextAttributes(), link2);
                    icon2 = link2.getIcon();
                    this.setIcon(ActionsTree.getEvenIcon(link2.getIcon()));
                    Rectangle treeVisibleRect = tree.getVisibleRect();
                    int rowX = TreeUtil.getNodeRowX((JTree)tree, (int)row);
                    this.setupLinkDimensions(treeVisibleRect, rowX);
                } else {
                    throw new IllegalArgumentException("unknown userObject: " + userObject);
                }
                if (showIcons) {
                    this.setIcon(ActionsTree.getEvenIcon(icon2));
                }
                if (selected2) {
                    foreground = UIUtil.getTreeForeground((boolean)true, (boolean)hasFocus);
                } else {
                    foreground = changed2 ? PlatformColors.BLUE : UIUtil.getTreeForeground();
                    if (bound) {
                        foreground = JBColor.MAGENTA;
                    }
                }
                if (!this.myHaveLink) {
                    Color background = UIUtil.getTreeBackground((boolean)selected2, (boolean)true);
                    SearchUtil.appendFragments(ActionsTree.this.myFilter, text2, 0, foreground, background, (SimpleColoredComponent)this);
                    if (actionId != null && UISettings.getInstance().getShowInplaceCommentsInternal()) {
                        Group parentGroup;
                        @NlsSafe String pluginName = ActionsTree.this.myPluginNames.get(actionId);
                        if (pluginName != null && pluginName.equals((parentGroup = (Group)((DefaultMutableTreeNode)node.getParent()).getUserObject()).getName())) {
                            pluginName = null;
                        }
                        this.append("   ");
                        this.append((String)(pluginName != null ? actionId + " (" + pluginName + ")" : actionId), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                    }
                }
            }
            this.putClientProperty(ExpandableItemsHandler.RENDERER_DISABLED, this.myHaveLink);
        }

        private void setupLinkDimensions(Rectangle treeVisibleRect, int rowX) {
            Dimension linkSize = this.myLink.getPreferredSize();
            this.myLinkWidth = linkSize.width;
            this.myLinkOffset = Math.min(super.getPreferredSize().width - 1, treeVisibleRect.x + treeVisibleRect.width - this.myLinkWidth - rowX);
        }

        public void append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes, Object tag2) {
            if (fragment == null) {
                KeymapsRenderer.$$$reportNull$$$0(1);
            }
            if (attributes == null) {
                KeymapsRenderer.$$$reportNull$$$0(2);
            }
            if (tag2 instanceof Hyperlink) {
                this.myHaveLink = true;
                this.myLink.append(fragment, attributes, tag2);
            } else {
                super.append(fragment, attributes, tag2);
            }
        }

        protected void doPaint(Graphics2D g) {
            if (!this.myHaveLink) {
                super.doPaint(g);
            }
            UIUtil.useSafely((Graphics)g.create(0, 0, this.myLinkOffset, g.getClipBounds().height), textGraphics -> super.doPaint(textGraphics));
            g.translate(this.myLinkOffset, 0);
            this.myLink.setHeight(this.getHeight());
            this.myLink.doPaint(g);
            g.translate(-this.myLinkOffset, 0);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (this.myHaveLink) {
                size.width += this.myLinkWidth;
            }
            Dimension dimension = size;
            if (dimension == null) {
                KeymapsRenderer.$$$reportNull$$$0(3);
            }
            return dimension;
        }

        @Nullable
        public Object getFragmentTagAt(int x) {
            if (this.myHaveLink) {
                return this.myLink.getFragmentTagAt(x - this.myLinkOffset);
            }
            return super.getFragmentTagAt(x);
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleKeymapsRenderer();
            }
            return this.accessibleContext;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/keymap/impl/ui/ActionsTree$KeymapsRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/keymap/impl/ui/ActionsTree$KeymapsRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "append";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        protected class AccessibleKeymapsRenderer
        extends ColoredTreeCellRenderer.AccessibleColoredTreeCellRenderer {
            protected AccessibleKeymapsRenderer() {
                super((ColoredTreeCellRenderer)KeymapsRenderer.this);
            }

            public String getAccessibleName() {
                Object data2;
                String name = super.getAccessibleName();
                @NlsSafe String shortcutName = null;
                TreePath path = KeymapsRenderer.this.myTree.getPathForRow(KeymapsRenderer.this.myRow);
                if (path == null) {
                    return KeyMapBundle.message((String)"accessible.name.unknown", (Object[])new Object[0]);
                }
                Object node = path.getLastPathComponent();
                if (node instanceof DefaultMutableTreeNode && !((data2 = ((DefaultMutableTreeNode)node).getUserObject()) instanceof Hyperlink)) {
                    Pair<Shortcut[], Set<String>> rowData = ActionsTree.this.extractRowData(data2);
                    Shortcut[] shortcuts = (Shortcut[])rowData.first;
                    if (shortcuts != null && shortcuts.length > 0) {
                        StringBuilder sb = new StringBuilder();
                        for (Shortcut shortcut : shortcuts) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(KeyMapBundle.message((String)"accessible.name.shortcut", (Object[])new Object[0]));
                            sb.append(KeymapUtil.getShortcutText((Shortcut)shortcut));
                        }
                        if (sb.length() > 0) {
                            shortcutName = sb.toString();
                        }
                    }
                }
                return AccessibleContextUtil.combineAccessibleStrings((String)name, (String)", ", shortcutName);
            }
        }
    }

    private class PathsKeeper {
        private ArrayList<String> myPathsToExpand;
        private ArrayList<String> mySelectionPaths;

        private PathsKeeper() {
        }

        public void storePaths() {
            this.myPathsToExpand = new ArrayList();
            this.mySelectionPaths = new ArrayList();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)ActionsTree.this.myTree.getModel().getRoot();
            TreePath path = new TreePath(root.getPath());
            if (ActionsTree.this.myTree.isPathSelected(path)) {
                this.addPathToList(root, this.mySelectionPaths);
            }
            if (ActionsTree.this.myTree.isExpanded(path) || root.getChildCount() == 0) {
                this.addPathToList(root, this.myPathsToExpand);
                this._storePaths(root);
            }
        }

        private void addPathToList(DefaultMutableTreeNode root, ArrayList<? super String> list2) {
            String path = ActionsTree.this.getPath(root);
            if (!StringUtil.isEmpty((String)path)) {
                list2.add(path);
            }
        }

        private void _storePaths(DefaultMutableTreeNode root) {
            ArrayList<TreeNode> childNodes = this.childrenToArray(root);
            for (TreeNode childNode1 : childNodes) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)childNode1;
                TreePath path = new TreePath(childNode.getPath());
                if (ActionsTree.this.myTree.isPathSelected(path)) {
                    this.addPathToList(childNode, this.mySelectionPaths);
                }
                if (!ActionsTree.this.myTree.isExpanded(path) && childNode.getChildCount() != 0 || childNode.isLeaf()) continue;
                this.addPathToList(childNode, this.myPathsToExpand);
                this._storePaths(childNode);
            }
        }

        public void restorePaths() {
            for (DefaultMutableTreeNode node : ActionsTree.this.getNodesByPaths(this.myPathsToExpand)) {
                ActionsTree.this.myTree.expandPath(new TreePath(node.getPath()));
            }
            if (ActionsTree.this.myTree.getSelectionModel().getSelectionCount() == 0) {
                List<DefaultMutableTreeNode> nodesToSelect = ActionsTree.this.getNodesByPaths(this.mySelectionPaths);
                if (!nodesToSelect.isEmpty()) {
                    for (DefaultMutableTreeNode node : nodesToSelect) {
                        TreeUtil.selectNode((JTree)ActionsTree.this.myTree, (TreeNode)node);
                    }
                } else {
                    ActionsTree.this.myTree.setSelectionRow(0);
                }
            }
        }

        private ArrayList<TreeNode> childrenToArray(DefaultMutableTreeNode node) {
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
                arrayList.add(node.getChildAt(i2));
            }
            return arrayList;
        }
    }

    private class MyModel
    extends DefaultTreeModel
    implements TreeTableModel {
        protected MyModel(DefaultMutableTreeNode root) {
            super(root);
        }

        public void setTree(JTree tree) {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return KeyMapBundle.message((String)"action.column.name", (Object[])new Object[0]);
                }
                case 1: {
                    return KeyMapBundle.message((String)"shortcuts.column.name", (Object[])new Object[0]);
                }
            }
            return "";
        }

        public Object getValueAt(Object value2, int column) {
            if (!(value2 instanceof DefaultMutableTreeNode)) {
                return "???";
            }
            if (column == 0) {
                return value2;
            }
            if (column == 1) {
                Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                if (userObject instanceof QuickList) {
                    userObject = ((QuickList)userObject).getActionId();
                }
                return userObject instanceof String ? KeymapUtil.getShortcutsText((Shortcut[])ActionsTree.this.myKeymap.getShortcuts((String)userObject)) : "";
            }
            return "???";
        }

        @Override
        public Object getChild(Object parent, int index2) {
            return ((TreeNode)parent).getChildAt(index2);
        }

        @Override
        public int getChildCount(Object parent) {
            return ((TreeNode)parent).getChildCount();
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return TreeTableModel.class;
            }
            return Object.class;
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public void setValueAt(Object aValue, Object node, int column) {
        }
    }
}

