/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.diagnostic.EventWatcher;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.KeyboardAwareFocusOwner;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ActionProcessor;
import com.intellij.openapi.keymap.impl.DumbModeWarningListener;
import com.intellij.openapi.keymap.impl.KeyProcessorContext;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.keymap.impl.SystemShortcuts;
import com.intellij.openapi.keymap.impl.keyGestures.KeyboardGestureProcessor;
import com.intellij.openapi.keymap.impl.ui.ShortcutTextField;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneEx;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ComponentWithMnemonics;
import com.intellij.ui.KeyStrokeAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.KeyboardLayoutUtil;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdeKeyEventDispatcher
implements Disposable {
    private static final Logger LOG = Logger.getInstance(IdeKeyEventDispatcher.class);
    private KeyStroke myFirstKeyStroke;
    private boolean myPressedWasProcessed;
    private boolean myIgnoreNextKeyTypedEvent;
    private KeyState myState = KeyState.STATE_INIT;
    private final PresentationFactory myPresentationFactory = new PresentationFactory();
    private boolean myDisposed;
    private boolean myLeftCtrlPressed;
    private boolean myRightAltPressed;
    private final KeyboardGestureProcessor myKeyGestureProcessor = new KeyboardGestureProcessor(this);
    private final KeyProcessorContext myContext = new KeyProcessorContext();
    private final IdeEventQueue myQueue;
    private final Alarm mySecondStrokeTimeout = new Alarm();
    private final Runnable mySecondStrokeTimeoutRunnable = () -> {
        if (this.myState == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
            this.resetState();
            DataContext dataContext = this.myContext.getDataContext();
            StatusBar.Info.set(null, dataContext == null ? null : (Project)CommonDataKeys.PROJECT.getData(dataContext));
        }
    };
    private final Alarm mySecondKeystrokePopupTimeout = new Alarm();
    private final ActionProcessor myActionProcessor = new ActionProcessor(){

        @Override
        @NotNull
        public AnActionEvent createEvent(InputEvent inputEvent, @NotNull DataContext context, @NotNull String place, @NotNull Presentation presentation2, @NotNull ActionManager manager2) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (place == null) {
                1.$$$reportNull$$$0(1);
            }
            if (presentation2 == null) {
                1.$$$reportNull$$$0(2);
            }
            if (manager2 == null) {
                1.$$$reportNull$$$0(3);
            }
            return new AnActionEvent(inputEvent, context, place, presentation2, manager2, 0);
        }

        @Override
        public void onUpdatePassed(InputEvent inputEvent, @NotNull AnAction action2, @NotNull AnActionEvent actionEvent) {
            if (action2 == null) {
                1.$$$reportNull$$$0(4);
            }
            if (actionEvent == null) {
                1.$$$reportNull$$$0(5);
            }
            IdeKeyEventDispatcher.this.setState(KeyState.STATE_PROCESSED);
            IdeKeyEventDispatcher.this.setPressedWasProcessed(inputEvent.getID() == 401);
        }

        @Override
        public void performAction(@NotNull InputEvent e, @NotNull AnAction action2, @NotNull AnActionEvent actionEvent) {
            if (e == null) {
                1.$$$reportNull$$$0(6);
            }
            if (action2 == null) {
                1.$$$reportNull$$$0(7);
            }
            if (actionEvent == null) {
                1.$$$reportNull$$$0(8);
            }
            e.consume();
            if (e instanceof KeyEvent) {
                IdeEventQueue.getInstance().onActionInvoked((KeyEvent)e);
            }
            DataContext ctx = actionEvent.getDataContext();
            if (action2 instanceof ActionGroup && !((ActionGroup)action2).canBePerformed(ctx)) {
                ActionGroup group2 = (ActionGroup)action2;
                String groupId2 = ActionManager.getInstance().getId(action2);
                JBPopupFactory.getInstance().createActionGroupPopup(group2.getTemplatePresentation().getText(), group2, ctx, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, -1, null, ActionPlaces.getActionGroupPopupPlace((String)groupId2)).showInBestPositionFor(ctx);
            } else {
                ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)actionEvent);
            }
            if (Registry.is((String)"actionSystem.fixLostTyping")) {
                IdeEventQueue.getInstance().doWhenReady(() -> IdeEventQueue.getInstance().getKeyEventDispatcher().resetState());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 4: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionEvent";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createEvent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onUpdatePassed";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performAction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static DumbModeWarningListener dumbModeWarningListener = null;
    KeyEvent lastKeyEventForCurrentContext;
    private static final KeyboardShortcut CONTROL_ENTER = KeyboardShortcut.fromString((String)"control ENTER");
    private static final KeyboardShortcut CMD_ENTER = KeyboardShortcut.fromString((String)"meta ENTER");
    private static final String POPUP_MENU_PREFIX = "PopupMenu-";
    @NonNls
    private static final Set<String> ALT_GR_LANGUAGES = Set.of("da", "de", "es", "et", "fi", "fr", "hr", "hu", "it", "lv", "mk", "nl", "no", "pl", "pt", "ro", "sk", "sl", "sr", "sv", "tr");
    @NonNls
    private static final Set<String> ALT_GR_COUNTRIES = Set.of("DK", "DE", "FI", "NL", "SL", "SE");

    public IdeKeyEventDispatcher(@Nullable IdeEventQueue queue2) {
        this.myQueue = queue2;
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            Disposer.register((Disposable)app, (Disposable)this);
        }
    }

    public boolean isWaitingForSecondKeyStroke() {
        return this.getState() == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE || this.isPressedWasProcessed();
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        DataManager dataManager;
        MenuSelectionManager menuSelectionManager;
        MenuElement[] selectedPath;
        if (this.myDisposed) {
            return false;
        }
        if (e.getID() == 401) {
            IdeKeyEventDispatcher.storeAsciiForChar(e);
        }
        if (e.isConsumed()) {
            return false;
        }
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        if (focusOwner instanceof KeyboardAwareFocusOwner && ((KeyboardAwareFocusOwner)((Object)focusOwner)).skipKeyEventDispatcher(e)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Key event not processed because %s is in focus and implements %s", focusOwner, KeyboardAwareFocusOwner.class));
            }
            return false;
        }
        int id2 = e.getID();
        if (this.myIgnoreNextKeyTypedEvent) {
            if (400 == id2) {
                return true;
            }
            this.myIgnoreNextKeyTypedEvent = false;
        }
        if (IdeKeyEventDispatcher.isSpeedSearchEditing(e)) {
            return false;
        }
        if (e.getKeyCode() == 17) {
            if (id2 == 401) {
                this.myLeftCtrlPressed = e.getKeyLocation() == 2;
            } else if (id2 == 402) {
                this.myLeftCtrlPressed = false;
            }
        } else if (e.getKeyCode() == 18) {
            if (id2 == 401) {
                this.myRightAltPressed = e.getKeyLocation() == 3;
            } else if (id2 == 402) {
                this.myRightAltPressed = false;
            }
        }
        if (focusOwner instanceof ShortcutTextField) {
            if (SystemInfoRt.isWindows && 401 == id2) {
                IdeKeyEventDispatcher.removeAltGraph(e);
            }
            return false;
        }
        if (id2 == 401 && focusOwner instanceof JTextComponent && ((JTextComponent)focusOwner).isEditable() && e.getKeyChar() != '\uffff' && e.getKeyCode() != 27) {
            MacUIUtil.hideCursor();
        }
        if ((selectedPath = (menuSelectionManager = MenuSelectionManager.defaultManager()).getSelectedPath()).length > 0 && !(selectedPath[0] instanceof ComboPopup)) {
            this.setState(KeyState.STATE_PROCESSED);
            return IdeKeyEventDispatcher.processMenuActions(e, selectedPath[0]);
        }
        Window focusedWindow = focusManager.getFocusedWindow();
        boolean isModalContext = focusedWindow != null && IdeKeyEventDispatcher.isModalContext(focusedWindow);
        Application app = ApplicationManager.getApplication();
        DataManager dataManager2 = dataManager = app == null ? null : (DataManager)app.getServiceIfCreated(DataManager.class);
        if (dataManager == null) {
            return false;
        }
        DataContext dataContext = Utils.wrapDataContext(dataManager.getDataContext());
        this.myContext.setDataContext(dataContext);
        this.myContext.setFocusOwner(focusOwner);
        this.myContext.setModalContext(isModalContext);
        this.myContext.setInputEvent(e);
        try {
            switch (this.getState()) {
                case STATE_INIT: {
                    boolean bl = this.inInitState();
                    return bl;
                }
                case STATE_PROCESSED: {
                    boolean bl = this.inProcessedState();
                    return bl;
                }
                case STATE_WAIT_FOR_SECOND_KEYSTROKE: {
                    boolean bl = this.inWaitForSecondStrokeState();
                    return bl;
                }
                case STATE_SECOND_STROKE_IN_PROGRESS: {
                    boolean bl = this.inSecondStrokeInProgressState();
                    return bl;
                }
                case STATE_KEY_GESTURE_PROCESSOR: {
                    boolean bl = this.myKeyGestureProcessor.process();
                    return bl;
                }
                case STATE_WAIT_FOR_POSSIBLE_ALT_GR: {
                    boolean bl = this.inWaitForPossibleAltGr();
                    return bl;
                }
            }
            throw new IllegalStateException("state = " + this.getState());
        }
        finally {
            this.myContext.clear();
        }
    }

    private static void storeAsciiForChar(@NotNull KeyEvent e) {
        char aChar;
        if (e == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(0);
        }
        if ((aChar = e.getKeyChar()) == '\uffff') {
            return;
        }
        int mods = e.getModifiers();
        if ((mods & 0xFFFFFFFE & 0xFFFFFFBF) != 0) {
            return;
        }
        KeyboardLayoutUtil.storeAsciiForChar((int)e.getKeyCode(), (char)aChar, (int)65, (int)90);
    }

    private static boolean isSpeedSearchEditing(KeyEvent e) {
        Component owner;
        int keyCode = e.getKeyCode();
        if (keyCode == 8 && (owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) instanceof JComponent) {
            SpeedSearchSupply supply2 = SpeedSearchSupply.getSupply((JComponent)((JComponent)owner));
            return supply2 != null && supply2.isPopupActive();
        }
        return false;
    }

    public static boolean isModalContext(@NotNull Component component2) {
        JBPopup popup2;
        boolean isPopup;
        JDialog dialog2;
        Component pane2;
        Window window;
        if (component2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(1);
        }
        if ((window = ComponentUtil.getWindow((Component)component2)) instanceof IdeFrameImpl && (pane2 = ((JFrame)window).getGlassPane()) instanceof IdeGlassPaneEx) {
            return ((IdeGlassPaneEx)((Object)pane2)).isInModalContext();
        }
        if (window instanceof JDialog && !(dialog2 = (JDialog)window).isModal()) {
            Window owner = dialog2.getOwner();
            return owner != null && IdeKeyEventDispatcher.isModalContext(owner);
        }
        if (window instanceof JFrame) {
            return false;
        }
        boolean isFloatingDecorator = window instanceof FloatingDecorator;
        boolean bl = isPopup = !(component2 instanceof JFrame) && !(component2 instanceof JDialog);
        if (isPopup && component2 instanceof JWindow && (popup2 = (JBPopup)((JWindow)component2).getRootPane().getClientProperty("JBPopup")) != null) {
            return popup2.isModalContext();
        }
        return !isFloatingDecorator;
    }

    private boolean inWaitForSecondStrokeState() {
        if (401 == this.myContext.getInputEvent().getID()) {
            this.setState(KeyState.STATE_SECOND_STROKE_IN_PROGRESS);
            return this.inSecondStrokeInProgressState();
        }
        return true;
    }

    private static KeyStroke getKeyStrokeWithoutMouseModifiers(KeyStroke originalKeyStroke) {
        int modifier = originalKeyStroke.getModifiers() & 0xFFFFFBFF & 0xFFFFFFEF & 0xFFFFF7FF & 0xFFFFFFF7 & 0xFFFFEFFF & 0xFFFFFFFB;
        try {
            return (KeyStroke)ReflectionHolder.getCachedStroke.invoke((Object)originalKeyStroke, Character.valueOf(originalKeyStroke.getKeyChar()), originalKeyStroke.getKeyCode(), modifier, originalKeyStroke.isOnKeyRelease());
        }
        catch (Exception exc) {
            throw new IllegalStateException(exc.getMessage());
        }
    }

    private boolean inWaitForPossibleAltGr() {
        KeyEvent e = this.myContext.getInputEvent();
        KeyStroke keyStroke = this.myFirstKeyStroke;
        this.myFirstKeyStroke = null;
        this.setState(KeyState.STATE_INIT);
        int eventId = e.getID();
        if (400 == eventId && e.isAltGraphDown()) {
            return false;
        }
        if (402 == eventId) {
            this.updateCurrentContext(this.myContext.getFoundComponent(), (Shortcut)new KeyboardShortcut(keyStroke, null));
            if (this.myContext.getActions().isEmpty()) {
                return false;
            }
            return this.processActionOrWaitSecondStroke(keyStroke);
        }
        return false;
    }

    private boolean inSecondStrokeInProgressState() {
        KeyEvent e = this.myContext.getInputEvent();
        if (402 == e.getID()) {
            this.myFirstKeyStroke = null;
            this.setState(KeyState.STATE_INIT);
            Project project = (Project)CommonDataKeys.PROJECT.getData(this.myContext.getDataContext());
            StatusBar.Info.set(null, (Project)project);
            return false;
        }
        KeyStroke originalKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke(e);
        if (originalKeyStroke == null) {
            return false;
        }
        KeyStroke keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        this.updateCurrentContext(this.myContext.getFoundComponent(), (Shortcut)new KeyboardShortcut(this.myFirstKeyStroke, keyStroke));
        if (this.myContext.getActions().isEmpty()) {
            return true;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(this.myContext.getDataContext());
        StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(project);
        if (this.processAction(e, this.myActionProcessor)) {
            if (statusBar != null) {
                statusBar.setInfo(null);
            }
            return true;
        }
        return false;
    }

    private boolean inProcessedState() {
        KeyEvent e = this.myContext.getInputEvent();
        if (400 == e.getID() && this.isPressedWasProcessed()) {
            return true;
        }
        if (402 == e.getID() && 18 == e.getKeyCode() && this.isPressedWasProcessed()) {
            return true;
        }
        this.setState(KeyState.STATE_INIT);
        this.setPressedWasProcessed(false);
        return this.inInitState();
    }

    private boolean inInitState() {
        KeyStroke originalKeyStroke;
        boolean isCandidateForAltGr;
        Component focusOwner = this.myContext.getFocusOwner();
        KeyEvent e = this.myContext.getInputEvent();
        if (SystemInfoRt.isWindows && 401 == e.getID() && IdeKeyEventDispatcher.removeAltGraph(e) && e.isControlDown()) {
            this.myFirstKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke(e);
            if (this.myFirstKeyStroke == null) {
                return false;
            }
            this.setState(KeyState.STATE_WAIT_FOR_POSSIBLE_ALT_GR);
            return true;
        }
        boolean bl = isCandidateForAltGr = this.myLeftCtrlPressed && this.myRightAltPressed && focusOwner != null && e.getModifiers() == 10;
        if (isCandidateForAltGr) {
            if (Registry.is((String)"actionSystem.force.alt.gr", (boolean)false)) {
                return false;
            }
            if (IdeKeyEventDispatcher.isAltGrLayout(focusOwner)) {
                return false;
            }
        }
        if ((originalKeyStroke = KeyStrokeAdapter.getDefaultKeyStroke(e)) == null) {
            return false;
        }
        KeyStroke keyStroke = IdeKeyEventDispatcher.getKeyStrokeWithoutMouseModifiers(originalKeyStroke);
        if (this.myKeyGestureProcessor.processInitState()) {
            return true;
        }
        if (512 == e.getModifiersEx() && (!SystemInfo.isMac || Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl")) && (400 == e.getID() && !IdeEventQueue.getInstance().isInputMethodEnabled() || IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, e))) {
            this.myIgnoreNextKeyTypedEvent = true;
            return false;
        }
        this.updateCurrentContext(focusOwner, (Shortcut)new KeyboardShortcut(keyStroke, null));
        if (this.myContext.getActions().isEmpty()) {
            return false;
        }
        if (isCandidateForAltGr && SystemInfo.isWindows && Registry.is((String)"actionSystem.fix.alt.gr")) {
            this.myFirstKeyStroke = keyStroke;
            this.setState(KeyState.STATE_WAIT_FOR_POSSIBLE_ALT_GR);
            return true;
        }
        return this.processActionOrWaitSecondStroke(keyStroke);
    }

    private boolean processActionOrWaitSecondStroke(KeyStroke keyStroke) {
        if (!this.myContext.isHasSecondStroke()) {
            return this.processAction(this.myContext.getInputEvent(), this.myActionProcessor);
        }
        this.myFirstKeyStroke = keyStroke;
        List<Pair<AnAction, KeyStroke>> secondKeyStrokes = this.getSecondKeystrokeActions();
        Project project = (Project)CommonDataKeys.PROJECT.getData(this.myContext.getDataContext());
        @NlsContexts.StatusBarText StringBuilder message2 = new StringBuilder();
        message2.append(KeyMapBundle.message((String)"prefix.key.pressed.message", (Object[])new Object[0]));
        message2.append(' ');
        for (int i2 = 0; i2 < secondKeyStrokes.size(); ++i2) {
            Pair<AnAction, KeyStroke> pair = secondKeyStrokes.get(i2);
            if (i2 > 0) {
                message2.append(", ");
            }
            message2.append(((AnAction)pair.getFirst()).getTemplatePresentation().getText());
            message2.append(" (");
            message2.append(KeymapUtil.getKeystrokeText((KeyStroke)((KeyStroke)pair.getSecond())));
            message2.append(")");
        }
        StatusBar.Info.set((String)message2.toString(), (Project)project);
        this.mySecondStrokeTimeout.cancelAllRequests();
        this.mySecondStrokeTimeout.addRequest(this.mySecondStrokeTimeoutRunnable, Registry.intValue((String)"actionSystem.secondKeystrokeTimeout"));
        if (Registry.is((String)"actionSystem.secondKeystrokeAutoPopupEnabled")) {
            this.mySecondKeystrokePopupTimeout.cancelAllRequests();
            if (secondKeyStrokes.size() > 1) {
                DataContext oldContext = this.myContext.getDataContext();
                this.mySecondKeystrokePopupTimeout.addRequest(() -> {
                    if (this.myState == KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE) {
                        StatusBar.Info.set(null, (Project)((Project)CommonDataKeys.PROJECT.getData(oldContext)));
                        new SecondaryKeystrokePopup(this.myFirstKeyStroke, secondKeyStrokes, oldContext).showInBestPositionFor(oldContext);
                    }
                }, Registry.intValue((String)"actionSystem.secondKeystrokePopupTimeout"));
            }
        }
        this.setState(KeyState.STATE_WAIT_FOR_SECOND_KEYSTROKE);
        return true;
    }

    private List<Pair<AnAction, KeyStroke>> getSecondKeystrokeActions() {
        ArrayList<Pair<AnAction, KeyStroke>> secondKeyStrokes = new ArrayList<Pair<AnAction, KeyStroke>>();
        for (AnAction action2 : this.myContext.getActions()) {
            Shortcut[] shortcuts;
            for (Shortcut shortcut : shortcuts = action2.getShortcutSet().getShortcuts()) {
                KeyboardShortcut keyShortcut;
                if (!(shortcut instanceof KeyboardShortcut) || !(keyShortcut = (KeyboardShortcut)shortcut).getFirstKeyStroke().equals(this.myFirstKeyStroke)) continue;
                secondKeyStrokes.add((Pair<AnAction, KeyStroke>)Pair.create((Object)action2, (Object)keyShortcut.getSecondKeyStroke()));
            }
        }
        return secondKeyStrokes;
    }

    public static boolean hasMnemonicInWindow(Component focusOwner, KeyEvent event) {
        return 400 == event.getID() && IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, event.getKeyChar()) || 401 == event.getID() && IdeKeyEventDispatcher.hasMnemonicInWindow(focusOwner, event.getKeyCode());
    }

    private static boolean hasMnemonicInWindow(Component focusOwner, int keyCode) {
        ComponentWithMnemonics componentWithMnemonics;
        Container container;
        if (keyCode == 18 || keyCode == 0) {
            return false;
        }
        Window window = container = focusOwner == null ? null : ComponentUtil.getWindow((Component)focusOwner);
        if (container instanceof JFrame && (componentWithMnemonics = (ComponentWithMnemonics)ComponentUtil.getParentOfType(ComponentWithMnemonics.class, (Component)focusOwner)) instanceof Container) {
            container = (Container)((Object)componentWithMnemonics);
        }
        return IdeKeyEventDispatcher.hasMnemonic(container, keyCode) || IdeKeyEventDispatcher.hasMnemonicInBalloons(container, keyCode);
    }

    private static boolean hasMnemonic(@Nullable Container container, int keyCode) {
        Component component2 = (Component)UIUtil.uiTraverser((Component)container).traverse().filter(Component::isEnabled).filter(Component::isShowing).find(c -> !(c instanceof ActionMenu) && MnemonicHelper.hasMnemonic((Component)c, (int)keyCode));
        return component2 != null;
    }

    private static boolean hasMnemonicInBalloons(Container container, int code) {
        Component parent = UIUtil.findUltimateParent((Component)container);
        if (parent instanceof RootPaneContainer) {
            JLayeredPane pane2 = ((RootPaneContainer)((Object)parent)).getLayeredPane();
            for (Component component2 : pane2.getComponents()) {
                if (!(component2 instanceof ComponentWithMnemonics) || !(component2 instanceof Container) || !IdeKeyEventDispatcher.hasMnemonic((Container)component2, code)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean processAction(InputEvent e, @NotNull ActionProcessor processor2) {
        if (processor2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(2);
        }
        return IdeKeyEventDispatcher.processAction(e, processor2, this.myContext.getDataContext(), this.myContext.getActions().toArray(AnAction.EMPTY_ARRAY), this.myPresentationFactory);
    }

    private static boolean processAction(InputEvent e, @NotNull ActionProcessor processor2, DataContext context, AnAction[] actions, PresentationFactory presentationFactory) {
        if (processor2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(3);
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        boolean dumb = project != null && DumbService.getInstance((Project)project).isDumb();
        ArrayList<AnActionEvent> nonDumbAwareAction = new ArrayList<AnActionEvent>();
        for (AnAction action2 : actions) {
            long startedAt = System.currentTimeMillis();
            Presentation presentation2 = presentationFactory.getPresentation(action2);
            AnActionEvent actionEvent = processor2.createEvent(e, context, "keyboard shortcut", presentation2, ActionManager.getInstance());
            try (AccessToken ignored = ProhibitAWTEvents.start("update");){
                ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)actionEvent, (boolean)true);
            }
            if (dumb && !action2.isDumbAware()) {
                if (!Boolean.FALSE.equals(presentation2.getClientProperty("WOULD_BE_ENABLED_IF_NOT_DUMB_MODE"))) {
                    nonDumbAwareAction.add(actionEvent);
                }
                IdeKeyEventDispatcher.logTimeMillis(startedAt, action2);
                continue;
            }
            if (!presentation2.isEnabled()) {
                IdeKeyEventDispatcher.logTimeMillis(startedAt, action2);
                continue;
            }
            processor2.onUpdatePassed(e, action2, actionEvent);
            if (context instanceof DataManagerImpl.MyDataContext) {
                ((DataManagerImpl.MyDataContext)context).setEventCount(IdeEventQueue.getInstance().getEventCount());
            }
            actionManager.fireBeforeActionPerformed(action2, actionEvent.getDataContext(), actionEvent);
            if (IdeKeyEventDispatcher.isContextComponentNotVisible(actionEvent)) {
                IdeKeyEventDispatcher.logTimeMillis(startedAt, action2);
                return true;
            }
            ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> processor2.performAction(e, action2, actionEvent));
            actionManager.fireAfterActionPerformed(action2, actionEvent.getDataContext(), actionEvent);
            IdeKeyEventDispatcher.logTimeMillis(startedAt, action2);
            return true;
        }
        if (!nonDumbAwareAction.isEmpty()) {
            if (dumbModeWarningListener != null) {
                dumbModeWarningListener.actionCanceledBecauseOfDumbMode();
                if (e instanceof KeyEvent) {
                    IdeEventQueue.getInstance().onActionInvoked((KeyEvent)e);
                }
            }
            IdeEventQueue.getInstance().flushDelayedKeyEvents();
            IdeKeyEventDispatcher.showDumbModeBalloonLaterIfNobodyConsumesEvent(project, e, processor2, actions, presentationFactory, nonDumbAwareAction.toArray(new AnActionEvent[0]));
        }
        IdeEventQueue.getInstance().flushDelayedKeyEvents();
        return false;
    }

    private static boolean isContextComponentNotVisible(AnActionEvent actionEvent) {
        Component component2 = (Component)actionEvent.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        return component2 != null && !component2.isShowing();
    }

    private static void showDumbModeBalloonLaterIfNobodyConsumesEvent(@Nullable Project project, InputEvent e, ActionProcessor processor2, AnAction[] actions, PresentationFactory presentationFactory, AnActionEvent ... actionEvents) {
        if (project == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (e.isConsumed()) {
                return;
            }
            DumbService.getInstance((Project)project).showDumbModeActionBalloon(IdeKeyEventDispatcher.getActionUnavailableMessage(actionEvents), () -> ApplicationManager.getApplication().invokeLater(() -> DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> IdeKeyEventDispatcher.processAction(e, processor2, context, actions, presentationFactory))));
        });
    }

    @NotNull
    @Nls
    private static String getActionUnavailableMessage(AnActionEvent ... actionEvents) {
        ArrayList<String> actionNames = new ArrayList<String>();
        for (AnActionEvent event : actionEvents) {
            String s = event.getPresentation().getText();
            if (!Strings.isNotEmpty((String)s)) continue;
            actionNames.add(s);
        }
        if (actionNames.isEmpty()) {
            return IdeKeyEventDispatcher.getUnavailableMessage(IdeBundle.message((String)"dumb.balloon.this.action", (Object[])new Object[0]), false);
        }
        if (actionNames.size() == 1) {
            return IdeKeyEventDispatcher.getUnavailableMessage("'" + (String)actionNames.get(0) + "'", false);
        }
        @NlsSafe String join = String.join((CharSequence)", ", actionNames);
        String string = IdeKeyEventDispatcher.getUnavailableMessage(IdeBundle.message((String)"dumb.balloon.none.of.the.following.actions", (Object[])new Object[0]), true) + ": " + join;
        if (string == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @Nls
    public static String getUnavailableMessage(@NotNull @Nls String action2, boolean plural) {
        if (action2 == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(5);
        }
        String string = plural ? IdeBundle.message((String)"dumb.balloon.0.are.not.available.while.indexing", (Object[])new Object[]{action2}) : IdeBundle.message((String)"dumb.balloon.0.is.not.available.while.indexing", (Object[])new Object[]{action2});
        if (string == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void addDumbModeWarningListener(DumbModeWarningListener listener2) {
        dumbModeWarningListener = listener2;
    }

    public void updateCurrentContext(Component component2, @NotNull Shortcut sc) {
        List<AnAction> actions;
        if (sc == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(7);
        }
        KeyEvent keyEvent = this.myContext.getInputEvent();
        this.myContext.setFoundComponent(null);
        this.myContext.setHasSecondStroke(false);
        this.myContext.getActions().clear();
        if (Registry.is((String)"ide.edt.update.context.only.on.key.pressed.event")) {
            if (keyEvent == null || keyEvent.getID() != 401) {
                return;
            }
            if (keyEvent == this.lastKeyEventForCurrentContext) {
                return;
            }
            this.lastKeyEventForCurrentContext = keyEvent;
        }
        if (IdeKeyEventDispatcher.isControlEnterOnDialog(component2, sc)) {
            return;
        }
        while (component2 != null) {
            List listOfActions;
            if (component2 instanceof JComponent && !(listOfActions = ActionUtil.getActions((JComponent)((JComponent)component2))).isEmpty()) {
                for (AnAction action2 : listOfActions) {
                    this.addAction(action2, sc);
                }
                if (!this.myContext.getActions().isEmpty()) {
                    this.myContext.setFoundComponent((JComponent)component2);
                    break;
                }
            }
            component2 = component2.getParent();
        }
        this.addActionsFromActiveKeymap(sc);
        if (!this.myContext.isHasSecondStroke() && sc instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)sc;
            KeyStroke firstKeyStroke = keyboardShortcut.getFirstKeyStroke();
            KeyStroke secondKeyStroke = keyboardShortcut.getSecondKeyStroke();
            if (secondKeyStroke != null && secondKeyStroke.getModifiers() != 0 && firstKeyStroke.getModifiers() != 0) {
                KeyboardShortcut altShortCut = new KeyboardShortcut(firstKeyStroke, KeyStroke.getKeyStroke(secondKeyStroke.getKeyCode(), 0));
                this.addActionsFromActiveKeymap((Shortcut)altShortCut);
            }
        }
        if ((actions = this.myContext.getActions()).size() > 1) {
            IdeKeyEventDispatcher.rearrangeByPromoters(actions, this.myContext.getDataContext());
        }
    }

    static void rearrangeByPromoters(List<AnAction> actions, DataContext context) {
        List<AnAction> readOnlyActions = Collections.unmodifiableList(actions);
        for (ActionPromoter promoter : (ActionPromoter[])ActionPromoter.EP_NAME.getExtensions()) {
            List promoted = promoter.promote(readOnlyActions, context);
            if (promoted == null || promoted.isEmpty()) continue;
            actions.removeAll(promoted);
            actions.addAll(0, promoted);
        }
    }

    private void addActionsFromActiveKeymap(@NotNull Shortcut shortcut) {
        String[] actionIds;
        if (shortcut == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(8);
        }
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return;
        }
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            return;
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        Keymap keymap2 = keymapManager2 == null ? null : keymapManager2.getActiveKeymap();
        for (String actionId : actionIds = keymap2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : keymap2.getActionIds(shortcut)) {
            AnAction action2 = actionManager.getAction(actionId);
            if (action2 == null || this.myContext.isModalContext() && !action2.isEnabledInModalContext()) continue;
            this.addAction(action2, shortcut);
        }
        if (keymap2 != null && actionIds.length > 0 && shortcut instanceof KeyboardShortcut) {
            SystemShortcuts.getInstance().onUserPressedShortcut(keymap2, actionIds, (KeyboardShortcut)shortcut);
        }
    }

    private static boolean isControlEnterOnDialog(Component component2, Shortcut sc) {
        return (CONTROL_ENTER.equals((Object)sc) || SystemInfo.isMac && CMD_ENTER.equals((Object)sc)) && !IdeEventQueue.getInstance().isPopupActive() && DialogWrapper.findInstance((Component)component2) != null;
    }

    private void addAction(AnAction action2, @NotNull Shortcut sc) {
        if (sc == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(9);
        }
        for (Shortcut each : action2.getShortcutSet().getShortcuts()) {
            if (each == null) {
                throw new NullPointerException("unexpected shortcut of action: " + action2);
            }
            if (!each.isKeyboard() || !each.startsWith(sc)) continue;
            if (each instanceof KeyboardShortcut && ((KeyboardShortcut)each).getSecondKeyStroke() != null) {
                long startedAt = System.currentTimeMillis();
                Presentation presentation2 = this.myPresentationFactory.getPresentation(action2);
                AnActionEvent actionEvent = this.myActionProcessor.createEvent(this.myContext.getInputEvent(), this.myContext.getDataContext(), "keyboard shortcut", presentation2, ActionManager.getInstance());
                ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)actionEvent, (boolean)false);
                IdeKeyEventDispatcher.logTimeMillis(startedAt, action2);
                if (!presentation2.isEnabled()) continue;
                this.myContext.setHasSecondStroke(true);
            }
            if (this.myContext.getActions().contains(action2)) continue;
            this.myContext.getActions().add(action2);
        }
    }

    public KeyProcessorContext getContext() {
        return this.myContext;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public KeyState getState() {
        return this.myState;
    }

    public void setState(KeyState state) {
        this.myState = state;
        if (this.myQueue != null) {
            this.myQueue.maybeReady();
        }
    }

    private void resetState() {
        this.setState(KeyState.STATE_INIT);
        this.setPressedWasProcessed(false);
    }

    public boolean isPressedWasProcessed() {
        return this.myPressedWasProcessed;
    }

    private void setPressedWasProcessed(boolean pressedWasProcessed) {
        this.myPressedWasProcessed = pressedWasProcessed;
    }

    public boolean isReady() {
        return this.myState == KeyState.STATE_INIT || this.myState == KeyState.STATE_PROCESSED;
    }

    private static boolean processMenuActions(KeyEvent event, MenuElement element2) {
        if (401 != event.getID() || !Registry.is((String)"ide.popup.navigation.via.actions")) {
            return false;
        }
        KeymapManager manager2 = KeymapManager.getInstance();
        if (manager2 == null) {
            return false;
        }
        JRootPane pane2 = IdeKeyEventDispatcher.getMenuActionsHolder(element2.getComponent());
        if (pane2 == null) {
            return false;
        }
        Keymap keymap2 = manager2.getActiveKeymap();
        for (String id2 : keymap2.getActionIds(KeyStroke.getKeyStrokeForEvent(event))) {
            if (!id2.startsWith(POPUP_MENU_PREFIX)) continue;
            String actionId = id2.substring(POPUP_MENU_PREFIX.length());
            Action action2 = pane2.getActionMap().get(actionId);
            if (action2 == null) continue;
            action2.actionPerformed(new ActionEvent(pane2, 1001, actionId));
            event.consume();
            return true;
        }
        return false;
    }

    private static JRootPane getMenuActionsHolder(Component component2) {
        if (component2 instanceof JPopupMenu) {
            JPopupMenu menu = (JPopupMenu)component2;
            return SwingUtilities.getRootPane(menu.getInvoker());
        }
        return SwingUtilities.getRootPane(component2);
    }

    /*
     * WARNING - void declaration
     */
    private static void logTimeMillis(long startedAt, @NotNull AnAction anAction) {
        EventWatcher watcher;
        if (anAction == null) {
            IdeKeyEventDispatcher.$$$reportNull$$$0(10);
        }
        if ((watcher = EventWatcher.getInstance()) != null) {
            void action2;
            watcher.logTimeMillis(action2.toString(), startedAt);
        }
    }

    public static boolean removeAltGraph(InputEvent e) {
        if (e.isAltGraphDown()) {
            try {
                Field field = InputEvent.class.getDeclaredField("modifiers");
                field.setAccessible(true);
                field.setInt(e, 0xFFFFDFDF & field.getInt(e));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAltGrLayout(Component component2) {
        Locale locale;
        InputContext context = component2 == null ? null : component2.getInputContext();
        Locale locale2 = locale = context == null ? null : context.getLocale();
        if (locale == null) {
            return false;
        }
        String language = locale.getLanguage();
        boolean contains = !"en".equals(language) ? ALT_GR_LANGUAGES.contains(language) : ALT_GR_COUNTRIES.contains(locale.getCountry());
        LOG.debug("AltGr", new Object[]{contains ? "" : " not", " supported for ", locale});
        return contains;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sc";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUnavailableMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnavailableMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "storeAsciiForChar";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isModalContext";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAction";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUnavailableMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentContext";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addActionsFromActiveKeymap";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "logTimeMillis";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class SecondaryKeystrokePopup
    extends ListPopupImpl {
        SecondaryKeystrokePopup(@NotNull KeyStroke firstKeystroke, @NotNull List<? extends Pair<AnAction, KeyStroke>> actions, DataContext context) {
            if (firstKeystroke == null) {
                SecondaryKeystrokePopup.$$$reportNull$$$0(0);
            }
            if (actions == null) {
                SecondaryKeystrokePopup.$$$reportNull$$$0(1);
            }
            super((Project)CommonDataKeys.PROJECT.getData(context), SecondaryKeystrokePopup.buildStep(actions, context));
            this.registerActions(firstKeystroke, actions, context);
        }

        private void registerActions(@NotNull KeyStroke firstKeyStroke, @NotNull List<? extends Pair<AnAction, KeyStroke>> actions, final DataContext ctx) {
            if (firstKeyStroke == null) {
                SecondaryKeystrokePopup.$$$reportNull$$$0(2);
            }
            if (actions == null) {
                SecondaryKeystrokePopup.$$$reportNull$$$0(3);
            }
            int size = actions.size();
            for (int i2 = 0; i2 < size; ++i2) {
                KeyStroke additionalKeyStroke;
                String _existing;
                final Pair<AnAction, KeyStroke> t = actions.get(i2);
                String actionText = ((AnAction)t.getFirst()).getTemplatePresentation().getText();
                AbstractAction a = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.cancel();
                        SecondaryKeystrokePopup.invokeAction((AnAction)t.getFirst(), ctx);
                    }
                };
                KeyStroke keyStroke = (KeyStroke)t.getSecond();
                if (keyStroke == null) continue;
                this.registerAction(actionText, keyStroke, a);
                if (keyStroke.getModifiers() != 0 || (_existing = this.getActionForKeyStroke(additionalKeyStroke = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), firstKeyStroke.getModifiers()))) != null) continue;
                this.registerAction("__additional__" + actionText, additionalKeyStroke, a);
            }
        }

        private static void invokeAction(@NotNull AnAction action2, DataContext ctx) {
            AnActionEvent event;
            if (action2 == null) {
                SecondaryKeystrokePopup.$$$reportNull$$$0(4);
            }
            if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)(event = new AnActionEvent(null, ctx, "unknown", action2.getTemplatePresentation().clone(), ActionManager.getInstance(), 0)), (boolean)true)) {
                ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)event);
            }
        }

        @Override
        protected ListCellRenderer<?> getListElementRenderer() {
            return new ActionListCellRenderer();
        }

        private static ListPopupStep<?> buildStep(@NotNull List<? extends Pair<AnAction, KeyStroke>> actions, final DataContext ctx) {
            if (actions == null) {
                SecondaryKeystrokePopup.$$$reportNull$$$0(5);
            }
            return new BaseListPopupStep<Pair<AnAction, KeyStroke>>(IdeBundle.message((String)"popup.title.choose.action", (Object[])new Object[0]), ContainerUtil.findAll(actions, pair -> {
                AnAction action2 = (AnAction)pair.getFirst();
                Presentation presentation2 = action2.getTemplatePresentation().clone();
                AnActionEvent event = new AnActionEvent(null, ctx, "unknown", presentation2, ActionManager.getInstance(), 0);
                ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)event, (boolean)true);
                return presentation2.isEnabled() && presentation2.isVisible();
            })){

                public PopupStep<?> onChosen(Pair<AnAction, KeyStroke> selectedValue, boolean finalChoice) {
                    SecondaryKeystrokePopup.invokeAction((AnAction)selectedValue.getFirst(), ctx);
                    return FINAL_CHOICE;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstKeystroke";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "firstKeyStroke";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$SecondaryKeystrokePopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerActions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildStep";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class ActionListCellRenderer
        extends ColoredListCellRenderer {
            private ActionListCellRenderer() {
            }

            protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
                if (list2 == null) {
                    ActionListCellRenderer.$$$reportNull$$$0(0);
                }
                if (value2 instanceof Pair) {
                    Pair pair = (Pair)value2;
                    this.append(KeymapUtil.getShortcutText((Shortcut)new KeyboardShortcut((KeyStroke)pair.getSecond(), null)), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.appendTextPadding(30);
                    String text2 = ((AnAction)pair.getFirst()).getTemplatePresentation().getText();
                    if (text2 != null) {
                        this.append(text2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/keymap/impl/IdeKeyEventDispatcher$SecondaryKeystrokePopup$ActionListCellRenderer", "customizeCellRenderer"));
            }
        }
    }

    private static final class ReflectionHolder {
        static final Method getCachedStroke = Objects.requireNonNull(ReflectionUtil.getDeclaredMethod(AWTKeyStroke.class, (String)"getCachedStroke", (Class[])new Class[]{Character.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}));

        private ReflectionHolder() {
        }
    }
}

