/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl.associate.win;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.openapi.fileTypes.impl.associate.OSFileAssociationException;
import com.intellij.openapi.fileTypes.impl.associate.SystemFileTypeAssociator;
import com.intellij.openapi.fileTypes.impl.associate.win.WinFileTypeAssociator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.system.CpuArch;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006H\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/fileTypes/impl/associate/win/WinFileTypeAssociator;", "Lcom/intellij/openapi/fileTypes/impl/associate/SystemFileTypeAssociator;", "()V", "associateFileTypes", "", "fileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "createAssignCommandLineToFiletypeCommand", "", "createCmdScriptText", "extensions", "Lcom/intellij/openapi/fileTypes/impl/associate/win/WinFileTypeAssociator$Extension;", "getUniqueFileType", "runCmdCommandWithSudo", "cmdCommand", "errorMessageProvider", "Lkotlin/Function0;", "stringify", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "processOutput", "Lcom/intellij/execution/process/ProcessOutput;", "Extension", "intellij.platform.lang.impl"})
public final class WinFileTypeAssociator
implements SystemFileTypeAssociator {
    @Override
    public void associateFileTypes(@NotNull List<? extends FileType> fileTypes) throws OSFileAssociationException {
        Object object;
        ExtensionFileNameMatcher it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(fileTypes, (String)"fileTypes");
        Iterable $this$map$iv = fileTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FileType fileType = (FileType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = OSAssociateFileTypesUtil.getMatchers((FileType)it);
            collection.add(object);
        }
        $this$map$iv = CollectionsKt.filterIsInstance((Iterable)CollectionsKt.flatten((Iterable)((List)destination$iv$iv)), ExtensionFileNameMatcher.class);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ExtensionFileNameMatcher)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.extension");
            object = new Extension(string);
            collection.add(object);
        }
        List extensions2 = (List)destination$iv$iv;
        this.runCmdCommandWithSudo(this.createCmdScriptText(extensions2), (Function0<String>)((Function0)associateFileTypes.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    private final String createCmdScriptText(List<Extension> extensions2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = extensions2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Extension extension2 = (Extension)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = "assoc " + it.dotExtension() + '=' + this.getUniqueFileType();
            collection.add(string);
        }
        List assocCommands = (List)destination$iv$iv;
        List allCommands = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.createAssignCommandLineToFiletypeCommand()), (Iterable)assocCommands);
        return CollectionsKt.joinToString$default((Iterable)allCommands, (CharSequence)" && ", null, null, (int)0, null, (Function1)createCmdScriptText.1.INSTANCE, (int)30, null);
    }

    private final String createAssignCommandLineToFiletypeCommand() throws OSFileAssociationException {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String scriptName = applicationNamesInfo.getScriptName();
        String suffix = CpuArch.isIntel64() ? "64" : "";
        Path path = PathManager.findBinFile((String)(scriptName + suffix + ".exe"));
        if (path == null) {
            throw (Throwable)new OSFileAssociationException(ApplicationBundle.message((String)"desktop.entry.script.missing", (Object[])new Object[]{PathManager.getBinPath()}));
        }
        Path scriptPath = path;
        return "ftype " + this.getUniqueFileType() + "=" + StringUtil.wrapWithDoubleQuote((String)((Object)scriptPath).toString()) + " \"%1\" %*";
    }

    private final void runCmdCommandWithSudo(String cmdCommand, Function0<String> errorMessageProvider) {
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{"cmd.exe", "/d", "/c", GeneralCommandLine.inescapableQuote((String)cmdCommand)});
        try {
            GeneralCommandLine sudoCommandLine = ExecUtil.sudoCommand((GeneralCommandLine)commandLine, (String)"");
            ProcessOutput processOutput = ExecUtil.execAndGetOutput((GeneralCommandLine)sudoCommandLine, (int)30000);
            if (processOutput.getExitCode() != 0 || processOutput.isCancelled() || processOutput.isTimeout()) {
                throw (Throwable)new OSFileAssociationException((String)errorMessageProvider.invoke(), new Exception(this.stringify(sudoCommandLine, processOutput)));
            }
        }
        catch (Exception e) {
            throw (Throwable)new OSFileAssociationException((String)errorMessageProvider.invoke(), new Exception(this.stringify(commandLine, null), e));
        }
    }

    private final String stringify(GeneralCommandLine commandLine, ProcessOutput processOutput) {
        List result2 = CollectionsKt.listOf((Object[])new String[]{"command line: " + commandLine.getCommandLineString(), "working directory: " + commandLine.getWorkDirectory()});
        if (processOutput != null) {
            result2 = CollectionsKt.plus((Collection)result2, (Iterable)CollectionsKt.listOf((Object[])new String[]{"exit code: " + processOutput.getExitCode(), "timeout: " + processOutput.isTimeout(), "cancelled: " + processOutput.isCancelled(), "stdout: " + processOutput.getStdout(), "stderr: " + processOutput.getStderr()}));
        }
        return CollectionsKt.joinToString$default((Iterable)result2, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String getUniqueFileType() {
        ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
        String string = applicationNamesInfo.getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationNamesInfo.getInstance().fullProductName");
        return StringsKt.replace$default((String)string, (String)" ", (String)"_", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0005\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0006\u0010\u0007\u001a\u00020\u0003J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/fileTypes/impl/associate/win/WinFileTypeAssociator$Extension;", "", "extension", "", "(Ljava/lang/String;)V", "component1", "copy", "dotExtension", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.lang.impl"})
    private static final class Extension {
        private final String extension;

        @NotNull
        public final String dotExtension() {
            return StringsKt.startsWith$default((String)this.extension, (String)".", (boolean)false, (int)2, null) ? this.extension : '.' + this.extension;
        }

        public Extension(@NotNull String extension2) {
            Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
            this.extension = extension2;
        }

        private final String component1() {
            return this.extension;
        }

        @NotNull
        public final Extension copy(@NotNull String extension2) {
            Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
            return new Extension(extension2);
        }

        public static /* synthetic */ Extension copy$default(Extension extension2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = extension2.extension;
            }
            return extension2.copy(string);
        }

        @NotNull
        public String toString() {
            return "Extension(extension=" + this.extension + ")";
        }

        public int hashCode() {
            String string = this.extension;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Extension)) break block3;
                    Extension extension2 = (Extension)object;
                    if (!Intrinsics.areEqual((Object)this.extension, (Object)extension2.extension)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

