/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

final class RemovedMappingTracker {
    private final MultiMap<FileNameMatcher, RemovedMapping> myRemovedMappings = new MultiMap();
    @NonNls
    private static final String ELEMENT_REMOVED_MAPPING = "removed_mapping";
    @NonNls
    private static final String ATTRIBUTE_APPROVED = "approved";
    @NonNls
    private static final String ATTRIBUTE_TYPE = "type";

    RemovedMappingTracker() {
    }

    void clear() {
        this.myRemovedMappings.clear();
    }

    @NotNull
    RemovedMapping add(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName, boolean approved) {
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(0);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(1);
        }
        RemovedMapping mapping2 = new RemovedMapping(matcher, fileTypeName, approved);
        List mappings = (List)this.myRemovedMappings.getModifiable((Object)matcher);
        for (int i2 = 0; i2 < mappings.size(); ++i2) {
            RemovedMapping removedMapping = (RemovedMapping)mappings.get(i2);
            if (!removedMapping.getFileTypeName().equals(fileTypeName)) continue;
            mappings.set(i2, mapping2);
            RemovedMapping removedMapping2 = mapping2;
            if (removedMapping2 == null) {
                RemovedMappingTracker.$$$reportNull$$$0(2);
            }
            return removedMapping2;
        }
        mappings.add(mapping2);
        RemovedMapping removedMapping = mapping2;
        if (removedMapping == null) {
            RemovedMappingTracker.$$$reportNull$$$0(3);
        }
        return removedMapping;
    }

    void load(@NotNull Element e) {
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(4);
        }
        this.myRemovedMappings.clear();
        Set uniques = CollectionFactory.createSmallMemoryFootprintSet((HashingStrategy)new HashingStrategy<RemovedMapping>(){

            public int hashCode(RemovedMapping object) {
                return object.myFileNameMatcher.hashCode();
            }

            public boolean equals(RemovedMapping o1, RemovedMapping o2) {
                return o1 != null && o2 != null && o1.getFileNameMatcher().equals(o2.getFileNameMatcher()) && o1.getFileTypeName().equals(o2.getFileTypeName());
            }
        });
        for (RemovedMapping mapping2 : RemovedMappingTracker.readRemovedMappings(e)) {
            if (!uniques.add(mapping2)) {
                throw new InvalidDataException("Duplicate <removed_mapping> tag for " + mapping2);
            }
            this.myRemovedMappings.putValue((Object)mapping2.myFileNameMatcher, (Object)mapping2);
        }
    }

    @NotNull
    static List<RemovedMapping> readRemovedMappings(@NotNull Element e) {
        List children2;
        if (e == null) {
            RemovedMappingTracker.$$$reportNull$$$0(5);
        }
        if ((children2 = e.getChildren(ELEMENT_REMOVED_MAPPING)).isEmpty()) {
            List<RemovedMapping> list2 = Collections.emptyList();
            if (list2 == null) {
                RemovedMappingTracker.$$$reportNull$$$0(6);
            }
            return list2;
        }
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        for (Element mapping2 : children2) {
            String ext = mapping2.getAttributeValue("ext");
            ExtensionFileNameMatcher matcher = ext == null ? FileTypeManager.parseFromString((String)mapping2.getAttributeValue("pattern")) : new ExtensionFileNameMatcher(ext);
            boolean approved = Boolean.parseBoolean(mapping2.getAttributeValue(ATTRIBUTE_APPROVED));
            String fileTypeName = mapping2.getAttributeValue(ATTRIBUTE_TYPE);
            if (fileTypeName == null) continue;
            RemovedMapping removedMapping = new RemovedMapping((FileNameMatcher)matcher, fileTypeName, approved);
            result2.add(removedMapping);
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    void save(@NotNull Element element2) {
        if (element2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(8);
        }
        ArrayList<RemovedMapping> removedMappings = new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
        removedMappings.sort(Comparator.comparing(mapping2 -> mapping2.getFileNameMatcher().getPresentableString()).thenComparing(RemovedMapping::getFileTypeName));
        for (RemovedMapping mapping3 : removedMappings) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(mapping3.myFileTypeName, mapping3.myFileNameMatcher, true, mapping3.myApproved);
            if (content2 == null) continue;
            element2.addContent(content2);
        }
    }

    void saveRemovedMappingsForFileType(@NotNull Element map2, @NotNull String fileTypeName, @NotNull Collection<? extends FileNameMatcher> associations, boolean specifyTypeName) {
        if (map2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(9);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(10);
        }
        if (associations == null) {
            RemovedMappingTracker.$$$reportNull$$$0(11);
        }
        for (FileNameMatcher fileNameMatcher : associations) {
            Element content2 = RemovedMappingTracker.writeRemovedMapping(fileTypeName, fileNameMatcher, specifyTypeName, this.isApproved(fileNameMatcher, fileTypeName));
            if (content2 == null) continue;
            map2.addContent(content2);
        }
    }

    boolean hasRemovedMapping(@NotNull FileNameMatcher matcher) {
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(12);
        }
        return this.myRemovedMappings.containsKey((Object)matcher);
    }

    private boolean isApproved(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName) {
        RemovedMapping mapping2;
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(13);
        }
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(14);
        }
        return (mapping2 = (RemovedMapping)ContainerUtil.find((Iterable)this.myRemovedMappings.get((Object)matcher), m -> m.getFileTypeName().equals(fileTypeName))) != null && mapping2.isApproved();
    }

    @NotNull
    List<RemovedMapping> getRemovedMappings() {
        return new ArrayList<RemovedMapping>(this.myRemovedMappings.values());
    }

    @NotNull
    List<FileNameMatcher> getMappingsForFileType(@NotNull String fileTypeName) {
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(15);
        }
        List<FileNameMatcher> list2 = this.myRemovedMappings.values().stream().filter(mapping2 -> mapping2.myFileTypeName.equals(fileTypeName)).map(mapping2 -> mapping2.myFileNameMatcher).collect(Collectors.toList());
        if (list2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    List<RemovedMapping> removeIf(@NotNull Predicate<? super RemovedMapping> predicate2) {
        if (predicate2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(17);
        }
        ArrayList<RemovedMapping> result2 = new ArrayList<RemovedMapping>();
        Iterator iterator2 = this.myRemovedMappings.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            Collection mappings = (Collection)entry.getValue();
            mappings.removeIf((? super E mapping2) -> {
                boolean toRemove2 = predicate2.test((RemovedMapping)mapping2);
                if (toRemove2) {
                    result2.add((RemovedMapping)mapping2);
                }
                return toRemove2;
            });
            if (!mappings.isEmpty()) continue;
            iterator2.remove();
        }
        ArrayList<RemovedMapping> arrayList = result2;
        if (arrayList == null) {
            RemovedMappingTracker.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @NotNull
    List<RemovedMapping> deleteUnapprovedMappings() {
        List<RemovedMapping> list2 = this.removeIf(mapping2 -> !mapping2.isApproved());
        if (list2 == null) {
            RemovedMappingTracker.$$$reportNull$$$0(19);
        }
        return list2;
    }

    private static Element writeRemovedMapping(@NotNull String fileTypeName, @NotNull FileNameMatcher matcher, boolean specifyTypeName, boolean approved) {
        Element mapping2;
        if (fileTypeName == null) {
            RemovedMappingTracker.$$$reportNull$$$0(20);
        }
        if (matcher == null) {
            RemovedMappingTracker.$$$reportNull$$$0(21);
        }
        if (!AbstractFileType.writePattern(matcher, mapping2 = new Element(ELEMENT_REMOVED_MAPPING))) {
            return null;
        }
        if (approved) {
            mapping2.setAttribute(ATTRIBUTE_APPROVED, "true");
        }
        if (specifyTypeName) {
            mapping2.setAttribute(ATTRIBUTE_TYPE, fileTypeName);
        }
        return mapping2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 10: 
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "associations";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readRemovedMappings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsForFileType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "removeIf";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteUnapprovedMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readRemovedMappings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveRemovedMappingsForFileType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasRemovedMapping";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isApproved";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsForFileType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeIf";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeRemovedMapping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RemovedMapping {
        private final FileNameMatcher myFileNameMatcher;
        private final String myFileTypeName;
        private final boolean myApproved;

        private RemovedMapping(@NotNull FileNameMatcher matcher, @NotNull String fileTypeName, boolean approved) {
            if (matcher == null) {
                RemovedMapping.$$$reportNull$$$0(0);
            }
            if (fileTypeName == null) {
                RemovedMapping.$$$reportNull$$$0(1);
            }
            this.myFileNameMatcher = matcher;
            this.myFileTypeName = fileTypeName;
            this.myApproved = approved;
        }

        @NotNull
        FileNameMatcher getFileNameMatcher() {
            FileNameMatcher fileNameMatcher = this.myFileNameMatcher;
            if (fileNameMatcher == null) {
                RemovedMapping.$$$reportNull$$$0(2);
            }
            return fileNameMatcher;
        }

        @NotNull
        String getFileTypeName() {
            String string = this.myFileTypeName;
            if (string == null) {
                RemovedMapping.$$$reportNull$$$0(3);
            }
            return string;
        }

        boolean isApproved() {
            return this.myApproved;
        }

        public String toString() {
            return "Removed mapping '" + this.myFileNameMatcher + "' -> " + this.myFileTypeName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypeName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker$RemovedMapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/RemovedMappingTracker$RemovedMapping";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileNameMatcher";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileTypeName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

