/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.impl.FileTypeConfigurableInteractions;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.JBColor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import com.intellij.ui.components.fields.valueEditors.ValueEditor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

class IgnoredFilesAndFoldersPanel
extends JPanel {
    private final DefaultListModel<String> myModel = new DefaultListModel();
    private final JBList<String> myPatternList;
    private final PatternEditField myEditField = new PatternEditField();

    IgnoredFilesAndFoldersPanel() {
        this.setLayout(new BorderLayout());
        this.myPatternList = new JBList();
        this.myPatternList.setModel(this.myModel);
        this.myPatternList.setSelectionMode(0);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myPatternList).setScrollPaneBorder((Border)JBUI.Borders.empty()).setPanelBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)1)).setAddAction(__ -> this.addPattern()).setEditAction(__ -> this.editPattern()).setRemoveAction(__ -> this.removePattern()).disableUpDownActions();
        this.add((Component)decorator.createPanel(), "North");
        JPanel listPanel = new JPanel(new BorderLayout());
        this.myEditField.setVisible(false);
        listPanel.add((Component)((Object)this.myEditField), "North");
        JBScrollPane scrollPane = new JBScrollPane(this.myPatternList);
        listPanel.add((Component)scrollPane, "Center");
        this.add((Component)listPanel, "Center");
        JLabel label2 = new JLabel(FileTypesBundle.message("filetype.ignore.text", new Object[0]));
        label2.setFont((Font)JBUI.Fonts.smallFont());
        label2.setForeground((Color)JBColor.GRAY);
        label2.setBorder(TitledSeparator.createEmptyBorder());
        this.add((Component)label2, "South");
    }

    private void removePattern() {
        int index2 = this.myPatternList.getSelectedIndex();
        if (index2 >= 0) {
            FileTypeConfigurableInteractions.ignorePatternRemoved.log();
            this.myModel.remove(index2);
            if (this.myModel.size() > 0) {
                if (index2 >= this.myModel.size()) {
                    index2 = this.myModel.size() - 1;
                }
                this.myPatternList.setSelectedIndex(index2);
            }
        }
    }

    private void editPattern() {
        FileTypeConfigurableInteractions.ignorePatternEdited.log();
        this.myEditField.startEdit((String)this.myPatternList.getSelectedValue());
    }

    private void addPattern() {
        FileTypeConfigurableInteractions.ignorePatternAdded.log();
        this.myEditField.startEdit("");
    }

    @NotNull
    String getValues() {
        String string = String.join((CharSequence)";", ArrayUtil.toStringArray(Collections.list(this.myModel.elements())));
        if (string == null) {
            IgnoredFilesAndFoldersPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    void setValues(@NotNull String values) {
        if (values == null) {
            IgnoredFilesAndFoldersPanel.$$$reportNull$$$0(1);
        }
        this.fillList(Arrays.asList(values.split(";")));
    }

    private void fillList(@NotNull List<String> patterns) {
        if (patterns == null) {
            IgnoredFilesAndFoldersPanel.$$$reportNull$$$0(2);
        }
        this.myModel.clear();
        this.myModel.addAll(patterns.stream().sorted().collect(Collectors.toList()));
    }

    private void reorderList() {
        int toSelect2;
        int selected2 = this.myPatternList.getSelectedIndex();
        String selection = selected2 >= 0 ? this.myModel.get(selected2) : null;
        this.fillList(Collections.list(this.myModel.elements()));
        if (selection != null && (toSelect2 = this.myModel.indexOf(selection)) >= 0) {
            this.myPatternList.setSelectedIndex(toSelect2);
            this.myPatternList.ensureIndexIsVisible(toSelect2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/IgnoredFilesAndFoldersPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/IgnoredFilesAndFoldersPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setValues";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatternValueEditor
    extends TextFieldValueEditor<String> {
        PatternValueEditor(@NotNull JTextField field) {
            if (field == null) {
                PatternValueEditor.$$$reportNull$$$0(0);
            }
            super(field, FileTypesBundle.message("filetype.ignore.pattern", new Object[0]), (Object)"");
        }

        @NotNull
        public String parseValue(@Nullable String text2) throws InvalidDataException {
            if (text2 != null) {
                if (!this.isValid(text2)) {
                    throw new InvalidDataException(FileTypesBundle.message("filetype.ignore.error.invalid", new Object[0]));
                }
                String string = text2;
                if (string == null) {
                    PatternValueEditor.$$$reportNull$$$0(1);
                }
                return string;
            }
            return "";
        }

        public String valueToString(@NotNull String value2) {
            if (value2 == null) {
                PatternValueEditor.$$$reportNull$$$0(2);
            }
            FileNameMatcherFactory.getInstance().createMatcher(value2);
            return value2;
        }

        public boolean isValid(@NotNull String value2) {
            if (value2 == null) {
                PatternValueEditor.$$$reportNull$$$0(3);
            }
            if (value2.isBlank()) {
                return false;
            }
            String withoutWildcards = value2.trim().replaceAll("\\*", "a").replaceAll("\\?", "a");
            return PathUtil.isValidFileName((String)withoutWildcards, (boolean)true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/IgnoredFilesAndFoldersPanel$PatternValueEditor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/IgnoredFilesAndFoldersPanel$PatternValueEditor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "valueToString";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isValid";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class PatternEditField
    extends JBTextField {
        private final PatternValueEditor myValueEditor;
        @Nls
        @NlsSafe
        private String myOldValue;

        private PatternEditField() {
            this.setBorder(true);
            this.myValueEditor = new PatternValueEditor((JTextField)((Object)this));
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        if (PatternEditField.this.trySave()) {
                            PatternEditField.this.stopEdit(e);
                        } else {
                            e.consume();
                        }
                    } else if (e.getKeyCode() == 27) {
                        PatternEditField.this.stopEdit(e);
                    }
                }
            });
            this.myValueEditor.addListener((ValueEditor.Listener)new ValueEditor.Listener<String>(){

                public void valueChanged(@NotNull String newValue2) {
                    if (newValue2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    PatternEditField.this.setBorder(PatternEditField.this.myValueEditor.isValid(newValue2));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/intellij/openapi/fileTypes/impl/IgnoredFilesAndFoldersPanel$PatternEditField$2", "valueChanged"));
                }
            });
        }

        void setBorder(boolean isValid) {
            if (isValid) {
                this.setBorder(JBUI.Borders.customLine((Color)JBColor.LIGHT_GRAY, (int)1, (int)1, (int)0, (int)1));
            } else {
                this.setBorder(JBUI.Borders.customLine((Color)JBColor.RED));
            }
        }

        private boolean trySave() {
            String newValue2 = this.getText();
            if (newValue2.equals(this.myOldValue)) {
                return true;
            }
            if (this.myValueEditor.isValid(newValue2)) {
                if (IgnoredFilesAndFoldersPanel.this.myModel.contains(newValue2)) {
                    this.setBorder(false);
                    this.showError(FileTypesBundle.message("filetype.ignore.error.already.exists", new Object[0]));
                    return false;
                }
                if (this.myOldValue != null) {
                    IgnoredFilesAndFoldersPanel.this.myModel.removeElement(this.myOldValue);
                }
                IgnoredFilesAndFoldersPanel.this.myModel.addElement(newValue2);
                int index2 = IgnoredFilesAndFoldersPanel.this.myModel.indexOf(newValue2);
                IgnoredFilesAndFoldersPanel.this.myPatternList.setSelectedIndex(index2);
                this.setBorder(true);
                IgnoredFilesAndFoldersPanel.this.reorderList();
                return true;
            }
            this.showError(FileTypesBundle.message("filetype.ignore.error.invalid", new Object[0]));
            this.setBorder(false);
            return false;
        }

        void startEdit(@NotNull @NlsSafe String value2) {
            if (value2 == null) {
                PatternEditField.$$$reportNull$$$0(0);
            }
            this.myOldValue = value2.isEmpty() ? null : value2;
            this.setText(value2);
            this.setBorder(true);
            this.setVisible(true);
            this.requestFocus();
            IgnoredFilesAndFoldersPanel.this.myPatternList.setEnabled(false);
        }

        private void stopEdit(@NotNull KeyEvent event) {
            if (event == null) {
                PatternEditField.$$$reportNull$$$0(1);
            }
            event.consume();
            this.setVisible(false);
            IgnoredFilesAndFoldersPanel.this.myPatternList.setEnabled(true);
            IgnoredFilesAndFoldersPanel.this.myPatternList.requestFocus();
        }

        private void showError(@NotNull @Nls String message2) {
            if (message2 == null) {
                PatternEditField.$$$reportNull$$$0(2);
            }
            Balloon balloon2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(message2)).setFillColor(HintUtil.getErrorColor()).setHideOnKeyOutside(true).setFadeoutTime(1000L).createBalloon();
            int xLoc = (int)this.getGraphics().getFontMetrics().getStringBounds(this.getText(), this.getGraphics()).getWidth();
            RelativePoint relativePoint = new RelativePoint((Component)((Object)this), new Point(xLoc, this.getHeight()));
            balloon2.show(relativePoint, Balloon.Position.below);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/IgnoredFilesAndFoldersPanel$PatternEditField";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startEdit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stopEdit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

