/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeSelectable;
import com.intellij.openapi.fileTypes.impl.RemovedMappingTracker;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class ConflictingFileTypeMappingTracker {
    private static final Logger LOG = Logger.getInstance(ConflictingFileTypeMappingTracker.class);
    private static ConflictPolicy throwOnConflict = ConflictPolicy.IGNORE;
    private final RemovedMappingTracker myRemovedMappingTracker;

    @NotNull
    ResolveConflictResult warnAndResolveConflict(@NotNull FileNameMatcher matcher, @Nullable FileType oldFileType, @NotNull FileType newFileType) {
        if (matcher == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(0);
        }
        if (newFileType == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(1);
        }
        if (oldFileType == null || oldFileType.equals(newFileType) || oldFileType instanceof AbstractFileType) {
            return new ResolveConflictResult((FileType)ObjectUtils.notNull((Object)oldFileType, (Object)newFileType), null, null, "", "", true);
        }
        ResolveConflictResult result2 = ConflictingFileTypeMappingTracker.resolveConflict(matcher, oldFileType, newFileType);
        if (!result2.resolved.equals(oldFileType) && !result2.approved) {
            this.showConflictNotification(null, matcher, oldFileType, result2);
        }
        ResolveConflictResult resolveConflictResult = result2;
        if (resolveConflictResult == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(2);
        }
        return resolveConflictResult;
    }

    @NotNull
    private static ResolveConflictResult resolveConflict(@NotNull FileNameMatcher matcher, @NotNull FileType oldFileType, @NotNull FileType newFileType) {
        if (matcher == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(3);
        }
        if (oldFileType == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(4);
        }
        if (newFileType == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(5);
        }
        PluginDescriptor oldPlugin = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(oldFileType.getClass().getName());
        PluginDescriptor newPlugin = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(newFileType.getClass().getName());
        if (newPlugin == null || newPlugin.isBundled() && oldPlugin != null && !oldPlugin.isBundled()) {
            PluginDescriptor plugin2 = newPlugin;
            FileType type = newFileType;
            newPlugin = oldPlugin;
            newFileType = oldFileType;
            oldFileType = type;
            oldPlugin = plugin2;
        }
        String oldPluginName = oldPlugin == null || oldPlugin.isBundled() ? "bundled" : oldPlugin.getName();
        String explanation = FileTypesBundle.message("notification.content.file.type.reassigned.explanation", matcher.getPresentableString());
        if (newPlugin != null) {
            boolean approved = oldPlugin == null || !oldPlugin.equals(newPlugin) && oldPlugin.isBundled() && !newPlugin.isBundled();
            String message2 = FileTypesBundle.message("notification.content.file.type.reassigned.plugin", matcher.getPresentableString(), oldPluginName, newFileType.getDisplayName(), newPlugin.getName());
            String newPluginName = newPlugin.isBundled() ? null : newPlugin.getName();
            return new ResolveConflictResult(newFileType, newPluginName, oldPlugin == null || oldPlugin.isBundled() ? null : oldPlugin.getName(), message2, explanation, approved);
        }
        String message3 = FileTypesBundle.message("notification.content.file.pattern.was.reassigned.to", matcher.getPresentableString(), oldFileType.getDisplayName());
        return new ResolveConflictResult(oldFileType, null, null, message3, explanation, false);
    }

    ConflictingFileTypeMappingTracker(@NotNull RemovedMappingTracker removedMappingTracker) {
        if (removedMappingTracker == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(6);
        }
        this.myRemovedMappingTracker = removedMappingTracker;
    }

    @TestOnly
    static void onConflict(@NotNull ConflictPolicy doThrow) {
        if (doThrow == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(7);
        }
        throwOnConflict = doThrow;
    }

    private void showConflictNotification(@Nullable Project project, @NotNull FileNameMatcher matcher, @NotNull FileType oldFileType, @NotNull ResolveConflictResult result2) {
        if (matcher == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(8);
        }
        if (oldFileType == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(10);
        }
        FileType resolvedFileType = result2.resolved;
        @Nls String notificationText = result2.notification;
        if (oldFileType.equals(resolvedFileType)) {
            throw new IllegalArgumentException("expected different file types but got " + resolvedFileType);
        }
        String oldDisplayName = oldFileType.getDisplayName();
        String resolvedDisplayName = resolvedFileType.getDisplayName();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            AssertionError error = new AssertionError((Object)(notificationText + "; matcher: " + matcher));
            switch (throwOnConflict) {
                case THROW: {
                    throw error;
                }
                case LOG_ERROR: {
                    LOG.error((Throwable)((Object)error));
                    break;
                }
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Notification notification = new Notification(NotificationGroup.createIdWithTitle((String)"File type conflict", (String)FileTypesBundle.message("notification.title.file.type.conflict", new Object[0])), notificationText, result2.explanation, NotificationType.INFORMATION, null);
            if (!result2.approved) {
                String message2 = result2.resolvedPluginName == null ? FileTypesBundle.message("notification.content.conflict.confirm.reassign", resolvedDisplayName) : FileTypesBundle.message("notification.content.conflict.confirm.reassign.from.plugin", resolvedDisplayName, result2.resolvedPluginName);
                notification.addAction((AnAction)NotificationAction.createSimple((String)message2, () -> {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        this.myRemovedMappingTracker.add(matcher, oldFileType.getName(), true);
                        FileTypeManager.getInstance().associate(resolvedFileType, matcher);
                    });
                    notification.expire();
                    String m = FileTypesBundle.message("dialog.message.file.pattern.was.assigned.to", matcher.getPresentableString(), resolvedDisplayName);
                    ConflictingFileTypeMappingTracker.showReassignedInfoNotification(project, m);
                }));
            }
            String revertMessage = result2.oldPluginName == null ? FileTypesBundle.message("notification.content.revert.reassign", oldDisplayName) : FileTypesBundle.message("notification.content.revert.reassign.from.plugin", oldDisplayName, result2.oldPluginName);
            notification.addAction((AnAction)NotificationAction.createSimple((String)revertMessage, () -> {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    this.myRemovedMappingTracker.add(matcher, resolvedFileType.getName(), true);
                    FileTypeManager.getInstance().associate(oldFileType, matcher);
                });
                notification.expire();
                String m = FileTypesBundle.message("dialog.message.file.pattern.was.reassigned.back.to", matcher.getPresentableString(), oldDisplayName);
                ConflictingFileTypeMappingTracker.showReassignedInfoNotification(project, m);
            }));
            if (!oldFileType.isReadOnly()) {
                notification.addAction((AnAction)NotificationAction.createSimple((String)FileTypesBundle.message("notification.content.edit", oldDisplayName), () -> ConflictingFileTypeMappingTracker.editFileType(project, oldFileType)));
            }
            if (!resolvedFileType.isReadOnly()) {
                notification.addAction((AnAction)NotificationAction.createSimple((String)FileTypesBundle.message("notification.content.edit", resolvedDisplayName), () -> ConflictingFileTypeMappingTracker.editFileType(project, resolvedFileType)));
            }
            Notifications.Bus.notify((Notification)notification, (Project)project);
        }, project == null ? ApplicationManager.getApplication().getDisposed() : project.getDisposed());
    }

    private static void showReassignedInfoNotification(@Nullable Project project, @NotNull @NlsContexts.NotificationContent String message2) {
        if (message2 == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(11);
        }
        Notification confirmNotification = new Notification(NotificationGroup.createIdWithTitle((String)"dialog.title.pattern.reassigned", (String)FileTypesBundle.message("dialog.title.pattern.reassigned", new Object[0])), FileTypesBundle.message("dialog.title.pattern.reassigned", new Object[0]), message2, NotificationType.INFORMATION, null);
        Notifications.Bus.notify((Notification)confirmNotification, (Project)project);
    }

    private static void editFileType(@Nullable Project project, @NotNull FileType fileType) {
        if (fileType == null) {
            ConflictingFileTypeMappingTracker.$$$reportNull$$$0(12);
        }
        ShowSettingsUtil.getInstance().showSettingsDialog(project, configurable2 -> configurable2 instanceof SearchableConfigurable && ((SearchableConfigurable)configurable2).getId().equals("preferences.fileTypes"), configurable2 -> {
            if (configurable2 instanceof ConfigurableWrapper) {
                configurable2 = (Configurable)((ConfigurableWrapper)configurable2).getConfigurable();
            }
            FileTypeSelectable fileTypeSelectable = (FileTypeSelectable)configurable2;
            fileTypeSelectable.selectFileType(fileType);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/ConflictingFileTypeMappingTracker";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFileType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedMappingTracker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doThrow";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/ConflictingFileTypeMappingTracker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "warnAndResolveConflict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "warnAndResolveConflict";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflict";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onConflict";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showConflictNotification";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showReassignedInfoNotification";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "editFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum ConflictPolicy {
        THROW,
        LOG_ERROR,
        IGNORE;

    }

    static class ResolveConflictResult {
        @NotNull
        final FileType resolved;
        final String resolvedPluginName;
        final String oldPluginName;
        @NotNull
        @Nls
        final String notification;
        @NotNull
        @Nls
        final String explanation;
        final boolean approved;

        private ResolveConflictResult(@NotNull FileType resolved2, @Nullable String resolvedPluginName, @Nullable String oldPluginName, @NotNull @Nls String notification, @NotNull @Nls String explanation, boolean approved) {
            if (resolved2 == null) {
                ResolveConflictResult.$$$reportNull$$$0(0);
            }
            if (notification == null) {
                ResolveConflictResult.$$$reportNull$$$0(1);
            }
            if (explanation == null) {
                ResolveConflictResult.$$$reportNull$$$0(2);
            }
            this.resolved = resolved2;
            this.resolvedPluginName = resolvedPluginName;
            this.oldPluginName = oldPluginName;
            this.notification = notification;
            this.explanation = explanation;
            this.approved = approved;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "explanation";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/fileTypes/impl/ConflictingFileTypeMappingTracker$ResolveConflictResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

