/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TextEditorState
implements FileEditorState {
    @NotNull
    @NotNull CaretState @NotNull [] CARETS = new CaretState[0];
    int RELATIVE_CARET_POSITION;
    private CodeFoldingState myFoldingState;
    private Supplier<? extends CodeFoldingState> myDelayedFoldInfoProducer;
    private static final int MIN_CHANGE_DISTANCE = 4;

    void setDelayedFoldState(@NotNull Supplier<? extends CodeFoldingState> producer) {
        if (producer == null) {
            TextEditorState.$$$reportNull$$$0(0);
        }
        this.myDelayedFoldInfoProducer = producer;
    }

    @Nullable
    Supplier<? extends CodeFoldingState> getDelayedFoldState() {
        return this.myDelayedFoldInfoProducer;
    }

    @Nullable
    CodeFoldingState getFoldingState() {
        if (this.myFoldingState == null && this.myDelayedFoldInfoProducer != null) {
            this.myFoldingState = this.myDelayedFoldInfoProducer.get();
            if (this.myFoldingState != null) {
                this.myDelayedFoldInfoProducer = null;
            }
        }
        return this.myFoldingState;
    }

    void setFoldingState(@Nullable CodeFoldingState foldingState) {
        this.myFoldingState = foldingState;
        this.myDelayedFoldInfoProducer = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextEditorState)) {
            return false;
        }
        TextEditorState textEditorState = (TextEditorState)o;
        if (!Arrays.equals(this.CARETS, textEditorState.CARETS)) {
            return false;
        }
        if (this.RELATIVE_CARET_POSITION != textEditorState.RELATIVE_CARET_POSITION) {
            return false;
        }
        CodeFoldingState localFoldingState = this.getFoldingState();
        CodeFoldingState theirFoldingState = textEditorState.getFoldingState();
        return Objects.equals(localFoldingState, theirFoldingState);
    }

    public int hashCode() {
        return Arrays.hashCode(this.CARETS);
    }

    public boolean canBeMergedWith(@NotNull FileEditorState otherState, @NotNull FileEditorStateLevel level) {
        if (otherState == null) {
            TextEditorState.$$$reportNull$$$0(1);
        }
        if (level == null) {
            TextEditorState.$$$reportNull$$$0(2);
        }
        if (!(otherState instanceof TextEditorState)) {
            return false;
        }
        TextEditorState other = (TextEditorState)otherState;
        return level == FileEditorStateLevel.NAVIGATION && this.CARETS.length == 1 && other.CARETS.length == 1 && Math.abs(this.CARETS[0].LINE - other.CARETS[0].LINE) < 4;
    }

    public String toString() {
        return Arrays.toString(this.CARETS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherState";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/text/TextEditorState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setDelayedFoldState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeMergedWith";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class CaretState {
        int LINE;
        int COLUMN;
        boolean LEAN_FORWARD;
        int VISUAL_COLUMN_ADJUSTMENT;
        int SELECTION_START_LINE;
        int SELECTION_START_COLUMN;
        int SELECTION_END_LINE;
        int SELECTION_END_COLUMN;

        CaretState() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof CaretState)) {
                return false;
            }
            CaretState caretState = (CaretState)o;
            if (this.COLUMN != caretState.COLUMN) {
                return false;
            }
            if (this.LINE != caretState.LINE) {
                return false;
            }
            if (this.VISUAL_COLUMN_ADJUSTMENT != caretState.VISUAL_COLUMN_ADJUSTMENT) {
                return false;
            }
            if (this.SELECTION_START_LINE != caretState.SELECTION_START_LINE) {
                return false;
            }
            if (this.SELECTION_START_COLUMN != caretState.SELECTION_START_COLUMN) {
                return false;
            }
            if (this.SELECTION_END_LINE != caretState.SELECTION_END_LINE) {
                return false;
            }
            return this.SELECTION_END_COLUMN == caretState.SELECTION_END_COLUMN;
        }

        public int hashCode() {
            return this.LINE + this.COLUMN;
        }

        public String toString() {
            return "[" + this.LINE + "," + this.COLUMN + "]";
        }
    }
}

