/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

final class OpenFilesActivity
implements StartupActivity {
    OpenFilesActivity() {
    }

    public void runActivity(@NotNull Project project) {
        FileEditorManager fileEditorManager;
        if (project == null) {
            OpenFilesActivity.$$$reportNull$$$0(0);
        }
        if (!((fileEditorManager = FileEditorManager.getInstance((Project)project)) instanceof FileEditorManagerImpl)) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(IdeBundle.message((String)"progress.text.reopening.files", (Object[])new Object[0]));
        }
        FileEditorManagerImpl manager2 = (FileEditorManagerImpl)fileEditorManager;
        EditorsSplitters editorSplitters = manager2.getMainSplitters();
        Ref<JPanel> panelRef = editorSplitters.restoreEditors();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (panelRef != null) {
                editorSplitters.doOpenFiles((JPanel)panelRef.get());
            }
            manager2.initDockableContentFactory();
            EditorsSplitters.stopOpenFilesActivity(project);
            if (!manager2.hasOpenFiles() && !ProjectUtil.isNotificationSilentMode((Project)project)) {
                project.putUserData(FileEditorManagerImpl.NOTHING_WAS_OPENED_ON_START, (Object)true);
                if (Registry.is((String)"ide.open.readme.md.on.startup")) {
                    RunOnceUtil.runOnceForProject((Project)project, (String)"ShowReadmeOnStart", () -> OpenFilesActivity.findAndOpenReadme(project, manager2));
                }
            }
        }, project.getDisposed());
    }

    private static void findAndOpenReadme(@NotNull Project project, @NotNull FileEditorManagerImpl manager2) {
        VirtualFile readme;
        VirtualFile dir;
        if (project == null) {
            OpenFilesActivity.$$$reportNull$$$0(1);
        }
        if (manager2 == null) {
            OpenFilesActivity.$$$reportNull$$$0(2);
        }
        if ((dir = ProjectUtil.guessProjectDir((Project)project)) != null && (readme = dir.findChild("README.md")) != null && !readme.isDirectory()) {
            readme.putUserData(TextEditorWithPreview.DEFAULT_LAYOUT_FOR_FILE, (Object)TextEditorWithPreview.Layout.SHOW_PREVIEW);
            ApplicationManager.getApplication().invokeLater(() -> manager2.openFile(readme, true), project.getDisposed());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/fileEditor/impl/OpenFilesActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndOpenReadme";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

