/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.MultiPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.impl.HTMLFileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import com.intellij.util.Alarm;
import com.intellij.util.AlarmFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000w\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0014\b\u0000\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\u001dH\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*H\u0016R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLFileEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/testFramework/LightVirtualFile;", "url", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/testFramework/LightVirtualFile;Ljava/lang/String;)V", "alarm", "Lcom/intellij/util/Alarm;", "Lorg/jetbrains/annotations/NotNull;", "contentPanel", "Lcom/intellij/ui/jcef/JCEFHtmlPanel;", "initial", "Ljava/util/concurrent/atomic/AtomicBoolean;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "multiPanel", "com/intellij/openapi/fileEditor/impl/HTMLFileEditor$multiPanel$1", "Lcom/intellij/openapi/fileEditor/impl/HTMLFileEditor$multiPanel$1;", "navigating", "addPropertyChangeListener", "", "listener", "Ljava/beans/PropertyChangeListener;", "dispose", "getComponent", "Ljavax/swing/JComponent;", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "getPreferredFocusedComponent", "isModified", "", "isValid", "removePropertyChangeListener", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "Companion", "intellij.platform.ide.impl"})
public final class HTMLFileEditor
extends UserDataHolderBase
implements FileEditor {
    private final JBLoadingPanel loadingPanel;
    private final JCEFHtmlPanel contentPanel;
    private final Alarm alarm;
    private final AtomicBoolean initial;
    private final AtomicBoolean navigating;
    private final multiPanel.1 multiPanel;
    private final Project project;
    private final LightVirtualFile file;
    @Deprecated
    private static final int LOADING_KEY = 1;
    @Deprecated
    private static final int CONTENT_KEY = 0;
    @NotNull
    private static final Companion Companion = new Companion(null);

    @NotNull
    public JComponent getComponent() {
        return this.multiPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.multiPanel;
    }

    @NotNull
    public String getName() {
        String string = IdeBundle.message((String)"tab.title.html.preview", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IdeBundle.message(\"tab.title.html.preview\")");
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.file;
    }

    public HTMLFileEditor(@NotNull Project project, @NotNull LightVirtualFile file2, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.project = project;
        this.file = file2;
        this.loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        this.contentPanel = new JCEFHtmlPanel(null);
        Alarm alarm2 = AlarmFactory.getInstance().create(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)alarm2, (String)"AlarmFactory.getInstance\u2026ToUse.SWING_THREAD, this)");
        this.alarm = alarm2;
        this.initial = new AtomicBoolean(true);
        this.navigating = new AtomicBoolean(false);
        this.multiPanel = new MultiPanel(this){
            final /* synthetic */ HTMLFileEditor this$0;

            @NotNull
            protected JComponent create(int key) {
                JComponent jComponent;
                switch (key) {
                    case 1: {
                        jComponent = (JComponent)HTMLFileEditor.access$getLoadingPanel$p(this.this$0);
                        break;
                    }
                    case 0: {
                        JComponent jComponent2 = HTMLFileEditor.access$getContentPanel$p(this.this$0).getComponent();
                        jComponent = jComponent2;
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"contentPanel.component");
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalArgumentException("Unknown key: " + key);
                    }
                }
                return jComponent;
            }

            @NotNull
            public ActionCallback select(int key, boolean now) {
                ActionCallback callback2 = super.select(key, now);
                if (key == 0) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
                        final /* synthetic */ multiPanel.1 this$0;

                        public final void run() {
                            HTMLFileEditor.access$getContentPanel$p(this.this$0.this$0).getComponent().requestFocusInWindow();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                ActionCallback actionCallback = callback2;
                Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"callback");
                return actionCallback;
            }
            {
                this.this$0 = this$0;
            }
        };
        this.loadingPanel.setLoadingText(CommonBundle.getLoadingTreeNodeText());
        this.contentPanel.getJBCefClient().addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(@NotNull CefBrowser browser2, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                Intrinsics.checkNotNullParameter((Object)browser2, (String)"browser");
                if (initial.get()) {
                    if (isLoading) {
                        ModalityState modalityState$iv = null;
                        boolean $i$f$invokeLater = false;
                        Application application = ApplicationManager.getApplication();
                        Runnable runnable2 = new Runnable(this){
                            final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                HTMLFileEditor.access$getLoadingPanel$p(this.this$0.this).startLoading();
                                multiPanel.1 v0 = HTMLFileEditor.access$getMultiPanel$p(this.this$0.this);
                                HTMLFileEditor.access$Companion();
                                v0.select(1, true);
                            }
                        };
                        ModalityState modalityState = ModalityState.defaultModalityState();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                        application.invokeLater(runnable2, modalityState);
                    } else {
                        alarm.cancelAllRequests();
                        initial.set(false);
                        ModalityState modalityState$iv = null;
                        boolean $i$f$invokeLater = false;
                        Application application = ApplicationManager.getApplication();
                        Runnable runnable3 = new Runnable(this){
                            final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final void run() {
                                boolean bl = false;
                                HTMLFileEditor.access$getLoadingPanel$p(this.this$0.this).stopLoading();
                                multiPanel.1 v0 = HTMLFileEditor.access$getMultiPanel$p(this.this$0.this);
                                HTMLFileEditor.access$Companion();
                                v0.select(0, true);
                            }
                        };
                        ModalityState modalityState = ModalityState.defaultModalityState();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
                        application.invokeLater(runnable3, modalityState);
                    }
                }
            }
        }, this.contentPanel.getCefBrowser());
        this.contentPanel.getJBCefClient().addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(){

            public boolean onBeforeBrowse(@NotNull CefBrowser browser2, @NotNull CefFrame frame, @NotNull CefRequest request, boolean userGesture, boolean isRedirect) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)browser2, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                if (userGesture) {
                    navigating.set(true);
                    BrowserUtil.browse((String)request.getURL());
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }, this.contentPanel.getCefBrowser());
        this.contentPanel.getJBCefClient().addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public boolean onBeforePopup(@NotNull CefBrowser browser2, @NotNull CefFrame frame, @NotNull String targetUrl, @Nullable String targetFrameName) {
                Intrinsics.checkNotNullParameter((Object)browser2, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
                Intrinsics.checkNotNullParameter((Object)targetUrl, (String)"targetUrl");
                BrowserUtil.browse((String)targetUrl);
                return true;
            }
        }, this.contentPanel.getCefBrowser());
        this.contentPanel.getJBCefClient().addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public void onStatusMessage(@NotNull CefBrowser browser2, @NlsSafe @NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)browser2, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                StatusBar.Info.set((String)text2, (Project)project);
            }
        }, this.contentPanel.getCefBrowser());
        this.contentPanel.setErrorPage(new JBCefBrowserBase.ErrorPage(){

            @Nullable
            public final String create(@NotNull CefLoadHandler.ErrorCode errorCode, @NotNull String errorText, @NotNull String failedUrl) {
                Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
                Intrinsics.checkNotNullParameter((Object)errorText, (String)"errorText");
                Intrinsics.checkNotNullParameter((Object)failedUrl, (String)"failedUrl");
                return errorCode == CefLoadHandler.ErrorCode.ERR_ABORTED && navigating.getAndSet(false) ? null : JBCefBrowserBase.ErrorPage.DEFAULT.create(errorCode, errorText, failedUrl);
            }
        });
        this.multiPanel.select(0, true);
        CharSequence charSequence = url;
        boolean bl = false;
        if (charSequence.length() > 0) {
            CharSequence charSequence2 = this.file.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"file.content");
            charSequence = charSequence2;
            bl = false;
            if (charSequence.length() == 0) {
                this.file.setContent((Object)this, (CharSequence)EditorBundle.message((String)"message.html.editor.timeout", (Object[])new Object[0]), false);
            }
            this.alarm.addRequest(new Runnable(){

                @Override
                public final void run() {
                    contentPanel.loadHTML(((Object)file.getContent()).toString());
                }
            }, Registry.intValue((String)"html.editor.timeout", (int)10000));
            this.contentPanel.loadURL(url);
        } else {
            this.contentPanel.loadHTML(((Object)this.file.getContent()).toString());
        }
    }

    public static final /* synthetic */ JBLoadingPanel access$getLoadingPanel$p(HTMLFileEditor $this) {
        return $this.loadingPanel;
    }

    public static final /* synthetic */ multiPanel.1 access$getMultiPanel$p(HTMLFileEditor $this) {
        return $this.multiPanel;
    }

    public static final /* synthetic */ Companion access$Companion() {
        return Companion;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLFileEditor$Companion;", "", "()V", "CONTENT_KEY", "", "LOADING_KEY", "intellij.platform.ide.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

