/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.impl.HTMLFileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.jcef.JBCefApp;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "Companion", "intellij.platform.ide.impl"})
public final class HTMLEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final Key<String> AFFINITY_KEY;
    private static final Key<FileEditor> EDITOR_KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        FileEditor fileEditor;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileEditor fileEditor2 = (FileEditor)file2.getUserData(EDITOR_KEY);
        if (fileEditor2 != null) {
            fileEditor = fileEditor2;
        } else {
            LightVirtualFile lightVirtualFile = (LightVirtualFile)file2;
            Object object = file2.getUserData(AFFINITY_KEY);
            Intrinsics.checkNotNull((Object)object);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.getUserData(AFFINITY_KEY)!!");
            HTMLFileEditor newEditor = new HTMLFileEditor(project, lightVirtualFile, (String)object);
            file2.putUserData(EDITOR_KEY, (Object)newEditor);
            fileEditor = newEditor;
        }
        return fileEditor;
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return JBCefApp.isSupported() && Companion.isHTMLEditor(file2);
    }

    @NotNull
    public String getEditorTypeId() {
        return "html-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"html.editor.affinity.key");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"html.editor.affinity.key\")");
        AFFINITY_KEY = key;
        Key key2 = Key.create((String)"html.editor.component.key");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"Key.create(\"html.editor.component.key\")");
        EDITOR_KEY = key2;
    }

    @JvmStatic
    public static final void openEditor(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DetailedDescription @NotNull String html) {
        Companion.openEditor(project, title, html);
    }

    @JvmStatic
    public static final void openEditor(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull String url, @NlsContexts.DetailedDescription @Nullable String timeoutHtml) {
        Companion.openEditor(project, title, url, timeoutHtml);
    }

    @JvmStatic
    public static final boolean isHTMLEditor(@NotNull VirtualFile file2) {
        return Companion.isHTMLEditor(file2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00052\b\b\u0001\u0010\u0011\u001a\u00020\u0005H\u0007J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\n\b\u0003\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/fileEditor/impl/HTMLEditorProvider$Companion;", "", "()V", "AFFINITY_KEY", "Lcom/intellij/openapi/util/Key;", "", "EDITOR_KEY", "Lcom/intellij/openapi/fileEditor/FileEditor;", "isHTMLEditor", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "openEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "html", "url", "timeoutHtml", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public final void openEditor(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NlsContexts.DetailedDescription @NotNull String html) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)html, (String)"html");
            LightVirtualFile file2 = new LightVirtualFile(title, (CharSequence)html);
            file2.putUserData(AFFINITY_KEY, (Object)"");
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file2, true);
        }

        @JvmStatic
        public final void openEditor(@NotNull Project project, @NlsContexts.DialogTitle @NotNull String title, @NotNull String url, @NlsContexts.DetailedDescription @Nullable String timeoutHtml) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            String string = timeoutHtml;
            if (string == null) {
                string = "";
            }
            LightVirtualFile file2 = new LightVirtualFile(title, (CharSequence)string);
            file2.putUserData(AFFINITY_KEY, (Object)url);
            FileEditorManager.getInstance((Project)project).openFile((VirtualFile)file2, true);
        }

        public static /* synthetic */ void openEditor$default(Companion companion, Project project, String string, String string2, String string3, int n, Object object) {
            if ((n & 8) != 0) {
                string3 = null;
            }
            companion.openEditor(project, string, string2, string3);
        }

        @JvmStatic
        public final boolean isHTMLEditor(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return file2.getUserData(AFFINITY_KEY) != null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

