/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="editorHistoryManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
public final class EditorHistoryManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(EditorHistoryManager.class);
    private final Project myProject;
    private final List<HistoryEntry> myEntriesList;

    public static EditorHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            EditorHistoryManager.$$$reportNull$$$0(0);
        }
        return (EditorHistoryManager)project.getService(EditorHistoryManager.class);
    }

    EditorHistoryManager(@NotNull Project project) {
        if (project == null) {
            EditorHistoryManager.$$$reportNull$$$0(1);
        }
        this.myEntriesList = new ArrayList<HistoryEntry>();
        this.myProject = project;
        SimpleMessageBusConnection connection = project.getMessageBus().simpleConnect();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.trimToSize());
        connection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before(){

            public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorHistoryManager.this.updateHistoryEntry(file2, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$1";
                objectArray[2] = "beforeFileClosed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyEditorManagerListener());
        FileEditorProvider.EP_FILE_EDITOR_PROVIDER.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileEditorProvider>(){

            public void extensionRemoved(@NotNull FileEditorProvider provider2, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                EditorHistoryManager.this.myEntriesList.forEach(e -> e.onProviderRemoval(provider2));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "provider";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$2";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    private synchronized void removeEntry(@NotNull HistoryEntry entry) {
        if (entry == null) {
            EditorHistoryManager.$$$reportNull$$$0(2);
        }
        if (this.myEntriesList.remove(entry)) {
            entry.destroy();
        }
    }

    private synchronized void moveOnTop(@NotNull HistoryEntry entry) {
        if (entry == null) {
            EditorHistoryManager.$$$reportNull$$$0(3);
        }
        this.myEntriesList.remove(entry);
        this.myEntriesList.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileOpenedImpl(@NotNull VirtualFile file2, @Nullable FileEditor fallbackEditor, @Nullable FileEditorProvider fallbackProvider) {
        FileEditorProvider[] oldProviders;
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!(file2 instanceof IncludeInEditorHistoryFile) && VirtualFileManager.getInstance().findFileByUrl(file2.getUrl()) == null) {
            return;
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file2);
        Object[] editors2 = (FileEditor[])editorsWithProviders.getFirst();
        LOG.assertTrue(editors2.length == (oldProviders = (FileEditorProvider[])editorsWithProviders.getSecond()).length, (Object)"Different number of editors and providers");
        if (editors2.length <= 0 && fallbackEditor != null && fallbackProvider != null) {
            editors2 = new FileEditor[]{fallbackEditor};
            oldProviders = new FileEditorProvider[]{fallbackProvider};
        }
        if (editors2.length <= 0) {
            return;
        }
        FileEditor selectedEditor = editorManager.getSelectedEditor(file2);
        if (selectedEditor == null) {
            selectedEditor = fallbackEditor;
        }
        LOG.assertTrue(selectedEditor != null);
        int selectedProviderIndex = ArrayUtilRt.find((Object[])editors2, (Object)selectedEditor);
        LOG.assertTrue(selectedProviderIndex != -1, (Object)("Can't find " + selectedEditor + " among " + Arrays.asList(editors2)));
        HistoryEntry entry = this.getEntry(file2);
        if (entry != null) {
            this.moveOnTop(entry);
        } else {
            FileEditorState[] states = new FileEditorState[editors2.length];
            FileEditorProvider[] providers = new FileEditorProvider[editors2.length];
            for (int i2 = states.length - 1; i2 >= 0; --i2) {
                FileEditorProvider provider2 = oldProviders[i2];
                LOG.assertTrue(provider2 != null);
                providers[i2] = provider2;
                Object editor = editors2[i2];
                if (!editor.isValid()) continue;
                states[i2] = editor.getState(FileEditorStateLevel.FULL);
            }
            EditorHistoryManager editorHistoryManager = this;
            synchronized (editorHistoryManager) {
                this.myEntriesList.add(HistoryEntry.createHeavy(this.myProject, file2, providers, states, providers[selectedProviderIndex]));
            }
            this.trimToSize();
        }
    }

    public void updateHistoryEntry(@NotNull VirtualFile file2, boolean changeEntryOrderOnly) {
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(5);
        }
        this.updateHistoryEntry(file2, null, null, changeEntryOrderOnly);
    }

    private void updateHistoryEntry(@NotNull VirtualFile file2, @Nullable FileEditor fileEditor, @Nullable FileEditorProvider fileEditorProvider, boolean changeEntryOrderOnly) {
        FileEditorWithProvider selectedEditorWithProvider;
        FileEditorProvider[] providers;
        FileEditor[] editors2;
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(6);
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        if (fileEditor == null || fileEditorProvider == null) {
            Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file2);
            editors2 = (FileEditor[])editorsWithProviders.getFirst();
            providers = (FileEditorProvider[])editorsWithProviders.getSecond();
        } else {
            editors2 = new FileEditor[]{fileEditor};
            providers = new FileEditorProvider[]{fileEditorProvider};
        }
        if (editors2.length == 0) {
            return;
        }
        HistoryEntry entry = this.getEntry(file2);
        if (entry == null) {
            if (file2.isValid()) {
                this.fileOpenedImpl(file2, fileEditor, fileEditorProvider);
            }
            return;
        }
        if (!changeEntryOrderOnly) {
            for (int i2 = editors2.length - 1; i2 >= 0; --i2) {
                FileEditor editor = editors2[i2];
                FileEditorProvider provider2 = providers[i2];
                if (provider2 == null || !editor.isValid()) continue;
                FileEditorState oldState = entry.getState(provider2);
                FileEditorState newState2 = editor.getState(FileEditorStateLevel.FULL);
                if (newState2.equals(oldState)) continue;
                entry.putState(provider2, newState2);
            }
        }
        if ((selectedEditorWithProvider = editorManager.getSelectedEditorWithProvider(file2)) != null) {
            entry.setSelectedProvider(selectedEditorWithProvider.getProvider());
            LOG.assertTrue(entry.getSelectedProvider() != null);
            if (changeEntryOrderOnly) {
                this.moveOnTop(entry);
            }
        }
    }

    public synchronized VirtualFile @NotNull [] getFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(this.myEntriesList.size());
        for (HistoryEntry entry : this.myEntriesList) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            EditorHistoryManager.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @VisibleForTesting
    public synchronized void removeAllFiles() {
        for (HistoryEntry entry : this.myEntriesList) {
            entry.destroy();
        }
        this.myEntriesList.clear();
    }

    @NotNull
    public synchronized List<VirtualFile> getFileList() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (HistoryEntry entry : this.myEntriesList) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            EditorHistoryManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public synchronized LinkedHashSet<VirtualFile> getFileSet() {
        return new LinkedHashSet<VirtualFile>(this.getFileList());
    }

    public synchronized boolean hasBeenOpen(@NotNull VirtualFile f) {
        if (f == null) {
            EditorHistoryManager.$$$reportNull$$$0(9);
        }
        for (HistoryEntry each : this.myEntriesList) {
            if (!f.equals(each.getFile())) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeFile(@NotNull VirtualFile file2) {
        HistoryEntry entry;
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(10);
        }
        if ((entry = this.getEntry(file2)) != null) {
            this.removeEntry(entry);
        }
    }

    public FileEditorState getState(@NotNull VirtualFile file2, @NotNull FileEditorProvider provider2) {
        HistoryEntry entry;
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(11);
        }
        if (provider2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(12);
        }
        return (entry = this.getEntry(file2)) != null ? entry.getState(provider2) : null;
    }

    FileEditorProvider getSelectedProvider(@NotNull VirtualFile file2) {
        HistoryEntry entry;
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(13);
        }
        return (entry = this.getEntry(file2)) != null ? entry.getSelectedProvider() : null;
    }

    private synchronized HistoryEntry getEntry(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorHistoryManager.$$$reportNull$$$0(14);
        }
        for (int i2 = this.myEntriesList.size() - 1; i2 >= 0; --i2) {
            HistoryEntry entry = this.myEntriesList.get(i2);
            VirtualFile entryFile = entry.getFile();
            if (!file2.equals(entryFile)) continue;
            return entry;
        }
        return null;
    }

    private synchronized void trimToSize() {
        int limit = UISettings.getInstance().getRecentFilesLimit() + 1;
        while (this.myEntriesList.size() > limit) {
            HistoryEntry removed = this.myEntriesList.remove(0);
            removed.destroy();
        }
    }

    public synchronized void loadState(@NotNull Element state) {
        if (state == null) {
            EditorHistoryManager.$$$reportNull$$$0(15);
        }
        this.removeAllFiles();
        LinkedHashMap<String, Element> fileToElement = new LinkedHashMap<String, Element>();
        for (Element e : state.getChildren("entry")) {
            String file2 = e.getAttributeValue("file");
            fileToElement.remove(file2);
            fileToElement.put(file2, e);
        }
        for (Element e : fileToElement.values()) {
            try {
                this.myEntriesList.add(HistoryEntry.createHeavy(this.myProject, e));
            }
            catch (ProcessCanceledException file2) {
            }
            catch (Exception anyException) {
                LOG.error((Throwable)anyException);
            }
        }
    }

    public synchronized Element getState() {
        Element element2 = new Element("state");
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
        for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
            VirtualFile file2 = openFiles[i2];
            if (this.getEntry(file2) == null) continue;
            this.updateHistoryEntry(file2, false);
        }
        for (HistoryEntry entry : this.myEntriesList) {
            entry.writeExternal(element2, this.myProject);
        }
        return element2;
    }

    public synchronized void dispose() {
        this.removeAllFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeEntry";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "moveOnTop";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fileOpenedImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateHistoryEntry";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasBeenOpen";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyEditorManagerListener
    implements FileEditorManagerListener {
        private MyEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            if (source == null) {
                MyEditorManagerListener.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                MyEditorManagerListener.$$$reportNull$$$0(1);
            }
            EditorHistoryManager.this.fileOpenedImpl(file2, null, null);
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            if (event == null) {
                MyEditorManagerListener.$$$reportNull$$$0(2);
            }
            PsiDocumentManager.getInstance((Project)EditorHistoryManager.this.myProject).performWhenAllCommitted(() -> {
                VirtualFile newFile;
                FileEditor newEditor = event.getNewEditor();
                if (newEditor != null && !newEditor.isValid()) {
                    return;
                }
                VirtualFile oldFile = event.getOldFile();
                if (oldFile != null) {
                    EditorHistoryManager.this.updateHistoryEntry(oldFile, event.getOldEditor(), event.getOldProvider(), false);
                }
                if ((newFile = event.getNewFile()) != null) {
                    EditorHistoryManager.this.updateHistoryEntry(newFile, true);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$MyEditorManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileOpened";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    public static interface IncludeInEditorHistoryFile {
    }

    static final class EditorHistoryManagerStartUpActivity
    implements StartupActivity.DumbAware {
        EditorHistoryManagerStartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            if (project == null) {
                EditorHistoryManagerStartUpActivity.$$$reportNull$$$0(0);
            }
            EditorHistoryManager.getInstance(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/EditorHistoryManager$EditorHistoryManagerStartUpActivity", "runActivity"));
        }
    }
}

