/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.google.common.collect.Sets;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class PersistentFileSetManager
implements PersistentStateComponent<Element> {
    private static final String FILE_ELEMENT = "file";
    private static final String PATH_ATTR = "url";
    private final Set<VirtualFile> myFiles = new HashSet<VirtualFile>();

    PersistentFileSetManager() {
    }

    protected boolean addFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(0);
        }
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        if (this.myFiles.add(file2)) {
            this.onFileSettingsChanged(Collections.singleton(file2));
        }
        return true;
    }

    protected boolean containsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(1);
        }
        return this.myFiles.contains(file2);
    }

    protected boolean removeFile(@NotNull VirtualFile file2) {
        boolean isRemoved;
        if (file2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(2);
        }
        if (isRemoved = this.myFiles.remove(file2)) {
            this.onFileSettingsChanged(Collections.singleton(file2));
        }
        return isRemoved;
    }

    protected void onFileSettingsChanged(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(3);
        }
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        Set<VirtualFile> set2 = this.myFiles;
        if (set2 == null) {
            PersistentFileSetManager.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @NotNull
    private Collection<VirtualFile> getSortedFiles() {
        ArrayList<VirtualFile> sortedFiles = new ArrayList<VirtualFile>(this.myFiles);
        sortedFiles.sort(Comparator.comparing(file2 -> StringUtil.toLowerCase((String)file2.getPath())));
        ArrayList<VirtualFile> arrayList = sortedFiles;
        if (arrayList == null) {
            PersistentFileSetManager.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public Element getState() {
        Element root = new Element("root");
        for (VirtualFile vf : this.getSortedFiles()) {
            Element vfElement = new Element(FILE_ELEMENT);
            Attribute filePathAttr = new Attribute(PATH_ATTR, VfsUtilCore.pathToUrl((String)vf.getPath()));
            vfElement.setAttribute(filePathAttr);
            root.addContent(vfElement);
        }
        return root;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            PersistentFileSetManager.$$$reportNull$$$0(6);
        }
        THashSet oldFiles = new THashSet(this.myFiles);
        this.myFiles.clear();
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        for (Element fileElement : state.getChildren(FILE_ELEMENT)) {
            String filePath;
            VirtualFile vf;
            Attribute filePathAttr = fileElement.getAttribute(PATH_ATTR);
            if (filePathAttr == null || (vf = vfManager.findFileByUrl(filePath = filePathAttr.getValue())) == null) continue;
            this.myFiles.add(vf);
        }
        Sets.SetView toReparse = Sets.symmetricDifference(this.myFiles, (Set)oldFiles);
        this.onFileSettingsChanged((Collection<VirtualFile>)toReparse);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_ELEMENT;
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/file/exclude/PersistentFileSetManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/file/exclude/PersistentFileSetManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onFileSettingsChanged";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

