/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectNode
extends ExternalSystemNode<ProjectData> {
    @Nls
    private String myTooltipCache;
    private ModuleNode effectiveRoot = null;

    public ProjectNode(ExternalProjectsView externalProjectsView, DataNode<ProjectData> projectDataNode) {
        super(externalProjectsView, null, projectDataNode);
        this.updateProject();
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            ProjectNode.$$$reportNull$$$0(0);
        }
        super.update(presentation2);
        presentation2.setIcon(this.getUiAware().getProjectIcon());
    }

    public ExternalSystemNode getGroup() {
        return (ExternalSystemNode)this.getParent();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
        this.setIdeGrouping(null);
        List<ExternalSystemNode<?>> children2 = super.doBuildChildren();
        List visibleChildren = ContainerUtil.filter(children2, node -> node.isVisible());
        if (this.getExternalProjectsView().getGroupModules()) {
            ExternalSystemNode child2;
            List topLevelChildren = ContainerUtil.filter((Collection)visibleChildren, node -> !(node instanceof ModuleNode) || ((ModuleNode)node).getIdeParentGrouping() == null);
            if (topLevelChildren.size() == 1 && (child2 = (ExternalSystemNode)topLevelChildren.get(0)) instanceof ModuleNode) {
                this.effectiveRoot = (ModuleNode)child2;
                List<ExternalSystemNode<?>> list2 = this.effectiveRoot.doBuildChildren();
                if (list2 == null) {
                    ProjectNode.$$$reportNull$$$0(1);
                }
                return list2;
            }
            List list3 = topLevelChildren;
            if (list3 == null) {
                ProjectNode.$$$reportNull$$$0(2);
            }
            return list3;
        }
        this.effectiveRoot = null;
        List list4 = visibleChildren;
        if (list4 == null) {
            ProjectNode.$$$reportNull$$$0(3);
        }
        return list4;
    }

    void updateProject() {
        this.myTooltipCache = this.makeDescription();
        this.getStructure().updateFrom(this.getParent());
    }

    @Override
    protected void doUpdate() {
        this.setNameAndTooltip(this.getName(), this.myTooltipCache);
    }

    @NlsSafe
    private String makeDescription() {
        ProjectData projectData2 = (ProjectData)this.getData();
        StringBuilder desc = new StringBuilder();
        desc.append(ExternalSystemBundle.message((String)"external.project.structure.project", (Object[])new Object[0])).append(": ").append(this.getName());
        if (projectData2 != null) {
            desc.append("\n\r").append(ExternalSystemBundle.message((String)"external.project.structure.project.location", (Object[])new Object[0])).append(": ").append(projectData2.getLinkedExternalProjectPath());
            String description = projectData2.getDescription();
            if (!StringUtil.isEmptyOrSpaces((String)description)) {
                desc.append("\n\r").append(description);
            }
        }
        return desc.toString();
    }

    @Nullable
    public String getIdeGrouping() {
        ProjectData data2 = (ProjectData)this.getData();
        if (data2 == null) {
            return null;
        }
        return data2.getIdeGrouping();
    }

    private void setIdeGrouping(@Nullable String ideGrouping) {
        ProjectData data2 = (ProjectData)this.getData();
        if (data2 != null) {
            data2.setIdeGrouping(ideGrouping);
        }
    }

    @Override
    @Nullable
    @NonNls
    protected String getMenuId() {
        return "ExternalSystemView.ProjectMenu";
    }

    public ModuleNode getEffectiveRoot() {
        return this.effectiveRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ProjectNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ProjectNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

