/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector$$special$;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Version;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getGroupId", "", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "ExternalSystemTaskId", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemUsagesCollector
extends ProjectUsagesCollector {
    private static final EnumEventField<ExternalSystemTaskId> TASK_ID_FIELD;
    private static final StringEventField TARGET_FIELD;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getGroupId() {
        return "build.tools";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        Set usages;
        block3: {
            Module module;
            boolean bl;
            Module[] moduleArray;
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                boolean bl2 = false;
                usages = new LinkedHashSet();
                for (ExternalSystemManager manager2 : ExternalSystemApiUtil.getAllManagers()) {
                    if (((AbstractExternalSystemSettings)manager2.getSettingsProvider().fun((Object)project)).getLinkedProjectsSettings().isEmpty()) continue;
                    ProjectSystemId projectSystemId = manager2.getSystemId();
                    Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"manager.getSystemId()");
                    usages.add(MetricEventFactoryKt.newMetric((String)"externalSystemId", (String)ExternalSystemStatUtilKt.getAnonymizedSystemId(projectSystemId)));
                }
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray2 = moduleManager.getModules();
                Intrinsics.checkNotNullExpressionValue((Object)moduleArray2, (String)"ModuleManager.getInstance(project).modules");
                moduleArray = moduleArray2;
                bl = false;
                Module[] moduleArray3 = moduleArray;
                boolean bl3 = false;
                Module[] moduleArray4 = moduleArray3;
                int n = moduleArray4.length;
                for (int j = 0; j < n; ++j) {
                    Module module2;
                    Module it = module2 = moduleArray4[j];
                    boolean bl4 = false;
                    Module module3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"it");
                    if (!ExternalSystemModulePropertyManager.Companion.getInstance(module3).isMavenized()) continue;
                    module = module2;
                    break block2;
                }
                module = null;
            }
            if (module == null) break block3;
            moduleArray = module;
            bl = false;
            boolean bl5 = false;
            Module[] it = moduleArray;
            boolean bl6 = false;
            usages.add(MetricEventFactoryKt.newMetric((String)"externalSystemId", (String)"Maven"));
        }
        return usages;
    }

    static {
        Companion = new Companion(null);
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "task_id";
        Function1 transform$iv = $special$$inlined$Enum$1.INSTANCE;
        boolean $i$f$Enum = false;
        TASK_ID_FIELD = new EnumEventField(name$iv, ExternalSystemTaskId.class, transform$iv);
        TARGET_FIELD = EventFields.StringValidatedByCustomRule((String)"target", (String)"run_target");
    }

    public static final /* synthetic */ EnumEventField access$getTASK_ID_FIELD$cp() {
        return TASK_ID_FIELD;
    }

    public static final /* synthetic */ StringEventField access$getTARGET_FIELD$cp() {
        return TARGET_FIELD;
    }

    @JvmStatic
    @NotNull
    public static final IdeActivity externalSystemTaskStarted(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull ExternalSystemTaskId taskId, @Nullable TargetEnvironmentConfigurationProvider environmentConfigurationProvider) {
        return Companion.externalSystemTaskStarted(project, systemId2, taskId, environmentConfigurationProvider);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$ExternalSystemTaskId;", "", "(Ljava/lang/String;I)V", "ResolveProject", "ExecuteTask", "intellij.platform.externalSystem.impl"})
    public static final class ExternalSystemTaskId
    extends Enum<ExternalSystemTaskId> {
        public static final /* enum */ ExternalSystemTaskId ResolveProject;
        public static final /* enum */ ExternalSystemTaskId ExecuteTask;
        private static final /* synthetic */ ExternalSystemTaskId[] $VALUES;

        static {
            ExternalSystemTaskId[] externalSystemTaskIdArray = new ExternalSystemTaskId[2];
            ExternalSystemTaskId[] externalSystemTaskIdArray2 = externalSystemTaskIdArray;
            externalSystemTaskIdArray[0] = ResolveProject = new ExternalSystemTaskId();
            externalSystemTaskIdArray[1] = ExecuteTask = new ExternalSystemTaskId();
            $VALUES = externalSystemTaskIdArray;
        }

        public static ExternalSystemTaskId[] values() {
            return (ExternalSystemTaskId[])$VALUES.clone();
        }

        public static ExternalSystemTaskId valueOf(String string) {
            return Enum.valueOf(ExternalSystemTaskId.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$Companion;", "", "()V", "TARGET_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "TASK_ID_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemUsagesCollector$ExternalSystemTaskId;", "externalSystemTaskStarted", "Lcom/intellij/internal/statistic/IdeActivity;", "project", "Lcom/intellij/openapi/project/Project;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "taskId", "environmentConfigurationProvider", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "getJRETypeUsage", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "key", "", "jreName", "getJREVersionUsage", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @NotNull
        public final MetricEvent getJRETypeUsage(@NotNull String key, @Nullable String jreName) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            CharSequence charSequence = jreName;
            boolean bl = false;
            boolean bl2 = false;
            String anonymizedName = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "empty" : (CollectionsKt.listOf((Object[])new String[]{"#JAVA_INTERNAL", "#USE_PROJECT_JDK", "#JAVA_HOME"}).contains(jreName) ? jreName : "custom");
            return MetricEventFactoryKt.newMetric((String)key, (String)anonymizedName);
        }

        @NotNull
        public final MetricEvent getJREVersionUsage(@NotNull Project project, @NotNull String key, @Nullable String jreName) {
            Object object;
            block6: {
                block5: {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Sdk jdk = ExternalSystemJdkUtil.getJdk(project, jreName);
                    object = jdk;
                    if (object == null || (object = object.getVersionString()) == null) break block5;
                    Object object2 = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object2;
                    boolean bl3 = false;
                    Version version2 = Version.parseVersion((String)it);
                    if (version2 != null) {
                        Version version3 = version2;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        Version parsed = version3;
                        boolean bl6 = false;
                        string = "" + parsed.major + '.' + parsed.minor;
                    } else {
                        string = object = null;
                    }
                    if (string != null) break block6;
                }
                object = "unknown";
            }
            Object versionString = object;
            return MetricEventFactoryKt.newMetric((String)key, (String)versionString);
        }

        @JvmStatic
        @NotNull
        public final IdeActivity externalSystemTaskStarted(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull ExternalSystemTaskId taskId, @Nullable TargetEnvironmentConfigurationProvider environmentConfigurationProvider) {
            Intrinsics.checkNotNullParameter((Object)((Object)taskId), (String)"taskId");
            return new IdeActivity(project, "external.project.task", null, 4, null).startedWithData((Consumer)new Consumer<FeatureUsageData>(systemId2, taskId, environmentConfigurationProvider){
                final /* synthetic */ ProjectSystemId $systemId;
                final /* synthetic */ ExternalSystemTaskId $taskId;
                final /* synthetic */ TargetEnvironmentConfigurationProvider $environmentConfigurationProvider;

                public final void accept(@NotNull FeatureUsageData data2) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
                        ExternalSystemStatUtilKt.addExternalSystemId(data2, this.$systemId);
                        new EventPair((EventField)ExternalSystemUsagesCollector.access$getTASK_ID_FIELD$cp(), (Object)((Object)this.$taskId)).addData(data2);
                        Object object = this.$environmentConfigurationProvider;
                        if (object == null || (object = object.getEnvironmentConfiguration()) == null || (object = object.getTypeId()) == null) break block0;
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        new EventPair((EventField)ExternalSystemUsagesCollector.access$getTARGET_FIELD$cp(), it).addData(data2);
                    }
                }
                {
                    this.$systemId = projectSystemId;
                    this.$taskId = externalSystemTaskId;
                    this.$environmentConfigurationProvider = targetEnvironmentConfigurationProvider;
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

