/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.execution.Executor;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector$$special$;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00062\u00020\u0001:\u0002\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemActionsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "ActionId", "Companion", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemActionsCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final StringEventField EXTERNAL_SYSTEM_ID;
    private static final StringEventField ACTION_EXECUTOR_FIELD;
    private static final EnumEventField<ActionId> DELEGATE_ACTION_ID;
    private static final VarargEventId ACTION_INVOKED;
    private static final VarargEventId DELEGATE_ACTION_INVOKED;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    static {
        Companion = new Companion(null);
        GROUP = new EventLogGroup("build.tools.actions", 4);
        EXTERNAL_SYSTEM_ID = EventFields.StringValidatedByEnum((String)"system_id", (String)"build_tools");
        ACTION_EXECUTOR_FIELD = EventFields.StringValidatedByCustomRule((String)"executor", (String)"run_config_executor");
        EventFields eventFields = EventFields.INSTANCE;
        String name$iv = "action_id";
        Function1 transform$iv = $special$$inlined$Enum$1.INSTANCE;
        boolean $i$f$Enum = false;
        DELEGATE_ACTION_ID = new EnumEventField(name$iv, ActionId.class, transform$iv);
        ACTION_INVOKED = ActionsEventLogGroup.Companion.registerActionInvokedEvent(GROUP, "action.invoked", (EventField)EXTERNAL_SYSTEM_ID);
        DELEGATE_ACTION_INVOKED = GROUP.registerVarargEvent("action.invoked", new EventField[]{(EventField)DELEGATE_ACTION_ID, (EventField)EventFields.ActionPlace, (EventField)ActionsEventLogGroup.CONTEXT_MENU, (EventField)ACTION_EXECUTOR_FIELD, (EventField)EXTERNAL_SYSTEM_ID});
    }

    @JvmStatic
    public static final void trigger(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull ActionId actionId, @Nullable String place, boolean isFromContextMenu, @Nullable Executor executor) {
        Companion.trigger(project, systemId2, actionId, place, isFromContextMenu, executor);
    }

    @JvmStatic
    public static final void trigger(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull AnAction action2, @NotNull AnActionEvent event) {
        Companion.trigger(project, systemId2, action2, event);
    }

    @JvmStatic
    public static final void trigger(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull ActionId action2, @NotNull AnActionEvent event, @Nullable Executor executor) {
        Companion.trigger(project, systemId2, action2, event, executor);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemActionsCollector$ActionId;", "", "(Ljava/lang/String;I)V", "RunExternalSystemTaskAction", "ExecuteExternalSystemRunConfigurationAction", "intellij.platform.externalSystem.impl"})
    public static final class ActionId
    extends Enum<ActionId> {
        public static final /* enum */ ActionId RunExternalSystemTaskAction;
        public static final /* enum */ ActionId ExecuteExternalSystemRunConfigurationAction;
        private static final /* synthetic */ ActionId[] $VALUES;

        static {
            ActionId[] actionIdArray = new ActionId[2];
            ActionId[] actionIdArray2 = actionIdArray;
            actionIdArray[0] = RunExternalSystemTaskAction = new ActionId();
            actionIdArray[1] = ExecuteExternalSystemRunConfigurationAction = new ActionId();
            $VALUES = actionIdArray;
        }

        public static ActionId[] values() {
            return (ActionId[])$VALUES.clone();
        }

        public static ActionId valueOf(String string) {
            return Enum.valueOf(ActionId.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J8\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007JB\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemActionsCollector$Companion;", "", "()V", "ACTION_EXECUTOR_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "ACTION_INVOKED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "DELEGATE_ACTION_ID", "Lcom/intellij/internal/statistic/eventLog/events/EnumEventField;", "Lcom/intellij/openapi/externalSystem/statistics/ExternalSystemActionsCollector$ActionId;", "DELEGATE_ACTION_INVOKED", "EXTERNAL_SYSTEM_ID", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "trigger", "", "project", "Lcom/intellij/openapi/project/Project;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "executor", "Lcom/intellij/execution/Executor;", "actionId", "place", "", "isFromContextMenu", "", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @JvmStatic
        public final void trigger(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull ActionId actionId, @Nullable String place, boolean isFromContextMenu, @Nullable Executor executor) {
            Intrinsics.checkNotNullParameter((Object)((Object)actionId), (String)"actionId");
            List data2 = CollectionsKt.arrayListOf((Object[])new EventPair[]{DELEGATE_ACTION_ID.with((Object)actionId)});
            if (place != null) {
                data2.add(EventFields.ActionPlace.with((Object)place));
                data2.add(ActionsEventLogGroup.CONTEXT_MENU.with((Object)isFromContextMenu));
            }
            Executor executor2 = executor;
            if (executor2 != null) {
                Executor executor3 = executor2;
                boolean bl = false;
                boolean bl2 = false;
                Executor it = executor3;
                boolean bl3 = false;
                data2.add(ACTION_EXECUTOR_FIELD.with((Object)it.getId()));
            }
            data2.add(EXTERNAL_SYSTEM_ID.with((Object)ExternalSystemStatUtilKt.anonymizeSystemId(systemId2)));
            Collection $this$toTypedArray$iv = data2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            EventPair[] eventPairArray = thisCollection$iv.toArray(new EventPair[0]);
            if (eventPairArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            DELEGATE_ACTION_INVOKED.log(project, Arrays.copyOf(eventPairArray, eventPairArray.length));
        }

        public static /* synthetic */ void trigger$default(Companion companion, Project project, ProjectSystemId projectSystemId, ActionId actionId, String string, boolean bl, Executor executor, int n, Object object) {
            if ((n & 0x20) != 0) {
                executor = null;
            }
            companion.trigger(project, projectSystemId, actionId, string, bl, executor);
        }

        @JvmStatic
        public final void trigger(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull AnAction action2, @NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ActionsCollectorImpl.record(ACTION_INVOKED, project, action2, event, CollectionsKt.listOf((Object)EXTERNAL_SYSTEM_ID.with((Object)ExternalSystemStatUtilKt.anonymizeSystemId(systemId2))));
        }

        @JvmStatic
        public final void trigger(@Nullable Project project, @Nullable ProjectSystemId systemId2, @NotNull ActionId action2, @NotNull AnActionEvent event, @Nullable Executor executor) {
            Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.trigger(project, systemId2, action2, event.getPlace(), event.isFromContextMenu(), executor);
        }

        public static /* synthetic */ void trigger$default(Companion companion, Project project, ProjectSystemId projectSystemId, ActionId actionId, AnActionEvent anActionEvent, Executor executor, int n, Object object) {
            if ((n & 0x10) != 0) {
                executor = null;
            }
            companion.trigger(project, projectSystemId, actionId, anActionEvent, executor);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

