/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.internal;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.ExternalSystemFacadeManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemExecutionAware;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.externalSystem.service.internal.AbstractExternalSystemTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemUsagesCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.keyFMap.KeyFMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecuteTaskTask
extends AbstractExternalSystemTask {
    @NotNull
    private final List<String> myTasksToExecute;
    @Nullable
    private final String myVmOptions;
    @Nullable
    private String myArguments;
    @Nullable
    private final String myJvmParametersSetup;
    private final boolean myPassParentEnvs;
    private final Map<String, String> myEnv;
    @NotNull
    private final ExternalSystemRunConfiguration myConfiguration;

    public ExternalSystemExecuteTaskTask(@NotNull Project project, @NotNull ExternalSystemTaskExecutionSettings settings, @Nullable String jvmParametersSetup, @NotNull ExternalSystemRunConfiguration configuration2) throws IllegalArgumentException {
        if (project == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(1);
        }
        if (configuration2 == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(2);
        }
        super(settings.getExternalSystemId(), ExternalSystemTaskType.EXECUTE_TASK, project, settings.getExternalProjectPath());
        this.myTasksToExecute = new ArrayList<String>(settings.getTaskNames());
        this.myVmOptions = settings.getVmOptions();
        this.myArguments = settings.getScriptParameters();
        this.myPassParentEnvs = settings.isPassParentEnvs();
        this.myEnv = settings.getEnv();
        this.myJvmParametersSetup = jvmParametersSetup;
        this.myConfiguration = configuration2;
    }

    @NotNull
    public List<String> getTasksToExecute() {
        List<String> list2 = this.myTasksToExecute;
        if (list2 == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Nullable
    public String getVmOptions() {
        return this.myVmOptions;
    }

    @Nullable
    public String getArguments() {
        return this.myArguments;
    }

    public void appendArguments(@NotNull String arguments) {
        if (arguments == null) {
            ExternalSystemExecuteTaskTask.$$$reportNull$$$0(4);
        }
        this.myArguments = this.myArguments == null ? arguments : this.myArguments + " " + arguments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        RemoteExternalSystemTaskManager<ExternalSystemExecutionSettings> taskManager;
        ExternalSystemExecutionSettings settings;
        ExternalSystemProgressNotificationManagerImpl progressNotificationManager = (ExternalSystemProgressNotificationManagerImpl)ApplicationManager.getApplication().getService(ExternalSystemProgressNotificationManager.class);
        ExternalSystemTaskId id2 = this.getId();
        String projectPath = this.getExternalProjectPath();
        TargetEnvironmentConfigurationProvider environmentConfigurationProvider = null;
        try {
            progressNotificationManager.onStart(id2, projectPath);
            Project project = this.getIdeProject();
            ProjectSystemId projectSystemId = this.getExternalSystemId();
            ExternalSystemTaskNotificationListener progressNotificationListener = ExternalSystemExecuteTaskTask.wrapWithListener(progressNotificationManager);
            for (ExternalSystemExecutionAware executionAware : ExternalSystemExecutionAware.getExtensions(projectSystemId)) {
                executionAware.prepareExecution(this, projectPath, false, progressNotificationListener, project);
                if (environmentConfigurationProvider != null) continue;
                environmentConfigurationProvider = executionAware.getEnvironmentConfigurationProvider(this.myConfiguration, project);
            }
            ExternalSystemFacadeManager manager2 = (ExternalSystemFacadeManager)ApplicationManager.getApplication().getService(ExternalSystemFacadeManager.class);
            settings = ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)projectPath, (ProjectSystemId)projectSystemId);
            KeyFMap keyFMap = this.getUserMap();
            for (Key key : keyFMap.getKeys()) {
                settings.putUserData(key, keyFMap.get(key));
            }
            ExternalSystemExecutionAware.Companion.setEnvironmentConfigurationProvider(settings, environmentConfigurationProvider);
            RemoteExternalSystemFacade facade = manager2.getFacade(project, projectPath, projectSystemId);
            taskManager = facade.getTaskManager();
            List<String> vmOptions = ExternalSystemExecuteTaskTask.parseCmdParameters(this.myVmOptions);
            List<String> arguments = ExternalSystemExecuteTaskTask.parseCmdParameters(this.myArguments);
            settings.withVmOptions(vmOptions).withArguments(arguments).withEnvironmentVariables(this.myEnv).passParentEnvs(this.myPassParentEnvs);
        }
        catch (Exception e) {
            progressNotificationManager.onFailure(id2, e);
            progressNotificationManager.onEnd(id2);
            throw e;
        }
        IdeActivity activity = ExternalSystemUsagesCollector.externalSystemTaskStarted(this.getIdeProject(), this.getExternalSystemId(), ExternalSystemUsagesCollector.ExternalSystemTaskId.ExecuteTask, environmentConfigurationProvider);
        try {
            taskManager.executeTasks(id2, this.myTasksToExecute, projectPath, settings, this.myJvmParametersSetup);
        }
        finally {
            activity.finished();
        }
    }

    @Override
    protected boolean doCancel() throws Exception {
        ExternalSystemFacadeManager manager2 = (ExternalSystemFacadeManager)ApplicationManager.getApplication().getService(ExternalSystemFacadeManager.class);
        RemoteExternalSystemFacade facade = manager2.getFacade(this.getIdeProject(), this.getExternalProjectPath(), this.getExternalSystemId());
        RemoteExternalSystemTaskManager taskManager = facade.getTaskManager();
        return taskManager.cancelTask(this.getId());
    }

    private static List<String> parseCmdParameters(@Nullable String cmdArgsLine) {
        return cmdArgsLine != null ? ParametersListUtil.parse((String)cmdArgsLine, (boolean)false, (boolean)true) : new ArrayList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/internal/ExternalSystemExecuteTaskTask";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksToExecute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

