/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.IntegrationKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemFacadeManager {
    private static final int REMOTE_FAIL_RECOVERY_ATTEMPTS_NUMBER = 3;
    private final ConcurrentMap<IntegrationKey, RemoteExternalSystemFacade> myFacadeWrappers = new ConcurrentHashMap<IntegrationKey, RemoteExternalSystemFacade>();
    private final Map<IntegrationKey, Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>> myRemoteFacades = new ConcurrentHashMap<IntegrationKey, Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>>();
    @NotNull
    private final Lock myLock = new ReentrantLock();
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;
    @NotNull
    private final RemoteExternalSystemCommunicationManager myRemoteCommunicationManager;
    @NotNull
    private final InProcessExternalSystemCommunicationManager myInProcessCommunicationManager;

    public ExternalSystemFacadeManager() {
        Application app = ApplicationManager.getApplication();
        this.myProgressManager = (RemoteExternalSystemProgressNotificationManager)app.getService(ExternalSystemProgressNotificationManager.class);
        this.myRemoteCommunicationManager = (RemoteExternalSystemCommunicationManager)app.getService(RemoteExternalSystemCommunicationManager.class);
        this.myInProcessCommunicationManager = (InProcessExternalSystemCommunicationManager)app.getService(InProcessExternalSystemCommunicationManager.class);
    }

    @NotNull
    private static Project findProject(@NotNull IntegrationKey key) {
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(0);
        }
        ProjectManager projectManager = ProjectManager.getInstance();
        for (Project project : projectManager.getOpenProjects()) {
            if (!key.getIdeProjectName().equals(project.getName()) || !key.getIdeProjectLocationHash().equals(project.getLocationHash())) continue;
            Project project2 = project;
            if (project2 == null) {
                ExternalSystemFacadeManager.$$$reportNull$$$0(1);
            }
            return project2;
        }
        Project project = projectManager.getDefaultProject();
        if (project == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(2);
        }
        return project;
    }

    public void onProjectRename(@NotNull String oldName, @NotNull String newName2) {
        if (oldName == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(3);
        }
        if (newName2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(4);
        }
        ExternalSystemFacadeManager.onProjectRename(this.myFacadeWrappers, oldName, newName2);
        ExternalSystemFacadeManager.onProjectRename(this.myRemoteFacades, oldName, newName2);
    }

    private static <V> void onProjectRename(@NotNull Map<IntegrationKey, V> data2, @NotNull String oldName, @NotNull String newName2) {
        if (data2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(5);
        }
        if (oldName == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(6);
        }
        if (newName2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(7);
        }
        HashSet<IntegrationKey> keys2 = new HashSet<IntegrationKey>(data2.keySet());
        for (IntegrationKey key : keys2) {
            if (!key.getIdeProjectName().equals(oldName)) continue;
            IntegrationKey newKey = new IntegrationKey(newName2, key.getIdeProjectLocationHash(), key.getExternalSystemId(), key.getExternalProjectConfigPath());
            V value2 = data2.get(key);
            data2.put(newKey, value2);
            data2.remove(key);
            if (!(value2 instanceof Consumer)) continue;
            ((Consumer)value2).consume((Object)newKey);
        }
    }

    @NotNull
    public RemoteExternalSystemFacade getFacade(@Nullable Project project, @NotNull String externalProjectPath, @NotNull ProjectSystemId externalSystemId2) {
        IntegrationKey key;
        RemoteExternalSystemFacade facade;
        if (externalProjectPath == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(8);
        }
        if (externalSystemId2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(9);
        }
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        if ((facade = (RemoteExternalSystemFacade)this.myFacadeWrappers.get(key = new IntegrationKey(project, externalSystemId2, externalProjectPath))) == null) {
            RemoteExternalSystemFacade newFacade = (RemoteExternalSystemFacade)Proxy.newProxyInstance(ExternalSystemFacadeManager.class.getClassLoader(), new Class[]{RemoteExternalSystemFacade.class, Consumer.class}, (InvocationHandler)new MyHandler(key));
            this.myFacadeWrappers.putIfAbsent(key, newFacade);
        }
        RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)this.myFacadeWrappers.get(key);
        if (remoteExternalSystemFacade == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(10);
        }
        return remoteExternalSystemFacade;
    }

    public Object doInvoke(@NotNull IntegrationKey key, @NotNull Project project, Method method2, Object[] args, int invocationNumber) throws Throwable {
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(11);
        }
        if (project == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(12);
        }
        RemoteExternalSystemFacade facade = this.doGetFacade(key, project);
        try {
            return method2.invoke((Object)facade, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RemoteException && invocationNumber > 0) {
                Thread.sleep(1000L);
                return this.doInvoke(key, project, method2, args, invocationNumber - 1);
            }
            throw e;
        }
    }

    public ExternalSystemCommunicationManager getCommunicationManager(@NotNull ProjectSystemId externalSystemId2) {
        boolean currentInProcess;
        if (externalSystemId2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(13);
        }
        return (currentInProcess = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)externalSystemId2)) ? this.myInProcessCommunicationManager : this.myRemoteCommunicationManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private RemoteExternalSystemFacade doGetFacade(@NotNull IntegrationKey key, @NotNull Project project) throws Exception {
        boolean currentInProcess;
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(15);
        }
        ExternalSystemCommunicationManager myCommunicationManager = (currentInProcess = ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)key.getExternalSystemId())) ? this.myInProcessCommunicationManager : this.myRemoteCommunicationManager;
        ExternalSystemManager manager2 = ExternalSystemApiUtil.getManager((ProjectSystemId)key.getExternalSystemId());
        if (project.isDisposed() || manager2 == null) {
            RemoteExternalSystemFacade<?> remoteExternalSystemFacade = RemoteExternalSystemFacade.NULL_OBJECT;
            if (remoteExternalSystemFacade == null) {
                ExternalSystemFacadeManager.$$$reportNull$$$0(16);
            }
            return remoteExternalSystemFacade;
        }
        Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair = this.myRemoteFacades.get(key);
        if (pair != null && this.prepare(myCommunicationManager, project, key, pair)) {
            RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)pair.first;
            if (remoteExternalSystemFacade == null) {
                ExternalSystemFacadeManager.$$$reportNull$$$0(17);
            }
            return remoteExternalSystemFacade;
        }
        this.myLock.lock();
        pair = this.myRemoteFacades.get(key);
        if (pair != null && this.prepare(myCommunicationManager, project, key, pair)) {
            RemoteExternalSystemFacade remoteExternalSystemFacade = (RemoteExternalSystemFacade)pair.first;
            RemoteExternalSystemFacade remoteExternalSystemFacade2 = remoteExternalSystemFacade;
            if (remoteExternalSystemFacade2 == null) {
                ExternalSystemFacadeManager.$$$reportNull$$$0(18);
            }
            return remoteExternalSystemFacade2;
        }
        if (pair != null) {
            this.myFacadeWrappers.clear();
            this.myRemoteFacades.clear();
        }
        RemoteExternalSystemFacade remoteExternalSystemFacade = this.doCreateFacade(key, project, myCommunicationManager);
        RemoteExternalSystemFacade remoteExternalSystemFacade3 = remoteExternalSystemFacade;
        if (remoteExternalSystemFacade3 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(19);
        }
        return remoteExternalSystemFacade3;
        finally {
            this.myLock.unlock();
        }
    }

    @NotNull
    private RemoteExternalSystemFacade doCreateFacade(@NotNull IntegrationKey key, @NotNull Project project, @NotNull ExternalSystemCommunicationManager communicationManager) throws Exception {
        RemoteExternalSystemFacade facade;
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(20);
        }
        if (project == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(21);
        }
        if (communicationManager == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(22);
        }
        if ((facade = communicationManager.acquire(key.getExternalProjectConfigPath(), key.getExternalSystemId())) == null) {
            throw new IllegalStateException("Can't obtain facade to working with external api at the remote process. Project: " + project);
        }
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                ExternalSystemFacadeManager.this.myFacadeWrappers.clear();
                ExternalSystemFacadeManager.this.myRemoteFacades.clear();
            }
        });
        ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings> result2 = new ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings>(facade, this.myProgressManager);
        ExternalSystemExecutionSettings settings = ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)key.getExternalProjectConfigPath(), (ProjectSystemId)key.getExternalSystemId());
        Pair newPair = Pair.create(result2, (Object)settings);
        this.myRemoteFacades.put(key, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)newPair);
        result2.applySettings((ExternalSystemExecutionSettings)newPair.second);
        ExternalSystemFacadeWrapper<ExternalSystemExecutionSettings> externalSystemFacadeWrapper = result2;
        if (externalSystemFacadeWrapper == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(23);
        }
        return externalSystemFacadeWrapper;
    }

    private boolean prepare(@NotNull ExternalSystemCommunicationManager communicationManager, @NotNull Project project, @NotNull IntegrationKey key, @NotNull Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings> pair) {
        if (communicationManager == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(25);
        }
        if (key == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(26);
        }
        if (pair == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(27);
        }
        if (!communicationManager.isAlive((RemoteExternalSystemFacade)pair.first)) {
            return false;
        }
        try {
            ExternalSystemExecutionSettings currentSettings = ExternalSystemApiUtil.getExecutionSettings((Project)project, (String)key.getExternalProjectConfigPath(), (ProjectSystemId)key.getExternalSystemId());
            if (!currentSettings.equals(pair.second)) {
                ((RemoteExternalSystemFacade)pair.first).applySettings(currentSettings);
                this.myRemoteFacades.put(key, (Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>)Pair.create((Object)((RemoteExternalSystemFacade)pair.first), (Object)currentSettings));
            }
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTaskActive(@NotNull ExternalSystemTaskId id2) {
        if (id2 == null) {
            ExternalSystemFacadeManager.$$$reportNull$$$0(28);
        }
        HashMap<IntegrationKey, Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>> copy2 = new HashMap<IntegrationKey, Pair<RemoteExternalSystemFacade, ExternalSystemExecutionSettings>>(this.myRemoteFacades);
        for (Map.Entry entry : copy2.entrySet()) {
            try {
                if (!((RemoteExternalSystemFacade)((Pair)entry.getValue()).first).isTaskInProgress(id2)) continue;
                return true;
            }
            catch (RemoteException e) {
                this.myLock.lock();
                try {
                    this.myRemoteFacades.remove(entry.getKey());
                    this.myFacadeWrappers.remove(entry.getKey());
                }
                finally {
                    this.myLock.unlock();
                }
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "communicationManager";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacade";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetFacade";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateFacade";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findProject";
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onProjectRename";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFacade";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCommunicationManager";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doGetFacade";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doCreateFacade";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isTaskActive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyHandler
    implements InvocationHandler {
        @NotNull
        private final AtomicReference<IntegrationKey> myKey;

        MyHandler(IntegrationKey key) {
            if (key == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            this.myKey = new AtomicReference();
            this.myKey.set(key);
        }

        @Override
        @Nullable
        public Object invoke(Object proxy, Method method2, Object[] args) throws Throwable {
            if ("consume".equals(method2.getName())) {
                this.myKey.set((IntegrationKey)args[0]);
                return null;
            }
            Project project = ExternalSystemFacadeManager.findProject(this.myKey.get());
            return ExternalSystemFacadeManager.this.doInvoke(this.myKey.get(), project, method2, args, 3);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/externalSystem/service/ExternalSystemFacadeManager$MyHandler", "<init>"));
        }
    }
}

