/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autoimport.AsyncFileChangeListenerBase;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/VirtualFilesChangesProvider;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesProvider;", "Lcom/intellij/openapi/externalSystem/autoimport/AsyncFileChangeListenerBase;", "isIgnoreInternalChanges", "", "(Z)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "processRecursively", "getProcessRecursively", "()Z", "apply", "", "init", "isRelevant", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "subscribe", "listener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "updateFile", "intellij.platform.externalSystem.impl"})
public final class VirtualFilesChangesProvider
extends AsyncFileChangeListenerBase
implements FilesChangesProvider {
    private final EventDispatcher<FilesChangesListener> eventDispatcher;
    private final boolean processRecursively;
    private final boolean isIgnoreInternalChanges;

    @Override
    public void subscribe(@NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    protected boolean getProcessRecursively() {
        return this.processRecursively;
    }

    @Override
    protected void init() {
        ((FilesChangesListener)this.eventDispatcher.getMulticaster()).init();
    }

    @Override
    protected void apply() {
        ((FilesChangesListener)this.eventDispatcher.getMulticaster()).apply();
    }

    @Override
    protected boolean isRelevant(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return !this.isIgnoreInternalChanges || !event.isFromSave();
    }

    @Override
    protected void updateFile(@NotNull VirtualFile file2, @NotNull VFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProjectStatus.ModificationType modificationType = event.isFromRefresh() ? ProjectStatus.ModificationType.EXTERNAL : ProjectStatus.ModificationType.INTERNAL;
        FilesChangesListener filesChangesListener = (FilesChangesListener)this.eventDispatcher.getMulticaster();
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        filesChangesListener.onFileChange(string, file2.getModificationStamp(), modificationType);
    }

    public VirtualFilesChangesProvider(boolean isIgnoreInternalChanges) {
        this.isIgnoreInternalChanges = isIgnoreInternalChanges;
        EventDispatcher eventDispatcher = EventDispatcher.create(FilesChangesListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"EventDispatcher.create(F\u2026ngesListener::class.java)");
        this.eventDispatcher = eventDispatcher;
    }
}

