/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.externalSystem.autoimport.ProjectStatus;
import com.intellij.openapi.externalSystem.autoimport.changes.DocumentsChangesProvider;
import com.intellij.openapi.externalSystem.autoimport.changes.FilesChangesListener;
import com.intellij.openapi.externalSystem.autoimport.changes.VirtualFilesChangesProvider;
import com.intellij.openapi.externalSystem.autoimport.settings.AsyncSupplier;
import com.intellij.openapi.externalSystem.util.PathPrefixTreeMap;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFilesChangesListener;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "filesProvider", "Lcom/intellij/openapi/externalSystem/autoimport/settings/AsyncSupplier;", "", "", "changesListener", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/externalSystem/autoimport/settings/AsyncSupplier;Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;Lcom/intellij/openapi/Disposable;)V", "updatedFiles", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFilesChangesListener$ModificationData;", "apply", "", "init", "onFileChange", "path", "modificationStamp", "", "modificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "Companion", "ModificationData", "intellij.platform.externalSystem.impl"})
public final class AsyncFilesChangesListener
implements FilesChangesListener {
    private final ConcurrentHashMap<String, ModificationData> updatedFiles;
    private final AsyncSupplier<Set<String>> filesProvider;
    private final FilesChangesListener changesListener;
    private final Disposable parentDisposable;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void init() {
        this.updatedFiles.clear();
    }

    @Override
    public void onFileChange(@NotNull String path, long modificationStamp, @NotNull ProjectStatus.ModificationType modificationType) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)modificationType), (String)"modificationType");
        ((Map)this.updatedFiles).put(path, new ModificationData(modificationStamp, modificationType));
    }

    @Override
    public void apply() {
        HashMap updatedFilesSnapshot = new HashMap(this.updatedFiles);
        this.filesProvider.supply((Function1<Set<String>, Unit>)((Function1)new Function1<Set<? extends String>, Unit>(this, updatedFilesSnapshot){
            final /* synthetic */ AsyncFilesChangesListener this$0;
            final /* synthetic */ HashMap $updatedFilesSnapshot;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Set<String> filesToWatch) {
                String $this$flatMapTo$iv$iv;
                Object element$iv2;
                Intrinsics.checkNotNullParameter(filesToWatch, (String)"filesToWatch");
                PathPrefixTreeMap<Boolean> index2 = new PathPrefixTreeMap<Boolean>(null, false, 3, null);
                Iterable $this$forEach$iv = filesToWatch;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    String it = (String)element$iv2;
                    boolean bl = false;
                    index2.set(it, true);
                }
                Map $this$flatMap$iv = this.$updatedFilesSnapshot;
                boolean $i$f$flatMap = false;
                element$iv2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo2 = false;
                void var9_13 = $this$flatMapTo$iv$iv;
                boolean bl = false;
                Object object = var9_13.entrySet().iterator();
                while (object.hasNext()) {
                    void $this$mapTo$iv$iv;
                    void path;
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> $dstr$path$modificationData = element$iv$iv = object.next();
                    boolean bl2 = false;
                    Map.Entry<K, V> entry = $dstr$path$modificationData;
                    boolean bl3 = false;
                    String string = (String)entry.getKey();
                    entry = $dstr$path$modificationData;
                    bl3 = false;
                    ModificationData modificationData = (ModificationData)entry.getValue();
                    void v0 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"path");
                    Iterable $this$map$iv = index2.getAllAncestorKeys((String)v0);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string2 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl4 = false;
                        Pair pair = TuplesKt.to((Object)it, (Object)modificationData);
                        collection.add(pair);
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv2;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List updatedWatchedFiles = (List)destination$iv$iv;
                Collection collection2 = updatedWatchedFiles;
                boolean bl5 = false;
                if (!collection2.isEmpty()) {
                    AsyncFilesChangesListener.access$getChangesListener$p(this.this$0).init();
                    for (Collection collection2 : updatedWatchedFiles) {
                        void modificationStamp;
                        void path;
                        $this$flatMapTo$iv$iv = (String)collection2.component1();
                        ModificationData modificationData = (ModificationData)collection2.component2();
                        object = modificationData;
                        long $i$f$flatMapTo2 = ((ModificationData)object).component1();
                        ProjectStatus.ModificationType modificationType = ((ModificationData)object).component2();
                        AsyncFilesChangesListener.access$getChangesListener$p(this.this$0).onFileChange((String)path, (long)modificationStamp, modificationType);
                    }
                    AsyncFilesChangesListener.access$getChangesListener$p(this.this$0).apply();
                }
            }
            {
                this.this$0 = asyncFilesChangesListener;
                this.$updatedFilesSnapshot = hashMap;
                super(1);
            }
        }), this.parentDisposable);
    }

    public AsyncFilesChangesListener(@NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener changesListener, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(filesProvider, (String)"filesProvider");
        Intrinsics.checkNotNullParameter((Object)changesListener, (String)"changesListener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.filesProvider = filesProvider;
        this.changesListener = changesListener;
        this.parentDisposable = parentDisposable;
        this.updatedFiles = new ConcurrentHashMap();
    }

    public static final /* synthetic */ FilesChangesListener access$getChangesListener$p(AsyncFilesChangesListener $this) {
        return $this.changesListener;
    }

    @JvmStatic
    public static final void subscribeOnDocumentsAndVirtualFilesChanges(@NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Companion.subscribeOnDocumentsAndVirtualFilesChanges(filesProvider, listener2, parentDisposable);
    }

    @JvmStatic
    public static final void subscribeOnVirtualFilesChanges(boolean isIgnoreInternalChanges, @NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Companion.subscribeOnVirtualFilesChanges(isIgnoreInternalChanges, filesProvider, listener2, parentDisposable);
    }

    @JvmStatic
    public static final void subscribeOnDocumentsChanges(boolean isIgnoreExternalChanges, @NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
        Companion.subscribeOnDocumentsChanges(isIgnoreExternalChanges, filesProvider, listener2, parentDisposable);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFilesChangesListener$ModificationData;", "", "modificationStamp", "", "modificationType", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "(JLcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;)V", "getModificationStamp", "()J", "getModificationType", "()Lcom/intellij/openapi/externalSystem/autoimport/ProjectStatus$ModificationType;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.externalSystem.impl"})
    private static final class ModificationData {
        private final long modificationStamp;
        @NotNull
        private final ProjectStatus.ModificationType modificationType;

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final ProjectStatus.ModificationType getModificationType() {
            return this.modificationType;
        }

        public ModificationData(long modificationStamp, @NotNull ProjectStatus.ModificationType modificationType) {
            Intrinsics.checkNotNullParameter((Object)((Object)modificationType), (String)"modificationType");
            this.modificationStamp = modificationStamp;
            this.modificationType = modificationType;
        }

        public final long component1() {
            return this.modificationStamp;
        }

        @NotNull
        public final ProjectStatus.ModificationType component2() {
            return this.modificationType;
        }

        @NotNull
        public final ModificationData copy(long modificationStamp, @NotNull ProjectStatus.ModificationType modificationType) {
            Intrinsics.checkNotNullParameter((Object)((Object)modificationType), (String)"modificationType");
            return new ModificationData(modificationStamp, modificationType);
        }

        public static /* synthetic */ ModificationData copy$default(ModificationData modificationData, long l, ProjectStatus.ModificationType modificationType, int n, Object object) {
            if ((n & 1) != 0) {
                l = modificationData.modificationStamp;
            }
            if ((n & 2) != 0) {
                modificationType = modificationData.modificationType;
            }
            return modificationData.copy(l, modificationType);
        }

        @NotNull
        public String toString() {
            return "ModificationData(modificationStamp=" + this.modificationStamp + ", modificationType=" + (Object)((Object)this.modificationType) + ")";
        }

        public int hashCode() {
            ProjectStatus.ModificationType modificationType = this.modificationType;
            return Long.hashCode(this.modificationStamp) * 31 + (modificationType != null ? ((Object)((Object)modificationType)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ModificationData)) break block3;
                    ModificationData modificationData = (ModificationData)object;
                    if (this.modificationStamp != modificationData.modificationStamp || !Intrinsics.areEqual((Object)((Object)this.modificationType), (Object)((Object)modificationData.modificationType))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J4\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J4\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000f2\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/changes/AsyncFilesChangesListener$Companion;", "", "()V", "subscribeOnDocumentsAndVirtualFilesChanges", "", "filesProvider", "Lcom/intellij/openapi/externalSystem/autoimport/settings/AsyncSupplier;", "", "", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/changes/FilesChangesListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "subscribeOnDocumentsChanges", "isIgnoreExternalChanges", "", "subscribeOnVirtualFilesChanges", "isIgnoreInternalChanges", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @JvmStatic
        public final void subscribeOnDocumentsAndVirtualFilesChanges(@NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(filesProvider, (String)"filesProvider");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.subscribeOnVirtualFilesChanges(true, filesProvider, listener2, parentDisposable);
            this.subscribeOnDocumentsChanges(true, filesProvider, listener2, parentDisposable);
        }

        @JvmStatic
        public final void subscribeOnVirtualFilesChanges(boolean isIgnoreInternalChanges, @NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(filesProvider, (String)"filesProvider");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            VirtualFilesChangesProvider changesProvider = new VirtualFilesChangesProvider(isIgnoreInternalChanges);
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
            VirtualFileManager fileManager = virtualFileManager;
            fileManager.addAsyncFileListener((AsyncFileListener)changesProvider, parentDisposable);
            AsyncFilesChangesListener asyncListener = new AsyncFilesChangesListener(filesProvider, listener2, parentDisposable);
            changesProvider.subscribe(asyncListener, parentDisposable);
        }

        @JvmStatic
        public final void subscribeOnDocumentsChanges(boolean isIgnoreExternalChanges, @NotNull AsyncSupplier<Set<String>> filesProvider, @NotNull FilesChangesListener listener2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter(filesProvider, (String)"filesProvider");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            DocumentsChangesProvider changesProvider = new DocumentsChangesProvider(isIgnoreExternalChanges);
            EditorFactory editorFactory = EditorFactory.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
            EditorEventMulticaster editorEventMulticaster = editorFactory.getEventMulticaster();
            Intrinsics.checkNotNullExpressionValue((Object)editorEventMulticaster, (String)"EditorFactory.getInstance().eventMulticaster");
            EditorEventMulticaster eventMulticaster = editorEventMulticaster;
            eventMulticaster.addDocumentListener((DocumentListener)changesProvider, parentDisposable);
            AsyncFilesChangesListener asyncListener = new AsyncFilesChangesListener(filesProvider, listener2, parentDisposable);
            changesProvider.subscribe(asyncListener, parentDisposable);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

