/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectRefreshActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "()V", "ensureValidActionVisibility", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "isFileEditor", "", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.externalSystem.impl"})
public final class ProjectRefreshActionGroup
extends DefaultActionGroup {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.ensureValidActionVisibility(e);
    }

    private final void ensureValidActionVisibility(AnActionEvent e) {
        block2: {
            Editor editor;
            block1: {
                Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
                if (editor2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"e.getData(CommonDataKeys.EDITOR) ?: return");
                editor = editor2;
                if (!DiffUtil.isDiffEditor(editor)) break block1;
                Presentation presentation2 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
                presentation2.setVisible(false);
                break block2;
            }
            if (this.isFileEditor(editor)) break block2;
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            presentation3.setVisible(false);
        }
    }

    private final boolean isFileEditor(Editor $this$isFileEditor) {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"FileDocumentManager.getInstance()");
        FileDocumentManager documentManager = fileDocumentManager;
        VirtualFile virtualFile = documentManager.getFile($this$isFileEditor.getDocument());
        if (virtualFile instanceof LightVirtualFileBase) {
            return false;
        }
        return virtualFile != null && virtualFile.isValid();
    }
}

