/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.autoimport;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ProjectRefreshFloatingProvider;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0007J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\fJ\u0006\u0010\u0012\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u0007\u001a.\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\f\u00a2\u0006\u0002\b\u000b0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectNotificationAware;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isHidden", "Ljava/util/concurrent/atomic/AtomicBoolean;", "projectsWithNotification", "", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "dispose", "", "getProjectsWithNotification", "getSystemIds", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "hideNotification", "isNotificationVisible", "", "notificationExpire", "projectId", "notificationNotify", "projectAware", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "revealNotification", "setHideStatus", "Companion", "intellij.platform.externalSystem.impl"})
public final class ProjectNotificationAware
implements Disposable {
    private final AtomicBoolean isHidden;
    private final Set<ExternalSystemProjectId> projectsWithNotification;
    private final Project project;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void notificationNotify(@NotNull ExternalSystemProjectAware projectAware) {
        Intrinsics.checkNotNullParameter((Object)projectAware, (String)"projectAware");
        ExternalSystemProjectId projectId = projectAware.getProjectId();
        LOG.debug(projectId.getReadableName() + ": Notify notification");
        this.projectsWithNotification.add(projectId);
        this.revealNotification();
    }

    public final void notificationExpire(@NotNull ExternalSystemProjectId projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        LOG.debug(projectId.getReadableName() + ": Expire notification");
        this.projectsWithNotification.remove(projectId);
        this.revealNotification();
    }

    public final void notificationExpire() {
        LOG.debug("Expire notification");
        this.projectsWithNotification.clear();
        this.revealNotification();
    }

    public void dispose() {
        this.notificationExpire();
    }

    private final void setHideStatus(boolean isHidden) {
        this.isHidden.set(isHidden);
        ProjectRefreshFloatingProvider.Companion.updateToolbarComponents(this.project, this);
    }

    private final void revealNotification() {
        this.setHideStatus(false);
    }

    public final void hideNotification() {
        this.setHideStatus(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isNotificationVisible() {
        if (this.isHidden.get()) return false;
        Collection collection = this.projectsWithNotification;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<ProjectSystemId> getSystemIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.projectsWithNotification;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ExternalSystemProjectId externalSystemProjectId = (ExternalSystemProjectId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProjectSystemId projectSystemId = it.getSystemId();
            collection.add(projectSystemId);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @TestOnly
    @NotNull
    public final Set<ExternalSystemProjectId> getProjectsWithNotification() {
        return CollectionsKt.toSet((Iterable)this.projectsWithNotification);
    }

    public ProjectNotificationAware(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.isHidden = new AtomicBoolean(false);
        Set set2 = ContainerUtil.newConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"ContainerUtil.newConcurr\u2026xternalSystemProjectId>()");
        this.projectsWithNotification = set2;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance((String)"#com.intellij.openapi.externalSystem.autoimport");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(\"#com\u2026ternalSystem.autoimport\")");
        LOG = logger;
    }

    @JvmStatic
    @NotNull
    public static final ProjectNotificationAware getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/externalSystem/autoimport/ProjectNotificationAware$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/openapi/externalSystem/autoimport/ProjectNotificationAware;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ProjectNotificationAware getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ProjectNotificationAware.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (ProjectNotificationAware)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

