/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action.task;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunExternalSystemTaskAction
extends ExternalSystemNodeAction<TaskData> {
    private static final Logger LOG = Logger.getInstance(RunExternalSystemTaskAction.class);

    public RunExternalSystemTaskAction() {
        super(TaskData.class);
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull TaskData taskData, @NotNull AnActionEvent e) {
        if (project == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(0);
        }
        if (projectSystemId == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(1);
        }
        if (taskData == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(2);
        }
        if (e == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(3);
        }
        ExternalTaskExecutionInfo taskExecutionInfo = ExternalSystemActionUtil.buildTaskInfo(taskData);
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)e.getDataContext());
        RunnerAndConfigurationSettings configuration2 = RunExternalSystemTaskAction.findOrGet(context);
        if (configuration2 == null || !RunExternalSystemTaskAction.runTaskAsExistingConfiguration(project, projectSystemId, taskExecutionInfo, configuration2)) {
            RunExternalSystemTaskAction.runTaskAsNewRunConfiguration(project, projectSystemId, taskExecutionInfo);
            configuration2 = RunExternalSystemTaskAction.findOrGet(context);
        }
        context.getRunManager().setSelectedConfiguration(configuration2);
    }

    @Nullable
    private static RunnerAndConfigurationSettings findOrGet(@NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings result2;
        if (context == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(4);
        }
        if ((result2 = context.findExisting()) == null && (result2 = context.getConfiguration()) != null) {
            context.getRunManager().setTemporaryConfiguration(result2);
        }
        return result2;
    }

    private static boolean runTaskAsExistingConfiguration(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull ExternalTaskExecutionInfo taskExecutionInfo, @NotNull RunnerAndConfigurationSettings configuration2) {
        String executorId;
        String runnerId;
        if (project == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(5);
        }
        if (projectSystemId == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(6);
        }
        if (taskExecutionInfo == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(7);
        }
        if (configuration2 == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(8);
        }
        if ((runnerId = ExternalSystemUtil.getRunnerId(executorId = taskExecutionInfo.getExecutorId())) == null) {
            return false;
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        ProgramRunner runner = ProgramRunner.findRunnerById((String)runnerId);
        if (executor == null || runner == null) {
            return false;
        }
        ExecutionEnvironment environment2 = new ExecutionEnvironment(executor, runner, configuration2, project);
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                environment2.getRunner().execute(environment2);
            }
            catch (ExecutionException exception) {
                LOG.error("Failed to execute " + projectSystemId.getReadableName() + " task.", (Throwable)exception);
            }
        });
        return true;
    }

    private static void runTaskAsNewRunConfiguration(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull ExternalTaskExecutionInfo taskExecutionInfo) {
        if (project == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(9);
        }
        if (projectSystemId == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(10);
        }
        if (taskExecutionInfo == null) {
            RunExternalSystemTaskAction.$$$reportNull$$$0(11);
        }
        ExternalSystemUtil.runTask(taskExecutionInfo.getSettings(), taskExecutionInfo.getExecutorId(), project, projectSystemId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskExecutionInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/action/task/RunExternalSystemTaskAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findOrGet";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runTaskAsExistingConfiguration";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "runTaskAsNewRunConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

