/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.toolbar.floating;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarComponentImpl;
import com.intellij.openapi.editor.toolbar.floating.FloatingToolbarProvider;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/EditorFloatingToolbar;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "Companion", "intellij.platform.ide.impl"})
public final class EditorFloatingToolbar
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public EditorFloatingToolbar(final @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.setLayout(new FlowLayout(2, 20, 20));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        EditorComponentImpl editorComponentImpl = editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)editorComponentImpl, (String)"editor.contentComponent");
        final EditorComponentImpl targetComponent = editorComponentImpl;
        JScrollPane jScrollPane = editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
        final JScrollPane container = jScrollPane;
        Disposable disposable2 = editor.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"editor.disposable");
        final Disposable parentDisposable = disposable2;
        final ArrayList toolbarComponents = new ArrayList();
        FloatingToolbarProvider.Companion.getEP_NAME().forEachExtensionSafe((Consumer)new Consumer<FloatingToolbarProvider>(){

            @Override
            public final void accept(FloatingToolbarProvider provider2) {
                ActionGroup actionGroup2 = provider2.getActionGroup();
                boolean autoHideable = provider2.getAutoHideable();
                FloatingToolbarComponentImpl component2 = new FloatingToolbarComponentImpl(this, targetComponent, actionGroup2, autoHideable, parentDisposable);
                DataContext dataContext = editor.getDataContext();
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"editor.dataContext");
                provider2.register(dataContext, component2, parentDisposable);
                toolbarComponents.add(component2);
                this.add(component2);
            }
        });
        editor.addEditorMouseMotionListener(new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                MouseEvent mouseEvent = e.getMouseEvent();
                Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"e.mouseEvent");
                Point point = mouseEvent.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.mouseEvent.point");
                if (Companion.isInsideActivationArea(container, point)) {
                    for (FloatingToolbarComponentImpl component2 : toolbarComponents) {
                        if (!component2.getAutoHideable()) continue;
                        component2.scheduleShow();
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/editor/toolbar/floating/EditorFloatingToolbar$Companion;", "", "()V", "isInsideActivationArea", "", "container", "Ljavax/swing/JScrollPane;", "p", "Ljava/awt/Point;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final boolean isInsideActivationArea(JScrollPane container, Point p) {
            JViewport viewport;
            JViewport jViewport = viewport = container.getViewport();
            Intrinsics.checkNotNullExpressionValue((Object)jViewport, (String)"viewport");
            Rectangle r = jViewport.getBounds();
            Point viewPosition = viewport.getViewPosition();
            Rectangle activationArea = new Rectangle(0, 0, r.width, r.height);
            return activationArea.contains(p.x, p.y - viewPosition.y);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

