/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import java.awt.Point;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class AfterLineEndInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, AfterLineEndInlayImpl<?>> {
    private static int ourGlobalCounter = 0;
    private final boolean mySoftWrappable;
    final int myOrder;

    AfterLineEndInlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, boolean insertFirst, boolean softWrappable, @NotNull R renderer) {
        if (editor == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(0);
        }
        if (renderer == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(1);
        }
        super(editor, offset, relatesToPrecedingText, renderer);
        this.mySoftWrappable = softWrappable;
        int order = ourGlobalCounter++;
        this.myOrder = insertFirst ? -order : order;
    }

    @Override
    RangeMarkerTree<AfterLineEndInlayImpl<?>> getTree() {
        return this.myEditor.getInlayModel().myAfterLineEndElementsTree;
    }

    @Override
    void doUpdate() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels <= 0) {
            throw PluginException.createByClass((String)("Positive width should be defined for an after-line-end element by " + this.myRenderer), null, this.myRenderer.getClass());
        }
    }

    @Override
    Point getPosition() {
        VisualPosition pos = this.getVisualPosition();
        return this.myEditor.visualPositionToXY(pos);
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        Inlay.Placement placement = Inlay.Placement.AFTER_LINE_END;
        if (placement == null) {
            AfterLineEndInlayImpl.$$$reportNull$$$0(2);
        }
        return placement;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        int offset = this.getOffset();
        int logicalLine = this.myEditor.getDocument().getLineNumber(offset);
        int lineEndOffset = this.myEditor.getDocument().getLineEndOffset(logicalLine);
        VisualPosition position = this.myEditor.offsetToVisualPosition(lineEndOffset, true, true);
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(lineEndOffset)) {
            VisualPosition visualPosition = position;
            if (visualPosition == null) {
                AfterLineEndInlayImpl.$$$reportNull$$$0(3);
            }
            return visualPosition;
        }
        List<Inlay<?>> inlays = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
        int order = inlays.indexOf(this);
        return new VisualPosition(position.line, position.column + 1 + order);
    }

    public boolean isSoftWrappable() {
        return this.mySoftWrappable;
    }

    public int getHeightInPixels() {
        return this.myEditor.getLineHeight();
    }

    @Override
    public String toString() {
        return "[After-line-end inlay, offset=" + this.getOffset() + ", width=" + this.myWidthInPixels + ", renderer=" + this.myRenderer + "]" + (this.isValid() ? "" : "(invalid)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/AfterLineEndInlayImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/AfterLineEndInlayImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlacement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

