/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredHighlighterIterator;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.ex.util.LimitedRangeHighlighterIterator;
import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.editor.ex.util.SegmentArrayWithData;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.text.MergingCharSequence;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredLexerEditorHighlighter
extends LexerEditorHighlighter {
    private static final Logger LOG = Logger.getInstance(LayeredLexerEditorHighlighter.class);
    private final Map<IElementType, LayerDescriptor> myTokensToLayer;

    public LayeredLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme2) {
        if (highlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(0);
        }
        if (scheme2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(1);
        }
        super(highlighter, scheme2);
        this.myTokensToLayer = new HashMap<IElementType, LayerDescriptor>();
    }

    @Override
    @NotNull
    protected SegmentArrayWithData createSegments() {
        return new MappingSegments(this.createStorage());
    }

    public synchronized void registerLayer(@NotNull IElementType tokenType, @NotNull LayerDescriptor layerHighlighter) {
        if (tokenType == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(2);
        }
        if (layerHighlighter == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(3);
        }
        this.myTokensToLayer.put(tokenType, layerHighlighter);
        this.getSegments().removeAll();
    }

    protected synchronized void unregisterLayer(@NotNull IElementType tokenType) {
        LayerDescriptor layer;
        if (tokenType == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(4);
        }
        if ((layer = this.myTokensToLayer.remove(tokenType)) != null) {
            this.getSegments().myLayerBuffers.remove(layer);
            this.getSegments().removeAll();
        }
    }

    @Override
    @NotNull
    public MappingSegments getSegments() {
        MappingSegments mappingSegments = (MappingSegments)super.getSegments();
        if (mappingSegments == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(5);
        }
        return mappingSegments;
    }

    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(6);
        }
        if (this.updateLayers()) {
            this.resetText(text2);
        } else {
            super.setText(text2);
        }
    }

    @Override
    @NotNull
    protected LexerEditorHighlighter.TokenProcessor createTokenProcessor(final int startIndex, SegmentArrayWithData segments, final CharSequence text2) {
        final MappingSegments mappingSegments = (MappingSegments)segments;
        return new LexerEditorHighlighter.TokenProcessor(){
            final Map<Mapper, LightMapper> docTexts = FactoryMap.create(key -> {
                MappedRange predecessor = key.findPredecessor(startIndex, mappingSegments);
                return new LightMapper((Mapper)key, predecessor != null ? predecessor.range.getEndOffset() : 0);
            });

            @Override
            public void addToken(int tokenIndex, int startOffset, int endOffset, int data2, @NotNull IElementType tokenType) {
                if (tokenType == null) {
                    1.$$$reportNull$$$0(0);
                }
                mappingSegments.setElementLight(tokenIndex, startOffset, endOffset, data2);
                Mapper mapper2 = mappingSegments.getMappingDocument(tokenType);
                if (mapper2 != null) {
                    this.docTexts.get(mapper2).addToken(text2.subSequence(startOffset, endOffset), tokenType, tokenIndex);
                }
            }

            @Override
            public void finish() {
                this.docTexts.keySet().forEach(mapper2 -> mappingSegments.freezeHighlighter((Mapper)mapper2));
                for (LightMapper mapper3 : this.docTexts.values()) {
                    mapper3.finish();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$1", "addToken"));
            }
        };
    }

    protected boolean updateLayers() {
        return false;
    }

    protected boolean updateLayers(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(7);
        }
        return this.updateLayers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void documentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(8);
        }
        boolean changed2 = this.updateLayers(e);
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        synchronized (layeredLexerEditorHighlighter) {
            if (changed2) {
                super.setText(e.getDocument().getImmutableCharSequence());
            } else {
                super.documentChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = this;
        // MONITORENTER : layeredLexerEditorHighlighter
        LayeredHighlighterIteratorImpl layeredHighlighterIteratorImpl = new LayeredHighlighterIteratorImpl(startOffset);
        // MONITOREXIT : layeredLexerEditorHighlighter
        if (layeredHighlighterIteratorImpl != null) return layeredHighlighterIteratorImpl;
        LayeredLexerEditorHighlighter.$$$reportNull$$$0(9);
        return layeredHighlighterIteratorImpl;
    }

    @NotNull
    public HighlighterIterator createBaseIterator(int startOffset) {
        HighlighterIterator highlighterIterator = super.createIterator(startOffset);
        if (highlighterIterator == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(10);
        }
        return highlighterIterator;
    }

    @Override
    public void setColorScheme(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(11);
        }
        super.setColorScheme(scheme2);
        for (MappedRange mapping2 : this.getSegments().myRanges) {
            Mapper mapper2;
            Mapper mapper3 = mapper2 = mapping2 == null ? null : mapping2.mapper;
            if (mapper2 == null) continue;
            mapper2.resetCachedTextAttributes();
        }
    }

    @Override
    protected boolean hasAdditionalData(int segmentIndex) {
        return this.getSegments().myRanges[segmentIndex] != null;
    }

    private static MappedRange @NotNull [] reallocateArray(MappedRange @NotNull [] array2, int index2) {
        if (array2 == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(12);
        }
        if (index2 < array2.length) {
            if (array2 == null) {
                LayeredLexerEditorHighlighter.$$$reportNull$$$0(13);
            }
            return array2;
        }
        MappedRange[] mappedRangeArray = (MappedRange[])ArrayUtil.realloc((Object[])array2, (int)SegmentArray.calcCapacity(array2.length, index2), MappedRange[]::new);
        if (mappedRangeArray == null) {
            LayeredLexerEditorHighlighter.$$$reportNull$$$0(14);
        }
        return mappedRangeArray;
    }

    @Override
    @NonNls
    public String toString() {
        return this.myText.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layerHighlighter";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegments";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createBaseIterator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "reallocateArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerLayer";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unregisterLayer";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateLayers";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setColorScheme";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reallocateArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyLexerEditorHighlighter
    extends LexerEditorHighlighter {
        private boolean inUpdate;
        private List<DocumentUpdate> updates;

        LazyLexerEditorHighlighter(@NotNull SyntaxHighlighter highlighter, @NotNull EditorColorsScheme scheme2) {
            if (highlighter == null) {
                LazyLexerEditorHighlighter.$$$reportNull$$$0(0);
            }
            if (scheme2 == null) {
                LazyLexerEditorHighlighter.$$$reportNull$$$0(1);
            }
            super(highlighter, scheme2);
            this.inUpdate = false;
        }

        public void beginUpdate() {
            this.inUpdate = true;
            this.updates = new SmartList();
        }

        public void finishUpdate() {
            this.inUpdate = false;
            if (this.updates.isEmpty()) {
                this.updates = null;
                return;
            }
            this.sortUpdates();
            this.mergeUpdates();
            Document document = this.updates.get((int)0).document;
            int documentSize = document.getTextLength();
            int processedOffset = -1;
            for (DocumentUpdate event : this.updates) {
                if (event.offset + event.newLength < processedOffset || (processedOffset = super.incrementalUpdate(event.offset, event.oldLength, event.newLength, document)) < documentSize) continue;
                break;
            }
            this.updates = null;
        }

        @Override
        int incrementalUpdate(int eventOffset, int eventOldLength, int eventNewLength, Document document) {
            if (this.inUpdate) {
                if (!LazyLexerEditorHighlighter.mergeUpdate(this.updates, eventOffset, eventOldLength, eventNewLength)) {
                    this.updates.add(new DocumentUpdate(eventOffset, eventOldLength, eventNewLength, document));
                }
                return -1;
            }
            return super.incrementalUpdate(eventOffset, eventOldLength, eventNewLength, document);
        }

        private static boolean mergeUpdate(List<DocumentUpdate> updates2, int eventOffset, int eventOldLength, int eventNewLength) {
            if (updates2.isEmpty()) {
                return false;
            }
            int MERGE_MARGIN = 5;
            DocumentUpdate a = updates2.get(updates2.size() - 1);
            if (eventOffset < a.offset) {
                return false;
            }
            if (a.offset == eventOffset) {
                if (a.newLength > eventOldLength) {
                    a.newLength += eventNewLength - eventOldLength;
                } else {
                    a.oldLength += eventOldLength - a.newLength;
                    a.newLength = eventNewLength;
                }
            } else if (a.offset + a.newLength > eventOffset) {
                if (a.offset + a.newLength < eventOffset + eventOldLength) {
                    a.oldLength = eventOldLength + eventOffset - (a.offset + a.oldLength);
                }
                a.newLength += eventNewLength - eventOldLength;
            } else if (a.offset + a.newLength + 5 >= eventOffset) {
                int offsetDiff = eventOffset - a.offset - a.newLength;
                a.oldLength += offsetDiff + eventOldLength;
                a.newLength += offsetDiff + eventNewLength;
            } else {
                return false;
            }
            return true;
        }

        private void mergeUpdates() {
            ArrayList<DocumentUpdate> result2 = new ArrayList<DocumentUpdate>(this.updates.size());
            result2.add(this.updates.get(0));
            for (int i2 = 1; i2 < this.updates.size(); ++i2) {
                DocumentUpdate b = this.updates.get(i2);
                if (LazyLexerEditorHighlighter.mergeUpdate(result2, b.offset, b.oldLength, b.newLength)) continue;
                result2.add(b);
            }
            this.updates = result2;
        }

        private void sortUpdates() {
            int sortedFrom = this.updates.size();
            while (sortedFrom != 0) {
                int lastSortedIndex = 0;
                for (int i2 = 1; i2 < sortedFrom; ++i2) {
                    DocumentUpdate a = this.updates.get(i2 - 1);
                    DocumentUpdate b = this.updates.get(i2);
                    if (a.offset <= b.offset) continue;
                    if (a.offset < b.offset + b.oldLength) {
                        int delta = b.offset + b.oldLength - a.offset;
                        a.offset = b.offset;
                        a.oldLength -= Math.min(0, delta);
                        a.newLength -= Math.min(0, delta);
                    } else {
                        a.offset += b.newLength - b.oldLength;
                    }
                    this.updates.set(i2 - 1, b);
                    this.updates.set(i2, a);
                    lastSortedIndex = i2;
                }
                sortedFrom = lastSortedIndex;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlighter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scheme";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LazyLexerEditorHighlighter";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class DocumentUpdate {
            int offset;
            int oldLength;
            int newLength;
            final Document document;

            DocumentUpdate(int offset, int oldLength, int newLength, Document document) {
                this.offset = offset;
                this.oldLength = oldLength;
                this.newLength = newLength;
                this.document = document;
            }

            public String toString() {
                return "update at " + this.offset + ": " + this.oldLength + " => " + this.newLength;
            }
        }
    }

    private final class LayeredHighlighterIteratorImpl
    implements LayeredHighlighterIterator {
        private final HighlighterIterator myBaseIterator;
        private HighlighterIterator myLayerIterator;
        private int myLayerStartOffset;
        private Mapper myCurrentMapper;

        private LayeredHighlighterIteratorImpl(int offset) {
            this.myBaseIterator = LayeredLexerEditorHighlighter.this.createBaseIterator(offset);
            if (!this.myBaseIterator.atEnd()) {
                int shift = offset - this.myBaseIterator.getStart();
                this.initLayer(shift);
            }
        }

        private void initLayer(int shiftInToken) {
            if (this.myBaseIterator.atEnd()) {
                this.myLayerIterator = null;
                this.myCurrentMapper = null;
                return;
            }
            MappedRange mapping2 = LayeredLexerEditorHighlighter.this.getSegments().myRanges[((LexerEditorHighlighter.HighlighterIteratorImpl)this.myBaseIterator).currentIndex()];
            if (mapping2 != null) {
                this.myCurrentMapper = mapping2.mapper;
                this.myLayerIterator = this.myCurrentMapper.createIterator(mapping2, shiftInToken);
                this.myLayerStartOffset = this.myBaseIterator.getStart() - mapping2.range.getStartOffset();
            } else {
                this.myCurrentMapper = null;
                this.myLayerIterator = null;
            }
        }

        public TextAttributes getTextAttributes() {
            if (this.myCurrentMapper != null) {
                return this.myCurrentMapper.getAttributes(this.getTokenType());
            }
            return this.myBaseIterator.getTextAttributes();
        }

        public TextAttributesKey @NotNull [] getTextAttributesKeys() {
            if (this.myCurrentMapper != null) {
                TextAttributesKey[] textAttributesKeyArray = this.myCurrentMapper.getAttributesKeys(this.getTokenType());
                if (textAttributesKeyArray == null) {
                    LayeredHighlighterIteratorImpl.$$$reportNull$$$0(0);
                }
                return textAttributesKeyArray;
            }
            TextAttributesKey[] textAttributesKeyArray = this.myBaseIterator.getTextAttributesKeys();
            if (textAttributesKeyArray == null) {
                LayeredHighlighterIteratorImpl.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }

        @Override
        @NotNull
        public SyntaxHighlighter getActiveSyntaxHighlighter() {
            if (this.myCurrentMapper != null) {
                SyntaxHighlighter syntaxHighlighter = this.myCurrentMapper.mySyntaxHighlighter;
                if (syntaxHighlighter == null) {
                    LayeredHighlighterIteratorImpl.$$$reportNull$$$0(2);
                }
                return syntaxHighlighter;
            }
            SyntaxHighlighter syntaxHighlighter = LayeredLexerEditorHighlighter.this.getSyntaxHighlighter();
            if (syntaxHighlighter == null) {
                LayeredHighlighterIteratorImpl.$$$reportNull$$$0(3);
            }
            return syntaxHighlighter;
        }

        public int getStart() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getStart() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getStart();
        }

        public int getEnd() {
            if (this.myLayerIterator != null) {
                return this.myLayerIterator.getEnd() + this.myLayerStartOffset;
            }
            return this.myBaseIterator.getEnd();
        }

        public IElementType getTokenType() {
            return this.myLayerIterator != null ? this.myLayerIterator.getTokenType() : this.myBaseIterator.getTokenType();
        }

        public void advance() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.advance();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.advance();
            this.initLayer(0);
        }

        public void retreat() {
            if (this.myLayerIterator != null) {
                this.myLayerIterator.retreat();
                if (!this.myLayerIterator.atEnd()) {
                    return;
                }
            }
            this.myBaseIterator.retreat();
            this.initLayer(this.myBaseIterator.atEnd() ? 0 : this.myBaseIterator.getEnd() - this.myBaseIterator.getStart() - 1);
        }

        public boolean atEnd() {
            return this.myBaseIterator.atEnd();
        }

        public Document getDocument() {
            return this.myBaseIterator.getDocument();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LayeredHighlighterIteratorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributesKeys";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActiveSyntaxHighlighter";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MappedRange {
        private RangeMarker range;
        private final Mapper mapper;
        private final IElementType outerToken;

        MappedRange(@NotNull Mapper mapper2, @NotNull RangeMarker range2, @NotNull IElementType outerToken) {
            if (range2 == null) {
                MappedRange.$$$reportNull$$$0(0);
            }
            if (outerToken == null) {
                MappedRange.$$$reportNull$$$0(1);
            }
            if (mapper2 == null) {
                MappedRange.$$$reportNull$$$0(2);
            }
            this.mapper = mapper2;
            this.range = range2;
            this.outerToken = outerToken;
            assert (mapper2.doc == range2.getDocument());
        }

        @NonNls
        public String toString() {
            return "MappedRange{range=" + this.range + ", outerToken=" + this.outerToken + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outerToken";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mapper";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappedRange";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class Mapper
    implements HighlighterClient {
        private final DocumentImpl doc;
        private final LazyLexerEditorHighlighter highlighter;
        private final String mySeparator;
        private final Map<IElementType, TextAttributes> myAttributesMap;
        private final Map<IElementType, TextAttributesKey[]> myKeysMap;
        @NotNull
        private final SyntaxHighlighter mySyntaxHighlighter;
        private final TextAttributesKey myBackground;

        private Mapper(LayerDescriptor descriptor2) {
            if (descriptor2 == null) {
                Mapper.$$$reportNull$$$0(0);
            }
            this.myAttributesMap = new HashMap<IElementType, TextAttributes>();
            this.myKeysMap = new HashMap<IElementType, TextAttributesKey[]>();
            this.doc = new DocumentImpl("", true);
            this.mySyntaxHighlighter = descriptor2.getLayerHighlighter();
            this.myBackground = descriptor2.getBackgroundKey();
            this.highlighter = new LazyLexerEditorHighlighter(this.mySyntaxHighlighter, LayeredLexerEditorHighlighter.this.getScheme());
            this.mySeparator = descriptor2.getTokenSeparator();
            this.highlighter.setEditor(this);
            this.doc.addDocumentListener(this.highlighter);
        }

        @NotNull
        public TextAttributes getAttributes(IElementType tokenType) {
            TextAttributes attrs = this.myAttributesMap.get(tokenType);
            if (attrs == null) {
                TextAttributesKey[] keys2 = this.getAttributesKeys(tokenType);
                attrs = LayeredLexerEditorHighlighter.this.convertAttributes(keys2);
                this.myAttributesMap.put(tokenType, attrs);
            }
            TextAttributes textAttributes = attrs;
            if (textAttributes == null) {
                Mapper.$$$reportNull$$$0(1);
            }
            return textAttributes;
        }

        private TextAttributesKey @NotNull [] getAttributesKeys(IElementType tokenType) {
            TextAttributesKey[] textAttributesKeyArray = this.myKeysMap.computeIfAbsent(tokenType, type -> SyntaxHighlighterBase.pack((TextAttributesKey)this.myBackground, (TextAttributesKey[])this.mySyntaxHighlighter.getTokenHighlights(type)));
            if (textAttributesKeyArray == null) {
                Mapper.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }

        @NotNull
        public HighlighterIterator createIterator(@NotNull MappedRange mapper2, int shift) {
            if (mapper2 == null) {
                Mapper.$$$reportNull$$$0(3);
            }
            int rangeStart = mapper2.range.getStartOffset();
            int rangeEnd = mapper2.range.getEndOffset();
            return new LimitedRangeHighlighterIterator(this.highlighter.createIterator(rangeStart + shift), rangeStart, rangeEnd);
        }

        public Project getProject() {
            return LayeredLexerEditorHighlighter.this.getClient().getProject();
        }

        public void repaint(int start2, int end) {
        }

        public Document getDocument() {
            return LayeredLexerEditorHighlighter.this.getDocument();
        }

        void resetCachedTextAttributes() {
            this.myAttributesMap.clear();
        }

        void updateMapping(int tokenIndex, @NotNull MappedRange oldMapping) {
            if (oldMapping == null) {
                Mapper.$$$reportNull$$$0(4);
            }
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int start2 = oldMapping.range.getStartOffset();
            int end = oldMapping.range.getEndOffset();
            if (Comparing.equal((CharSequence)this.doc.getCharsSequence().subSequence(start2, end), (CharSequence)tokenText)) {
                return;
            }
            this.doc.replaceString(start2, end, tokenText);
            int newEnd = start2 + tokenText.length();
            if (oldMapping.range.getStartOffset() != start2 || oldMapping.range.getEndOffset() != newEnd) {
                assert (oldMapping.range.getDocument() == this.doc);
                oldMapping.range.dispose();
                oldMapping.range = this.doc.createRangeMarker(start2, newEnd);
            }
        }

        @NotNull
        private MappedRange insertMapping(int tokenIndex, @NotNull IElementType outerToken) {
            if (outerToken == null) {
                Mapper.$$$reportNull$$$0(5);
            }
            CharSequence tokenText = this.getTokenText(tokenIndex);
            int length = tokenText.length();
            MappedRange predecessor = this.findPredecessor(tokenIndex, LayeredLexerEditorHighlighter.this.getSegments());
            int insertOffset = predecessor != null ? predecessor.range.getEndOffset() : 0;
            this.doc.insertString(insertOffset, (CharSequence)new MergingCharSequence((CharSequence)this.mySeparator, tokenText));
            RangeMarker marker = this.doc.createRangeMarker(insertOffset += this.mySeparator.length(), insertOffset + length);
            return new MappedRange(this, marker, outerToken);
        }

        @NotNull
        private CharSequence getTokenText(int tokenIndex) {
            CharSequence charSequence = LayeredLexerEditorHighlighter.this.myText.subSequence(LayeredLexerEditorHighlighter.this.getSegments().getSegmentStart(tokenIndex), LayeredLexerEditorHighlighter.this.getSegments().getSegmentEnd(tokenIndex));
            if (charSequence == null) {
                Mapper.$$$reportNull$$$0(6);
            }
            return charSequence;
        }

        @Nullable
        MappedRange findPredecessor(int token2, MappingSegments segments) {
            --token2;
            while (token2 >= 0) {
                MappedRange mappedRange = segments.myRanges[token2];
                if (mappedRange != null && mappedRange.mapper == this) {
                    return mappedRange;
                }
                --token2;
            }
            return null;
        }

        private void removeMapping(@NotNull MappedRange mapping2) {
            RangeMarker rangeMarker;
            if (mapping2 == null) {
                Mapper.$$$reportNull$$$0(7);
            }
            if ((rangeMarker = mapping2.range).isValid()) {
                int start2 = rangeMarker.getStartOffset();
                int end = rangeMarker.getEndOffset();
                assert (this.doc == rangeMarker.getDocument());
                this.doc.deleteString(start2 - this.mySeparator.length(), end);
                rangeMarker.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldMapping";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outerToken";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$Mapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesKeys";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createIterator";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "updateMapping";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insertMapping";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeMapping";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class MappingSegments
    extends SegmentArrayWithData {
        private MappedRange[] myRanges;
        private final Map<LayerDescriptor, Mapper> myLayerBuffers;
        @Nullable
        private Set<LazyLexerEditorHighlighter> myFreezedHighlighters;

        private MappingSegments(DataStorage o) {
            super(o);
            this.myRanges = new MappedRange[64];
            this.myLayerBuffers = new HashMap<LayerDescriptor, Mapper>();
        }

        @Nullable
        Mapper getMappingDocument(@NotNull IElementType token2) {
            LayerDescriptor descriptor2;
            if (token2 == null) {
                MappingSegments.$$$reportNull$$$0(0);
            }
            if ((descriptor2 = LayeredLexerEditorHighlighter.this.myTokensToLayer.get(token2)) == null) {
                return null;
            }
            Mapper mapper2 = this.myLayerBuffers.get(descriptor2);
            if (mapper2 == null) {
                mapper2 = new Mapper(descriptor2);
                this.myLayerBuffers.put(descriptor2, mapper2);
            }
            return mapper2;
        }

        @Override
        public void removeAll() {
            if (this.mySegmentCount != 0) {
                Arrays.fill(this.myRanges, null);
            }
            this.myLayerBuffers.clear();
            super.removeAll();
        }

        @Override
        public void replace(int startIndex, int endIndex, @NotNull SegmentArrayWithData newData) {
            if (newData == null) {
                MappingSegments.$$$reportNull$$$0(1);
            }
            this.withFreezedHighlighters(() -> super.replace(startIndex, endIndex, newData));
        }

        @Override
        public void setElementAt(int i2, int startOffset, int endOffset, int data2) {
            this.setElementLight(i2, startOffset, endOffset, data2);
            MappedRange range2 = this.myRanges[i2];
            if (range2 != null) {
                this.freezeHighlighter(range2.mapper);
                range2.mapper.removeMapping(range2);
                this.myRanges[i2] = null;
            }
            this.updateMappingForToken(i2);
        }

        private void setElementLight(int i2, int startOffset, int endOffset, int data2) {
            super.setElementAt(i2, startOffset, endOffset, data2);
            this.myRanges = LayeredLexerEditorHighlighter.reallocateArray(this.myRanges, i2 + 1);
        }

        @Override
        public void remove(int startIndex, int endIndex) {
            Map mins = FactoryMap.create(key -> Integer.MAX_VALUE);
            Map maxs = FactoryMap.create(key -> 0);
            for (int i2 = startIndex; i2 < endIndex; ++i2) {
                MappedRange range2 = this.myRanges[i2];
                if (range2 != null && range2.range.isValid()) {
                    mins.put(range2.mapper, Math.min((Integer)mins.get(range2.mapper), range2.range.getStartOffset()));
                    maxs.put(range2.mapper, Math.max((Integer)maxs.get(range2.mapper), range2.range.getEndOffset()));
                }
                this.myRanges[i2] = null;
            }
            for (Map.Entry entry : maxs.entrySet()) {
                Mapper mapper2 = (Mapper)entry.getKey();
                this.freezeHighlighter(mapper2);
                mapper2.doc.deleteString((Integer)mins.get(mapper2) - mapper2.mySeparator.length(), (Integer)entry.getValue());
            }
            this.removeRange(this.myRanges, startIndex, endIndex);
            super.remove(startIndex, endIndex);
        }

        @Override
        protected void replace(int startOffset, @NotNull SegmentArrayWithData data2, int len) {
            if (data2 == null) {
                MappingSegments.$$$reportNull$$$0(2);
            }
            super.replace(startOffset, data2, len);
            for (int i2 = startOffset; i2 < startOffset + len; ++i2) {
                this.updateMappingForToken(i2);
            }
        }

        private MappedRange @NotNull [] insert(MappedRange @NotNull [] array2, MappedRange @NotNull [] insertArray, int startIndex, int insertLength) {
            if (array2 == null) {
                MappingSegments.$$$reportNull$$$0(3);
            }
            if (insertArray == null) {
                MappingSegments.$$$reportNull$$$0(4);
            }
            MappedRange[] newArray = LayeredLexerEditorHighlighter.reallocateArray(array2, this.mySegmentCount + insertLength);
            if (startIndex < this.mySegmentCount) {
                System.arraycopy(newArray, startIndex, newArray, startIndex + insertLength, this.mySegmentCount - startIndex);
            }
            System.arraycopy(insertArray, 0, newArray, startIndex, insertLength);
            if (newArray == null) {
                MappingSegments.$$$reportNull$$$0(5);
            }
            return newArray;
        }

        private <T> void removeRange(T @NotNull [] array2, int startIndex, int endIndex) {
            if (array2 == null) {
                MappingSegments.$$$reportNull$$$0(6);
            }
            if (endIndex < this.mySegmentCount) {
                System.arraycopy(array2, endIndex, array2, startIndex, this.mySegmentCount - endIndex);
            }
            Arrays.fill(array2, this.mySegmentCount - (endIndex - startIndex), this.mySegmentCount, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(@NotNull SegmentArrayWithData segmentArray, int startIndex) {
            if (segmentArray == null) {
                MappingSegments.$$$reportNull$$$0(7);
            }
            LayeredLexerEditorHighlighter layeredLexerEditorHighlighter = LayeredLexerEditorHighlighter.this;
            synchronized (layeredLexerEditorHighlighter) {
                super.insert(segmentArray, startIndex);
                int newCount = segmentArray.getSegmentCount();
                MappedRange[] newRanges = new MappedRange[newCount];
                this.myRanges = this.insert(this.myRanges, newRanges, startIndex, newCount);
                int endIndex = startIndex + segmentArray.getSegmentCount();
                LexerEditorHighlighter.TokenProcessor processor2 = LayeredLexerEditorHighlighter.this.createTokenProcessor(startIndex, LayeredLexerEditorHighlighter.this.getSegments(), LayeredLexerEditorHighlighter.this.myText);
                for (int i2 = startIndex; i2 < endIndex; ++i2) {
                    int data2 = this.getSegmentData(i2);
                    IElementType token2 = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data2);
                    processor2.addToken(i2, this.getSegmentStart(i2), this.getSegmentEnd(i2), data2, token2);
                }
                processor2.finish();
            }
        }

        private void updateMappingForToken(int i2) {
            int data2 = this.getSegmentData(i2);
            IElementType token2 = LayeredLexerEditorHighlighter.this.getSegments().unpackTokenFromData(data2);
            Mapper mapper2 = this.getMappingDocument(token2);
            MappedRange oldMapping = this.myRanges[i2];
            if (mapper2 != null) {
                this.freezeHighlighter(mapper2);
                if (oldMapping != null) {
                    if (oldMapping.mapper == mapper2 && oldMapping.outerToken == token2) {
                        mapper2.updateMapping(i2, oldMapping);
                    } else {
                        oldMapping.mapper.removeMapping(oldMapping);
                        this.myRanges[i2] = mapper2.insertMapping(i2, token2);
                    }
                } else {
                    this.myRanges[i2] = mapper2.insertMapping(i2, token2);
                }
            } else if (oldMapping != null) {
                this.freezeHighlighter(oldMapping.mapper);
                oldMapping.mapper.removeMapping(oldMapping);
                this.myRanges[i2] = null;
            }
        }

        private void withFreezedHighlighters(@NotNull Runnable action2) {
            if (action2 == null) {
                MappingSegments.$$$reportNull$$$0(8);
            }
            if (this.myFreezedHighlighters != null) {
                action2.run();
                return;
            }
            this.myFreezedHighlighters = new HashSet<LazyLexerEditorHighlighter>();
            try {
                action2.run();
            }
            finally {
                this.myFreezedHighlighters.forEach(highlighter -> {
                    try {
                        highlighter.finishUpdate();
                    }
                    catch (IllegalStateException e) {
                        LOG.error(e.getMessage() + "\nLayer highlighter: " + highlighter.getSyntaxHighlighter().toString() + "\nTop level highlighter: " + LayeredLexerEditorHighlighter.this.getSyntaxHighlighter().toString(), (Throwable)e, new Attachment[]{new Attachment("layerTextAfterChange.txt", highlighter.myText.toString()), new Attachment("editorTextAfterChange.txt", LayeredLexerEditorHighlighter.this.myText.toString())});
                    }
                });
                this.myFreezedHighlighters = null;
            }
        }

        private void freezeHighlighter(@NotNull Mapper mapper2) {
            if (mapper2 == null) {
                MappingSegments.$$$reportNull$$$0(9);
            }
            if (this.myFreezedHighlighters != null && this.myFreezedHighlighters.add(mapper2.highlighter)) {
                mapper2.highlighter.beginUpdate();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "insertArray";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segmentArray";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "action";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$MappingSegments";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "insert";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMappingDocument";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replace";
                    break;
                }
                case 3: 
                case 4: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "insert";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRange";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "withFreezedHighlighters";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "freezeHighlighter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class LightMapper {
        final Mapper mapper;
        final StringBuilder text;
        final IntList lengths;
        final List<IElementType> tokenTypes;
        final Int2IntMap index2Global;
        private final String mySeparator;
        final int insertOffset;

        LightMapper(Mapper mapper2, int insertOffset) {
            if (mapper2 == null) {
                LightMapper.$$$reportNull$$$0(0);
            }
            this.text = new StringBuilder();
            this.lengths = new IntArrayList();
            this.tokenTypes = new ArrayList<IElementType>();
            this.index2Global = new Int2IntOpenHashMap();
            this.mapper = mapper2;
            this.mySeparator = mapper2.mySeparator;
            this.insertOffset = insertOffset;
        }

        void addToken(@NotNull CharSequence tokenText, @NotNull IElementType tokenType, int globalIndex) {
            if (tokenText == null) {
                LightMapper.$$$reportNull$$$0(1);
            }
            if (tokenType == null) {
                LightMapper.$$$reportNull$$$0(2);
            }
            this.index2Global.put(this.tokenTypes.size(), globalIndex);
            this.text.append(this.mySeparator).append(tokenText);
            this.lengths.add(tokenText.length());
            this.tokenTypes.add(tokenType);
        }

        void finish() {
            assert (this.insertOffset >= 0);
            DocumentImpl document = this.mapper.doc;
            document.insertString(this.insertOffset, this.text);
            int start2 = this.insertOffset;
            for (int i2 = 0; i2 < this.tokenTypes.size(); ++i2) {
                IElementType type = this.tokenTypes.get(i2);
                int len = this.lengths.getInt(i2);
                int globalIndex = this.index2Global.get(i2);
                MappedRange[] ranges = LayeredLexerEditorHighlighter.this.getSegments().myRanges;
                this.checkNull(type, ranges[globalIndex]);
                ranges[globalIndex] = new MappedRange(this.mapper, document.createRangeMarker(start2 += this.mySeparator.length(), start2 + len), type);
                start2 += len;
            }
        }

        private void checkNull(@NotNull IElementType type, @Nullable MappedRange range2) {
            if (type == null) {
                LightMapper.$$$reportNull$$$0(3);
            }
            if (range2 != null) {
                Document mainDocument = LayeredLexerEditorHighlighter.this.getDocument();
                VirtualFile file2 = mainDocument == null ? null : FileDocumentManager.getInstance().getFile(mainDocument);
                LOG.error("Expected null range on " + type + ", found " + range2 + "; highlighter=" + LayeredLexerEditorHighlighter.this.getSyntaxHighlighter(), new Attachment[]{new Attachment(file2 != null ? file2.getName() : "editorText.txt", LayeredLexerEditorHighlighter.this.myText.toString())});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tokenType";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/ex/util/LayeredLexerEditorHighlighter$LightMapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToken";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNull";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

