/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/openapi/editor/actions/TransposeAction;", "Lcom/intellij/openapi/editor/actionSystem/EditorAction;", "()V", "TransposeHandler", "intellij.platform.ide.impl"})
public final class TransposeAction
extends EditorAction {
    public TransposeAction() {
        super((EditorActionHandler)new TransposeHandler());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/editor/actions/TransposeAction$TransposeHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler$ForEachCaret;", "()V", "executeWriteAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isEnabledForCaret", "", "intellij.platform.ide.impl"})
    private static final class TransposeHandler
    extends EditorWriteActionHandler.ForEachCaret {
        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            return !caret.hasSelection() && caret.getOffset() > 0;
        }

        public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, @Nullable DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
            int line = caret.getLogicalPosition().line;
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
            Document document2 = document;
            if (caret.getOffset() < document2.getLineEndOffset(line)) {
                int offsetBeforeCaret = DocumentUtil.getPreviousCodePointOffset(document2, caret.getOffset());
                int offsetAfterCaret = DocumentUtil.getNextCodePointOffset(document2, caret.getOffset());
                CharSequence codepointBeforeCaret = document2.getCharsSequence().subSequence(offsetBeforeCaret, caret.getOffset());
                CharSequence codepointAfterCaret = document2.getCharsSequence().subSequence(caret.getOffset(), offsetAfterCaret);
                document2.replaceString(offsetBeforeCaret, offsetAfterCaret, (CharSequence)("" + codepointAfterCaret + codepointBeforeCaret));
                caret.moveToOffset(offsetAfterCaret);
            } else {
                int offsetBeforeCaret = DocumentUtil.getPreviousCodePointOffset(document2, caret.getOffset());
                int offset2BeforeCaret = DocumentUtil.getPreviousCodePointOffset(document2, offsetBeforeCaret);
                if (offset2BeforeCaret >= 0) {
                    CharSequence codepoint2BeforeCaret = document2.getCharsSequence().subSequence(offset2BeforeCaret, offsetBeforeCaret);
                    CharSequence codepointBeforeCaret = document2.getCharsSequence().subSequence(offsetBeforeCaret, caret.getOffset());
                    document2.replaceString(offset2BeforeCaret, caret.getOffset(), (CharSequence)("" + codepointBeforeCaret + codepoint2BeforeCaret));
                }
            }
        }
    }
}

