/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actions.CaretStop;
import com.intellij.openapi.editor.actions.CaretStopPolicy;
import com.intellij.openapi.editor.actions.LanguageWordBoundaryFilter;
import com.intellij.openapi.editor.actions.WordBoundaryFilter;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.DocumentUtil;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorActionUtil {
    protected static final Object EDIT_COMMAND_GROUP = Key.create((String)"EditGroup");
    public static final Object DELETE_COMMAND_GROUP = Key.create((String)"DeleteGroup");
    private static final Key<VisualPosition> PREV_POS = Key.create((String)"PREV_POS");

    private EditorActionUtil() {
    }

    public static void scrollRelatively(@NotNull Editor editor, int lineShift, int columnShift, boolean moveCaret) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(0);
        }
        if (lineShift != 0) {
            editor.getScrollingModel().scrollVertically(editor.getScrollingModel().getVerticalScrollOffset() + lineShift * editor.getLineHeight());
        }
        if (columnShift != 0) {
            editor.getScrollingModel().scrollHorizontally(editor.getScrollingModel().getHorizontalScrollOffset() + columnShift * EditorUtil.getSpaceWidth(0, editor));
        }
        if (!moveCaret) {
            return;
        }
        Rectangle viewRectangle = EditorActionUtil.getVisibleArea(editor);
        int lineNumber = editor.getCaretModel().getVisualPosition().line;
        VisualPosition startPos = editor.xyToVisualPosition(new Point(0, viewRectangle.y));
        int start2 = startPos.line + 1;
        VisualPosition endPos = editor.xyToVisualPosition(new Point(0, viewRectangle.y + viewRectangle.height));
        int end = endPos.line - 2;
        if (lineNumber < start2) {
            editor.getCaretModel().moveCaretRelatively(0, start2 - lineNumber, false, false, true);
        } else if (lineNumber > end) {
            editor.getCaretModel().moveCaretRelatively(0, end - lineNumber, false, false, true);
        }
    }

    public static void moveCaretRelativelyAndScroll(@NotNull Editor editor, int columnShift, int lineShift, boolean withSelection) {
        boolean scrollToCaret;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(1);
        }
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        VisualPosition pos = editor.getCaretModel().getVisualPosition();
        Point caretLocation = editor.visualPositionToXY(pos);
        int caretVShift = caretLocation.y - visibleArea.y;
        editor.getCaretModel().moveCaretRelatively(columnShift, lineShift, withSelection, false, false);
        VisualPosition caretPos = editor.getCaretModel().getVisualPosition();
        Point caretLocation2 = editor.visualPositionToXY(caretPos);
        boolean bl = scrollToCaret = !(editor instanceof EditorImpl) || ((EditorImpl)editor).isScrollToCaret();
        if (scrollToCaret) {
            editor.getScrollingModel().scrollVertically(caretLocation2.y - caretVShift);
        }
    }

    public static void indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(2);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        int newCaretOffset = EditorActionUtil.indentLine(project, editor, lineNumber, indent, caretOffset);
        editor.getCaretModel().moveToOffset(newCaretOffset);
    }

    public static int indentLine(Project project, @NotNull Editor editor, int lineNumber, int indent, int caretOffset) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(3);
        }
        return EditorCoreUtil.indentLine((Project)project, (Editor)editor, (int)lineNumber, (int)indent, (int)caretOffset, (boolean)EditorActionUtil.shouldUseSmartTabs(project, editor));
    }

    public static boolean shouldUseSmartTabs(Project project, @NotNull Editor editor) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(4);
        }
        if (!(editor instanceof EditorEx)) {
            return false;
        }
        return CodeStyle.getIndentOptions((Project)project, (Document)editor.getDocument()).SMART_TABS;
    }

    public static void selectEntireLines(@NotNull Caret caret) {
        if (caret == null) {
            EditorActionUtil.$$$reportNull$$$0(5);
        }
        EditorActionUtil.selectEntireLines(caret, false);
    }

    public static void selectEntireLines(@NotNull Caret caret, boolean resetToSingleLineAtCaret) {
        Editor editor;
        Document document;
        int lineNumber;
        if (caret == null) {
            EditorActionUtil.$$$reportNull$$$0(6);
        }
        if ((lineNumber = caret.getLogicalPosition().line) >= (document = (editor = caret.getEditor()).getDocument()).getLineCount()) {
            return;
        }
        Pair<LogicalPosition, LogicalPosition> lines2 = EditorUtil.calcSurroundingRange(editor, resetToSingleLineAtCaret ? caret.getVisualPosition() : caret.getSelectionStartPosition(), resetToSingleLineAtCaret ? caret.getVisualPosition() : caret.getSelectionEndPosition());
        LogicalPosition lineStart = (LogicalPosition)lines2.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines2.second;
        int start2 = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        caret.setSelection(start2, end);
    }

    @NotNull
    public static TextRange getRangeToWordEnd(@NotNull Editor editor, boolean isCamel, boolean handleQuoted) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(7);
        }
        int startOffset = editor.getCaretModel().getOffset();
        int endOffset = EditorActionUtil.getNextCaretStopOffset(editor, CaretStopPolicy.BOTH, isCamel, handleQuoted);
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            EditorActionUtil.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @NotNull
    public static TextRange getRangeToWordStart(@NotNull Editor editor, boolean isCamel, boolean handleQuoted) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(9);
        }
        int endOffset = editor.getCaretModel().getOffset();
        int startOffset = EditorActionUtil.getPreviousCaretStopOffset(editor, CaretStopPolicy.WORD_START, isCamel, handleQuoted);
        TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
        if (textRange == null) {
            EditorActionUtil.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    public static int getNextCaretStopOffset(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(11);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(12);
        }
        return EditorActionUtil.getNextCaretStopOffset(editor, caretStopPolicy, isCamel, false);
    }

    public static int getPreviousCaretStopOffset(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(13);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(14);
        }
        return EditorActionUtil.getPreviousCaretStopOffset(editor, caretStopPolicy, isCamel, false);
    }

    public static int getNextCaretStopOffset(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel, boolean handleQuoted) {
        int newOffsetBeforeQuote;
        HighlighterIterator tokenIterator;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(15);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(16);
        }
        int maxOffset = EditorActionUtil.getNextLineStopOffset(editor, caretStopPolicy.getLineStop());
        CaretStop wordStop = caretStopPolicy.getWordStop();
        if (wordStop.equals(CaretStop.NONE)) {
            return maxOffset;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == maxOffset) {
            return maxOffset;
        }
        CharSequence text2 = editor.getDocument().getCharsSequence();
        int newOffset = EditorActionUtil.getNextWordStopOffset(text2, wordStop, tokenIterator = EditorActionUtil.createHighlighterIteratorAtOffset(editor, offset), offset, maxOffset, isCamel);
        if (newOffset < maxOffset && handleQuoted && tokenIterator != null && EditorActionUtil.isTokenStart(tokenIterator, newOffset - 1) && EditorActionUtil.isQuotedToken(tokenIterator, text2) && EditorActionUtil.isTokenEnd(tokenIterator, (newOffsetBeforeQuote = EditorActionUtil.getNextWordStopOffset(text2, CaretStop.BOTH, tokenIterator, newOffset, maxOffset, isCamel)) + 1)) {
            return EditorActionUtil.getNextWordStopOffset(text2, wordStop, tokenIterator, newOffsetBeforeQuote, maxOffset, isCamel);
        }
        return newOffset;
    }

    public static int getPreviousCaretStopOffset(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isCamel, boolean handleQuoted) {
        int newOffsetAfterQuote;
        HighlighterIterator tokenIterator;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(17);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(18);
        }
        int minOffset = EditorActionUtil.getPreviousLineStopOffset(editor, caretStopPolicy.getLineStop());
        CaretStop wordStop = caretStopPolicy.getWordStop();
        if (wordStop.equals(CaretStop.NONE)) {
            return minOffset;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == minOffset) {
            return minOffset;
        }
        CharSequence text2 = editor.getDocument().getCharsSequence();
        int newOffset = EditorActionUtil.getPreviousWordStopOffset(text2, wordStop, tokenIterator = EditorActionUtil.createHighlighterIteratorAtOffset(editor, offset - 1), offset, minOffset, isCamel);
        if (newOffset > minOffset && handleQuoted && tokenIterator != null && EditorActionUtil.isTokenEnd(tokenIterator, newOffset + 1) && EditorActionUtil.isQuotedToken(tokenIterator, text2) && EditorActionUtil.isTokenStart(tokenIterator, (newOffsetAfterQuote = EditorActionUtil.getPreviousWordStopOffset(text2, CaretStop.BOTH, tokenIterator, newOffset, minOffset, isCamel)) - 1)) {
            return EditorActionUtil.getPreviousWordStopOffset(text2, wordStop, tokenIterator, newOffsetAfterQuote, minOffset, isCamel);
        }
        return newOffset;
    }

    private static int getNextWordStopOffset(@NotNull CharSequence text2, @NotNull CaretStop wordStop, @Nullable HighlighterIterator tokenIterator, int offset, int maxOffset, boolean isCamel) {
        int newOffset;
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(19);
        }
        if (wordStop == null) {
            EditorActionUtil.$$$reportNull$$$0(20);
        }
        for (newOffset = offset + 1; newOffset < maxOffset; ++newOffset) {
            boolean isTokenBoundary;
            boolean bl = isTokenBoundary = tokenIterator != null && EditorActionUtil.advanceTokenOnBoundary(tokenIterator, text2, newOffset);
            if (EditorActionUtil.isWordStopOffset(text2, wordStop, newOffset, isCamel, isTokenBoundary)) break;
        }
        return newOffset;
    }

    private static int getPreviousWordStopOffset(@NotNull CharSequence text2, @NotNull CaretStop wordStop, @Nullable HighlighterIterator tokenIterator, int offset, int minOffset, boolean isCamel) {
        int newOffset;
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(21);
        }
        if (wordStop == null) {
            EditorActionUtil.$$$reportNull$$$0(22);
        }
        for (newOffset = offset - 1; newOffset > minOffset; --newOffset) {
            boolean isTokenBoundary;
            boolean bl = isTokenBoundary = tokenIterator != null && EditorActionUtil.retreatTokenOnBoundary(tokenIterator, text2, newOffset);
            if (EditorActionUtil.isWordStopOffset(text2, wordStop, newOffset, isCamel, isTokenBoundary)) break;
        }
        return newOffset;
    }

    private static boolean isWordStopOffset(@NotNull CharSequence text2, @NotNull CaretStop wordStop, int offset, boolean isCamel, boolean isLexemeBoundary) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(23);
        }
        if (wordStop == null) {
            EditorActionUtil.$$$reportNull$$$0(24);
        }
        if (wordStop.isAtStart() && wordStop.isAtEnd()) {
            return isLexemeBoundary || EditorActionUtil.isWordStart(text2, offset, isCamel) || EditorActionUtil.isWordEnd(text2, offset, isCamel);
        }
        if (wordStop.isAtStart()) {
            return isLexemeBoundary && !EditorActionUtil.isWordEnd(text2, offset, isCamel) || EditorActionUtil.isWordStart(text2, offset, isCamel);
        }
        if (wordStop.isAtEnd()) {
            return isLexemeBoundary && !EditorActionUtil.isWordStart(text2, offset, isCamel) || EditorActionUtil.isWordEnd(text2, offset, isCamel);
        }
        return false;
    }

    private static boolean advanceTokenOnBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text2, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(25);
        }
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(26);
        }
        if (EditorActionUtil.isTokenEnd(tokenIterator, offset)) {
            IElementType leftToken = tokenIterator.getTokenType();
            boolean wasQuotedToken = EditorActionUtil.isQuotedToken(tokenIterator, text2);
            tokenIterator.advance();
            return wasQuotedToken || EditorActionUtil.isQuotedToken(tokenIterator, text2) || !EditorActionUtil.isBetweenWhitespaces(text2, offset) && EditorActionUtil.isLexemeBoundary(leftToken, tokenIterator.getTokenType());
        }
        return EditorActionUtil.isQuotedTokenInnardsBoundary(tokenIterator, text2, offset);
    }

    private static boolean retreatTokenOnBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text2, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(27);
        }
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(28);
        }
        if (EditorActionUtil.isTokenStart(tokenIterator, offset)) {
            IElementType rightToken = tokenIterator.getTokenType();
            boolean wasQuotedToken = EditorActionUtil.isQuotedToken(tokenIterator, text2);
            tokenIterator.retreat();
            return wasQuotedToken || EditorActionUtil.isQuotedToken(tokenIterator, text2) || !EditorActionUtil.isBetweenWhitespaces(text2, offset) && EditorActionUtil.isLexemeBoundary(tokenIterator.getTokenType(), rightToken);
        }
        return EditorActionUtil.isQuotedTokenInnardsBoundary(tokenIterator, text2, offset);
    }

    private static boolean isQuotedTokenInnardsBoundary(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text2, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(29);
        }
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(30);
        }
        return (EditorActionUtil.isTokenStart(tokenIterator, offset - 1) || EditorActionUtil.isTokenEnd(tokenIterator, offset + 1)) && EditorActionUtil.isQuotedToken(tokenIterator, text2);
    }

    private static boolean isTokenStart(@NotNull HighlighterIterator tokenIterator, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(31);
        }
        return offset == tokenIterator.getStart();
    }

    private static boolean isTokenEnd(@NotNull HighlighterIterator tokenIterator, int offset) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(32);
        }
        return offset == tokenIterator.getEnd();
    }

    private static boolean isQuotedToken(@NotNull HighlighterIterator tokenIterator, @NotNull CharSequence text2) {
        if (tokenIterator == null) {
            EditorActionUtil.$$$reportNull$$$0(33);
        }
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(34);
        }
        int startOffset = tokenIterator.getStart();
        int endOffset = tokenIterator.getEnd();
        if (endOffset - startOffset < 2) {
            return false;
        }
        char openingQuote = EditorActionUtil.getQuoteAt(text2, startOffset);
        char closingQuote = EditorActionUtil.getQuoteAt(text2, endOffset - 1);
        return openingQuote != '\u0000' && closingQuote == openingQuote;
    }

    private static char getQuoteAt(@NotNull CharSequence text2, int offset) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(35);
        }
        if (offset < 0 || offset >= text2.length()) {
            return '\u0000';
        }
        char ch = text2.charAt(offset);
        return ch == '\'' || ch == '\"' ? ch : (char)'\u0000';
    }

    @Nullable
    private static HighlighterIterator createHighlighterIteratorAtOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(36);
        }
        if (!(editor instanceof EditorEx)) {
            return null;
        }
        return ((EditorEx)editor).getHighlighter().createIterator(offset);
    }

    private static boolean isLexemeBoundary(@Nullable IElementType leftTokenType, @Nullable IElementType rightTokenType) {
        return leftTokenType != null && rightTokenType != null && ((WordBoundaryFilter)LanguageWordBoundaryFilter.INSTANCE.forLanguage(rightTokenType.getLanguage())).isWordBoundary(leftTokenType, rightTokenType);
    }

    public static int getNextLineStopOffset(@NotNull Editor editor, @NotNull CaretStop lineStop) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(37);
        }
        if (lineStop == null) {
            EditorActionUtil.$$$reportNull$$$0(38);
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int lineNumber = caretModel.getLogicalPosition().line;
        boolean isAtLineEnd = caretModel.getOffset() == document.getLineEndOffset(lineNumber);
        return EditorActionUtil.getNextLineStopOffset(document, lineStop, lineNumber, isAtLineEnd);
    }

    private static int getNextLineStopOffset(@NotNull Document document, @NotNull CaretStop lineStop, int lineNumber, boolean isAtLineEnd) {
        if (document == null) {
            EditorActionUtil.$$$reportNull$$$0(39);
        }
        if (lineStop == null) {
            EditorActionUtil.$$$reportNull$$$0(40);
        }
        if (lineNumber + 1 >= document.getLineCount()) {
            return document.getTextLength();
        }
        if (!isAtLineEnd) {
            return lineStop.isAtEnd() ? document.getLineEndOffset(lineNumber) : (lineStop.isAtStart() ? document.getLineStartOffset(lineNumber + 1) : document.getTextLength());
        }
        return lineStop.isAtStart() ? document.getLineStartOffset(lineNumber + 1) : (lineStop.isAtEnd() ? document.getLineEndOffset(lineNumber + 1) : document.getTextLength());
    }

    public static int getPreviousLineStopOffset(@NotNull Editor editor, @NotNull CaretStop lineStop) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(41);
        }
        if (lineStop == null) {
            EditorActionUtil.$$$reportNull$$$0(42);
        }
        Document document = editor.getDocument();
        CaretModel caretModel = editor.getCaretModel();
        int lineNumber = caretModel.getLogicalPosition().line;
        boolean isAtLineStart = caretModel.getOffset() == document.getLineStartOffset(lineNumber);
        return EditorActionUtil.getPreviousLineStopOffset(document, lineStop, lineNumber, isAtLineStart);
    }

    private static int getPreviousLineStopOffset(@NotNull Document document, @NotNull CaretStop lineStop, int lineNumber, boolean isAtLineStart) {
        if (document == null) {
            EditorActionUtil.$$$reportNull$$$0(43);
        }
        if (lineStop == null) {
            EditorActionUtil.$$$reportNull$$$0(44);
        }
        if (lineNumber - 1 < 0) {
            return 0;
        }
        if (!isAtLineStart) {
            return lineStop.isAtStart() ? document.getLineStartOffset(lineNumber) : (lineStop.isAtEnd() ? document.getLineEndOffset(lineNumber - 1) : 0);
        }
        return lineStop.isAtEnd() ? document.getLineEndOffset(lineNumber - 1) : (lineStop.isAtStart() ? document.getLineStartOffset(lineNumber - 1) : 0);
    }

    public static boolean isWordOrLexemeStart(@NotNull Editor editor, int offset, boolean isCamel) {
        CharSequence chars;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(45);
        }
        return EditorActionUtil.isWordStart(chars = editor.getDocument().getCharsSequence(), offset, isCamel) || !EditorActionUtil.isWordEnd(chars, offset, isCamel) && EditorActionUtil.isLexemeBoundary(editor, offset);
    }

    public static boolean isWordOrLexemeEnd(@NotNull Editor editor, int offset, boolean isCamel) {
        CharSequence chars;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(46);
        }
        return EditorActionUtil.isWordEnd(chars = editor.getDocument().getCharsSequence(), offset, isCamel) || !EditorActionUtil.isWordStart(chars, offset, isCamel) && EditorActionUtil.isLexemeBoundary(editor, offset);
    }

    public static boolean isLexemeBoundary(@NotNull Editor editor, int offset) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(47);
        }
        if (!(editor instanceof EditorEx) || offset <= 0 || offset >= editor.getDocument().getTextLength() || DocumentUtil.isInsideSurrogatePair(editor.getDocument(), offset) || EditorActionUtil.isBetweenWhitespaces(editor.getDocument().getCharsSequence(), offset)) {
            return false;
        }
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator it = highlighter.createIterator(offset);
        return EditorActionUtil.retreatTokenOnBoundary(it, editor.getDocument().getCharsSequence(), offset);
    }

    public static void moveCaretToLineStart(@NotNull Editor editor, boolean isWithSelection) {
        int logLineToUse;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(48);
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        EditorSettings editorSettings = editor.getSettings();
        int logCaretLine = caretModel.getLogicalPosition().line;
        VisualPosition currentVisCaret = caretModel.getVisualPosition();
        VisualPosition caretLogLineStartVis = editor.offsetToVisualPosition(document.getLineStartOffset(logCaretLine));
        if (currentVisCaret.line > caretLogLineStartVis.line) {
            if (editorSettings.isSmartHome()) {
                EditorActionUtil.moveCaretToStartOfSoftWrappedLine(editor, currentVisCaret);
            } else {
                caretModel.moveToVisualPosition(new VisualPosition(currentVisCaret.line, 0));
            }
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            EditorModificationUtil.scrollToCaret((Editor)editor);
            return;
        }
        for (logLineToUse = logCaretLine - 1; logLineToUse >= 0 && editor.offsetToVisualPosition((int)document.getLineEndOffset((int)logLineToUse)).line == currentVisCaret.line; --logLineToUse) {
        }
        if (++logLineToUse >= document.getLineCount() || !editorSettings.isSmartHome()) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(logLineToUse, 0));
        } else if (logLineToUse == logCaretLine) {
            int column;
            int line = currentVisCaret.line;
            if (currentVisCaret.column == 0) {
                column = EditorActionUtil.findSmartIndentColumn(editor, currentVisCaret.line);
            } else {
                column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, currentVisCaret.line);
                if (column >= currentVisCaret.column) {
                    column = 0;
                }
            }
            caretModel.moveToVisualPosition(new VisualPosition(line, Math.max(column, 0)));
        } else {
            LogicalPosition logLineEndLog = editor.offsetToLogicalPosition(document.getLineEndOffset(logLineToUse));
            VisualPosition logLineEndVis = editor.logicalToVisualPosition(logLineEndLog);
            int softWrapCount = EditorUtil.getSoftWrapCountAfterLineStart(editor, logLineEndLog);
            if (softWrapCount > 0) {
                EditorActionUtil.moveCaretToStartOfSoftWrappedLine(editor, logLineEndVis);
            } else {
                int firstNonSpaceColumnOnTheLine;
                int line = logLineEndVis.line;
                int column = 0;
                if (currentVisCaret.column > 0 && (firstNonSpaceColumnOnTheLine = Math.max(0, EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, currentVisCaret.line))) < currentVisCaret.column) {
                    column = firstNonSpaceColumnOnTheLine;
                }
                caretModel.moveToVisualPosition(new VisualPosition(line, column));
            }
        }
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
        EditorModificationUtil.scrollToCaret((Editor)editor);
    }

    private static void moveCaretToStartOfSoftWrappedLine(@NotNull Editor editor, VisualPosition currentVisual) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(49);
        }
        CaretModel caretModel = editor.getCaretModel();
        int startLineOffset = editor.visualPositionToOffset(new VisualPosition(currentVisual.line, 0));
        SoftWrapModel softWrapModel = editor.getSoftWrapModel();
        SoftWrap softWrap = softWrapModel.getSoftWrap(startLineOffset);
        if (softWrap == null) {
            int column;
            int columnToMove = column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, currentVisual.line);
            if (column < 0 || currentVisual.column <= column && currentVisual.column > 0) {
                columnToMove = 0;
            }
            caretModel.moveToVisualPosition(new VisualPosition(currentVisual.line, columnToMove));
            return;
        }
        if (currentVisual.column > softWrap.getIndentInColumns()) {
            caretModel.moveToOffset(softWrap.getStart());
        } else if (currentVisual.column > 0) {
            caretModel.moveToVisualPosition(new VisualPosition(currentVisual.line, 0));
        } else {
            int lineStartOffset = EditorUtil.getNotFoldedLineStartOffset(editor, startLineOffset);
            int visualLine = editor.offsetToVisualPosition((int)lineStartOffset).line;
            caretModel.moveToVisualPosition(new VisualPosition(visualLine, Math.max(0, EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, visualLine))));
        }
    }

    private static int findSmartIndentColumn(@NotNull Editor editor, int visualLine) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(50);
        }
        for (int i2 = visualLine; i2 >= 0; --i2) {
            int column = EditorActionUtil.findFirstNonSpaceColumnOnTheLine(editor, i2);
            if (column < 0) continue;
            return column;
        }
        return 0;
    }

    public static int findFirstNonSpaceColumnOnTheLine(@NotNull Editor editor, int visualLineNumber) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(51);
        }
        int startOffset = editor.visualPositionToOffset(new VisualPosition(visualLineNumber, 0));
        int endOffset = EditorUtil.getNotFoldedLineEndOffset(editor, startOffset);
        int offset = EditorActionUtil.findFirstNonSpaceOffsetInRange(editor.getDocument().getImmutableCharSequence(), startOffset, endOffset);
        if (offset == -1) {
            return -1;
        }
        VisualPosition targetPosition = editor.offsetToVisualPosition(offset, true, false);
        return targetPosition.line == visualLineNumber ? targetPosition.column : -1;
    }

    public static int findFirstNonSpaceOffsetOnTheLine(@NotNull Document document, int lineNumber) {
        if (document == null) {
            EditorActionUtil.$$$reportNull$$$0(52);
        }
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        int result2 = EditorActionUtil.findFirstNonSpaceOffsetInRange(document.getCharsSequence(), lineStart, lineEnd);
        return result2 >= 0 ? result2 : lineEnd;
    }

    public static int findFirstNonSpaceOffsetInRange(@NotNull CharSequence text2, int start2, int end) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(53);
        }
        while (start2 < end) {
            char c = text2.charAt(start2);
            if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                return start2;
            }
            ++start2;
        }
        return -1;
    }

    public static void moveCaretToLineEnd(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(54);
        }
        EditorActionUtil.moveCaretToLineEnd(editor, isWithSelection, true);
    }

    public static void moveCaretToLineEnd(@NotNull Editor editor, boolean isWithSelection, boolean ignoreTrailingWhitespace) {
        int offset;
        VisualPosition visualEndOfLineWithCaret;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(55);
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        SoftWrapModel softWrapModel = editor.getSoftWrapModel();
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        if (lineNumber >= document.getLineCount()) {
            LogicalPosition pos = new LogicalPosition(lineNumber, 0);
            editor.getCaretModel().moveToLogicalPosition(pos);
            EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
            EditorModificationUtil.scrollToCaret((Editor)editor);
            return;
        }
        VisualPosition currentVisualCaret = editor.getCaretModel().getVisualPosition();
        if (currentVisualCaret.equals((Object)(visualEndOfLineWithCaret = new VisualPosition(currentVisualCaret.line, EditorUtil.getLastVisualLineColumnNumber(editor, currentVisualCaret.line), true))) && (offset = editor.visualPositionToOffset(visualEndOfLineWithCaret)) < editor.getDocument().getTextLength()) {
            int logicalLineEndOffset = EditorUtil.getNotFoldedLineEndOffset(editor, offset);
            visualEndOfLineWithCaret = editor.offsetToVisualPosition(logicalLineEndOffset, true, false);
        }
        LogicalPosition logLineEnd = editor.visualToLogicalPosition(visualEndOfLineWithCaret);
        int offset2 = editor.logicalPositionToOffset(logLineEnd);
        lineNumber = logLineEnd.line;
        int newOffset = offset2;
        CharSequence text2 = document.getCharsSequence();
        int i2 = newOffset - 1;
        while (i2 >= document.getLineStartOffset(lineNumber)) {
            if (softWrapModel.getSoftWrap(i2) != null) {
                newOffset = offset2;
                break;
            }
            if (text2.charAt(i2) != ' ' && text2.charAt(i2) != '\t') break;
            newOffset = i2--;
        }
        if (newOffset == offset2 || newOffset == caretModel.getOffset() || !ignoreTrailingWhitespace) {
            caretModel.moveToVisualPosition(visualEndOfLineWithCaret);
        } else if (editor instanceof EditorImpl) {
            caretModel.moveToLogicalPosition(editor.offsetToLogicalPosition(newOffset).leanForward(true));
        } else {
            caretModel.moveToOffset(newOffset);
        }
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretToNextWord(@NotNull Editor editor, boolean isWithSelection, boolean camel) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(56);
        }
        EditorActionUtil.moveToNextCaretStop(editor, EditorSettingsExternalizable.getInstance().getCaretStopOptions().getForwardPolicy(), isWithSelection, camel);
    }

    public static void moveToNextCaretStop(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isWithSelection, boolean isCamel) {
        int boundaryOffset;
        int newOffset;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(57);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(58);
        }
        Document document = editor.getDocument();
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        int offset = caretModel.getOffset();
        if (offset == document.getTextLength()) {
            return;
        }
        FoldRegion currentFoldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset);
        if (currentFoldRegion != null) {
            newOffset = currentFoldRegion.getEndOffset();
        } else {
            newOffset = EditorActionUtil.getNextCaretStopOffset(editor, caretStopPolicy, isCamel);
            if (newOffset == offset) {
                return;
            }
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(newOffset);
            if (foldRegion != null) {
                newOffset = foldRegion.getStartOffset();
            }
        }
        if (editor instanceof EditorImpl && (boundaryOffset = ((EditorImpl)editor).findNearestDirectionBoundary(offset, true)) >= 0) {
            newOffset = Math.min(boundaryOffset, newOffset);
        }
        caretModel.moveToOffset(newOffset);
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    private static void setupSelection(@NotNull Editor editor, boolean isWithSelection, int selectionStart, @NotNull LogicalPosition blockSelectionStart) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(59);
        }
        if (blockSelectionStart == null) {
            EditorActionUtil.$$$reportNull$$$0(60);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        if (isWithSelection) {
            if (editor.isColumnMode() && !caretModel.supportsMultipleCarets()) {
                selectionModel.setBlockSelection(blockSelectionStart, caretModel.getLogicalPosition());
            } else {
                selectionModel.setSelection(selectionStart, caretModel.getVisualPosition(), caretModel.getOffset());
            }
        } else {
            selectionModel.removeSelection();
        }
        EditorActionUtil.selectNonexpandableFold(editor);
    }

    public static void selectNonexpandableFold(@NotNull Editor editor) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(61);
        }
        CaretModel caretModel = editor.getCaretModel();
        VisualPosition pos = caretModel.getVisualPosition();
        VisualPosition prevPos = (VisualPosition)editor.getUserData(PREV_POS);
        if (prevPos != null) {
            int columnShift = pos.line == prevPos.line ? pos.column - prevPos.column : 0;
            int caret = caretModel.getOffset();
            FoldRegion collapsedUnderCaret = editor.getFoldingModel().getCollapsedRegionAtOffset(caret);
            if (collapsedUnderCaret != null && collapsedUnderCaret.shouldNeverExpand() && Boolean.TRUE.equals(collapsedUnderCaret.getUserData(FoldingModelImpl.SELECT_REGION_ON_CARET_NEARBY))) {
                if (caret > collapsedUnderCaret.getStartOffset() && columnShift > 0) {
                    caretModel.moveToOffset(collapsedUnderCaret.getEndOffset());
                } else if (caret + 1 < collapsedUnderCaret.getEndOffset() && columnShift < 0) {
                    caretModel.moveToOffset(collapsedUnderCaret.getStartOffset());
                }
                editor.getSelectionModel().setSelection(collapsedUnderCaret.getStartOffset(), collapsedUnderCaret.getEndOffset());
            }
        }
        editor.putUserData(PREV_POS, (Object)pos);
    }

    public static void moveCaretToPreviousWord(@NotNull Editor editor, boolean isWithSelection, boolean camel) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(62);
        }
        EditorActionUtil.moveToPreviousCaretStop(editor, EditorSettingsExternalizable.getInstance().getCaretStopOptions().getBackwardPolicy(), isWithSelection, camel);
    }

    public static void moveToPreviousCaretStop(@NotNull Editor editor, @NotNull CaretStopPolicy caretStopPolicy, boolean isWithSelection, boolean isCamel) {
        int newOffset;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(63);
        }
        if (caretStopPolicy == null) {
            EditorActionUtil.$$$reportNull$$$0(64);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        int offset = editor.getCaretModel().getOffset();
        if (offset == 0) {
            return;
        }
        FoldRegion currentFoldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
        if (currentFoldRegion != null) {
            newOffset = currentFoldRegion.getStartOffset();
        } else {
            newOffset = EditorActionUtil.getPreviousCaretStopOffset(editor, caretStopPolicy, isCamel);
            if (newOffset == offset) {
                return;
            }
            FoldRegion foldRegion = editor.getFoldingModel().getCollapsedRegionAtOffset(newOffset);
            if (foldRegion != null && newOffset > foldRegion.getStartOffset()) {
                newOffset = foldRegion.getEndOffset();
            }
        }
        if (editor instanceof EditorImpl) {
            int boundaryOffset = ((EditorImpl)editor).findNearestDirectionBoundary(offset, false);
            if (boundaryOffset >= 0) {
                newOffset = Math.max(boundaryOffset, newOffset);
            }
            caretModel.moveToLogicalPosition(editor.offsetToLogicalPosition(newOffset).leanForward(true));
        } else {
            editor.getCaretModel().moveToOffset(newOffset);
        }
        EditorModificationUtil.scrollToCaret((Editor)editor);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageUp(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(65);
        }
        int lineHeight = editor.getLineHeight();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        editor.getScrollingModel().scrollVertically(EditorActionUtil.adjustYToVisualLineBase(editor, visibleArea.y - visibleArea.height / lineHeight * lineHeight));
        int lineShift = EditorActionUtil.calcVisualLineIncrement(editor, editor.getCaretModel().getVisualPosition().line, -visibleArea.height);
        editor.getCaretModel().moveCaretRelatively(0, lineShift, isWithSelection, editor.isColumnMode(), true);
    }

    public static void moveCaretPageDown(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(66);
        }
        int lineHeight = editor.getLineHeight();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        int allowedBottom = ((EditorEx)editor).getContentSize().height - visibleArea.height;
        editor.getScrollingModel().scrollVertically(Math.min(allowedBottom, EditorActionUtil.adjustYToVisualLineBase(editor, visibleArea.y + visibleArea.height / lineHeight * lineHeight)));
        int lineShift = EditorActionUtil.calcVisualLineIncrement(editor, editor.getCaretModel().getVisualPosition().line, visibleArea.height);
        editor.getCaretModel().moveCaretRelatively(0, lineShift, isWithSelection, editor.isColumnMode(), true);
    }

    private static int adjustYToVisualLineBase(@NotNull Editor editor, int y) {
        int visualLineBaseY;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(67);
        }
        return y > (visualLineBaseY = editor.visualLineToY(editor.yToVisualLine(y))) && y < visualLineBaseY + editor.getLineHeight() ? visualLineBaseY : y;
    }

    private static int calcVisualLineIncrement(@NotNull Editor editor, int visualLine, int yIncrement) {
        int targetVisualLine;
        int targetVisualLineBase;
        int startY;
        int targetY;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(68);
        }
        if ((targetY = (startY = editor.visualLineToY(visualLine) + (yIncrement > 0 ? editor.getLineHeight() - 1 : 0)) + yIncrement) < (targetVisualLineBase = editor.visualLineToY(targetVisualLine = editor.yToVisualLine(targetY)))) {
            if (yIncrement < 0) {
                --targetVisualLine;
            }
        } else if (targetY >= targetVisualLineBase + editor.getLineHeight() && yIncrement > 0) {
            ++targetVisualLine;
        }
        return targetVisualLine - visualLine;
    }

    public static void moveCaretPageTop(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(69);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        int lineNumber = editor.yToVisualLine(visibleArea.y);
        if (visibleArea.y > editor.visualLineToY(lineNumber) && visibleArea.y + visibleArea.height > editor.visualLineToY(lineNumber + 1)) {
            ++lineNumber;
        }
        VisualPosition pos = new VisualPosition(lineNumber, editor.getCaretModel().getVisualPosition().column);
        editor.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    public static void moveCaretPageBottom(@NotNull Editor editor, boolean isWithSelection) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(70);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        CaretModel caretModel = editor.getCaretModel();
        LogicalPosition blockSelectionStart = caretModel.getLogicalPosition();
        Rectangle visibleArea = EditorActionUtil.getVisibleArea(editor);
        int maxY = visibleArea.y + visibleArea.height - editor.getLineHeight();
        int lineNumber = editor.yToVisualLine(maxY);
        if (lineNumber > 0 && maxY < editor.visualLineToY(lineNumber) && visibleArea.y <= editor.visualLineToY(lineNumber - 1)) {
            --lineNumber;
        }
        VisualPosition pos = new VisualPosition(lineNumber, editor.getCaretModel().getVisualPosition().column);
        editor.getCaretModel().moveToVisualPosition(pos);
        EditorActionUtil.setupSelection(editor, isWithSelection, selectionStart, blockSelectionStart);
    }

    @NotNull
    private static Rectangle getVisibleArea(@NotNull Editor editor) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(71);
        }
        ScrollingModel model2 = editor.getScrollingModel();
        Rectangle rectangle = EditorCoreUtil.isTrueSmoothScrollingEnabled() ? model2.getVisibleAreaOnScrollingFinished() : model2.getVisibleArea();
        if (rectangle == null) {
            EditorActionUtil.$$$reportNull$$$0(72);
        }
        return rectangle;
    }

    private static boolean isBetweenWhitespaces(@NotNull CharSequence text2, int offset) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(73);
        }
        return 0 < offset && offset < text2.length() && Character.isWhitespace(text2.charAt(offset - 1)) && Character.isWhitespace(text2.charAt(offset));
    }

    public static boolean isWordStart(@NotNull CharSequence text2, int offset, boolean isCamel) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(74);
        }
        return EditorActionUtil.isWordBoundary(text2, offset, isCamel, true);
    }

    public static boolean isWordEnd(@NotNull CharSequence text2, int offset, boolean isCamel) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(75);
        }
        return EditorActionUtil.isWordBoundary(text2, offset, isCamel, false);
    }

    public static boolean isWordBoundary(@NotNull CharSequence text2, int offset, boolean isCamel, boolean isStart) {
        char neighbor;
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(76);
        }
        if (offset < 0 || offset > text2.length()) {
            return false;
        }
        char prev2 = offset > 0 ? text2.charAt(offset - 1) : (char)'\u0000';
        char curr = offset < text2.length() ? text2.charAt(offset) : (char)'\u0000';
        char word = isStart ? curr : prev2;
        char c = neighbor = isStart ? prev2 : curr;
        if (Character.isJavaIdentifierPart(word)) {
            if (!Character.isJavaIdentifierPart(neighbor)) {
                return true;
            }
            if (isCamel && EditorActionUtil.isHumpBound(text2, offset, isStart)) {
                return true;
            }
        }
        return EditorActionUtil.isPunctuation(word) && !EditorActionUtil.isPunctuation(neighbor);
    }

    public static boolean isHumpBound(@NotNull CharSequence text2, int offset, boolean isStart) {
        if (text2 == null) {
            EditorActionUtil.$$$reportNull$$$0(77);
        }
        if (offset <= 0 || offset >= text2.length()) {
            return false;
        }
        char prev2 = text2.charAt(offset - 1);
        char curr = text2.charAt(offset);
        char next = offset + 1 < text2.length() ? text2.charAt(offset + 1) : (char)'\u0000';
        char hump = isStart ? curr : prev2;
        char neighbor = isStart ? prev2 : curr;
        return EditorActionUtil.isLowerCaseOrDigit(prev2) && Character.isUpperCase(curr) || neighbor == '_' && hump != '_' || neighbor == '$' && Character.isLetterOrDigit(hump) || Character.isUpperCase(prev2) && Character.isUpperCase(curr) && Character.isLowerCase(next);
    }

    private static boolean isLowerCaseOrDigit(char c) {
        return Character.isLowerCase(c) || Character.isDigit(c);
    }

    private static boolean isPunctuation(char c) {
        return !Character.isJavaIdentifierPart(c) && !Character.isWhitespace(c);
    }

    public static void moveCaretToLineStartIgnoringSoftWraps(@NotNull Editor editor) {
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(78);
        }
        editor.getCaretModel().moveToLogicalPosition((LogicalPosition)EditorUtil.calcCaretLineRange((Editor)editor).first);
    }

    public static void makePositionVisible(@NotNull Editor editor, int offset) {
        FoldRegion region;
        if (editor == null) {
            EditorActionUtil.$$$reportNull$$$0(79);
        }
        FoldingModel foldingModel = editor.getFoldingModel();
        while ((region = foldingModel.getCollapsedRegionAtOffset(offset)) != null && !region.shouldNeverExpand()) {
            foldingModel.runBatchFoldingOperation(() -> region.setExpanded(true));
        }
    }

    public static void moveCaret(@NotNull Caret caret, int offset, boolean withSelection) {
        if (caret == null) {
            EditorActionUtil.$$$reportNull$$$0(80);
        }
        if (withSelection) {
            caret.setSelection(caret.getLeadSelectionOffset(), offset);
        } else {
            caret.removeSelection();
        }
        caret.moveToOffset(offset);
        EditorModificationUtil.scrollToCaret((Editor)caret.getEditor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 72: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 72: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 6: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 8: 
            case 10: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actions/EditorActionUtil";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 58: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretStopPolicy";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 34: 
            case 35: 
            case 53: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordStop";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenIterator";
                break;
            }
            case 38: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineStop";
                break;
            }
            case 39: 
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockSelectionStart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actions/EditorActionUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToWordEnd";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToWordStart";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleArea";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scrollRelatively";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretRelativelyAndScroll";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "indentLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseSmartTabs";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectEntireLines";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToWordEnd";
                break;
            }
            case 8: 
            case 10: 
            case 72: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToWordStart";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNextCaretStopOffset";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousCaretStopOffset";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNextWordStopOffset";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousWordStopOffset";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isWordStopOffset";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "advanceTokenOnBoundary";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "retreatTokenOnBoundary";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedTokenInnardsBoundary";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isTokenStart";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isTokenEnd";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedToken";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getQuoteAt";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighterIteratorAtOffset";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getNextLineStopOffset";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousLineStopOffset";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isWordOrLexemeStart";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isWordOrLexemeEnd";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isLexemeBoundary";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineStart";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToStartOfSoftWrappedLine";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findSmartIndentColumn";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNonSpaceColumnOnTheLine";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNonSpaceOffsetOnTheLine";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findFirstNonSpaceOffsetInRange";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineEnd";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToNextWord";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "moveToNextCaretStop";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "setupSelection";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "selectNonexpandableFold";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToPreviousWord";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "moveToPreviousCaretStop";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretPageUp";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretPageDown";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "adjustYToVisualLineBase";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "calcVisualLineIncrement";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretPageTop";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretPageBottom";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleArea";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isBetweenWhitespaces";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "isWordStart";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isWordEnd";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isWordBoundary";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isHumpBound";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "moveCaretToLineStartIgnoringSoftWraps";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "makePositionVisible";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "moveCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 72: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

