/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class AddBomAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(AddBomAction.class);

    public AddBomAction() {
        super(IdeBundle.messagePointer((String)"add.BOM", (Object[])new Object[0]));
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            AddBomAction.$$$reportNull$$$0(0);
        }
        boolean enabled = (file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null && file2.getBOM() == null && CharsetToolkit.getPossibleBom((Charset)file2.getCharset()) != null;
        e.getPresentation().setEnabled(enabled);
        e.getPresentation().setVisible(enabled || ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()));
        e.getPresentation().setDescription(IdeBundle.messagePointer((String)"add.byte.order.mark.to", (Object[])new Object[]{enabled ? file2.getName() : null}));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file2;
        if (e == null) {
            AddBomAction.$$$reportNull$$$0(1);
        }
        if ((file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) == null) {
            return;
        }
        AddBomAction.doAddBOM(file2);
    }

    private static void doAddBOM(@NotNull VirtualFile virtualFile) {
        byte[] bom;
        if (virtualFile == null) {
            AddBomAction.$$$reportNull$$$0(2);
        }
        if ((bom = virtualFile.getBOM()) != null) {
            return;
        }
        Charset charset = virtualFile.getCharset();
        byte[] possibleBom = CharsetToolkit.getPossibleBom((Charset)charset);
        if (possibleBom == null) {
            return;
        }
        virtualFile.setBOM(possibleBom);
        NewVirtualFile file2 = (NewVirtualFile)virtualFile;
        try {
            byte[] bytes = file2.contentsToByteArray();
            byte[] contentWithAddedBom = ArrayUtil.mergeArrays((byte[])possibleBom, (byte[])bytes);
            WriteAction.runAndWait(() -> file2.setBinaryContent(contentWithAddedBom));
        }
        catch (IOException ex) {
            LOG.warn("Unexpected exception occurred in file " + file2, (Throwable)ex);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/actions/AddBomAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddBOM";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

