/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginPathManager {
    private PluginPathManager() {
    }

    public static File getPluginHome(@NonNls String pluginName) {
        File subrepo = PluginPathManager.findSubrepo(pluginName);
        if (subrepo != null) {
            return subrepo;
        }
        return new File(PathManager.getHomePath(), "plugins/" + pluginName);
    }

    private static File findSubrepo(String pluginName) {
        for (File subrepo : SubrepoHolder.subrepos) {
            File candidate = new File(subrepo, pluginName);
            if (!candidate.isDirectory()) continue;
            return candidate;
        }
        return null;
    }

    public static String getPluginHomePath(String pluginName) {
        return PluginPathManager.getPluginHome(pluginName).getPath();
    }

    public static String getPluginHomePathRelative(String pluginName) {
        File subrepo = PluginPathManager.findSubrepo(pluginName);
        if (subrepo != null) {
            String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
            return "/" + FileUtil.getRelativePath((String)homePath, (String)FileUtil.toSystemIndependentName((String)subrepo.getPath()), (char)'/');
        }
        return "/plugins/" + pluginName;
    }

    @Nullable
    public static File getPluginResource(@NotNull Class<?> pluginClass, @NotNull String resourceName) {
        if (pluginClass == null) {
            PluginPathManager.$$$reportNull$$$0(0);
        }
        if (resourceName == null) {
            PluginPathManager.$$$reportNull$$$0(1);
        }
        try {
            String jarPath = PathUtil.getJarPathForClass(pluginClass);
            if (!jarPath.endsWith(".jar")) {
                URL resource = pluginClass.getClassLoader().getResource(resourceName);
                if (resource == null) {
                    return null;
                }
                return new File(URLUtil.decode((String)resource.getPath()));
            }
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                return null;
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, resourceName);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "pluginClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "resourceName";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/application/PluginPathManager";
        objectArray[2] = "getPluginResource";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SubrepoHolder {
        @NonNls
        private static final Set<String> ROOT_NAMES = Set.of("community", "contrib", "android", "CIDR");
        private static final List<File> subrepos = SubrepoHolder.findSubrepos();

        private SubrepoHolder() {
        }

        private static List<File> findSubrepos() {
            File[] gitRoots;
            ArrayList<File> result2 = new ArrayList<File>();
            for (File subdir : gitRoots = SubrepoHolder.getSortedSubreposRoots(new File(PathManager.getHomePath()))) {
                File pluginsDir = new File(subdir, "plugins");
                if (pluginsDir.exists()) {
                    result2.add(pluginsDir);
                } else {
                    result2.add(subdir);
                }
                result2.addAll(Arrays.asList(SubrepoHolder.getSortedSubreposRoots(subdir)));
            }
            return result2;
        }

        private static File @NotNull [] getSortedSubreposRoots(@NotNull File dir) {
            File[] gitRoots;
            if (dir == null) {
                SubrepoHolder.$$$reportNull$$$0(0);
            }
            if ((gitRoots = dir.listFiles(child2 -> child2.isDirectory() && ROOT_NAMES.contains(child2.getName()))) == null) {
                return new File[0];
            }
            Arrays.sort(gitRoots, (file2, file22) -> FileUtil.compareFiles((File)file2, (File)file22));
            if (gitRoots == null) {
                SubrepoHolder.$$$reportNull$$$0(1);
            }
            return gitRoots;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/application/PluginPathManager$SubrepoHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/application/PluginPathManager$SubrepoHolder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSortedSubreposRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSortedSubreposRoots";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

