/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.CommonBundle;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionUpdater;
import com.intellij.openapi.actionSystem.impl.PreCachedDataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public final class Utils {
    private static final Logger LOG = Logger.getInstance(Utils.class);
    @Nls
    public static final String NOTHING_HERE = CommonBundle.message((String)"empty.menu.filler", (Object[])new Object[0]);
    public static final AnAction EMPTY_MENU_FILLER = new AnAction(CommonBundle.messagePointer((String)"empty.menu.filler", (Object[])new Object[0])){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final boolean DO_FULL_EXPAND = Boolean.getBoolean("actionSystem.use.full.group.expand");

    @NotNull
    public static DataContext wrapDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            Utils.$$$reportNull$$$0(0);
        }
        if (dataContext instanceof DataManagerImpl.MyDataContext && Registry.is((String)"actionSystem.update.actions.async")) {
            return new PreCachedDataContext(dataContext);
        }
        DataContext dataContext2 = dataContext;
        if (dataContext2 == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return dataContext2;
    }

    public static boolean isAsyncDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            Utils.$$$reportNull$$$0(2);
        }
        return dataContext instanceof PreCachedDataContext;
    }

    public static List<AnAction> expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context, @NotNull String place) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(3);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(4);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(5);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(6);
        }
        return Utils.expandActionGroup(isInModalContext, group2, presentationFactory, context, place, false, null);
    }

    public static CancellablePromise<List<AnAction>> expandActionGroupAsync(boolean isInModalContext, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context, @NotNull String place, @Nullable ActionGroupVisitor visitor) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(7);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(8);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(9);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(10);
        }
        if (!(context instanceof PreCachedDataContext)) {
            context = new PreCachedDataContext(context);
        }
        return new ActionUpdater(isInModalContext, presentationFactory, context, place, false, false, visitor).expandActionGroupAsync(group2, group2 instanceof CompactActionGroup);
    }

    public static List<AnAction> expandActionGroupWithTimeout(boolean isInModalContext, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context, @NotNull String place, @Nullable ActionGroupVisitor visitor, int timeoutMs) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(11);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(12);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(13);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(14);
        }
        return new ActionUpdater(isInModalContext, presentationFactory, context, place, false, false, visitor).expandActionGroupWithTimeout(group2, group2 instanceof CompactActionGroup, timeoutMs);
    }

    public static List<AnAction> expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group2, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context, @NotNull String place, boolean isContextMenu, @Nullable ActionGroupVisitor visitor) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(15);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(16);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(17);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(18);
        }
        ActionUpdater updater = new ActionUpdater(isInModalContext, presentationFactory, context, place, isContextMenu, false, visitor);
        return DO_FULL_EXPAND ? updater.expandActionGroupFull(group2, group2 instanceof CompactActionGroup) : updater.expandActionGroupWithTimeout(group2, group2 instanceof CompactActionGroup);
    }

    static void fillMenu(@NotNull ActionGroup group2, @NotNull JComponent component2, boolean enableMnemonics, @NotNull PresentationFactory presentationFactory, @NotNull DataContext context, @NotNull String place, boolean isWindowMenu, boolean isInModalContext, boolean useDarkIcons) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(19);
        }
        if (component2 == null) {
            Utils.$$$reportNull$$$0(20);
        }
        if (presentationFactory == null) {
            Utils.$$$reportNull$$$0(21);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(22);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(23);
        }
        List<AnAction> list2 = Utils.expandActionGroup(isInModalContext, group2, presentationFactory, context, place, true, null);
        boolean checked = group2 instanceof CheckedActionGroup;
        Utils.fillMenuInner(component2, list2, checked, enableMnemonics, presentationFactory, context, place, isWindowMenu, useDarkIcons);
    }

    private static void fillMenuInner(JComponent component2, List<AnAction> list2, boolean checked, boolean enableMnemonics, PresentationFactory presentationFactory, @NotNull DataContext context, String place, boolean isWindowMenu, boolean useDarkIcons) {
        if (context == null) {
            Utils.$$$reportNull$$$0(24);
        }
        boolean fixMacScreenMenu = SystemInfo.isMacSystemMenu && isWindowMenu && Registry.is((String)"actionSystem.mac.screenMenuNotUpdatedFix");
        ArrayList<Object> children2 = new ArrayList<Object>();
        int size = list2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            AnAction action2 = list2.get(i2);
            Presentation presentation2 = presentationFactory.getPresentation(action2);
            if (!(action2 instanceof Separator) && presentation2.isVisible() && StringUtil.isEmpty((String)presentation2.getText())) {
                String message2 = "Skipping empty menu item for action " + action2 + " of " + action2.getClass();
                if (action2.getTemplatePresentation().getText() == null) {
                    message2 = message2 + ". Please specify some default action text in plugin.xml or action constructor";
                }
                LOG.warn(message2);
                continue;
            }
            if (action2 instanceof Separator) {
                String text2 = ((Separator)action2).getText();
                if (StringUtil.isEmpty((String)text2) && (i2 <= 0 || i2 >= size - 1)) continue;
                JPopupMenu.Separator separator = Utils.createSeparator(text2);
                component2.add(separator);
                children2.add(separator);
                continue;
            }
            if (action2 instanceof ActionGroup && !Boolean.TRUE.equals(presentation2.getClientProperty("actionGroup.perform.only"))) {
                ActionMenu menu = new ActionMenu(context, place, (ActionGroup)action2, presentationFactory, enableMnemonics, useDarkIcons);
                component2.add((Component)((Object)menu));
                children2.add((Object)menu);
                continue;
            }
            ActionMenuItem each = new ActionMenuItem(action2, presentation2, place, context, enableMnemonics, !fixMacScreenMenu, checked, useDarkIcons);
            component2.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (list2.isEmpty()) {
            ActionMenuItem each = new ActionMenuItem(EMPTY_MENU_FILLER, presentationFactory.getPresentation(EMPTY_MENU_FILLER), place, context, enableMnemonics, !fixMacScreenMenu, checked, useDarkIcons);
            component2.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (fixMacScreenMenu) {
            SwingUtilities.invokeLater(() -> {
                for (Component each : children2) {
                    if (each.getParent() == null || !(each instanceof ActionMenuItem)) continue;
                    ((ActionMenuItem)((Object)((Object)each))).prepare();
                }
            });
        }
        if (SystemInfo.isMacSystemMenu && isWindowMenu) {
            if (ActionMenu.isAligned()) {
                Icon icon2 = Utils.hasIcons(children2) ? ActionMenuItem.EMPTY_ICON : null;
                children2.forEach((Consumer<Object>)((Consumer<Component>)child2 -> Utils.replaceIconIn(child2, icon2)));
            } else if (ActionMenu.isAlignedInGroup()) {
                ArrayList<Component> currentGroup = new ArrayList<Component>();
                for (int i3 = 0; i3 < children2.size(); ++i3) {
                    boolean isLastElement;
                    Component child3 = (Component)children2.get(i3);
                    boolean isSeparator = child3 instanceof JPopupMenu.Separator;
                    boolean bl = isLastElement = i3 == children2.size() - 1;
                    if (isLastElement || isSeparator) {
                        if (isLastElement && !isSeparator) {
                            currentGroup.add(child3);
                        }
                        Icon icon3 = Utils.hasIcons(currentGroup) ? ActionMenuItem.EMPTY_ICON : null;
                        currentGroup.forEach(menuItem -> Utils.replaceIconIn(menuItem, icon3));
                        currentGroup.clear();
                        continue;
                    }
                    currentGroup.add(child3);
                }
            }
        }
    }

    @NotNull
    private static JPopupMenu.Separator createSeparator(final @NlsContexts.Separator String text2) {
        return new JPopupMenu.Separator(){
            private final JMenuItem myMenu;
            {
                this.myMenu = !StringUtil.isEmpty((String)text2) ? new JMenuItem(text2) : null;
            }

            @Override
            public void doLayout() {
                super.doLayout();
                if (this.myMenu != null) {
                    this.myMenu.setBounds(this.getBounds());
                }
            }

            @Override
            protected void paintComponent(Graphics g) {
                if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderWin10LookAndFeel()) {
                    g.setColor(this.getParent().getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (this.myMenu != null) {
                    this.myMenu.paint(g);
                } else {
                    super.paintComponent(g);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.myMenu != null ? this.myMenu.getPreferredSize() : super.getPreferredSize();
            }
        };
    }

    private static void replaceIconIn(Component menuItem, Icon icon2) {
        Icon from2;
        Icon icon3 = from2 = icon2 == null ? ActionMenuItem.EMPTY_ICON : null;
        if (menuItem instanceof ActionMenuItem && ((ActionMenuItem)((Object)menuItem)).getIcon() == from2) {
            ((ActionMenuItem)((Object)menuItem)).setIcon(icon2);
        } else if (menuItem instanceof ActionMenu && ((ActionMenu)((Object)menuItem)).getIcon() == from2) {
            ((ActionMenu)((Object)menuItem)).setIcon(icon2);
        }
    }

    private static boolean hasIcons(List<? extends Component> components) {
        for (Component component2 : components) {
            if (!Utils.hasNotEmptyIcon(component2)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNotEmptyIcon(Component comp) {
        Icon icon2 = null;
        if (comp instanceof ActionMenuItem) {
            icon2 = ((ActionMenuItem)((Object)comp)).getIcon();
        } else if (comp instanceof ActionMenu) {
            icon2 = ((ActionMenu)((Object)comp)).getIcon();
        }
        return icon2 != null && icon2 != ActionMenuItem.EMPTY_ICON;
    }

    @NotNull
    public static UpdateSession getOrCreateUpdateSession(@NotNull AnActionEvent e) {
        UpdateSession updater;
        if (e == null) {
            Utils.$$$reportNull$$$0(25);
        }
        if ((updater = e.getUpdateSession()) == null) {
            ActionUpdater actionUpdater = new ActionUpdater(LaterInvocator.isInModalContext(), new PresentationFactory(), e.getDataContext(), e.getPlace(), e.isFromContextMenu(), e.isFromActionToolbar());
            updater = actionUpdater.asUpdateSession();
        }
        UpdateSession updateSession = updater;
        if (updateSession == null) {
            Utils.$$$reportNull$$$0(26);
        }
        return updateSession;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/Utils";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationFactory";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapDataContext";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateUpdateSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapDataContext";
                break;
            }
            case 1: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAsyncDataContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroup";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroupAsync";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "expandActionGroupWithTimeout";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillMenu";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fillMenuInner";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateUpdateSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ActionGroupVisitor {
        public void begin();

        public boolean enterNode(@NotNull ActionGroup var1);

        public void visitLeaf(@NotNull AnAction var1);

        public void leaveNode();

        @Nullable
        public Component getCustomComponent(@NotNull AnAction var1);

        public boolean beginUpdate(@NotNull AnAction var1, AnActionEvent var2);

        public void endUpdate(@NotNull AnAction var1);
    }
}

