/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class ToolbarUpdater
implements Activatable {
    private final JComponent myComponent;
    private final KeymapManagerListener myKeymapManagerListener;
    private final TimerListener myTimerListener;
    private final WeakTimerListener myWeakTimerListener;
    private boolean myListenersArmed;

    public ToolbarUpdater(@NotNull JComponent component2) {
        if (component2 == null) {
            ToolbarUpdater.$$$reportNull$$$0(0);
        }
        this.myKeymapManagerListener = new MyKeymapManagerListener();
        this.myTimerListener = new MyTimerListener();
        this.myComponent = component2;
        this.myWeakTimerListener = new WeakTimerListener(this.myTimerListener);
        new UiNotifyConnector((Component)component2, (Activatable)this);
    }

    public void showNotify() {
        if (this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = true;
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        actionManager.addTimerListener(-1, (TimerListener)this.myWeakTimerListener);
        KeymapManagerEx.getInstanceEx().addWeakListener(this.myKeymapManagerListener);
        this.updateActionTooltips();
    }

    public void hideNotify() {
        if (!this.myListenersArmed) {
            return;
        }
        this.myListenersArmed = false;
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        actionManager.removeTimerListener((TimerListener)this.myWeakTimerListener);
        KeymapManagerEx.getInstanceEx().removeWeakListener(this.myKeymapManagerListener);
    }

    public void updateActions(boolean now, boolean forced, boolean includeInvisible) {
        MyUpdateRunnable updateRunnable = new MyUpdateRunnable(this, forced, includeInvisible);
        Application app = ApplicationManager.getApplication();
        if (now || app.isUnitTestMode() && app.isDispatchThread()) {
            updateRunnable.run();
        } else if (!app.isHeadlessEnvironment()) {
            IdeFocusManager focusManager = IdeFocusManager.getInstance(null);
            if (app.isDispatchThread() && this.myComponent.isShowing()) {
                focusManager.doWhenFocusSettlesDown((Runnable)updateRunnable);
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)this.myComponent, () -> focusManager.doWhenFocusSettlesDown(updateRunnable));
            }
        }
    }

    protected abstract void updateActionsImpl(boolean var1);

    protected void updateActionTooltips() {
        for (ActionButton actionButton : UIUtil.uiTraverser((Component)this.myComponent).preOrderDfsTraversal().filter(ActionButton.class)) {
            actionButton.updateToolTipText();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater", "<init>"));
    }

    private static final class MyUpdateRunnable
    implements Runnable {
        private final boolean myForced;
        @NotNull
        private final WeakReference<ToolbarUpdater> myUpdaterRef;
        private final boolean myIncludeInvisible;
        private final int myHash;

        MyUpdateRunnable(@NotNull ToolbarUpdater updater, boolean forced, boolean includeInvisible) {
            if (updater == null) {
                MyUpdateRunnable.$$$reportNull$$$0(0);
            }
            this.myForced = forced;
            this.myIncludeInvisible = includeInvisible;
            this.myHash = updater.hashCode();
            this.myUpdaterRef = new WeakReference<ToolbarUpdater>(updater);
        }

        @Override
        public void run() {
            ToolbarUpdater updater = (ToolbarUpdater)this.myUpdaterRef.get();
            if (updater == null || !updater.myComponent.isVisible() && !ApplicationManager.getApplication().isUnitTestMode() && !this.myIncludeInvisible) {
                return;
            }
            updater.updateActionsImpl(this.myForced);
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof MyUpdateRunnable)) {
                return false;
            }
            MyUpdateRunnable that = (MyUpdateRunnable)obj2;
            if (this.myHash != that.myHash) {
                return false;
            }
            ToolbarUpdater updater1 = (ToolbarUpdater)this.myUpdaterRef.get();
            ToolbarUpdater updater2 = (ToolbarUpdater)that.myUpdaterRef.get();
            return Comparing.equal((Object)updater1, (Object)updater2);
        }

        public int hashCode() {
            return this.myHash;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updater", "com/intellij/openapi/actionSystem/impl/ToolbarUpdater$MyUpdateRunnable", "<init>"));
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)ToolbarUpdater.this.myComponent);
        }

        public void run() {
            if (!ToolbarUpdater.this.myComponent.isShowing()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && ((Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(ToolbarUpdater.this.myComponent, window)) {
                return;
            }
            ToolbarUpdater.this.updateActions(false, false, false);
        }
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        public void activeKeymapChanged(Keymap keymap2) {
            ToolbarUpdater.this.updateActionTooltips();
        }
    }
}

