/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ProhibitAWTEvents;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PreCachedDataContext
implements DataContext,
UserDataHolder {
    private Map<Key<?>, Object> myUserData;
    private final Map<String, Object> myCachedData;
    private static int ourPrevMapEventCount;
    private static final Map<Component, Map<String, Object>> ourPrevMaps;

    PreCachedDataContext(@NotNull DataContext original) {
        if (original == null) {
            PreCachedDataContext.$$$reportNull$$$0(0);
        }
        if (!(original instanceof DataManagerImpl.MyDataContext)) {
            throw new AssertionError((Object)original.getClass().getName());
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Component component2 = (Component)original.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        try (AccessToken ignored = ProhibitAWTEvents.start("getData");){
            int count = IdeEventQueue.getInstance().getEventCount();
            if (ourPrevMapEventCount != count) {
                ourPrevMaps.clear();
            }
            if (component2 == null) {
                this.myCachedData = ContainerUtil.createConcurrentWeakValueMap();
                this.myCachedData.put(PlatformDataKeys.MODALITY_STATE.getName(), ModalityState.NON_MODAL);
                return;
            }
            Map<String, Object> prevMap = ourPrevMaps.get(component2);
            if (prevMap != null) {
                this.myCachedData = prevMap;
                return;
            }
            this.myCachedData = ContainerUtil.createConcurrentWeakValueMap();
            PreCachedDataContext.preGetAllData(component2, this.myCachedData);
            ourPrevMapEventCount = count;
            ourPrevMaps.put(component2, this.myCachedData);
        }
    }

    @Override
    public Object getData(@NotNull String dataId) {
        DataManagerImpl dataManager;
        GetDataRule rule;
        if (dataId == null) {
            PreCachedDataContext.$$$reportNull$$$0(1);
        }
        ProgressManager.checkCanceled();
        Object answer = this.myCachedData.get(dataId);
        if (answer != null) {
            if (answer == NullResult.Initial) {
                answer = null;
            } else {
                return answer == NullResult.Final ? null : answer;
            }
        }
        if ((rule = (dataManager = (DataManagerImpl)DataManager.getInstance()).getDataRule(dataId)) != null) {
            answer = dataManager.getDataFromProvider(id2 -> {
                Object o = this.myCachedData.get(id2);
                return o == NullResult.Initial || o == NullResult.Final ? null : o;
            }, dataId, null, rule);
        }
        this.myCachedData.put(dataId, answer == null ? NullResult.Final : answer);
        return answer;
    }

    private static void preGetAllData(@NotNull Component component2, @NotNull Map<String, Object> cachedData) {
        if (component2 == null) {
            PreCachedDataContext.$$$reportNull$$$0(2);
        }
        if (cachedData == null) {
            PreCachedDataContext.$$$reportNull$$$0(3);
        }
        long start2 = System.currentTimeMillis();
        DataManagerImpl dataManager = (DataManagerImpl)DataManager.getInstance();
        DataKey<?>[] keys2 = DataKey.allKeys();
        BitSet computed = new BitSet(keys2.length);
        for (Component c = component2; c != null; c = c.getParent()) {
            DataProvider dataProvider = DataManagerImpl.getDataProviderEx(c);
            if (dataProvider == null) continue;
            for (int i2 = 0; i2 < keys2.length; ++i2) {
                Serializable data2;
                DataKey<?> key = keys2[i2];
                if (computed.get(i2)) continue;
                Serializable serializable = key == PlatformDataKeys.IS_MODAL_CONTEXT ? Boolean.valueOf(IdeKeyEventDispatcher.isModalContext(c)) : (key == PlatformDataKeys.CONTEXT_COMPONENT ? c : (data2 = key == PlatformDataKeys.MODALITY_STATE ? ModalityState.stateForComponent((Component)c) : dataManager.getDataFromProvider(dataProvider, key.getName(), null, null)));
                if (data2 instanceof Editor) {
                    data2 = DataManagerImpl.validateEditor((Editor)data2, c);
                }
                if (data2 == null) continue;
                computed.set(i2, true);
                cachedData.put(key.getName(), data2);
            }
        }
        for (int i3 = 0; i3 < keys2.length; ++i3) {
            DataKey<?> key = keys2[i3];
            if (computed.get(i3)) continue;
            cachedData.put(key.getName(), (Object)NullResult.Initial);
        }
        long time = System.currentTimeMillis() - start2;
        if (time > 200L) {
            // empty if block
        }
    }

    public String toString() {
        return "component=" + this.getData(PlatformDataKeys.CONTEXT_COMPONENT);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            PreCachedDataContext.$$$reportNull$$$0(4);
        }
        return (T)this.getOrCreateMap().get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            PreCachedDataContext.$$$reportNull$$$0(5);
        }
        this.getOrCreateMap().put(key, value2);
    }

    @NotNull
    private Map<Key<?>, Object> getOrCreateMap() {
        Map userData = this.myUserData;
        if (userData == null) {
            this.myUserData = userData = ContainerUtil.createWeakValueMap();
        }
        Map map2 = userData;
        if (map2 == null) {
            PreCachedDataContext.$$$reportNull$$$0(6);
        }
        return map2;
    }

    static {
        ourPrevMaps = ContainerUtil.createWeakKeySoftValueMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedData";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/PreCachedDataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/PreCachedDataContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preGetAllData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum NullResult {
        Initial,
        Final;

    }
}

