/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AlwaysPerformingActionGroup;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.actionSystem.UpdateSession;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionUpdateEdtExecutor;
import com.intellij.openapi.actionSystem.impl.AsyncDataContext;
import com.intellij.openapi.actionSystem.impl.PreCachedDataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.PaintEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

final class ActionUpdater {
    private static final Logger LOG = Logger.getInstance(ActionUpdater.class);
    private static final Executor ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Action Updater", (int)2);
    private final boolean myModalContext;
    private final PresentationFactory myFactory;
    private final DataContext myDataContext;
    private final String myPlace;
    private final boolean myContextMenuAction;
    private final boolean myToolbarAction;
    private final Project myProject;
    private final Map<AnAction, Presentation> myUpdatedPresentations = new ConcurrentHashMap<AnAction, Presentation>();
    private final Map<ActionGroup, List<AnAction>> myGroupChildren = new ConcurrentHashMap<ActionGroup, List<AnAction>>();
    private final Map<ActionGroup, Boolean> myCanBePerformedCache = new ConcurrentHashMap<ActionGroup, Boolean>();
    private final UpdateStrategy myRealUpdateStrategy;
    private final UpdateStrategy myCheapStrategy;
    private final Utils.ActionGroupVisitor myVisitor;
    private boolean myAllowPartialExpand = true;
    private boolean myPreCacheAsyncDataKeys;

    ActionUpdater(boolean isInModalContext, PresentationFactory presentationFactory, DataContext dataContext, String place, boolean isContextMenuAction, boolean isToolbarAction) {
        this(isInModalContext, presentationFactory, dataContext, place, isContextMenuAction, isToolbarAction, null);
    }

    ActionUpdater(boolean isInModalContext, PresentationFactory presentationFactory, DataContext dataContext, String place, boolean isContextMenuAction, boolean isToolbarAction, Utils.ActionGroupVisitor visitor) {
        this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        this.myModalContext = isInModalContext;
        this.myFactory = presentationFactory;
        this.myDataContext = dataContext;
        this.myVisitor = visitor;
        this.myPlace = place;
        this.myContextMenuAction = isContextMenuAction;
        this.myToolbarAction = isToolbarAction;
        this.myPreCacheAsyncDataKeys = Utils.isAsyncDataContext(dataContext);
        boolean forceAsync = Utils.isAsyncDataContext(dataContext) && Registry.is((String)"actionSystem.update.actions.async.unsafe");
        this.myRealUpdateStrategy = new UpdateStrategy((NullableFunction<? super AnAction, Presentation>)((NullableFunction)action2 -> {
            this.ensureAsyncDataKeysPreCached();
            Presentation presentation2 = ActionUpdateEdtExecutor.computeOnEdt(() -> this.myFactory.getPresentation((AnAction)action2).clone());
            presentation2.setEnabledAndVisible(true);
            Supplier<Boolean> doUpdate2 = () -> ActionUpdater.doUpdate(this.myModalContext, action2, this.createActionEvent((AnAction)action2, presentation2), this.myVisitor);
            boolean success2 = ActionUpdater.callAction(forceAsync, action2, "update", doUpdate2);
            return success2 ? presentation2 : null;
        }), (NotNullFunction<? super ActionGroup, ? extends AnAction[]>)((NotNullFunction)group2 -> ActionUpdater.callAction(forceAsync, (AnAction)group2, "getChildren", () -> group2.getChildren(this.createActionEvent((AnAction)group2, this.orDefault((AnAction)group2, this.myUpdatedPresentations.get(group2)))))), group2 -> ActionUpdater.callAction(forceAsync, (AnAction)group2, "canBePerformed", () -> group2.canBePerformed(this.getDataContext((AnAction)group2))));
        this.myCheapStrategy = new UpdateStrategy((NullableFunction<? super AnAction, Presentation>)((NullableFunction)this.myFactory::getPresentation), (NotNullFunction<? super ActionGroup, ? extends AnAction[]>)((NotNullFunction)group2 -> group2.getChildren(null)), group2 -> true);
    }

    private void applyPresentationChanges() {
        for (Map.Entry<AnAction, Presentation> entry : this.myUpdatedPresentations.entrySet()) {
            Presentation original = this.myFactory.getPresentation(entry.getKey());
            Presentation cloned = entry.getValue();
            original.copyFrom(cloned);
            ActionUpdater.reflectSubsequentChangesInOriginalPresentation(original, cloned);
        }
    }

    private DataContext getDataContext(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionUpdater.$$$reportNull$$$0(0);
        }
        if (this.myVisitor == null) {
            return this.myDataContext;
        }
        if (this.myDataContext instanceof AsyncDataContext) {
            return this.myDataContext;
        }
        if (this.myDataContext instanceof PreCachedDataContext) {
            return this.myDataContext;
        }
        Component component2 = this.myVisitor.getCustomComponent(action2);
        return component2 != null ? DataManager.getInstance().getDataContext(component2) : this.myDataContext;
    }

    private static void reflectSubsequentChangesInOriginalPresentation(Presentation original, Presentation cloned) {
        cloned.addPropertyChangeListener(e -> {
            if (SwingUtilities.isEventDispatchThread()) {
                original.copyFrom(cloned);
            }
        });
    }

    private static <T> T callAction(boolean forceAsync, AnAction action2, String operation2, Supplier<? extends T> call) {
        if (forceAsync || action2 instanceof UpdateInBackground || ApplicationManager.getApplication().isDispatchThread()) {
            return call.get();
        }
        ProgressIndicator progress2 = Objects.requireNonNull(ProgressManager.getInstance().getProgressIndicator());
        return (T)ActionUpdateEdtExecutor.computeOnEdt(() -> {
            long start2 = System.currentTimeMillis();
            try {
                Object object = ProgressManager.getInstance().runProcess(((Supplier)call)::get, (ProgressIndicator)ProgressWrapper.wrap(progress2));
                return object;
            }
            finally {
                long elapsed = System.currentTimeMillis() - start2;
                if (elapsed > 100L) {
                    LOG.warn("Slow (" + elapsed + "ms) '" + operation2 + "' on action " + action2 + " of " + action2.getClass() + ". Consider speeding it up and/or implementing UpdateInBackground.");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AnAction> expandActionGroup(ActionGroup group2, boolean hideDisabled) {
        try {
            List<AnAction> list2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
            return list2;
        }
        finally {
            this.applyPresentationChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AnAction> expandActionGroupFull(ActionGroup group2, boolean hideDisabled) {
        try {
            this.myAllowPartialExpand = false;
            List<AnAction> list2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
            return list2;
        }
        finally {
            this.myAllowPartialExpand = true;
            this.applyPresentationChanges();
        }
    }

    private List<AnAction> expandActionGroup(ActionGroup group2, boolean hideDisabled, UpdateStrategy strategy) {
        if (this.myVisitor != null) {
            this.myVisitor.begin();
        }
        return ActionUpdater.removeUnnecessarySeparators(this.doExpandActionGroup(group2, hideDisabled, strategy));
    }

    @NotNull
    List<AnAction> expandActionGroupWithTimeout(ActionGroup group2, boolean hideDisabled) {
        List<AnAction> list2 = this.expandActionGroupWithTimeout(group2, hideDisabled, Registry.intValue((String)"actionSystem.update.timeout.ms"));
        if (list2 == null) {
            ActionUpdater.$$$reportNull$$$0(1);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    List<AnAction> expandActionGroupWithTimeout(ActionGroup group2, boolean hideDisabled, int timeoutMs) {
        List<AnAction> result2 = (List<AnAction>)ProgressIndicatorUtils.withTimeout(timeoutMs, () -> this.expandActionGroup(group2, hideDisabled));
        List<AnAction> list2 = result2 != null ? result2 : this.expandActionGroup(group2, hideDisabled, this.myCheapStrategy);
        List<AnAction> list3 = list2;
        if (list3 == null) {
            ActionUpdater.$$$reportNull$$$0(2);
        }
        return list3;
        finally {
            this.applyPresentationChanges();
        }
    }

    @NotNull
    CancellablePromise<List<AnAction>> expandActionGroupAsync(ActionGroup group2, boolean hideDisabled) {
        AsyncPromise promise = new AsyncPromise();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        promise.onError(arg_0 -> this.lambda$expandActionGroupAsync$13((ProgressIndicator)indicator, arg_0));
        ActionUpdater.cancelAndRestartOnUserActivity(promise, (ProgressIndicator)indicator);
        ourExecutor.execute(() -> this.lambda$expandActionGroupAsync$16(promise, (ProgressIndicator)indicator, group2, hideDisabled));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            ActionUpdater.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    private void ensureAsyncDataKeysPreCached() {
        if (!this.myPreCacheAsyncDataKeys) {
            return;
        }
        this.myPreCacheAsyncDataKeys = false;
        long start2 = System.currentTimeMillis();
        ReadAction.nonBlocking(() -> {
            for (DataKey<?> key : DataKey.allKeys()) {
                this.myDataContext.getData(key);
            }
        }).executeSynchronously();
        long time = System.currentTimeMillis() - start2;
        if (time > 500L) {
            LOG.debug("ensureAsyncDataKeysPreCached() took: " + time + " ms");
        }
    }

    private static void cancelAndRestartOnUserActivity(Promise<?> promise, ProgressIndicator indicator) {
        Disposable disposable2 = Disposer.newDisposable((String)"Action Update");
        IdeEventQueue.getInstance().addPostprocessor(e -> {
            if (e instanceof ComponentEvent && !(e instanceof PaintEvent) && ((long)e.getID() & 0x20L) == 0L) {
                indicator.cancel();
            }
            return false;
        }, disposable2);
        promise.onProcessed(__ -> Disposer.dispose((Disposable)disposable2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AnAction> doExpandActionGroup(ActionGroup group2, boolean hideDisabled, UpdateStrategy strategy) {
        if (group2 instanceof ActionGroupStub) {
            throw new IllegalStateException("Trying to expand non-unstubbed group");
        }
        if (this.myAllowPartialExpand) {
            ProgressManager.checkCanceled();
        }
        if (this.myVisitor != null && !this.myVisitor.enterNode(group2)) {
            return Collections.emptyList();
        }
        try {
            Presentation presentation2 = this.update((AnAction)group2, strategy);
            if (presentation2 == null || !presentation2.isVisible()) {
                List<AnAction> list2 = Collections.emptyList();
                return list2;
            }
            List<AnAction> children2 = this.getGroupChildren(group2, strategy);
            List result2 = ContainerUtil.concat(children2, child2 -> (Collection)TimeoutUtil.compute(() -> this.expandGroupChild((AnAction)child2, hideDisabled, strategy), (long)1000L, ms -> LOG.warn(ms + "ms to expand group child " + ActionManager.getInstance().getId(child2))));
            List list3 = group2.afterExpandGroup(result2, this.asUpdateSession(strategy));
            return list3;
        }
        finally {
            if (this.myVisitor != null) {
                this.myVisitor.leaveNode();
            }
        }
    }

    private List<AnAction> getGroupChildren(ActionGroup group2, UpdateStrategy strategy) {
        return this.myGroupChildren.computeIfAbsent(group2, __ -> {
            Object[] children2 = (AnAction[])TimeoutUtil.compute(() -> (AnAction[])strategy.getChildren.fun((Object)group2), (long)1000L, ms -> LOG.warn(ms + "ms to expand group child " + ActionManager.getInstance().getId((AnAction)group2)));
            int nullIndex = ArrayUtil.indexOf((Object[])children2, null);
            if (nullIndex < 0) {
                return Arrays.asList(children2);
            }
            LOG.error("action is null: i=" + nullIndex + " group=" + group2 + " group id=" + ActionManager.getInstance().getId((AnAction)group2));
            return ContainerUtil.filter((Object[])children2, (Condition)Conditions.notNull());
        });
    }

    private List<AnAction> expandGroupChild(AnAction child2, boolean hideDisabled, UpdateStrategy strategy) {
        Presentation presentation2 = this.update(child2, strategy);
        if (presentation2 == null) {
            return Collections.emptyList();
        }
        if (!presentation2.isVisible() || !presentation2.isEnabled() && hideDisabled) {
            return Collections.emptyList();
        }
        if (child2 instanceof ActionGroup) {
            ActionGroup actionGroup2 = (ActionGroup)child2;
            JBIterable<AnAction> childrenIterable = this.iterateGroupChildren(actionGroup2, strategy);
            if (!presentation2.isVisible() || !presentation2.isEnabled() && hideDisabled) {
                return Collections.emptyList();
            }
            boolean isPopup = actionGroup2.isPopup(this.myPlace);
            boolean hasEnabled = false;
            boolean hasVisible = false;
            if (hideDisabled || isPopup) {
                AnAction action2;
                Presentation p;
                Iterator iterator2 = childrenIterable.iterator();
                while (!(!iterator2.hasNext() || (p = this.update(action2 = (AnAction)iterator2.next(), strategy)) != null && ((hasEnabled |= p.isEnabled()) && hasVisible || hideDisabled && hasEnabled && !isPopup || isPopup && (hasVisible |= p.isVisible()) && !hideDisabled))) {
                }
            }
            if (hideDisabled && !hasEnabled) {
                return Collections.emptyList();
            }
            if (isPopup) {
                boolean canBePerformed = this.canBePerformed(actionGroup2, strategy);
                boolean performOnly = canBePerformed && (actionGroup2 instanceof AlwaysPerformingActionGroup || !hasVisible);
                presentation2.putClientProperty("actionGroup.perform.only", (Object)(performOnly ? Boolean.valueOf(true) : null));
                if (!hasVisible && actionGroup2.disableIfNoVisibleChildren()) {
                    if (actionGroup2.hideIfNoVisibleChildren()) {
                        return Collections.emptyList();
                    }
                    if (!canBePerformed) {
                        presentation2.setEnabled(false);
                    }
                }
                if (this.myVisitor != null) {
                    this.myVisitor.visitLeaf(child2);
                }
                if (hideDisabled && !(child2 instanceof CompactActionGroup)) {
                    return Collections.singletonList(new EmptyAction.DelegatingCompactActionGroup((ActionGroup)child2));
                }
                return Collections.singletonList(child2);
            }
            return this.doExpandActionGroup((ActionGroup)child2, hideDisabled || actionGroup2 instanceof CompactActionGroup, strategy);
        }
        if (this.myVisitor != null) {
            this.myVisitor.visitLeaf(child2);
        }
        return Collections.singletonList(child2);
    }

    private boolean canBePerformed(ActionGroup group2, UpdateStrategy strategy) {
        return this.myCanBePerformedCache.computeIfAbsent(group2, __ -> strategy.canBePerformed.test((ActionGroup)group2));
    }

    private Presentation orDefault(AnAction action2, Presentation presentation2) {
        return presentation2 != null ? presentation2 : ActionUpdateEdtExecutor.computeOnEdt(() -> this.myFactory.getPresentation(action2));
    }

    private static List<AnAction> removeUnnecessarySeparators(List<? extends AnAction> visible) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        for (AnAction anAction : visible) {
            if (anAction instanceof Separator) {
                if (StringUtil.isEmpty((String)((Separator)anAction).getText()) && (result2.isEmpty() || result2.get(result2.size() - 1) instanceof Separator)) continue;
                result2.add(anAction);
                continue;
            }
            result2.add(anAction);
        }
        return result2;
    }

    private AnActionEvent createActionEvent(AnAction action2, Presentation presentation2) {
        AnActionEvent event = new AnActionEvent(null, this.getDataContext(action2), this.myPlace, presentation2, ActionManager.getInstance(), 0, this.myContextMenuAction, this.myToolbarAction);
        event.setInjectedContext(action2.isInInjectedContext());
        event.setUpdateSession(this.asUpdateSession());
        return event;
    }

    @NotNull
    UpdateSession asUpdateSession() {
        return this.asUpdateSession(this.myRealUpdateStrategy);
    }

    @NotNull
    private UpdateSession asUpdateSession(final UpdateStrategy strategy) {
        return new UpdateSession(){

            @NotNull
            public Iterable<? extends AnAction> children(@NotNull ActionGroup actionGroup2) {
                if (actionGroup2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                JBIterable<AnAction> jBIterable = ActionUpdater.this.iterateGroupChildren(actionGroup2, strategy);
                if (jBIterable == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jBIterable;
            }

            @NotNull
            public Presentation presentation(@NotNull AnAction action2) {
                if (action2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                Presentation presentation2 = ActionUpdater.this.orDefault(action2, ActionUpdater.this.update(action2, strategy));
                if (presentation2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return presentation2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionGroup";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionUpdater$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionUpdater$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "children";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "presentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "children";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "presentation";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    private JBIterable<AnAction> iterateGroupChildren(@NotNull ActionGroup group2, @NotNull UpdateStrategy strategy) {
        if (group2 == null) {
            ActionUpdater.$$$reportNull$$$0(4);
        }
        if (strategy == null) {
            ActionUpdater.$$$reportNull$$$0(5);
        }
        boolean isDumb = this.myProject != null && DumbService.getInstance((Project)this.myProject).isDumb();
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(o -> {
            if (o == group2) {
                return null;
            }
            if (o instanceof AlwaysVisibleActionGroup) {
                return null;
            }
            if (isDumb && !o.isDumbAware()) {
                return null;
            }
            if (!(o instanceof ActionGroup)) {
                return null;
            }
            ActionGroup oo = (ActionGroup)o;
            Presentation presentation2 = this.update((AnAction)oo, strategy);
            if (presentation2 == null || !presentation2.isVisible()) {
                return null;
            }
            if (oo.isPopup(this.myPlace) || strategy.canBePerformed.test((ActionGroup)oo)) {
                return null;
            }
            return this.getGroupChildren(oo, strategy);
        }).withRoots(this.getGroupChildren(group2, strategy))).unique()).traverse(TreeTraversal.LEAVES_DFS).filter(o -> !(o instanceof Separator) && (!isDumb || o.isDumbAware())).take(1000);
        if (jBIterable == null) {
            ActionUpdater.$$$reportNull$$$0(6);
        }
        return jBIterable;
    }

    private static void handleUpdateException(AnAction action2, Presentation presentation2, Throwable exc) {
        String id2 = ActionManager.getInstance().getId(action2);
        if (id2 != null) {
            LOG.error("update failed for AnAction(" + action2.getClass().getName() + ") with ID=" + id2, exc);
        } else {
            LOG.error("update failed for ActionGroup: " + action2 + "[" + presentation2.getText() + "]", exc);
        }
    }

    @Nullable
    private Presentation update(AnAction action2, UpdateStrategy strategy) {
        Presentation cached = this.myUpdatedPresentations.get(action2);
        if (cached != null) {
            return cached;
        }
        Presentation presentation2 = (Presentation)strategy.update.fun((Object)action2);
        if (presentation2 != null) {
            this.myUpdatedPresentations.put(action2, presentation2);
        }
        return presentation2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean doUpdate(boolean isInModalContext, AnAction action2, AnActionEvent e, Utils.ActionGroupVisitor visitor) {
        boolean result2;
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        if (visitor != null && !visitor.beginUpdate(action2, e)) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        try {
            result2 = !ActionUtil.performDumbAwareUpdate((boolean)isInModalContext, (AnAction)action2, (AnActionEvent)e, (boolean)false);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable exc) {
            ActionUpdater.handleUpdateException(action2, e.getPresentation(), exc);
            boolean bl = false;
            return bl;
        }
        finally {
            if (visitor != null) {
                visitor.endUpdate(action2);
            }
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime > 10L && LOG.isDebugEnabled()) {
            LOG.debug("Action " + action2 + ": updated in " + (endTime - startTime) + " ms");
        }
        return result2;
    }

    private /* synthetic */ void lambda$expandActionGroupAsync$16(AsyncPromise promise, ProgressIndicator indicator, ActionGroup group2, boolean hideDisabled) {
        this.ensureAsyncDataKeysPreCached();
        while (promise.getState() == Promise.State.PENDING) {
            try {
                indicator.checkCanceled();
                boolean success2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                    List<AnAction> result2 = this.expandActionGroup(group2, hideDisabled, this.myRealUpdateStrategy);
                    ActionUpdateEdtExecutor.computeOnEdt(() -> {
                        this.applyPresentationChanges();
                        promise.setResult((Object)result2);
                        return null;
                    });
                }, new SensitiveProgressWrapper(indicator));
                if (success2) continue;
                ProgressIndicatorUtils.yieldToPendingWriteActions();
            }
            catch (Throwable e) {
                promise.setError(e);
            }
        }
    }

    private /* synthetic */ void lambda$expandActionGroupAsync$13(ProgressIndicator indicator, Throwable __) {
        indicator.cancel();
        ActionUpdateEdtExecutor.computeOnEdt(() -> {
            this.applyPresentationChanges();
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionUpdater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionUpdater";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "expandActionGroupWithTimeout";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "expandActionGroupAsync";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateGroupChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "iterateGroupChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UpdateStrategy {
        final NullableFunction<? super AnAction, Presentation> update;
        final NotNullFunction<? super ActionGroup, ? extends AnAction[]> getChildren;
        final Predicate<? super ActionGroup> canBePerformed;

        UpdateStrategy(NullableFunction<? super AnAction, Presentation> update2, NotNullFunction<? super ActionGroup, ? extends AnAction[]> getChildren, Predicate<? super ActionGroup> canBePerformed) {
            this.update = update2;
            this.getChildren = getChildren;
            this.canBePerformed = canBePerformed;
        }
    }
}

