/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.idea.IdeaLogger;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionIdProvider;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsCollectorImpl;
import com.intellij.internal.statistic.collectors.fus.actions.persistence.ActionsEventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.ObjectEventData;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionGroupStub;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionStubBase;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.OverridingAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionPopupMenuListener;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.impl.AbbreviationManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ButtonToolbarImpl;
import com.intellij.openapi.actionSystem.impl.ChameleonAction;
import com.intellij.openapi.actionSystem.impl.DynamicActionConfigurationCustomizer;
import com.intellij.openapi.actionSystem.impl.FusAwareAction;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.ProxyShortcutSet;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectType;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionManagerImpl
extends ActionManagerEx
implements Disposable {
    private static final ExtensionPointName<ActionConfigurationCustomizer> EP = new ExtensionPointName("com.intellij.actionConfigurationCustomizer");
    private static final ExtensionPointName<DynamicActionConfigurationCustomizer> DYNAMIC_EP_NAME = new ExtensionPointName("com.intellij.dynamicActionConfigurationCustomizer");
    private static final ExtensionPointName<EditorActionHandlerBean> EDITOR_ACTION_HANDLER_EP = new ExtensionPointName("com.intellij.editorActionHandler");
    private static final String ACTION_ELEMENT_NAME = "action";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String CLASS_ATTR_NAME = "class";
    private static final String ID_ATTR_NAME = "id";
    private static final String INTERNAL_ATTR_NAME = "internal";
    private static final String ICON_ATTR_NAME = "icon";
    private static final String ADD_TO_GROUP_ELEMENT_NAME = "add-to-group";
    private static final String SHORTCUT_ELEMENT_NAME = "keyboard-shortcut";
    private static final String MOUSE_SHORTCUT_ELEMENT_NAME = "mouse-shortcut";
    private static final String DESCRIPTION = "description";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String KEY_ATTR_NAME = "key";
    private static final String POPUP_ATTR_NAME = "popup";
    private static final String COMPACT_ATTR_NAME = "compact";
    private static final String SEARCHABLE_ATTR_NAME = "searchable";
    private static final String SEPARATOR_ELEMENT_NAME = "separator";
    private static final String REFERENCE_ELEMENT_NAME = "reference";
    private static final String ABBREVIATION_ELEMENT_NAME = "abbreviation";
    private static final String GROUPID_ATTR_NAME = "group-id";
    private static final String ANCHOR_ELEMENT_NAME = "anchor";
    private static final String FIRST = "first";
    private static final String LAST = "last";
    private static final String BEFORE = "before";
    private static final String AFTER = "after";
    private static final String SECONDARY = "secondary";
    private static final String RELATIVE_TO_ACTION_ATTR_NAME = "relative-to-action";
    private static final String FIRST_KEYSTROKE_ATTR_NAME = "first-keystroke";
    private static final String SECOND_KEYSTROKE_ATTR_NAME = "second-keystroke";
    private static final String REMOVE_SHORTCUT_ATTR_NAME = "remove";
    private static final String REPLACE_SHORTCUT_ATTR_NAME = "replace-all";
    private static final String KEYMAP_ATTR_NAME = "keymap";
    private static final String KEYSTROKE_ATTR_NAME = "keystroke";
    private static final String REF_ATTR_NAME = "ref";
    private static final String VALUE_ATTR_NAME = "value";
    private static final String ACTIONS_BUNDLE = "messages.ActionsBundle";
    private static final String USE_SHORTCUT_OF_ATTR_NAME = "use-shortcut-of";
    private static final String OVERRIDES_ATTR_NAME = "overrides";
    private static final String KEEP_CONTENT_ATTR_NAME = "keep-content";
    private static final String PROJECT_TYPE = "project-type";
    private static final String UNREGISTER_ELEMENT_NAME = "unregister";
    private static final String OVERRIDE_TEXT_ELEMENT_NAME = "override-text";
    private static final String SYNONYM_ELEMENT_NAME = "synonym";
    private static final String PLACE_ATTR_NAME = "place";
    private static final String USE_TEXT_OF_PLACE_ATTR_NAME = "use-text-of-place";
    private static final String RESOURCE_BUNDLE_ATTR_NAME = "resource-bundle";
    private static final Logger LOG = Logger.getInstance(ActionManagerImpl.class);
    private static final int DEACTIVATED_TIMER_DELAY = 5000;
    private static final int TIMER_DELAY = 500;
    private static final int UPDATE_DELAY_AFTER_TYPING = 500;
    private final Object myLock = new Object();
    private final Map<String, AnAction> idToAction = CollectionFactory.createSmallMemoryFootprintMap();
    private final MultiMap<PluginId, String> pluginToId = new MultiMap();
    private final Object2IntMap<String> idToIndex = new Object2IntOpenHashMap();
    private final Map<Object, String> actionToId = CollectionFactory.createSmallMemoryFootprintMap();
    private final MultiMap<String, String> idToGroupId = new MultiMap();
    private final List<String> myNotRegisteredInternalActionIds = new ArrayList<String>();
    private final List<AnActionListener> myActionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ActionPopupMenuListener> myActionPopupMenuListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Object> myPopups = new ArrayList<Object>();
    private MyTimer myTimer;
    private int myRegisteredActionsCount;
    private String myLastPreformedActionId;
    private String myPrevPerformedActionId;
    private long myLastTimeEditorWasTypedIn;
    private final Map<OverridingAction, AnAction> myBaseActions = new HashMap<OverridingAction, AnAction>();
    private int myAnonymousGroupIdCounter;

    ActionManagerImpl() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode()) {
            LoadingState.COMPONENTS_LOADED.checkOccurred();
            if (!app.isHeadlessEnvironment() && !app.isCommandLine()) {
                LOG.assertTrue(!app.isDispatchThread());
            }
        }
        this.registerActions(PluginManagerCore.getLoadedPlugins(null), true);
        EP.forEachExtensionSafe(customizer -> customizer.customize((ActionManager)this));
        DYNAMIC_EP_NAME.forEachExtensionSafe(customizer -> customizer.registerActions((ActionManager)this));
        DYNAMIC_EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<DynamicActionConfigurationCustomizer>(){

            public void extensionAdded(@NotNull DynamicActionConfigurationCustomizer extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                extension2.registerActions((ActionManager)ActionManagerImpl.this);
            }

            public void extensionRemoved(@NotNull DynamicActionConfigurationCustomizer extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                extension2.unregisterActions((ActionManager)ActionManagerImpl.this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        EDITOR_ACTION_HANDLER_EP.addChangeListener(this::updateAllHandlers, (Disposable)this);
    }

    @ApiStatus.Internal
    public void registerActions(@NotNull List<IdeaPluginDescriptorImpl> plugins2, boolean initialStartup) {
        if (plugins2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(0);
        }
        KeymapManager keymapManager2 = Objects.requireNonNull(KeymapManager.getInstance());
        for (IdeaPluginDescriptorImpl plugin2 : plugins2) {
            this.registerPluginActions(plugin2, keymapManager2);
            for (PluginDependency pluginDependency : plugin2.getPluginDependencies()) {
                IdeaPluginDescriptorImpl subPlugin;
                IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = subPlugin = pluginDependency.isDisabledOrBroken ? null : pluginDependency.subDescriptor;
                if (subPlugin == null) continue;
                this.registerPluginActions(subPlugin, keymapManager2);
                for (PluginDependency subPluginDependency : subPlugin.getPluginDependencies()) {
                    IdeaPluginDescriptorImpl subSubPlugin = subPluginDependency.isDisabledOrBroken ? null : subPluginDependency.subDescriptor;
                    if (subSubPlugin == null) continue;
                    this.registerPluginActions(subSubPlugin, keymapManager2);
                }
            }
        }
    }

    @NotNull
    private static AnActionListener publisher() {
        AnActionListener anActionListener = (AnActionListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(AnActionListener.TOPIC);
        if (anActionListener == null) {
            ActionManagerImpl.$$$reportNull$$$0(1);
        }
        return anActionListener;
    }

    @Nullable
    static AnAction convertStub(@NotNull ActionStub stub) {
        AnAction anAction;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(2);
        }
        if ((anAction = ActionManagerImpl.instantiate(stub.getClassName(), stub.getPlugin(), AnAction.class)) == null) {
            return null;
        }
        stub.initAction(anAction);
        ActionManagerImpl.updateIconFromStub((ActionStubBase)stub, anAction);
        return anAction;
    }

    @Nullable
    private static <T> T instantiate(@NotNull String stubClassName, @NotNull PluginDescriptor pluginDescriptor, @NotNull Class<T> expectedClass) {
        Object obj2;
        if (stubClassName == null) {
            ActionManagerImpl.$$$reportNull$$$0(3);
        }
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(4);
        }
        if (expectedClass == null) {
            ActionManagerImpl.$$$reportNull$$$0(5);
        }
        try {
            Class<?> aClass = Class.forName(stubClassName, true, pluginDescriptor.getPluginClassLoader());
            Constructor<?> constructor = aClass.getDeclaredConstructor(new Class[0]);
            try {
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            obj2 = constructor.newInstance(new Object[0]);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (PluginException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (Throwable e) {
            LOG.error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
            return null;
        }
        if (!expectedClass.isInstance(obj2)) {
            LOG.error((Throwable)new PluginException("class with name '" + stubClassName + "' must be an instance of '" + expectedClass.getName() + "'; got " + obj2, pluginDescriptor.getPluginId()));
            return null;
        }
        return (T)obj2;
    }

    private static void updateIconFromStub(@NotNull ActionStubBase stub, @NotNull AnAction anAction) {
        String iconPath;
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(6);
        }
        if (anAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(7);
        }
        if ((iconPath = stub.getIconPath()) != null) {
            ActionManagerImpl.setIconFromClass(anAction.getClass(), stub.getPlugin(), iconPath, anAction.getTemplatePresentation());
        }
    }

    @Nullable
    private static ActionGroup convertGroupStub(@NotNull ActionGroupStub stub, @NotNull ActionManager actionManager) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(8);
        }
        if (actionManager == null) {
            ActionManagerImpl.$$$reportNull$$$0(9);
        }
        IdeaPluginDescriptor plugin2 = stub.getPlugin();
        ActionGroup group2 = ActionManagerImpl.instantiate(stub.getActionClass(), (PluginDescriptor)plugin2, ActionGroup.class);
        if (group2 == null) {
            return null;
        }
        stub.initGroup(group2, actionManager);
        ActionManagerImpl.updateIconFromStub((ActionStubBase)stub, (AnAction)group2);
        return group2;
    }

    private static void processAbbreviationNode(@NotNull Element e, @NotNull String id2) {
        String abbr;
        if (e == null) {
            ActionManagerImpl.$$$reportNull$$$0(10);
        }
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(11);
        }
        if (!Strings.isEmpty((String)(abbr = e.getAttributeValue(VALUE_ATTR_NAME)))) {
            AbbreviationManagerImpl abbreviationManager = (AbbreviationManagerImpl)AbbreviationManager.getInstance();
            abbreviationManager.register(abbr, id2, true);
        }
    }

    private static boolean isSecondary(Element element2) {
        return "true".equalsIgnoreCase(element2.getAttributeValue(SECONDARY));
    }

    private static void setIconFromClass(@Nullable Class<?> actionClass, @NotNull PluginDescriptor pluginDescriptor, @NotNull String iconPath, @NotNull Presentation presentation2) {
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(12);
        }
        if (iconPath == null) {
            ActionManagerImpl.$$$reportNull$$$0(13);
        }
        if (presentation2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(14);
        }
        long start2 = StartUpMeasurer.getCurrentTimeIfEnabled();
        Icon icon2 = IconLoader.findIcon((String)iconPath, actionClass, (ClassLoader)pluginDescriptor.getPluginClassLoader(), null, (boolean)true);
        if (icon2 == null) {
            ActionManagerImpl.reportActionError(pluginDescriptor.getPluginId(), "Icon cannot be found in '" + iconPath + "', action '" + actionClass + "'");
            icon2 = AllIcons.Nodes.Unknown;
        }
        IconLoadMeasurer.actionIcon.end(start2);
        presentation2.setIcon(icon2);
    }

    @NlsActions.ActionDescription
    private static String computeDescription(@NotNull ResourceBundle bundle, String id2, String elementType, String descriptionValue) {
        if (bundle == null) {
            ActionManagerImpl.$$$reportNull$$$0(15);
        }
        String key = elementType + "." + id2 + ".description";
        return AbstractBundle.messageOrDefault((ResourceBundle)bundle, (String)key, (String)Strings.notNullize((String)descriptionValue), (Object[])new Object[0]);
    }

    @NlsActions.ActionText
    private static String computeActionText(@Nullable ResourceBundle bundle, String id2, String elementType, @Nullable String textValue) {
        String defaultValue = Strings.notNullize((String)textValue);
        return bundle == null ? defaultValue : AbstractBundle.messageOrDefault((ResourceBundle)bundle, (String)(elementType + "." + id2 + ".text"), (String)defaultValue, (Object[])new Object[0]);
    }

    private static boolean checkRelativeToAction(String relativeToActionId, @NotNull Anchor anchor2, @NotNull String actionName, @Nullable PluginId pluginId) {
        if (anchor2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(16);
        }
        if (actionName == null) {
            ActionManagerImpl.$$$reportNull$$$0(17);
        }
        if ((Anchor.BEFORE == anchor2 || Anchor.AFTER == anchor2) && relativeToActionId == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": \"relative-to-action\" cannot be null if anchor is \"after\" or \"before\"");
            return false;
        }
        return true;
    }

    @Nullable
    private static Anchor parseAnchor(String anchorStr, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (anchorStr == null) {
            return Anchor.LAST;
        }
        if (FIRST.equalsIgnoreCase(anchorStr)) {
            return Anchor.FIRST;
        }
        if (LAST.equalsIgnoreCase(anchorStr)) {
            return Anchor.LAST;
        }
        if (BEFORE.equalsIgnoreCase(anchorStr)) {
            return Anchor.BEFORE;
        }
        if (AFTER.equalsIgnoreCase(anchorStr)) {
            return Anchor.AFTER;
        }
        ActionManagerImpl.reportActionError(pluginId, actionName + ": anchor should be one of the following constants: \"first\", \"last\", \"before\" or \"after\"");
        return null;
    }

    private static void processMouseShortcutNode(Element element2, String actionId, PluginId pluginId, @NotNull KeymapManager keymapManager2) {
        MouseShortcut shortcut;
        String keystrokeString;
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(18);
        }
        if ((keystrokeString = element2.getAttributeValue(KEYSTROKE_ATTR_NAME)) == null || keystrokeString.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        try {
            shortcut = KeymapUtil.parseMouseShortcut((String)keystrokeString);
        }
        catch (Exception ex) {
            ActionManagerImpl.reportActionError(pluginId, "\"keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element2.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap2 = keymapManager2.getKeymap(keymapName);
        if (keymap2 == null) {
            ActionManagerImpl.reportKeymapNotFoundWarning(pluginId, keymapName);
            return;
        }
        ActionManagerImpl.processRemoveAndReplace(element2, actionId, keymap2, (Shortcut)shortcut);
    }

    private static void reportActionError(@Nullable PluginId pluginId, @NotNull String message2) {
        if (message2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(19);
        }
        ActionManagerImpl.reportActionError(pluginId, message2, null);
    }

    private static void reportActionError(@Nullable PluginId pluginId, @NotNull String message2, @Nullable Throwable cause) {
        if (message2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(20);
        }
        if (pluginId != null) {
            LOG.error((Throwable)new PluginException(message2, cause, pluginId));
        } else if (cause != null) {
            LOG.error(message2, cause);
        } else {
            LOG.error(message2);
        }
    }

    private static void reportKeymapNotFoundWarning(@Nullable PluginId pluginId, @NotNull String keymapName) {
        if (keymapName == null) {
            ActionManagerImpl.$$$reportNull$$$0(21);
        }
        if (DefaultKeymap.isBundledKeymapHidden(keymapName)) {
            return;
        }
        String message2 = "keymap \"" + keymapName + "\" not found";
        LOG.warn((String)(pluginId == null ? message2 : new PluginException(message2, null, pluginId).getMessage()));
    }

    private static String getPluginInfo(@Nullable PluginId id2) {
        IdeaPluginDescriptor plugin2;
        IdeaPluginDescriptor ideaPluginDescriptor = plugin2 = id2 == null ? null : PluginManagerCore.getPlugin(id2);
        if (plugin2 == null) {
            return "";
        }
        String name = plugin2.getName();
        if (name == null) {
            name = id2.getIdString();
        }
        return " (Plugin: " + name + ")";
    }

    @NotNull
    private static DataContext getContextBy(Component contextComponent) {
        DataManager dataManager = DataManager.getInstance();
        DataContext dataContext = contextComponent != null ? dataManager.getDataContext(contextComponent) : dataManager.getDataContext();
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(22);
        }
        return dataContext;
    }

    public void dispose() {
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public void addTimerListener(int unused, @NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(23);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (this.myTimer == null) {
            this.myTimer = new MyTimer();
            this.myTimer.start();
        }
        this.myTimer.listeners.add(listener2);
    }

    public void removeTimerListener(@NotNull TimerListener listener2) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(24);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (LOG.assertTrue(this.myTimer != null)) {
            this.myTimer.listeners.remove(listener2);
        }
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group2, @Nullable PresentationFactory presentationFactory) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(25);
        }
        if (group2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(26);
        }
        return new ActionPopupMenuImpl(place, group2, this, presentationFactory);
    }

    @NotNull
    public ActionPopupMenu createActionPopupMenu(@NotNull String place, @NotNull ActionGroup group2) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(27);
        }
        if (group2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(28);
        }
        return new ActionPopupMenuImpl(place, group2, this, null);
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group2, boolean horizontal) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(29);
        }
        if (group2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(30);
        }
        ActionToolbar actionToolbar = this.createActionToolbar(place, group2, horizontal, false);
        if (actionToolbar == null) {
            ActionManagerImpl.$$$reportNull$$$0(31);
        }
        return actionToolbar;
    }

    @NotNull
    public ActionToolbar createActionToolbar(@NotNull String place, @NotNull ActionGroup group2, boolean horizontal, boolean decorateButtons) {
        if (place == null) {
            ActionManagerImpl.$$$reportNull$$$0(32);
        }
        if (group2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(33);
        }
        return new ActionToolbarImpl(place, group2, horizontal, decorateButtons);
    }

    private void registerPluginActions(@NotNull IdeaPluginDescriptorImpl plugin2, @NotNull KeymapManager keymapManager2) {
        List<Element> elements;
        if (plugin2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(34);
        }
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(35);
        }
        if ((elements = plugin2.getActionDescriptionElements()) == null) {
            return;
        }
        long startTime = StartUpMeasurer.getCurrentTime();
        String lastBundleName = null;
        ResourceBundle lastBundle = null;
        block16: for (Element element2 : elements) {
            ResourceBundle bundle;
            String bundleName;
            Element parent = element2.getParentElement();
            String string = bundleName = parent == null ? null : parent.getAttributeValue(RESOURCE_BUNDLE_ATTR_NAME);
            if (bundleName == null) {
                String string2 = bundleName = plugin2.getPluginId() == PluginManagerCore.CORE_ID ? ACTIONS_BUNDLE : plugin2.getResourceBundleBaseName();
            }
            if (bundleName == null) {
                bundle = null;
            } else if (bundleName.equals(lastBundleName)) {
                bundle = lastBundle;
            } else {
                try {
                    lastBundle = bundle = DynamicBundle.INSTANCE.getResourceBundle(bundleName, plugin2.getPluginClassLoader());
                    lastBundleName = bundleName;
                }
                catch (MissingResourceException e) {
                    LOG.error((Throwable)new PluginException("Cannot resolve resource bundle " + bundleName + " for action " + JDOMUtil.writeElement((Element)element2), (Throwable)e, plugin2.getPluginId()));
                    bundle = null;
                }
            }
            switch (element2.getName()) {
                case "action": {
                    this.processActionElement(element2, plugin2, bundle, keymapManager2);
                    continue block16;
                }
                case "group": {
                    this.processGroupElement(element2, plugin2, bundle, keymapManager2);
                    continue block16;
                }
                case "separator": {
                    this.processSeparatorNode(null, element2, plugin2.getPluginId(), bundle);
                    continue block16;
                }
                case "reference": {
                    this.processReferenceNode(element2, plugin2.getPluginId(), bundle);
                    continue block16;
                }
                case "unregister": {
                    this.processUnregisterNode(element2, plugin2.getPluginId());
                    continue block16;
                }
            }
            LOG.error((Throwable)new PluginException("Unexpected name of element" + element2.getName(), plugin2.getPluginId()));
        }
        StartUpMeasurer.addPluginCost((String)plugin2.getPluginId().getIdString(), (String)"Actions", (long)(StartUpMeasurer.getCurrentTime() - startTime));
    }

    @Nullable
    public AnAction getAction(@NotNull String id2) {
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(36);
        }
        return this.getActionImpl(id2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AnAction getActionImpl(@NotNull String id2, boolean canReturnStub) {
        AnAction converted;
        AnAction action2;
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(37);
        }
        Object object = this.myLock;
        synchronized (object) {
            action2 = this.idToAction.get(id2);
            if (canReturnStub || !(action2 instanceof ActionStubBase)) {
                return action2;
            }
        }
        Object object2 = converted = action2 instanceof ActionStub ? ActionManagerImpl.convertStub((ActionStub)action2) : ActionManagerImpl.convertGroupStub((ActionGroupStub)action2, (ActionManager)this);
        if (converted == null) {
            this.unregisterAction(id2);
            return null;
        }
        Object object3 = this.myLock;
        synchronized (object3) {
            action2 = this.idToAction.get(id2);
            if (action2 instanceof ActionStubBase) {
                action2 = this.replaceStub((ActionStubBase)action2, converted);
            }
            return action2;
        }
    }

    @NotNull
    private AnAction replaceStub(@NotNull ActionStubBase stub, AnAction anAction) {
        if (stub == null) {
            ActionManagerImpl.$$$reportNull$$$0(38);
        }
        LOG.assertTrue(this.actionToId.containsKey(stub));
        this.actionToId.remove(stub);
        LOG.assertTrue(this.idToAction.containsKey(stub.getId()));
        AnAction action2 = this.idToAction.remove(stub.getId());
        LOG.assertTrue(action2 != null);
        LOG.assertTrue(action2.equals(stub));
        this.actionToId.put(anAction, stub.getId());
        ActionManagerImpl.updateHandlers(anAction);
        AnAction anAction2 = this.addToMap(stub.getId(), anAction, stub.getPlugin().getPluginId(), stub instanceof ActionStub ? ((ActionStub)stub).getProjectType() : null);
        if (anAction2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(39);
        }
        return anAction2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId(@NotNull AnAction action2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(40);
        }
        if (action2 instanceof ActionStubBase) {
            return ((ActionStubBase)action2).getId();
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.actionToId.get(action2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getActionIdList(@NotNull String idPrefix) {
        if (idPrefix == null) {
            ActionManagerImpl.$$$reportNull$$$0(41);
        }
        ArrayList<String> result2 = new ArrayList<String>();
        Object object = this.myLock;
        synchronized (object) {
            for (String id2 : this.idToAction.keySet()) {
                if (!id2.startsWith(idPrefix)) continue;
                result2.add(id2);
            }
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ActionManagerImpl.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    public String @NotNull [] getActionIds(@NotNull String idPrefix) {
        if (idPrefix == null) {
            ActionManagerImpl.$$$reportNull$$$0(43);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(this.getActionIdList(idPrefix));
        if (stringArray == null) {
            ActionManagerImpl.$$$reportNull$$$0(44);
        }
        return stringArray;
    }

    public boolean isGroup(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(45);
        }
        return this.getActionImpl(actionId, true) instanceof ActionGroup;
    }

    @NotNull
    public JComponent createButtonToolbar(@NotNull String actionPlace, @NotNull ActionGroup messageActionGroup) {
        if (actionPlace == null) {
            ActionManagerImpl.$$$reportNull$$$0(46);
        }
        if (messageActionGroup == null) {
            ActionManagerImpl.$$$reportNull$$$0(47);
        }
        return new ButtonToolbarImpl(actionPlace, messageActionGroup);
    }

    public AnAction getActionOrStub(@NotNull String id2) {
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(48);
        }
        return this.getActionImpl(id2, true);
    }

    @Nullable
    private AnAction processActionElement(@NotNull Element element2, @NotNull IdeaPluginDescriptorImpl plugin2, @Nullable ResourceBundle bundle, @NotNull KeymapManager keymapManager2) {
        String className;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(49);
        }
        if (plugin2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(50);
        }
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(51);
        }
        if ((className = element2.getAttributeValue(CLASS_ATTR_NAME)) == null || className.isEmpty()) {
            ActionManagerImpl.reportActionError(plugin2.getPluginId(), "action element should have specified \"class\" attribute");
            return null;
        }
        String id2 = ActionManagerImpl.obtainActionId(element2, className);
        if (Boolean.parseBoolean(element2.getAttributeValue(INTERNAL_ATTR_NAME)) && !ApplicationManager.getApplication().isInternal()) {
            this.myNotRegisteredInternalActionIds.add(id2);
            return null;
        }
        String iconPath = element2.getAttributeValue(ICON_ATTR_NAME);
        String projectType = element2.getAttributeValue(PROJECT_TYPE);
        String textValue = element2.getAttributeValue(TEXT_ATTR_NAME);
        String descriptionValue = element2.getAttributeValue(DESCRIPTION);
        ActionStub stub = new ActionStub(className, id2, (PluginDescriptor)plugin2, iconPath, projectType, () -> {
            Supplier<String> text2 = () -> ActionManagerImpl.computeActionText(bundle, id2, ACTION_ELEMENT_NAME, textValue);
            if (text2.get() == null) {
                ActionManagerImpl.reportActionError(plugin2.getPluginId(), "'text' attribute is mandatory (actionId=" + id2 + ", plugin=" + plugin2 + ")");
            }
            Presentation presentation2 = new Presentation();
            presentation2.setText(text2);
            if (bundle == null) {
                presentation2.setDescription(descriptionValue);
            } else {
                presentation2.setDescription(() -> ActionManagerImpl.computeDescription(bundle, id2, ACTION_ELEMENT_NAME, descriptionValue));
            }
            return presentation2;
        });
        block16: for (Element e : element2.getChildren()) {
            switch (e.getName()) {
                case "add-to-group": {
                    this.processAddToGroupNode((AnAction)stub, e, plugin2.getPluginId(), ActionManagerImpl.isSecondary(e));
                    continue block16;
                }
                case "keyboard-shortcut": {
                    ActionManagerImpl.processKeyboardShortcutNode(e, id2, plugin2.getPluginId(), keymapManager2);
                    continue block16;
                }
                case "mouse-shortcut": {
                    ActionManagerImpl.processMouseShortcutNode(e, id2, plugin2.getPluginId(), keymapManager2);
                    continue block16;
                }
                case "abbreviation": {
                    ActionManagerImpl.processAbbreviationNode(e, id2);
                    continue block16;
                }
                case "override-text": {
                    ActionManagerImpl.processOverrideTextNode((AnAction)stub, stub.getId(), e, plugin2.getPluginId(), bundle);
                    continue block16;
                }
                case "synonym": {
                    ActionManagerImpl.processSynonymNode((AnAction)stub, e, plugin2.getPluginId(), bundle);
                    continue block16;
                }
            }
            ActionManagerImpl.reportActionError(plugin2.getPluginId(), "unexpected name of element \"" + e.getName() + "\"");
            return null;
        }
        String shortcutOfActionId = element2.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME);
        if (shortcutOfActionId != null) {
            keymapManager2.bindShortcuts(shortcutOfActionId, id2);
        }
        this.registerOrReplaceActionInner(element2, id2, (AnAction)stub, plugin2);
        return stub;
    }

    private static String obtainActionId(Element element2, String className) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        return Strings.isEmpty((String)id2) ? StringUtilRt.getShortName((String)className) : id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOrReplaceActionInner(@NotNull Element element2, @NotNull String id2, @NotNull AnAction action2, @NotNull IdeaPluginDescriptor plugin2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(52);
        }
        if (id2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(53);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(54);
        }
        if (plugin2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(55);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (Boolean.parseBoolean(element2.getAttributeValue(OVERRIDES_ATTR_NAME))) {
                if (this.getActionOrStub(id2) == null) {
                    LOG.error(element2.getName() + " '" + id2 + "' doesn't override anything");
                    return;
                }
                AnAction prev2 = this.replaceAction(id2, action2, plugin2.getPluginId());
                if (action2 instanceof DefaultActionGroup && prev2 instanceof DefaultActionGroup && Boolean.parseBoolean(element2.getAttributeValue(KEEP_CONTENT_ATTR_NAME))) {
                    ((DefaultActionGroup)action2).copyFromGroup((DefaultActionGroup)prev2);
                }
            } else {
                this.registerAction(id2, action2, plugin2.getPluginId(), element2.getAttributeValue(PROJECT_TYPE));
            }
            ActionsCollectorImpl.onActionLoadedFromXml(action2, id2, plugin2);
        }
    }

    private AnAction processGroupElement(@NotNull Element element2, @NotNull IdeaPluginDescriptorImpl plugin2, @Nullable ResourceBundle bundle, @NotNull KeymapManager keymapManager2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(56);
        }
        if (plugin2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(57);
        }
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(58);
        }
        if (!GROUP_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(plugin2.getPluginId(), "unexpected name of element \"" + element2.getName() + "\"");
            return null;
        }
        String className = element2.getAttributeValue(CLASS_ATTR_NAME);
        if (className == null) {
            className = "true".equals(element2.getAttributeValue(COMPACT_ATTR_NAME)) ? DefaultCompactActionGroup.class.getName() : DefaultActionGroup.class.getName();
        }
        try {
            String searchable;
            DefaultActionGroup group2;
            Object id2 = element2.getAttributeValue(ID_ATTR_NAME);
            if (id2 != null && ((String)id2).isEmpty()) {
                ActionManagerImpl.reportActionError(plugin2.getPluginId(), "ID of the group cannot be an empty string");
                return null;
            }
            boolean customClass = false;
            if (DefaultActionGroup.class.getName().equals(className)) {
                group2 = new DefaultActionGroup();
            } else if (DefaultCompactActionGroup.class.getName().equals(className)) {
                group2 = new DefaultCompactActionGroup();
            } else if (id2 == null) {
                Object obj2 = ApplicationManager.getApplication().instantiateClass(className, (PluginDescriptor)plugin2);
                if (!(obj2 instanceof ActionGroup)) {
                    ActionManagerImpl.reportActionError(plugin2.getPluginId(), "class with name \"" + className + "\" should be instance of " + ActionGroup.class.getName());
                    return null;
                }
                if (element2.getChildren().size() != element2.getChildren(ADD_TO_GROUP_ELEMENT_NAME).size() && !(obj2 instanceof DefaultActionGroup)) {
                    ActionManagerImpl.reportActionError(plugin2.getPluginId(), "class with name \"" + className + "\" should be instance of " + DefaultActionGroup.class.getName() + " because there are children specified");
                    return null;
                }
                customClass = true;
                group2 = (ActionGroup)obj2;
            } else {
                group2 = new ActionGroupStub((String)id2, className, (IdeaPluginDescriptor)plugin2);
                customClass = true;
            }
            if (Boolean.parseBoolean(element2.getAttributeValue(INTERNAL_ATTR_NAME)) && !ApplicationManager.getApplication().isInternal()) {
                this.myNotRegisteredInternalActionIds.add((String)id2);
                return null;
            }
            if (id2 == null) {
                id2 = "<anonymous-group-" + this.myAnonymousGroupIdCounter++ + ">";
            }
            this.registerOrReplaceActionInner(element2, (String)id2, (AnAction)group2, plugin2);
            Presentation presentation2 = group2.getTemplatePresentation();
            Object finalId = id2;
            Supplier<String> text2 = () -> ActionManagerImpl.lambda$processGroupElement$5(bundle, (String)finalId, element2);
            if (!Strings.isEmpty((String)text2.get()) || presentation2.getText() == null) {
                presentation2.setText(text2);
            }
            String description = element2.getAttributeValue(DESCRIPTION);
            if (bundle == null) {
                if (!Strings.isEmpty((String)description) || presentation2.getDescription() == null) {
                    presentation2.setDescription(description);
                }
            } else {
                Supplier<String> descriptionSupplier = () -> ActionManagerImpl.lambda$processGroupElement$6(bundle, (String)finalId, description);
                if (!Strings.isEmpty((String)descriptionSupplier.get()) || presentation2.getDescription() == null) {
                    presentation2.setDescription(descriptionSupplier);
                }
            }
            String iconPath = element2.getAttributeValue(ICON_ATTR_NAME);
            if (group2 instanceof ActionGroupStub) {
                ((ActionGroupStub)group2).setIconPath(iconPath);
            } else if (iconPath != null) {
                ActionManagerImpl.setIconFromClass(null, (PluginDescriptor)plugin2, iconPath, presentation2);
            }
            String popup2 = element2.getAttributeValue(POPUP_ATTR_NAME);
            if (popup2 != null) {
                group2.setPopup(Boolean.parseBoolean(popup2));
                if (group2 instanceof ActionGroupStub) {
                    ((ActionGroupStub)group2).setPopupDefinedInXml(true);
                }
            }
            if ((searchable = element2.getAttributeValue(SEARCHABLE_ATTR_NAME)) != null) {
                group2.setSearchable(Boolean.parseBoolean(searchable));
            }
            String shortcutOfActionId = element2.getAttributeValue(USE_SHORTCUT_OF_ATTR_NAME);
            if (customClass && shortcutOfActionId != null) {
                KeymapManagerEx.getInstanceEx().bindShortcuts(shortcutOfActionId, (String)id2);
            }
            for (Element child2 : element2.getChildren()) {
                AnAction action2;
                String name = child2.getName();
                if (ACTION_ELEMENT_NAME.equals(name)) {
                    action2 = this.processActionElement(child2, plugin2, bundle, keymapManager2);
                    if (action2 == null) continue;
                    this.addToGroupInner((AnAction)group2, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (SEPARATOR_ELEMENT_NAME.equals(name)) {
                    this.processSeparatorNode(group2, child2, plugin2.getPluginId(), bundle);
                    continue;
                }
                if (GROUP_ELEMENT_NAME.equals(name)) {
                    action2 = this.processGroupElement(child2, plugin2, bundle, keymapManager2);
                    if (action2 == null) continue;
                    this.addToGroupInner((AnAction)group2, action2, Constraints.LAST, false);
                    continue;
                }
                if (ADD_TO_GROUP_ELEMENT_NAME.equals(name)) {
                    this.processAddToGroupNode((AnAction)group2, child2, plugin2.getPluginId(), ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (REFERENCE_ELEMENT_NAME.equals(name)) {
                    action2 = this.processReferenceElement(child2, plugin2.getPluginId());
                    if (action2 == null) continue;
                    this.addToGroupInner((AnAction)group2, action2, Constraints.LAST, ActionManagerImpl.isSecondary(child2));
                    continue;
                }
                if (OVERRIDE_TEXT_ELEMENT_NAME.equals(name)) {
                    ActionManagerImpl.processOverrideTextNode((AnAction)group2, (String)id2, child2, plugin2.getPluginId(), bundle);
                    continue;
                }
                ActionManagerImpl.reportActionError(plugin2.getPluginId(), "unexpected name of element \"" + name + "\n");
                return null;
            }
            return group2;
        }
        catch (Exception e) {
            String message2 = "cannot create class \"" + className + "\"";
            ActionManagerImpl.reportActionError(plugin2.getPluginId(), message2, e);
            return null;
        }
    }

    private void processReferenceNode(@NotNull Element element2, @Nullable PluginId pluginId, @Nullable ResourceBundle bundle) {
        AnAction action2;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(59);
        }
        if ((action2 = this.processReferenceElement(element2, pluginId)) == null) {
            return;
        }
        for (Element child2 : element2.getChildren()) {
            if (ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) {
                this.processAddToGroupNode(action2, child2, pluginId, ActionManagerImpl.isSecondary(child2));
                continue;
            }
            if (!SYNONYM_ELEMENT_NAME.equals(child2.getName())) continue;
            ActionManagerImpl.processSynonymNode(action2, child2, pluginId, bundle);
        }
    }

    private void processAddToGroupNode(AnAction action2, Element element2, PluginId pluginId, boolean secondary) {
        String name = action2 instanceof ActionStub ? ((ActionStub)action2).getClassName() : action2.getClass().getName();
        String id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.actionToId.get(action2);
        String actionName = name + " (" + id2 + ")";
        if (!ADD_TO_GROUP_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        DefaultActionGroup parentGroup = this.getParentGroup(element2.getAttributeValue(GROUPID_ATTR_NAME), actionName, pluginId);
        if (parentGroup == null) {
            return;
        }
        Anchor anchor2 = ActionManagerImpl.parseAnchor(element2.getAttributeValue(ANCHOR_ELEMENT_NAME), actionName, pluginId);
        if (anchor2 == null) {
            return;
        }
        String relativeToActionId = element2.getAttributeValue(RELATIVE_TO_ACTION_ATTR_NAME);
        if (!ActionManagerImpl.checkRelativeToAction(relativeToActionId, anchor2, actionName, pluginId)) {
            return;
        }
        this.addToGroupInner((AnAction)parentGroup, action2, new Constraints(anchor2, relativeToActionId), secondary);
    }

    private void addToGroupInner(AnAction group2, AnAction action2, Constraints constraints2, boolean secondary) {
        String actionId = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : this.actionToId.get(action2);
        ((DefaultActionGroup)group2).addAction(action2, constraints2, (ActionManager)this).setAsSecondary(secondary);
        this.idToGroupId.putValue((Object)actionId, (Object)this.actionToId.get(group2));
    }

    @Nullable
    public DefaultActionGroup getParentGroup(String groupId2, @Nullable String actionName, @Nullable PluginId pluginId) {
        if (groupId2 == null || groupId2.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": attribute \"group-id\" should be defined");
            return null;
        }
        AnAction parentGroup = this.getActionImpl(groupId2, true);
        if (parentGroup == null) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId2 + "\" isn't registered; action will be added to the \"Other\" group", null);
            parentGroup = this.getActionImpl("OtherMenu", true);
        }
        if (!(parentGroup instanceof DefaultActionGroup)) {
            ActionManagerImpl.reportActionError(pluginId, actionName + ": group with id \"" + groupId2 + "\" should be instance of " + DefaultActionGroup.class.getName() + " but was " + (Serializable)(parentGroup != null ? parentGroup.getClass() : "[null]"));
            return null;
        }
        return (DefaultActionGroup)parentGroup;
    }

    private static void processOverrideTextNode(AnAction action2, String id2, Element element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        if (!OVERRIDE_TEXT_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        String place = element2.getAttributeValue(PLACE_ATTR_NAME);
        if (place == null) {
            ActionManagerImpl.reportActionError(pluginId, id2 + ": override-text specified without place");
            return;
        }
        String useTextOfPlace = element2.getAttributeValue(USE_TEXT_OF_PLACE_ATTR_NAME);
        if (useTextOfPlace != null) {
            action2.copyActionTextOverride(useTextOfPlace, place, id2);
        } else {
            String text2 = element2.getAttributeValue(TEXT_ATTR_NAME, "");
            if (text2.isEmpty() && bundle != null) {
                String prefix = action2 instanceof ActionGroup ? GROUP_ELEMENT_NAME : ACTION_ELEMENT_NAME;
                String key = prefix + "." + id2 + "." + place + ".text";
                action2.addTextOverride(place, () -> BundleBase.message((ResourceBundle)bundle, (String)key, (Object[])new Object[0]));
            } else {
                action2.addTextOverride(place, () -> text2);
            }
        }
    }

    private static void processSynonymNode(AnAction action2, Element element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        if (!SYNONYM_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        String text2 = element2.getAttributeValue(TEXT_ATTR_NAME, "");
        if (!text2.isEmpty()) {
            action2.addSynonym(() -> text2);
        } else {
            String key = element2.getAttributeValue(KEY_ATTR_NAME);
            if (key != null && bundle != null) {
                action2.addSynonym(() -> BundleBase.message((ResourceBundle)bundle, (String)key, (Object[])new Object[0]));
            } else {
                ActionManagerImpl.reportActionError(pluginId, "Can't process synonym: neither text nor resource bundle key is specified");
            }
        }
    }

    private void processSeparatorNode(@Nullable DefaultActionGroup parentGroup, @NotNull Element element2, PluginId pluginId, @Nullable ResourceBundle bundle) {
        Separator separator;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(60);
        }
        if (!SEPARATOR_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"");
            return;
        }
        String text2 = element2.getAttributeValue(TEXT_ATTR_NAME);
        String key = element2.getAttributeValue(KEY_ATTR_NAME);
        Separator separator2 = text2 != null ? new Separator(text2) : (separator = key != null ? ActionManagerImpl.createSeparator(bundle, key) : Separator.getInstance());
        if (parentGroup != null) {
            parentGroup.add((AnAction)separator, (ActionManager)this);
        }
        for (Element child2 : element2.getChildren()) {
            if (!ADD_TO_GROUP_ELEMENT_NAME.equals(child2.getName())) continue;
            this.processAddToGroupNode((AnAction)separator, child2, pluginId, ActionManagerImpl.isSecondary(child2));
        }
    }

    @NotNull
    private static Separator createSeparator(@Nullable ResourceBundle bundle, @NotNull String key) {
        if (key == null) {
            ActionManagerImpl.$$$reportNull$$$0(61);
        }
        String text2 = bundle != null ? AbstractBundle.messageOrNull((ResourceBundle)bundle, (String)key, (Object[])new Object[0]) : null;
        Separator separator = text2 != null ? new Separator(text2) : Separator.getInstance();
        if (separator == null) {
            ActionManagerImpl.$$$reportNull$$$0(62);
        }
        return separator;
    }

    private void processUnregisterNode(Element element2, PluginId pluginId) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        if (id2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "'id' attribute is required for 'unregister' elements");
            return;
        }
        AnAction action2 = this.getAction(id2);
        if (action2 == null) {
            ActionManagerImpl.reportActionError(pluginId, "Trying to unregister non-existing action " + id2);
            return;
        }
        AbbreviationManager.getInstance().removeAllAbbreviations(id2);
        this.unregisterAction(id2);
    }

    private static void processKeyboardShortcutNode(Element element2, String actionId, PluginId pluginId, @NotNull KeymapManager keymapManager2) {
        String firstStrokeString;
        if (keymapManager2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(63);
        }
        if ((firstStrokeString = element2.getAttributeValue(FIRST_KEYSTROKE_ATTR_NAME)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute must be specified for action with id=" + actionId);
            return;
        }
        KeyStroke firstKeyStroke = ActionManagerImpl.getKeyStroke((String)firstStrokeString);
        if (firstKeyStroke == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"first-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        KeyStroke secondKeyStroke = null;
        String secondStrokeString = element2.getAttributeValue(SECOND_KEYSTROKE_ATTR_NAME);
        if (secondStrokeString != null && (secondKeyStroke = ActionManagerImpl.getKeyStroke((String)secondStrokeString)) == null) {
            ActionManagerImpl.reportActionError(pluginId, "\"second-keystroke\" attribute has invalid value for action with id=" + actionId);
            return;
        }
        String keymapName = element2.getAttributeValue(KEYMAP_ATTR_NAME);
        if (keymapName == null || keymapName.trim().isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "attribute \"keymap\" should be defined");
            return;
        }
        Keymap keymap2 = keymapManager2.getKeymap(keymapName);
        if (keymap2 == null) {
            ActionManagerImpl.reportKeymapNotFoundWarning(pluginId, keymapName);
            return;
        }
        KeyboardShortcut shortcut = new KeyboardShortcut(firstKeyStroke, secondKeyStroke);
        ActionManagerImpl.processRemoveAndReplace(element2, actionId, keymap2, (Shortcut)shortcut);
    }

    private static void processRemoveAndReplace(@NotNull Element element2, String actionId, @NotNull Keymap keymap2, @NotNull Shortcut shortcut) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(64);
        }
        if (keymap2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(65);
        }
        if (shortcut == null) {
            ActionManagerImpl.$$$reportNull$$$0(66);
        }
        boolean remove = Boolean.parseBoolean(element2.getAttributeValue(REMOVE_SHORTCUT_ATTR_NAME));
        boolean replace = Boolean.parseBoolean(element2.getAttributeValue(REPLACE_SHORTCUT_ATTR_NAME));
        if (remove) {
            keymap2.removeShortcut(actionId, shortcut);
        }
        if (replace) {
            keymap2.removeAllActionShortcuts(actionId);
        }
        if (!remove) {
            keymap2.addShortcut(actionId, shortcut);
        }
    }

    @Nullable
    private AnAction processReferenceElement(Element element2, PluginId pluginId) {
        if (!REFERENCE_ELEMENT_NAME.equals(element2.getName())) {
            ActionManagerImpl.reportActionError(pluginId, "unexpected name of element \"" + element2.getName() + "\"", null);
            return null;
        }
        String ref = ActionManagerImpl.getReferenceActionId(element2);
        if (ref == null || ref.isEmpty()) {
            ActionManagerImpl.reportActionError(pluginId, "ID of reference element should be defined", null);
            return null;
        }
        AnAction action2 = this.getActionImpl(ref, true);
        if (action2 == null) {
            if (!this.myNotRegisteredInternalActionIds.contains(ref)) {
                ActionManagerImpl.reportActionError(pluginId, "action specified by reference isn't registered (ID=" + ref + ")", null);
            }
            return null;
        }
        return action2;
    }

    private static String getReferenceActionId(@NotNull Element element2) {
        String ref;
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(67);
        }
        if ((ref = element2.getAttributeValue(REF_ATTR_NAME)) == null) {
            ref = element2.getAttributeValue(ID_ATTR_NAME);
        }
        return ref;
    }

    @ApiStatus.Internal
    @Nullable
    public static String checkUnloadActions(PluginId pluginId, @NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        List<Element> elements;
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(68);
        }
        if ((elements = pluginDescriptor.getActionDescriptionElements()) == null) {
            return null;
        }
        for (Element element2 : elements) {
            if (element2.getName().equals(ACTION_ELEMENT_NAME) || element2.getName().equals(GROUP_ELEMENT_NAME) && ActionManagerImpl.canUnloadGroup(element2) || element2.getName().equals(REFERENCE_ELEMENT_NAME)) continue;
            return "Plugin " + pluginId + " is not unload-safe because of action element " + element2.getName();
        }
        return null;
    }

    private static boolean canUnloadGroup(@NotNull Element element2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(69);
        }
        if (element2.getAttributeValue(ID_ATTR_NAME) == null) {
            return false;
        }
        for (Element child2 : element2.getChildren()) {
            if (!child2.getName().equals(GROUP_ELEMENT_NAME) || ActionManagerImpl.canUnloadGroup(child2)) continue;
            return false;
        }
        return true;
    }

    public void unloadActions(@NotNull IdeaPluginDescriptorImpl pluginDescriptor) {
        List<Element> elements;
        if (pluginDescriptor == null) {
            ActionManagerImpl.$$$reportNull$$$0(70);
        }
        if ((elements = pluginDescriptor.getActionDescriptionElements()) == null) {
            return;
        }
        for (Element element2 : ContainerUtil.reverse(elements)) {
            switch (element2.getName()) {
                case "action": {
                    this.unloadActionElement(element2);
                    break;
                }
                case "group": {
                    this.unloadGroupElement(element2);
                    break;
                }
                case "reference": {
                    PluginId pluginId = pluginDescriptor.getPluginId();
                    AnAction action2 = this.processReferenceElement(element2, pluginId);
                    if (action2 == null) {
                        return;
                    }
                    String actionId = ActionManagerImpl.getReferenceActionId(element2);
                    for (Element child2 : element2.getChildren(ADD_TO_GROUP_ELEMENT_NAME)) {
                        String groupId2 = child2.getAttributeValue(GROUPID_ATTR_NAME);
                        DefaultActionGroup parentGroup = this.getParentGroup(groupId2, actionId, pluginId);
                        if (parentGroup == null) {
                            return;
                        }
                        parentGroup.remove(action2);
                        this.idToGroupId.remove((Object)actionId, (Object)groupId2);
                    }
                    break;
                }
            }
        }
    }

    private void unloadGroupElement(Element element2) {
        String id2 = element2.getAttributeValue(ID_ATTR_NAME);
        if (id2 == null) {
            throw new IllegalStateException("Cannot unload groups with no ID");
        }
        for (Element groupChild : element2.getChildren()) {
            if (groupChild.getName().equals(ACTION_ELEMENT_NAME)) {
                this.unloadActionElement(groupChild);
                continue;
            }
            if (!groupChild.getName().equals(GROUP_ELEMENT_NAME)) continue;
            this.unloadGroupElement(groupChild);
        }
        this.unregisterAction(id2);
    }

    private void unloadActionElement(@NotNull Element element2) {
        if (element2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(71);
        }
        String className = element2.getAttributeValue(CLASS_ATTR_NAME);
        String id2 = ActionManagerImpl.obtainActionId(element2, className);
        this.unregisterAction(id2);
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(72);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(73);
        }
        this.registerAction(actionId, action2, pluginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAction(@NotNull String actionId, @NotNull AnAction action2, @Nullable PluginId pluginId, @Nullable String projectType) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(74);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(75);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.addToMap(actionId, action2, pluginId, projectType) == null) {
                return;
            }
            if (this.actionToId.containsKey(action2)) {
                ActionManagerImpl.reportActionError(pluginId, "ID \"" + this.actionToId.get(action2) + "\" is already taken by action \"" + action2 + "\"" + ActionManagerImpl.getPluginInfo(pluginId) + ". ID \"" + actionId + "\" cannot be registered for the same action");
                return;
            }
            this.idToIndex.put((Object)actionId, this.myRegisteredActionsCount++);
            this.actionToId.put(action2, actionId);
            if (pluginId != null && !(action2 instanceof ActionGroup)) {
                this.pluginToId.putValue((Object)pluginId, (Object)actionId);
            }
            action2.registerCustomShortcutSet((ShortcutSet)new ProxyShortcutSet(actionId), null);
            ActionManagerImpl.notifyCustomActionsSchema(actionId);
            ActionManagerImpl.updateHandlers(action2);
        }
    }

    private static void notifyCustomActionsSchema(@NotNull String registeredID) {
        CustomActionsSchema schema2;
        if (registeredID == null) {
            ActionManagerImpl.$$$reportNull$$$0(76);
        }
        if ((schema2 = (CustomActionsSchema)ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class)) == null) {
            return;
        }
        for (ActionUrl url : schema2.getActions()) {
            if (!registeredID.equals(url.getComponent())) continue;
            schema2.incrementModificationStamp();
            break;
        }
    }

    private AnAction addToMap(String actionId, AnAction action2, PluginId pluginId, String projectType) {
        if (projectType != null || this.idToAction.containsKey(actionId)) {
            return this.registerChameleon(actionId, action2, pluginId, projectType);
        }
        this.idToAction.put(actionId, action2);
        return action2;
    }

    private AnAction registerChameleon(String actionId, AnAction action2, PluginId pluginId, String projectType) {
        ChameleonAction chameleonAction;
        ProjectType type = projectType == null ? null : new ProjectType(projectType);
        AnAction o = this.idToAction.get(actionId);
        if (o == null) {
            ChameleonAction chameleonAction2 = new ChameleonAction(action2, type);
            this.idToAction.put(actionId, chameleonAction2);
            return chameleonAction2;
        }
        if (o instanceof ChameleonAction) {
            chameleonAction = (ChameleonAction)o;
        } else {
            chameleonAction = new ChameleonAction(o, type);
            this.idToAction.put(actionId, chameleonAction);
        }
        AnAction old = chameleonAction.addAction(action2, type);
        if (old != null) {
            String oldPluginInfo = this.pluginToId.keySet().stream().filter(p -> this.pluginToId.get(p).contains(actionId)).map(ActionManagerImpl::getPluginInfo).collect(Collectors.joining(","));
            ActionManagerImpl.reportActionError(pluginId, "ID \"" + actionId + "\" is already taken by action \"" + this.idToAction.get(actionId) + "\"" + oldPluginInfo + ". Action \"" + action2 + "\"" + ActionManagerImpl.getPluginInfo(pluginId) + " cannot use the same ID");
            return null;
        }
        return chameleonAction;
    }

    public void registerAction(@NotNull String actionId, @NotNull AnAction action2) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(77);
        }
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(78);
        }
        this.registerAction(actionId, action2, null);
    }

    public void unregisterAction(@NotNull String actionId) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(79);
        }
        this.unregisterAction(actionId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAction(@NotNull String actionId, boolean removeFromGroups) {
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(80);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.idToAction.containsKey(actionId)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("action with ID " + actionId + " wasn't registered");
                }
                return;
            }
            AnAction actionToRemove = this.idToAction.remove(actionId);
            this.actionToId.remove(actionToRemove);
            this.idToIndex.removeInt((Object)actionId);
            for (Object entry : this.pluginToId.entrySet()) {
                ((Collection)entry.getValue()).remove(actionId);
            }
            if (removeFromGroups) {
                CustomActionsSchema customActionSchema = (CustomActionsSchema)ApplicationManager.getApplication().getServiceIfCreated(CustomActionsSchema.class);
                for (String groupId2 : this.idToGroupId.get((Object)actionId)) {
                    DefaultActionGroup group2;
                    if (customActionSchema != null) {
                        customActionSchema.invalidateCustomizedActionGroup(groupId2);
                    }
                    if ((group2 = (DefaultActionGroup)this.getActionOrStub(groupId2)) == null) {
                        LOG.error("Trying to remove action " + actionId + " from non-existing group " + groupId2);
                        continue;
                    }
                    group2.remove(actionToRemove, actionId);
                    if (group2 instanceof ActionGroupStub) continue;
                    for (String parentOfGroup : this.idToGroupId.get((Object)groupId2)) {
                        DefaultActionGroup parentOfGroupAction = (DefaultActionGroup)this.getActionOrStub(parentOfGroup);
                        if (parentOfGroupAction == null) {
                            LOG.error("Trying to remove action " + actionId + " from non-existing group " + parentOfGroup);
                            continue;
                        }
                        for (AnAction stub : parentOfGroupAction.getChildActionsOrStubs()) {
                            if (!(stub instanceof ActionGroupStub) || ((ActionGroupStub)stub).getId() != groupId2) continue;
                            ((ActionGroupStub)stub).remove(actionToRemove, actionId);
                        }
                    }
                }
            }
            if (actionToRemove instanceof ActionGroup) {
                for (Object entry : this.idToGroupId.entrySet()) {
                    ((Collection)entry.getValue()).remove(actionId);
                }
            }
            ActionManagerImpl.updateHandlers(actionToRemove);
        }
    }

    @NotNull
    public Comparator<String> getRegistrationOrderComparator() {
        Comparator<String> comparator2 = Comparator.comparingInt(arg_0 -> this.idToIndex.getInt(arg_0));
        if (comparator2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(81);
        }
        return comparator2;
    }

    public String @NotNull [] getPluginActions(@NotNull PluginId pluginName) {
        if (pluginName == null) {
            ActionManagerImpl.$$$reportNull$$$0(82);
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)this.pluginToId.get((Object)pluginName));
        if (stringArray == null) {
            ActionManagerImpl.$$$reportNull$$$0(83);
        }
        return stringArray;
    }

    public void addActionPopup(@NotNull Object menu) {
        if (menu == null) {
            ActionManagerImpl.$$$reportNull$$$0(84);
        }
        this.myPopups.add(menu);
        if (menu instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuCreated((ActionPopupMenu)menu);
            }
        }
    }

    void removeActionPopup(@NotNull Object menu) {
        boolean removed;
        if (menu == null) {
            ActionManagerImpl.$$$reportNull$$$0(85);
        }
        if ((removed = this.myPopups.remove(menu)) && menu instanceof ActionPopupMenu) {
            for (ActionPopupMenuListener listener2 : this.myActionPopupMenuListeners) {
                listener2.actionPopupMenuReleased((ActionPopupMenu)menu);
            }
        }
    }

    public void queueActionPerformedEvent(@NotNull AnAction action2, @NotNull DataContext context, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(86);
        }
        if (context == null) {
            ActionManagerImpl.$$$reportNull$$$0(87);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(88);
        }
        if (this.myPopups.isEmpty()) {
            this.fireAfterActionPerformed(action2, context, event);
        }
    }

    public boolean isToolWindowContextMenuVisible() {
        for (Object popup2 : this.myPopups) {
            if (!(popup2 instanceof ActionPopupMenuImpl) || !((ActionPopupMenuImpl)popup2).isToolWindowContextMenu()) continue;
            return true;
        }
        return false;
    }

    public boolean isActionPopupStackEmpty() {
        return this.myPopups.isEmpty();
    }

    public void addActionPopupMenuListener(@NotNull ActionPopupMenuListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(89);
        }
        if (parentDisposable == null) {
            ActionManagerImpl.$$$reportNull$$$0(90);
        }
        this.myActionPopupMenuListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myActionPopupMenuListeners.remove(listener2));
    }

    public void replaceAction(@NotNull String actionId, @NotNull AnAction newAction) {
        Class callerClass;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(91);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(92);
        }
        PluginId pluginId = (callerClass = ReflectionUtil.getGrandCallerClass()) != null ? PluginManagerCore.getPluginByClassName(callerClass.getName()) : null;
        this.replaceAction(actionId, newAction, pluginId);
    }

    private AnAction replaceAction(@NotNull String actionId, @NotNull AnAction newAction, @Nullable PluginId pluginId) {
        AnAction oldAction;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(93);
        }
        if (newAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(94);
        }
        AnAction anAction = oldAction = newAction instanceof OverridingAction ? this.getAction(actionId) : this.getActionOrStub(actionId);
        if (oldAction != null) {
            boolean isGroup;
            if (newAction instanceof OverridingAction) {
                this.myBaseActions.put((OverridingAction)newAction, oldAction);
            }
            if ((isGroup = oldAction instanceof ActionGroup) != newAction instanceof ActionGroup) {
                throw new IllegalStateException("cannot replace a group with an action and vice versa: " + actionId);
            }
            for (String groupId2 : this.idToGroupId.get((Object)actionId)) {
                DefaultActionGroup group2 = (DefaultActionGroup)this.getActionOrStub(groupId2);
                if (group2 == null) {
                    throw new IllegalStateException("Trying to replace action which has been added to a non-existing group " + groupId2);
                }
                group2.replaceAction(oldAction, newAction);
            }
            this.unregisterAction(actionId, false);
        }
        this.registerAction(actionId, newAction, pluginId);
        return oldAction;
    }

    public AnAction getBaseAction(OverridingAction overridingAction) {
        return this.myBaseActions.get(overridingAction);
    }

    public Collection<String> getParentGroupIds(String actionId) {
        return this.idToGroupId.get((Object)actionId);
    }

    public void addAnActionListener(AnActionListener listener2) {
        this.myActionListeners.add(listener2);
    }

    public void removeAnActionListener(AnActionListener listener2) {
        this.myActionListeners.remove(listener2);
    }

    public void fireBeforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(95);
        }
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(96);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(97);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        this.myLastPreformedActionId = this.getId(action2);
        if (this.myLastPreformedActionId == null && action2 instanceof ActionIdProvider) {
            this.myLastPreformedActionId = ((ActionIdProvider)action2).getId();
        }
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId;
        ArrayList customData = new ArrayList();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Language hostFileLanguage = ActionManagerImpl.getHostFileLanguage(dataContext, project);
        customData.add(EventFields.CurrentFile.with((Object)hostFileLanguage));
        if (hostFileLanguage == null || hostFileLanguage == PlainTextLanguage.INSTANCE) {
            PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Language language = file2 != null ? file2.getLanguage() : null;
            customData.add(EventFields.Language.with((Object)language));
        }
        if (action2 instanceof FusAwareAction) {
            List<EventPair<?>> additionalUsageData = ((FusAwareAction)action2).getAdditionalUsageData(event);
            customData.add(ActionsEventLogGroup.ADDITIONAL.with((Object)new ObjectEventData(additionalUsageData)));
        }
        ActionsCollectorImpl.recordActionInvoked(project, action2, event, customData);
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeActionPerformed(action2, dataContext, event);
        }
        ActionManagerImpl.publisher().beforeActionPerformed(action2, dataContext, event);
    }

    @Nullable
    private static Language getHostFileLanguage(@NotNull DataContext dataContext, @Nullable Project project) {
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(98);
        }
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.HOST_EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        return file2 != null ? file2.getLanguage() : null;
    }

    public void fireAfterActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(99);
        }
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(100);
        }
        if (event == null) {
            ActionManagerImpl.$$$reportNull$$$0(101);
        }
        this.myPrevPerformedActionId = this.myLastPreformedActionId;
        IdeaLogger.ourLastActionId = this.myLastPreformedActionId = this.getId(action2);
        for (AnActionListener listener2 : this.myActionListeners) {
            try {
                listener2.afterActionPerformed(action2, dataContext, event);
            }
            catch (AbstractMethodError abstractMethodError) {}
        }
        ActionManagerImpl.publisher().afterActionPerformed(action2, dataContext, event);
    }

    public KeyboardShortcut getKeyboardShortcut(@NotNull String actionId) {
        Shortcut[] shortcuts;
        AnAction action2;
        if (actionId == null) {
            ActionManagerImpl.$$$reportNull$$$0(102);
        }
        if ((action2 = ActionManager.getInstance().getAction(actionId)) == null) {
            return null;
        }
        ShortcutSet shortcutSet = action2.getShortcutSet();
        for (Shortcut shortcut : shortcuts = shortcutSet.getShortcuts()) {
            KeyboardShortcut kb;
            if (!(shortcut instanceof KeyboardShortcut) || (kb = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            return (KeyboardShortcut)shortcut;
        }
        return null;
    }

    public void fireBeforeEditorTyping(char c, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(103);
        }
        this.myLastTimeEditorWasTypedIn = System.currentTimeMillis();
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.beforeEditorTyping(c, dataContext);
        }
        ActionManagerImpl.publisher().beforeEditorTyping(c, dataContext);
    }

    public void fireAfterEditorTyping(char c, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ActionManagerImpl.$$$reportNull$$$0(104);
        }
        for (AnActionListener listener2 : this.myActionListeners) {
            listener2.afterEditorTyping(c, dataContext);
        }
        ActionManagerImpl.publisher().afterEditorTyping(c, dataContext);
    }

    public String getLastPreformedActionId() {
        return this.myLastPreformedActionId;
    }

    public String getPrevPreformedActionId() {
        return this.myPrevPerformedActionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<String> getActionIds() {
        Object object = this.myLock;
        // MONITORENTER : object
        HashSet<String> hashSet = new HashSet<String>(this.idToAction.keySet());
        // MONITOREXIT : object
        if (hashSet != null) return hashSet;
        ActionManagerImpl.$$$reportNull$$$0(105);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadActions(@NotNull ProgressIndicator indicator) {
        ArrayList<String> ids;
        if (indicator == null) {
            ActionManagerImpl.$$$reportNull$$$0(106);
        }
        Iterator iterator2 = this.myLock;
        synchronized (iterator2) {
            ids = new ArrayList<String>(this.idToAction.keySet());
        }
        for (String id2 : ids) {
            indicator.checkCanceled();
            this.getActionImpl(id2, false);
        }
    }

    @NotNull
    public ActionCallback tryToExecute(@NotNull AnAction action2, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, @Nullable String place, boolean now) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(107);
        }
        if (inputEvent == null) {
            ActionManagerImpl.$$$reportNull$$$0(108);
        }
        assert (ApplicationManager.getApplication().isDispatchThread());
        ActionCallback result2 = new ActionCallback();
        Runnable doRunnable = () -> this.tryToExecuteNow(action2, inputEvent, contextComponent, place, result2);
        if (now) {
            doRunnable.run();
        } else {
            SwingUtilities.invokeLater(doRunnable);
        }
        ActionCallback actionCallback = result2;
        if (actionCallback == null) {
            ActionManagerImpl.$$$reportNull$$$0(109);
        }
        return actionCallback;
    }

    private void tryToExecuteNow(@NotNull AnAction action2, @NotNull InputEvent inputEvent, @Nullable Component contextComponent, String place, ActionCallback result2) {
        if (action2 == null) {
            ActionManagerImpl.$$$reportNull$$$0(110);
        }
        if (inputEvent == null) {
            ActionManagerImpl.$$$reportNull$$$0(111);
        }
        Presentation presentation2 = action2.getTemplatePresentation().clone();
        IdeFocusManager.findInstanceByContext((DataContext)ActionManagerImpl.getContextBy(contextComponent)).doWhenFocusSettlesDown(() -> ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(() -> {
            DataContext context = ActionManagerImpl.getContextBy(contextComponent);
            AnActionEvent event = new AnActionEvent(inputEvent, context, place != null ? place : "unknown", presentation2, (ActionManager)this, inputEvent.getModifiersEx());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action2, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            ActionUtil.lastUpdateAndCheckDumb((AnAction)action2, (AnActionEvent)event, (boolean)false);
            if (!event.getPresentation().isEnabled()) {
                result2.setRejected();
                return;
            }
            Component component2 = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(context);
            if (component2 != null && !component2.isShowing() && !"TouchBarGeneral".equals(place)) {
                result2.setRejected();
                return;
            }
            this.fireBeforeActionPerformed(action2, context, event);
            UIUtil.addAwtListener(event1 -> {
                if (!(event1.getID() != 200 && event1.getID() != 205 || result2.isProcessed())) {
                    WindowEvent we = (WindowEvent)event1;
                    IdeFocusManager.findInstanceByComponent((Component)we.getWindow()).doWhenFocusSettlesDown(result2.createSetDoneRunnable(), ModalityState.defaultModalityState());
                }
            }, (long)64L, (Disposable)result2);
            ActionUtil.performActionDumbAware((AnAction)action2, (AnActionEvent)event);
            result2.setDone();
            this.queueActionPerformedEvent(action2, context, event);
        }), ModalityState.defaultModalityState());
    }

    @NotNull
    public List<EditorActionHandlerBean> getRegisteredHandlers(@NotNull EditorAction editorAction) {
        if (editorAction == null) {
            ActionManagerImpl.$$$reportNull$$$0(112);
        }
        ArrayList<EditorActionHandlerBean> result2 = new ArrayList<EditorActionHandlerBean>();
        String id2 = this.getId((AnAction)editorAction);
        if (id2 != null) {
            List extensions2 = EDITOR_ACTION_HANDLER_EP.getExtensionList();
            for (int i2 = extensions2.size() - 1; i2 >= 0; --i2) {
                EditorActionHandlerBean handlerBean = (EditorActionHandlerBean)extensions2.get(i2);
                if (!handlerBean.action.equals(id2)) continue;
                result2.add(handlerBean);
            }
        }
        ArrayList<EditorActionHandlerBean> arrayList = result2;
        if (arrayList == null) {
            ActionManagerImpl.$$$reportNull$$$0(113);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllHandlers() {
        Object object = this.myLock;
        synchronized (object) {
            this.actionToId.keySet().forEach(ActionManagerImpl::updateHandlers);
        }
    }

    private static void updateHandlers(Object action2) {
        if (action2 instanceof EditorAction) {
            ((EditorAction)action2).clearDynamicHandlersCache();
        }
    }

    private static /* synthetic */ String lambda$processGroupElement$6(ResourceBundle bundle, String finalId, String description) {
        return ActionManagerImpl.computeDescription(bundle, finalId, GROUP_ELEMENT_NAME, description);
    }

    private static /* synthetic */ String lambda$processGroupElement$5(ResourceBundle bundle, String finalId, Element element2) {
        return ActionManagerImpl.computeActionText(bundle, finalId, GROUP_ELEMENT_NAME, element2.getAttributeValue(TEXT_ATTR_NAME));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 22: 
            case 31: 
            case 39: 
            case 42: 
            case 44: 
            case 62: 
            case 81: 
            case 83: 
            case 105: 
            case 109: 
            case 113: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 22: 
            case 31: 
            case 39: 
            case 42: 
            case 44: 
            case 62: 
            case 81: 
            case 83: 
            case 105: 
            case 109: 
            case 113: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 1: 
            case 22: 
            case 31: 
            case 39: 
            case 42: 
            case 44: 
            case 62: 
            case 81: 
            case 83: 
            case 105: 
            case 109: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubClassName";
                break;
            }
            case 4: 
            case 12: 
            case 68: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: 
            case 36: 
            case 37: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_ATTR_NAME;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = ANCHOR_ELEMENT_NAME;
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 18: 
            case 35: 
            case 51: 
            case 58: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapManager";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keymapName";
                break;
            }
            case 23: 
            case 24: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = PLACE_ATTR_NAME;
                break;
            }
            case 26: 
            case 28: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = GROUP_ELEMENT_NAME;
                break;
            }
            case 34: 
            case 50: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 40: 
            case 54: 
            case 73: 
            case 75: 
            case 78: 
            case 86: 
            case 95: 
            case 99: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = ACTION_ELEMENT_NAME;
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idPrefix";
                break;
            }
            case 45: 
            case 72: 
            case 74: 
            case 77: 
            case 79: 
            case 80: 
            case 91: 
            case 93: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionPlace";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageActionGroup";
                break;
            }
            case 49: 
            case 52: 
            case 56: 
            case 59: 
            case 60: 
            case 64: 
            case 67: 
            case 69: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY_ATTR_NAME;
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEYMAP_ATTR_NAME;
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredID";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menu";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 88: 
            case 97: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
            case 96: 
            case 98: 
            case 100: 
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 108: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputEvent";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "publisher";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextBy";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceStub";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIdList";
                break;
            }
            case 44: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIds";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createSeparator";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationOrderComparator";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginActions";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToExecute";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredHandlers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerActions";
                break;
            }
            case 1: 
            case 22: 
            case 31: 
            case 39: 
            case 42: 
            case 44: 
            case 62: 
            case 81: 
            case 83: 
            case 105: 
            case 109: 
            case 113: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertStub";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateIconFromStub";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertGroupStub";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAbbreviationNode";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setIconFromClass";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeDescription";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkRelativeToAction";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processMouseShortcutNode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "reportActionError";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "reportKeymapNotFoundWarning";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addTimerListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "removeTimerListener";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopupMenu";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "registerPluginActions";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAction";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getActionImpl";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "replaceStub";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getId";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getActionIdList";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getActionIds";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isGroup";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createButtonToolbar";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getActionOrStub";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processActionElement";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "registerOrReplaceActionInner";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processGroupElement";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "processReferenceNode";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processSeparatorNode";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createSeparator";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processKeyboardShortcutNode";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processRemoveAndReplace";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceActionId";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "checkUnloadActions";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "canUnloadGroup";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "unloadActions";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "unloadActionElement";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "registerAction";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "notifyCustomActionsSchema";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "unregisterAction";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getPluginActions";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "addActionPopup";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "removeActionPopup";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "queueActionPerformedEvent";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "addActionPopupMenuListener";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "replaceAction";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeActionPerformed";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "getHostFileLanguage";
                break;
            }
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterActionPerformed";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getKeyboardShortcut";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeEditorTyping";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterEditorTyping";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "preloadActions";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecute";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "tryToExecuteNow";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getRegisteredHandlers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 22: 
            case 31: 
            case 39: 
            case 42: 
            case 44: 
            case 62: 
            case 81: 
            case 83: 
            case 105: 
            case 109: 
            case 113: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyTimer
    extends Timer
    implements ActionListener {
        final List<TimerListener> listeners;
        private int myLastTimePerformed;

        private MyTimer() {
            super(500, null);
            this.listeners = ContainerUtil.createLockFreeCopyOnWriteList();
            this.addActionListener(this);
            this.setRepeats(true);
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MyTimer.this.setDelay(500);
                    MyTimer.this.restart();
                }

                public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    MyTimer.this.setDelay(5000);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "ideFrame";
                    objectArray2[1] = "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$MyTimer$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationActivated";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "applicationDeactivated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public String toString() {
            return "Action manager timer";
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ActionManagerImpl.this.myLastTimeEditorWasTypedIn + 500L > System.currentTimeMillis()) {
                return;
            }
            int lastEventCount = this.myLastTimePerformed;
            this.myLastTimePerformed = ActivityTracker.getInstance().getCount();
            if (this.myLastTimePerformed == lastEventCount) {
                return;
            }
            for (TimerListener listener2 : this.listeners) {
                this.runListenerAction(listener2);
            }
        }

        private void runListenerAction(@NotNull TimerListener listener2) {
            ModalityState modalityState;
            if (listener2 == null) {
                MyTimer.$$$reportNull$$$0(0);
            }
            if ((modalityState = listener2.getModalityState()) == null) {
                return;
            }
            LOG.debug("notify ", new Object[]{listener2});
            if (!ModalityState.current().dominates(modalityState)) {
                try {
                    listener2.run();
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/actionSystem/impl/ActionManagerImpl$MyTimer", "runListenerAction"));
        }
    }
}

