/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.navigation;

import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.navigation.JBProtocolNavigateCommand;
import com.intellij.navigation.JBProtocolNavigateCommandKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/navigation/JBProtocolNavigateCommand;", "Lcom/intellij/openapi/application/JBProtocolCommand;", "()V", "perform", "", "target", "", "parameters", "", "Companion", "intellij.platform.lang.impl"})
public class JBProtocolNavigateCommand
extends JBProtocolCommand {
    @NotNull
    public static final String NAVIGATE_COMMAND = "navigate";
    @NotNull
    public static final String PROJECT_NAME_KEY = "project";
    @NotNull
    public static final String REFERENCE_TARGET = "reference";
    @NotNull
    public static final String PATH_KEY = "path";
    @NotNull
    public static final String FQN_KEY = "fqn";
    @NotNull
    public static final String SELECTION = "selection";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void perform(@NotNull String target2, @NotNull Map<String, String> parameters2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        String projectName = parameters2.get(PROJECT_NAME_KEY);
        CharSequence charSequence = projectName;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            return;
        }
        if (Intrinsics.areEqual((Object)target2, (Object)REFERENCE_TARGET) ^ true) {
            JBProtocolNavigateCommandKt.access$getLOG$p().warn("JB navigate action supports only reference target, got " + target2);
            return;
        }
        for (AnAction recentProjectAction : RecentProjectListActionProvider.getActions$default(RecentProjectListActionProvider.Companion.getInstance(), false, false, 3, null)) {
            if (!(recentProjectAction instanceof ReopenProjectAction) || Intrinsics.areEqual((Object)((ReopenProjectAction)recentProjectAction).getProjectName(), (Object)projectName) ^ true) continue;
            Project[] projectArray = ProjectUtil.getOpenProjects();
            int n = projectArray.length;
            for (int j = 0; j < n; ++j) {
                Project project;
                Project project2 = project = projectArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)PROJECT_NAME_KEY);
                if (!Intrinsics.areEqual((Object)project2.getName(), (Object)projectName)) continue;
                JBProtocolNavigateCommandKt.access$findAndNavigateToReference(project, parameters2);
                return;
            }
            ApplicationManager.getApplication().invokeLater(new Runnable(recentProjectAction, parameters2){
                final /* synthetic */ AnAction $recentProjectAction;
                final /* synthetic */ Map $parameters;

                public final void run() {
                    RecentProjectsManagerBase recentProjectsManagerBase = RecentProjectsManagerBase.Companion.getInstanceEx();
                    Path path = Paths.get(((ReopenProjectAction)this.$recentProjectAction).getProjectPath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(recentProjectAction.projectPath)");
                    Project project = recentProjectsManagerBase.openProject(path, new OpenProjectTask(false, null, false, false, null, null, false, null, null, 0, 0, false, false, false, null, false, false, null, null, null, 1048575, null));
                    if (project == null) {
                        return;
                    }
                    Project project2 = project;
                    StartupManager.getInstance((Project)project2).runAfterOpened(new Runnable(this, project2){
                        final /* synthetic */ perform.1 this$0;
                        final /* synthetic */ Project $project;

                        public final void run() {
                            DumbService.getInstance((Project)this.$project).runWhenSmart(new Runnable(this){
                                final /* synthetic */ perform.1 this$0;

                                public final void run() {
                                    JBProtocolNavigateCommandKt.access$findAndNavigateToReference(this.this$0.$project, this.this$0.this$0.$parameters);
                                }
                                {
                                    this.this$0 = var1_1;
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            this.$project = project;
                        }
                    });
                }
                {
                    this.$recentProjectAction = anAction;
                    this.$parameters = map2;
                }
            }, ModalityState.NON_MODAL);
        }
    }

    public JBProtocolNavigateCommand() {
        super(NAVIGATE_COMMAND);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/navigation/JBProtocolNavigateCommand$Companion;", "", "()V", "FQN_KEY", "", "NAVIGATE_COMMAND", "PATH_KEY", "PROJECT_NAME_KEY", "REFERENCE_TARGET", "SELECTION", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

