/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.impl.MessageBusFactoryImpl;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager,
MessageBusOwner {
    private final MessageBus myMessageBus;
    private final DefaultPicoContainer myPicoContainer;
    private final ExtensionsAreaImpl myExtensionArea;
    private final Map<Class<?>, Object> myComponents;
    private final Set<Object> myDisposableComponents;
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(0);
        }
        this.myMessageBus = MessageBusFactoryImpl.createRootBus((MessageBusOwner)this);
        this.myComponents = new HashMap();
        this.myDisposableComponents = ContainerUtil.newConcurrentSet();
        this.myPicoContainer = new DefaultPicoContainer((DefaultPicoContainer)parent){

            @Nullable
            public Object getComponentInstance(@NotNull Object componentKey) {
                if (componentKey == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + (Object)((Object)this));
                }
                Object o = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o);
                return o;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/mock/MockComponentManager$1", "getComponentInstance"));
            }
        };
        this.myPicoContainer.registerComponentInstance((Object)this);
        this.myExtensionArea = new ExtensionsAreaImpl((ComponentManager)this);
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public ExtensionsAreaImpl getExtensionArea() {
        ExtensionsAreaImpl extensionsAreaImpl = this.myExtensionArea;
        if (extensionsAreaImpl == null) {
            MockComponentManager.$$$reportNull$$$0(1);
        }
        return extensionsAreaImpl;
    }

    @NotNull
    public RuntimeException createError(@NotNull Throwable error, @NotNull PluginId pluginId) {
        if (error == null) {
            MockComponentManager.$$$reportNull$$$0(2);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(3);
        }
        ExceptionUtilRt.rethrowUnchecked((Throwable)error);
        return new RuntimeException(error);
    }

    @NotNull
    public RuntimeException createError(@NotNull @NonNls String message2, @NotNull PluginId pluginId) {
        if (message2 == null) {
            MockComponentManager.$$$reportNull$$$0(4);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(5);
        }
        return new RuntimeException(message2);
    }

    @NotNull
    public RuntimeException createError(@NotNull @NonNls String message2, @NotNull PluginId pluginId, @Nullable Map<String, String> attachments) {
        if (message2 == null) {
            MockComponentManager.$$$reportNull$$$0(6);
        }
        if (pluginId == null) {
            MockComponentManager.$$$reportNull$$$0(7);
        }
        return new RuntimeException(message2);
    }

    protected void registerComponentInDisposer(@Nullable Object o) {
        if (o instanceof Disposable && o != this && !(o instanceof MessageBus) && this.myDisposableComponents.add(o)) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)o));
        }
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(8);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(9);
        }
        this.myPicoContainer.unregisterComponent((Object)serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation((Object)serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceImplementation) {
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(10);
        }
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(11);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(12);
        }
        this.myPicoContainer.registerComponentInstance((Object)serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation, @NotNull Disposable parentDisposable) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(13);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(15);
        }
        String key = serviceInterface.getName();
        this.registerService(serviceInterface, serviceImplementation);
        Disposer.register((Disposable)parentDisposable, () -> this.myPicoContainer.unregisterComponent((Object)key));
    }

    public <T> void addComponent(@NotNull Class<T> interfaceClass, @NotNull T instance) {
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(16);
        }
        if (instance == null) {
            MockComponentManager.$$$reportNull$$$0(17);
        }
        this.myComponents.put(interfaceClass, instance);
        this.registerComponentInDisposer(instance);
    }

    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        Object o;
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(18);
        }
        return (T)((o = this.myPicoContainer.getComponentInstance(interfaceClass)) != null ? o : this.myComponents.get(interfaceClass));
    }

    public <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            MockComponentManager.$$$reportNull$$$0(19);
        }
        Object result2 = this.myPicoContainer.getService(serviceClass);
        this.registerComponentInDisposer(result2);
        return (T)result2;
    }

    @NotNull
    public final MutablePicoContainer getPicoContainer() {
        DefaultPicoContainer defaultPicoContainer = this.myPicoContainer;
        if (defaultPicoContainer == null) {
            MockComponentManager.$$$reportNull$$$0(20);
        }
        return defaultPicoContainer;
    }

    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            MockComponentManager.$$$reportNull$$$0(21);
        }
        return messageBus;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myMessageBus);
        this.myDisposed = true;
    }

    @NotNull
    public Condition<?> getDisposed() {
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            MockComponentManager.$$$reportNull$$$0(22);
        }
        return condition;
    }

    @NotNull
    public Object createListener(@NotNull ListenerDescriptor descriptor2) {
        if (descriptor2 == null) {
            MockComponentManager.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public <T> Class<T> loadClass(@NotNull String className, @NotNull PluginDescriptor pluginDescriptor) throws ClassNotFoundException {
        if (className == null) {
            MockComponentManager.$$$reportNull$$$0(24);
        }
        if (pluginDescriptor == null) {
            MockComponentManager.$$$reportNull$$$0(25);
        }
        Class<?> clazz = Class.forName(className);
        if (clazz == null) {
            MockComponentManager.$$$reportNull$$$0(26);
        }
        return clazz;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceImplementation";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionArea";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "loadClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createError";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerService";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

